/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.rpt.IGLRptRowData;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class VirtualModeRowSet
implements IGLRptRowData {
    private IGLRptBaseFacade iFacade;
    private int viewRowCount = 0;
    private int pageRowCount;
    private GLRptTableHeadInfo tableHeadInfo;
    private String queryId;
    private GLRptRowSet data;
    private int currRowIndex = 0;
    private Map<Integer, Integer> rowIndexMap = new HashMap<Integer, Integer>();

    public VirtualModeRowSet(IGLRptBaseFacade iFacade, GLRptQueryResult rs, int pageRowCount) {
        this.queryId = rs.getQueryId();
        this.tableHeadInfo = rs.getTableHeadInfo();
        this.viewRowCount = rs.getViewRowCount();
        this.data = rs.getData();
        this.buildRowIndexMap(this.data);
        this.pageRowCount = pageRowCount;
    }

    @Override
    public boolean next() throws EASBizException, BOSException {
        if (this.currRowIndex + 1 > this.viewRowCount) {
            return false;
        }
        ++this.currRowIndex;
        this.data.absolute(this.getRowSetIndex(this.currRowIndex));
        return true;
    }

    private void buildRowIndexMap(GLRptRowSet data) {
        data.beforeFirst();
        while (data.next()) {
            this.rowIndexMap.put(data.getRowIndex(), new Integer(data.getCurrRowIndex()));
        }
    }

    public GLRptTableHeadInfo getTableHeadInfo() {
        return this.tableHeadInfo;
    }

    @Override
    public String getString(String columnName) throws BOSException {
        return this.data.getString(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws BOSException {
        return this.data.getBigDecimal(columnName);
    }

    @Override
    public int getInt(String columnName) throws BOSException {
        return this.data.getInt(columnName);
    }

    @Override
    public short getShort(String columnName) throws BOSException {
        return this.data.getShort(columnName);
    }

    @Override
    public boolean getBoolean(String columnName) throws BOSException {
        return this.data.getBoolean(columnName);
    }

    @Override
    public byte getByte(String columnName) throws BOSException {
        return this.data.getByte(columnName);
    }

    @Override
    public byte[] getBytes(String columnName) throws BOSException {
        return this.data.getBytes(columnName);
    }

    @Override
    public Date getDate(String columnName) throws BOSException {
        return this.data.getDate(columnName);
    }

    @Override
    public Time getTime(String columnName) throws BOSException {
        return this.data.getTime(columnName);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws BOSException {
        return this.data.getTimestamp(columnName);
    }

    @Override
    public Object getObject(String columnName) throws BOSException {
        return this.data.getObject(columnName);
    }

    @Override
    public void updateString(String columnName, String x) throws BOSException {
        this.data.updateString(columnName, x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws BOSException {
        this.data.updateBigDecimal(columnName, x);
    }

    @Override
    public void updateInt(String columnName, int x) throws BOSException {
        this.data.updateInt(columnName, x);
    }

    @Override
    public void updateShort(String columnName, short x) throws BOSException {
        this.data.updateShort(columnName, x);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws BOSException {
        this.data.updateBoolean(columnName, x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws BOSException {
        this.data.updateByte(columnName, x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws BOSException {
        this.data.updateBytes(columnName, x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws BOSException {
        this.data.updateDate(columnName, x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws BOSException {
        this.data.updateTime(columnName, x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws BOSException {
        this.data.updateTimestamp(columnName, x);
    }

    @Override
    public void updateObject(String columnName, Object x) throws BOSException {
        this.data.updateObject(columnName, x);
    }

    @Override
    public Object getObject(int rowIndex, String columnName) throws BOSException, EASBizException {
        return this.data.getObject(this.getRowSetIndex(rowIndex), columnName);
    }

    @Override
    public void updateObject(int rowIndex, String columnName, Object x) throws BOSException, EASBizException {
        this.data.updateObject(this.getRowSetIndex(rowIndex), columnName, x);
    }

    @Override
    public void beforeFirst() {
        this.currRowIndex = 0;
        this.data.beforeFirst();
    }

    @Override
    public boolean previous() throws BOSException, EASBizException {
        if (this.currRowIndex - 1 <= 0) {
            return false;
        }
        --this.currRowIndex;
        this.data.absolute(this.getRowSetIndex(this.currRowIndex));
        return true;
    }

    @Override
    public void absolute(int rowIndex) throws BOSException, EASBizException {
        if (rowIndex > this.viewRowCount || rowIndex < 1) {
            throw new BOSException("The row is not exist!");
        }
        this.currRowIndex = rowIndex;
        this.data.absolute(this.getRowSetIndex(this.currRowIndex));
    }

    @Override
    public boolean first() throws BOSException, EASBizException {
        if (this.viewRowCount > 0) {
            this.currRowIndex = 1;
            this.data.absolute(this.getRowSetIndex(this.currRowIndex));
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws BOSException, EASBizException {
        if (this.size() > 0) {
            this.currRowIndex = this.viewRowCount;
            this.data.absolute(this.getRowSetIndex(this.currRowIndex));
            return true;
        }
        return false;
    }

    private int getRowSetIndex(int rowIndex) throws BOSException, EASBizException {
        Integer rowSetIndex = this.rowIndexMap.get(rowIndex);
        if (rowSetIndex == null) {
            GLRptRowSet rs = this.iFacade.getData(this.queryId, rowIndex, this.pageRowCount);
            this.buildRowIndexMap(rs);
            this.data.addRowSets(rs);
            rowSetIndex = this.rowIndexMap.get(rowIndex);
        }
        return rowSetIndex;
    }

    @Override
    public int size() {
        return this.viewRowCount;
    }

    @Override
    public String[] getColumKeys() {
        return this.data.getColumKeys();
    }

    @Override
    public void close() throws BOSException, EASBizException {
        if (this.queryId != null) {
            this.iFacade.releaseDataSource(this.queryId);
        }
    }
}

