/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class AbstractVoucherBaseValidator
implements IVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(AbstractVoucherBaseValidator.class);
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";

    @Override
    public abstract void validate(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected void checkVoucherPeriod(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getPeriod() == null) {
            throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
        }
        PeriodInfo currPeriod = GlUtils.getCurrentPeriod(ctx, voucherInfo.getCompany().getId().toString());
        if (voucherInfo.getPeriod().isIsAdjustPeriod() && voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() - 1) {
            return;
        }
        if (voucherInfo.getPeriod().getPeriodYear() < currPeriod.getPeriodYear() || voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() && voucherInfo.getPeriod().getPeriodNumber() < currPeriod.getPeriodNumber()) {
            throw new VoucherException(VoucherException.PERIOD_NOT_VAILD);
        }
    }

    protected void checkVoucherType(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getVoucherType() == null) {
            throw new VoucherException(VoucherException.TYPE_CANNOT_NULL);
        }
        String cuId = null;
        if (voucherInfo.getCompany() != null && voucherInfo.getCompany().getCU() != null) {
            cuId = voucherInfo.getCompany().getCU().getId().toString();
        }
        if (!VoucherUtil.isExistedVoucherType((Context)ctx, cuId, (String)voucherInfo.getVoucherType().getId().toString())) {
            throw new VoucherException(VoucherException.VOUCHERTYOENOTSEE);
        }
    }

    protected boolean existsCashOrBankAccount(Context ctx, String voucherId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        CoreBaseInfo model = VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherId), sic);
        return ((VoucherInfo)model).existsCashOrBankAccount();
    }

    protected void checkPiaoJu(Context ctx, String id, GlParam sysParam, boolean isSubmit) throws BOSException, EASBizException {
        boolean isFzz = sysParam.getBoolean("GL_060");
        if (!isFzz) {
            return;
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("  select a.fnumber,a.fcompanyid,b.fcurrencyid,sum(c.foriginalamount) famount, c.fsettlementcode,d.fbankaccountid,f.fnttypeid  \r\n");
        sql.append("\tfrom  \t\r\n");
        sql.append("\tt_gl_voucher a,t_gl_voucherentry b ,t_gl_voucherassistrecord c, \t\t\r\n");
        sql.append("\tt_bd_assistanthg d ,t_bd_accountview e\t,t_bd_settlementtype f,T_NT_NTType g\t\t\t\r\n");
        sql.append(" where a.fid=b.fbillid \t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.fid=c.fentryid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and b.faccountid=e.fid\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" and c.fassgrpid=d.fid\tand d.fbankaccountid is not null\t\t\t\t\t\r\n");
        sql.append("  and c.fsettlementtypeid=f.fid\t\t\t\t\t\t\t\t\r\n");
        sql.append("  and f.fnttypeid=g.fid and g.fgroup=1 \t\t\t\t\t\t\t\r\n");
        sql.append(" and a.fsourcetype=0 and e.fisbank=1 and b.fentrydc=0\t\t\r\n");
        sql.append(" and a.fid=?\tgroup by a.fnumber,a.fcompanyid,b.fcurrencyid,c.fsettlementcode,d.fbankaccountid,f.fnttypeid\t\t\t\r\n");
        StringBuffer sqlCheck = new StringBuffer("");
        sqlCheck.append(" select f.fid,f.fstate,f.famount,h.fceiling,f.fpaymentbillnum \t from  \t\t\r\n");
        sqlCheck.append(" t_nt_cheque f,T_NT_NTType g ,T_NT_ChequeAppRec h \t\t\t\t\t\t\t\r\n");
        sqlCheck.append("  where f.fapplyrecid=h.fid and g.fid=f.fnttypeid and g.fgroup=1 \t\t\t\r\n");
        sqlCheck.append(" \tand f.fcompanyid=?\tand f.fbankacctid=?  \t\t\t\t\t\t\t\t\r\n");
        sqlCheck.append(" \tand f.fcurrencyid=?\tand f.fnumber=?\tand g.fid=? \t\t\t\t\t\t\r\n");
        String update = "update t_nt_cheque set fPaymentBillNum=? where fid=? ";
        String updateFalse = "update t_nt_cheque set fPaymentBillNum=null where fid=? ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        if (set != null) {
            try {
                while (set.next()) {
                    String number = set.getString("fnumber");
                    String comid = set.getString("fcompanyid");
                    String bankAccid = set.getString("fbankaccountid");
                    String curid = set.getString("fcurrencyid");
                    String settlementcode = set.getString("fsettlementcode");
                    String nttype = set.getString("fnttypeid");
                    BigDecimal amount = set.getBigDecimal("famount");
                    if (isSubmit && settlementcode == null) {
                        throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                    }
                    IRowSet checkset = DbUtil.executeQuery((Context)ctx, (String)sqlCheck.toString(), (Object[])new Object[]{comid, bankAccid, curid, settlementcode, nttype});
                    if (checkset != null && checkset.next()) {
                        String chequeid = checkset.getString("fid");
                        BigDecimal checkamount = checkset.getBigDecimal("famount");
                        BigDecimal ceiling = checkset.getBigDecimal("fceiling");
                        int state = checkset.getInt("fstate");
                        String paymentbillnum = checkset.getString("fpaymentbillnum");
                        if (isSubmit) {
                            if (paymentbillnum != null) {
                                throw new VoucherException(VoucherException.TICKEDHASRELATED);
                            }
                            if (checkamount != null && ChequeStatusEnum.WRITTEN_OFF.getValue() == state && checkamount.compareTo(amount) != 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT2);
                            }
                            if (ceiling != null && ceiling.compareTo(amount) < 0) {
                                throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT3);
                            }
                            DbUtil.execute((Context)ctx, (String)update, (Object[])new Object[]{number, chequeid});
                            continue;
                        }
                        DbUtil.execute((Context)ctx, (String)updateFalse, (Object[])new Object[]{chequeid});
                        continue;
                    }
                    if (!isSubmit) continue;
                    throw new VoucherException(VoucherException.NOTEQUALSTICKETAMOUNT1);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void checkACNoticeCorrelation(Context ctx, String vchId) throws BOSException, EASBizException {
        AcNoticeUtil.checkACNoticeCorrelation((Context)ctx, (String)vchId);
    }

    protected void checkVerifiedStatus(Context ctx, VoucherInfo voucherInfo, GlParam sysParam, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        boolean hasVerified;
        boolean isInTimeVerify;
        if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            return;
        }
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (!isInTimeVerify && voucherInfo.getId() != null && !voucherInfo.isFromSaveSubmit() && voucherInfo.getId() != null && (hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(voucherInfo.getId().toString()))) {
            throw new VoucherException(VoucherException.CANNOT_OPER_AFTER_VERIFIED, new Object[]{status.toString()});
        }
    }

    protected void checkMutex(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ObjectUpdateLock lock = mutexService.getObjectUpdateLock(pk.toString());
        if (lock != null) {
            String mutexUserName = lock.getUserName();
            String curUserName = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
            if (mutexUserName != null && !curUserName.equalsIgnoreCase(mutexUserName)) {
                throw new VoucherException(VoucherException.VOUCHER_IN_EDITING);
            }
        }
    }

    public boolean checkOriginalAmount(Context ctx, VoucherInfo info) throws EASBizException, BOSException {
        int i;
        BigDecimal creditAmount = new BigDecimal("0.00");
        BigDecimal debitAmount = new BigDecimal("0.00");
        VoucherEntryCollection collection = info.getEntries();
        if (collection == null || collection.size() <= 1) {
            return false;
        }
        String currencyName = null;
        for (i = 0; i < collection.size() - 1; ++i) {
            VoucherEntryInfo entryInfo1 = collection.get(i);
            VoucherEntryInfo entryInfo2 = collection.get(i + 1);
            currencyName = entryInfo1.getCurrency().getName();
            if (entryInfo1.getAccount().isBw()) {
                return false;
            }
            if (entryInfo1.getCurrency().getId().equals((Object)entryInfo2.getCurrency().getId())) continue;
            return false;
        }
        for (i = 0; i < collection.size(); ++i) {
            VoucherEntryInfo entryInfo = collection.get(i);
            if (entryInfo.getOriginalAmount() == null) continue;
            if (EntryDC.DEBIT.equals((Object)entryInfo.getEntryDC())) {
                debitAmount = debitAmount.add(entryInfo.getOriginalAmount());
                continue;
            }
            creditAmount = creditAmount.add(entryInfo.getOriginalAmount());
        }
        if (creditAmount.compareTo(debitAmount) != 0) {
            throw new VoucherException(VoucherException.ORIGINAL_DC_NOT_EQUAL, new Object[]{currencyName + " ", debitAmount.toString(), creditAmount.toString()});
        }
        return false;
    }

    protected void checkIsOUSealUp(Context ctx, VoucherInfo info) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = info.getCompany();
        if (!company.containsKey("isSealUp")) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("isSealUp");
            CompanyOrgUnitInfo tCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
            company.setIsSealUp(tCompany.isIsSealUp());
        }
        if (company.isIsSealUp()) {
            Object[] param = new Object[]{OrgType.Company.getAlias()};
            throw new OUException(OUException.CANT_ADDNEW_FOR_SEALED, param);
        }
    }
}

