/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.fi.gl.validator.ReverseVoucherValidatorUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.Locale;

public class ReverseVoucherBaseSubmitValidator
implements IVoucherBaseValidator {
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        ObjectUuidPK srcVchPK = new ObjectUuidPK(voucherInfo.getSourceBillId());
        VoucherInfo srcVch = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)srcVchPK, VoucherInfo.getReverseSelector());
        voucherInfo.setSrcVoucherInfo((BaseVoucherInfo)srcVch);
        this.checkSrcVch(ctx, srcVch);
        StringBuffer msgCollector = new StringBuffer();
        msgCollector.append(this.getResource(ctx, resource, "BEYOND_SRC_AMOUNT", new Object[]{srcVch.getVoucherType().getName(ctx.getLocale()), srcVch.getNumber(), srcVch.getPeriod().getPeriodYear() + "." + srcVch.getPeriod().getPeriodNumber()}));
        msgCollector.append("\r\n");
        int result = ReverseVoucherValidatorUtils.checkReverse(ctx, voucherInfo, srcVch, msgCollector);
        if (result == -1) {
            throw new VoucherException(VoucherException.NO_MSG, new String[]{msgCollector.toString()});
        }
        if (result == 0) {
            srcVch.put("ReverseComplete", (Object)true);
        }
    }

    private void checkSrcVch(Context ctx, VoucherInfo srcVch) throws BOSException, EASBizException {
        if (!VoucherStatusEnum.POSTED.equals((Object)srcVch.getBizStatus())) {
            throw new VoucherException(VoucherException.VOUCHER_NOT_POSTED);
        }
        if (srcVch.isIsReverseVoucher()) {
            throw new VoucherException(VoucherException.VOUCHER_IS_REVERSE);
        }
        boolean hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(srcVch.getId().toString());
        if (hasVerified) {
            throw new VoucherException(VoucherException.CANNOT_CANCEL_VERIFIED);
        }
        VoucherEntryCollection entries = srcVch.getEntries();
        VoucherEntryInfo entry = null;
        boolean hasPLAccount = false;
        String currentAcctTable = srcVch.getCompany().getAccountTable().getId().toString();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            if (!currentAcctTable.equals(entry.getAccount().getAccountTableID().getId().toString())) {
                throw new VoucherException(VoucherException.REV_FAILUE_FOR_ACCOUNT_CHANGED);
            }
            if (!AccountProperty.SUNYI.equals((Object)entry.getAccount().getAccountTypeID().getProperty())) continue;
            hasPLAccount = true;
        }
        if (hasPLAccount) {
            boolean canRerveseSunYiVch;
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)srcVch.getCompany());
            Object gl_120 = GlUtils.getParamByKey(ctx, srcVch.getCompany().getId().toString(), "GL_120");
            boolean bl = canRerveseSunYiVch = gl_120 == null ? false : Boolean.valueOf(gl_120.toString());
            if (srcVch.getPeriod().getPeriodYear() != currentPeriod.getPeriodYear() && !canRerveseSunYiVch) {
                throw new VoucherException(VoucherException.REV_FAILURE_FOR_PL);
            }
        }
        this.lockSrcVoucher(ctx, srcVch);
    }

    private void lockSrcVoucher(Context ctx, VoucherInfo srcVch) throws EASBizException, BOSException {
        VoucherOprateSharer operateSharer = new VoucherOprateSharer(ctx);
        operateSharer.lockVoucher(ctx, srcVch.getId().toString());
    }

    protected String getResource(Context ctx, String resName, String key, Object[] params) {
        String message = ResourceBase.getString((String)resName, (String)key, (Locale)ctx.getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }
}

