/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLAsstBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceCollection;
import com.kingdee.eas.fi.gl.GLBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceKey;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.validator.AbstractVoucherBaseValidator;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;

public class VoucherBaseDeleteValidator
extends AbstractVoucherBaseValidator {
    private GlParam sysParam = null;
    private boolean isFromGL = true;

    public VoucherBaseDeleteValidator(GlParam sysParam, boolean isFromGL) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
        this.isFromGL = isFromGL;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.checkMutex(ctx, voucherInfo);
        this.checkModifyVoucherFromMain(ctx, voucherInfo, this.sysParam);
        if (voucherInfo.getSourceType() != SourceType.ACCOUNTADJUST) {
            this.checkVoucherSource(ctx, voucherInfo, this.sysParam, this.isFromGL);
            this.checkVchIsChecked(ctx, voucherInfo);
            this.checkAcNoticeIsChecked(ctx, voucherInfo, this.sysParam);
            this.checkVerifiedStatus(ctx, voucherInfo, this.sysParam);
            int cashDeficitCtrl = this.sysParam.getInt("GL_013");
            int acDeficitCtrl = this.sysParam.getInt("GL_073");
            if (!(voucherInfo.isWebVoucher() || voucherInfo.get("isDeficitValidated") != null || cashDeficitCtrl != 0 && acDeficitCtrl != 0)) {
                this.checkDeficit(ctx, voucherInfo);
            } else if (voucherInfo.get("isDeficitValidated") != null) {
                voucherInfo.remove("isDeficitValidated");
            }
            this.checkDeleteDapVchInGL(ctx, voucherInfo, this.sysParam, this.isFromGL);
            this.checkVchIsReversed(ctx, voucherInfo);
            this.checkPiaoJu(ctx, voucherInfo, this.sysParam);
        }
    }

    private void checkDeficit(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        int cashDeficitCtrl = this.sysParam.getInt("GL_013");
        int acDeficitCtrl = this.sysParam.getInt("GL_073");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(voucherInfo.getId().toString());
        GLBalanceCollection deficitBalColl = AccountBalanceFactory.getLocalInstance(ctx).getDeficitBalance(idSet, VoucherStatusEnum.SUBMITTED);
        if (deficitBalColl == null || deficitBalColl.size() == 0) {
            return;
        }
        boolean hasCashAccount = false;
        boolean hasAcAccount = false;
        StringBuffer[] msgs = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        GLBalanceInfo balInfo = null;
        Iterator it = deficitBalColl.iterator();
        while (it.hasNext()) {
            balInfo = (GLBalanceInfo)it.next();
            if (!hasCashAccount && (balInfo.getKey().getAccount().isIsCash() || balInfo.getKey().getAccount().isIsBank() || balInfo.getKey().getAccount().isIsCashEquivalent())) {
                hasCashAccount = true;
            } else if (!hasAcAccount && balInfo.getKey().getAccount().isAC()) {
                hasAcAccount = true;
            }
            this.getDeficitMsg(ctx, balInfo, msgs);
        }
        if (hasCashAccount && cashDeficitCtrl == 0) {
            throw new VoucherException(new NumericExceptionSubItem(null, msgs[0].toString()));
        }
        if (hasAcAccount && acDeficitCtrl == 0) {
            throw new VoucherException(new NumericExceptionSubItem(null, msgs[1].toString()));
        }
        if (hasCashAccount && hasAcAccount && acDeficitCtrl == 0 && cashDeficitCtrl == 0) {
            throw new VoucherException(new NumericExceptionSubItem(null, msgs[0].toString() + msgs[1].toString()));
        }
    }

    private void getDeficitMsg(Context ctx, GLBalanceInfo balInfo, StringBuffer[] msgs) throws BOSException, EASBizException {
        GLBalanceKey key = balInfo.getKey();
        if (balInfo.compareToZero() < 0) {
            if (balInfo.getKey().getAccount().isIsCash() || balInfo.getKey().getAccount().isIsBank() || balInfo.getKey().getAccount().isIsCashEquivalent()) {
                msgs[0].append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitNegroCashAccount"), key.getAccount().getNumber(), key.getCurrency() == null ? "null" : key.getCurrency().getName())).append(";");
            }
            if (balInfo.getKey().getAccount().isAC()) {
                msgs[1].append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitNegroACAccount"), key.getAccount().getNumber(), key.getCurrency() == null ? "null" : key.getCurrency().getName())).append(";");
            }
        }
        if (balInfo.getAsstBalColl() != null && balInfo.getAsstBalColl().size() > 0) {
            Iterator asstIt = balInfo.getAsstBalColl().iterator();
            while (asstIt.hasNext()) {
                GLAsstBalanceInfo asstBalInfo = (GLAsstBalanceInfo)asstIt.next();
                if (asstBalInfo.compareToZero() >= 0) continue;
                AssistantHGInfo hg = asstBalInfo.getKey().getHg();
                String hgName = hg.getLongNameGroup();
                if (hgName == null) {
                    hgName = this.getLongName(ctx, hg.getId().toString());
                }
                if (balInfo.getKey().getAccount().isIsCash() || balInfo.getKey().getAccount().isIsBank() || balInfo.getKey().getAccount().isIsCashEquivalent()) {
                    msgs[0].append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitCashNegroAsst"), key.getAccount().getNumber(), key.getCurrency().getName(), hgName)).append(";");
                }
                if (!balInfo.getKey().getAccount().isAC()) continue;
                msgs[1].append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitNegroACAsst"), key.getAccount().getNumber(), key.getCurrency().getName(), hgName)).append(";");
            }
        }
    }

    private String getLongName(Context ctx, String hgId) throws EASBizException, BOSException {
        if (hgId == null || hgId.trim().length() == 0) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longNameGroup"));
        AssistantHGInfo info = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(hgId), sic);
        return info.getLongNameGroup();
    }

    private void checkVoucherSource(Context ctx, VoucherInfo voucher, GlParam sysParam2, boolean isFromGL2) throws EASBizException, NumberFormatException, BOSException {
        boolean cannotModifyVouvher = this.sysParam.getBoolean("GL_104");
        if (isFromGL2 && cannotModifyVouvher && voucher.getSourceType().getValue() == 4) {
            throw new VoucherException(VoucherException.CANNOT_DELETE_IMPORT_VOUCHERNEW, new String[]{voucher.getNumber()});
        }
    }

    protected void checkMutex(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (GlUtils.isExisted(ctx, voucherInfo)) {
            this.checkMutex(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
    }

    private void checkModifyVoucherFromMain(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws GLException, EASBizException, BOSException {
        boolean canModifyVoucherFromMain = sysParam.getBoolean("GL015");
        if (!canModifyVoucherFromMain && !BooksUtil.isMasterBook((Context)ctx) && voucherInfo.isIsAccountCopy()) {
            throw new VoucherException(VoucherException.MASTERVOUCHERNOTAUDIT);
        }
    }

    private void checkVchIsChecked(Context ctx, VoucherInfo voucherInfo) throws VoucherException {
        if (voucherInfo.getCashier() != null) {
            throw new VoucherException(VoucherException.VOUCHERCHECKED);
        }
    }

    private void checkAcNoticeIsChecked(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean useAC = sysParam.getBoolean("GLG01");
        if (useAC) {
            this.checkACNoticeCorrelation(ctx, voucherInfo.getId().toString());
        }
    }

    private void checkVerifiedStatus(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        this.checkVerifiedStatus(ctx, voucherInfo, sysParam, VoucherOperateStatusEnum.DELETE);
    }

    private void checkDeleteDapVchInGL(Context ctx, VoucherInfo voucherInfo, GlParam sysParam, boolean isFromGL) throws EASBizException, NumberFormatException, BOSException {
        int deleteCtrl = sysParam.getInt("GL_019");
        boolean vchIsGL = SystemEnum.GENERALLEDGER.equals((Object)voucherInfo.getSourceSys());
        if (!vchIsGL) {
            if (deleteCtrl == 0 && isFromGL) {
                throw new VoucherException(VoucherException.DELETE_CTRL_BYOTHER, new Object[]{voucherInfo.getVoucherType().getName(), voucherInfo.getNumber()});
            }
            if (deleteCtrl == 1 && !isFromGL) {
                throw new VoucherException(VoucherException.DELETE_CTRL_BYGL, new Object[]{voucherInfo.getVoucherType().getName(), voucherInfo.getNumber()});
            }
        }
    }

    private void checkVchIsReversed(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean isSQLServer = SQLUtil.isMSSQLSERVER(ctx);
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        StringBuffer sqlReverse = new StringBuffer();
        if (cache != null && cache.isMultiThread() && isSQLServer) {
            sqlReverse.append("/*dialect*/ ");
        }
        sqlReverse.append("select fid from t_gl_voucher ");
        if (cache != null && cache.isMultiThread() && isSQLServer) {
            sqlReverse.append("with(nolock) ");
        }
        sqlReverse.append("where fsourcebillid=? and FIsReverseVoucher=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlReverse.toString(), (Object[])new Object[]{voucherInfo.getId().toString(), new Integer(1)});
        try {
            if (rs.next()) {
                throw new VoucherException(VoucherException.REVERSED_VCH_NOT_DEL);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkPiaoJu(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        this.checkPiaoJu(ctx, voucherInfo.getId().toString(), sysParam, false);
    }
}

