/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.validator.AbstractVoucherBaseValidator;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class VoucherBasePostValidator
extends AbstractVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(VoucherBasePostValidator.class);
    protected GlParam sysParam;

    public VoucherBasePostValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.checkCloseInit(ctx, voucherInfo, this.sysParam);
        this.checkVoucherPeriod(ctx, voucherInfo);
        this.checkVoucherCheck(ctx, voucherInfo, this.sysParam);
        this.checkReverseVoucher(ctx, voucherInfo);
    }

    private void checkReverseVoucher(Context ctx, VoucherInfo voucherInfo) throws VoucherException, NumberFormatException, BOSException {
        boolean isReverseVoucher = voucherInfo.isIsReverseVoucher();
        String sourceBillId = voucherInfo.getSourceBillId();
        if (isReverseVoucher && !StringUtils.isEmpty((CharSequence)sourceBillId) && this.sysParam.getInt("GL_052") != 0) {
            String verifyHistorySql = "select 1 from T_GL_ACCTCUSSENTHISTORY where FCussVchID=? or FVeriVchID = ?";
            try {
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)verifyHistorySql, (Object[])new Object[]{sourceBillId, sourceBillId});
                if (result.next()) {
                    throw new VoucherException(VoucherException.VERIFYVCHCANNOTREVERSE);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkCloseInit(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curCompany = voucherInfo.getCompany();
        boolean isClosed = VoucherProcessCache.isCloseInited(ctx, curCompany);
        if (!isClosed) {
            this.checkAccountInited(ctx, voucherInfo);
            this.checkAssitInited(ctx, voucherInfo);
            this.checkCussentInited(ctx, voucherInfo, sysParam);
        }
    }

    private void checkAccountInited(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curCompany = voucherInfo.getCompany();
        boolean isAccountClosed = VoucherProcessCache.isAccountInited(ctx, curCompany);
        if (!isAccountClosed) {
            throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
        }
    }

    private void checkAssitInited(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        String curCompanyID = voucherInfo.getCompany().getId().toString();
        Map checkMap = null;
        checkMap = VoucherUtil.checkAssitInited((Context)ctx, (String)("'" + voucherInfo.getId().toString() + "'"), (String)curCompanyID);
        if (checkMap != null && checkMap.containsKey(voucherInfo.getId().toString())) {
            String errMsg = ((StringBuffer)checkMap.get(voucherInfo.getId().toString())).toString();
            throw new GLPeriodEndException(GLPeriodEndException.ASST_INIT_NOT_CLOSED, new String[]{errMsg});
        }
    }

    private void checkCussentInited(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean isAllowCussent = sysParam.getBoolean("GL_028");
        if (isAllowCussent) {
            String curCompanyID = voucherInfo.getCompany().getId().toString();
            Map checkMap = null;
            VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
            if (cache != null) {
                checkMap = cache.getCussentInitStateMap();
            }
            if (checkMap == null || checkMap.isEmpty()) {
                checkMap = VoucherUtil.checkCussentInited((Context)ctx, (String)("'" + voucherInfo.getId().toString() + "'"), (String)curCompanyID);
            }
            if (checkMap != null && checkMap.containsKey(voucherInfo.getId().toString())) {
                String errMsg = ((StringBuffer)checkMap.get(voucherInfo.getId().toString())).toString();
                throw new GLPeriodEndException(GLPeriodEndException.CUSSENT_INIT_NOT_CLOSED, new String[]{errMsg});
            }
        }
    }

    @Override
    protected void checkVoucherPeriod(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getPeriod() == null) {
            throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
        }
        PeriodInfo currPeriod = GlUtils.getCurrentPeriod(ctx, voucherInfo.getCompany().getId().toString());
        if (voucherInfo.getPeriod().isIsAdjustPeriod() && voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() - 1) {
            return;
        }
        boolean periodValidate = false;
        Object o = voucherInfo.get("periodValidate");
        if (o != null) {
            String str = o.toString();
            periodValidate = str.equals("true");
        }
        if (periodValidate) {
            return;
        }
        if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            return;
        }
        if (voucherInfo.getPeriod().getPeriodYear() != currPeriod.getPeriodYear() || voucherInfo.getPeriod().getPeriodNumber() != currPeriod.getPeriodNumber()) {
            throw new VoucherException(VoucherException.NO_MSG, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"VCH_NOT_IN_CURRENT_PERIOD", (Locale)ctx.getLocale())});
        }
    }

    private void checkVoucherCheck(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean useWorkflow = sysParam.getBoolean("GL_032");
        boolean isCheckBeforPost = sysParam.getBoolean("GL_046");
        if (!useWorkflow && isCheckBeforPost && !voucherInfo.isIsCheck() && voucherInfo.existsCashOrBankAccount()) {
            String errMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"VOUCHERNOTCHECK", (Locale)ctx.getLocale());
            throw new VoucherException(VoucherException.NO_MSG, new String[]{errMsg});
        }
    }
}

