/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherCategoryEnum;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.common.LicenseChecker;
import com.kingdee.eas.fi.gl.validator.AbstractVoucherBaseValidator;
import com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator;
import org.apache.log4j.Logger;

public class VoucherBaseSaveValidator
extends AbstractVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(VoucherBaseSaveValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected VoucherInfo voucherInfo;
    protected IVoucherEntryValidator entryValidator;

    public VoucherBaseSaveValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        if (voucherInfo.getReportingCreditAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        if (voucherInfo.getReportingDebitAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        this.checkIsOUSealUp(ctx, voucherInfo);
        this.checkVoucherHeadEmpty(ctx, voucherInfo, this.sysParam);
        this.checkVoucherPeriod(ctx, voucherInfo);
        this.checkVoucherType(ctx, voucherInfo);
        int entryCount = voucherInfo.getEntryCount();
        if (entryCount == 0) {
            throw new VoucherException(VoucherException.ONE_ENTRY_AT_LEAST);
        }
        this.checkBudget(ctx, voucherInfo);
    }

    private void checkVoucherHeadEmpty(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean isFzz;
        if (!sysParam.isParamExisted("GL_008")) {
            sysParam.setParam("GL_008", (Object)false);
        }
        if ((isFzz = sysParam.getBoolean("GL_008")) && voucherInfo.getCurrency() == null) {
            throw new VoucherException(VoucherException.VOUCHER_CURRENCY_NULL);
        }
        if (voucherInfo.getCompany() == null) {
            throw new VoucherException(VoucherException.COMPANY_CANNOT_NULL);
        }
        if (voucherInfo.getPeriod() == null) {
            throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
        }
        if (voucherInfo.getVoucherType() == null) {
            throw new VoucherException(VoucherException.TYPE_CANNOT_NULL);
        }
        if (voucherInfo.getBookedDate() == null) {
            throw new VoucherException(VoucherException.BOOKEDDATE_NULL);
        }
        if (voucherInfo.getBizDate() == null) {
            throw new VoucherException(VoucherException.BIZDATE_NULL);
        }
        if (voucherInfo.getSourceSys() == null) {
            throw new VoucherException(VoucherException.SOUCESYS_NULL);
        }
        if (voucherInfo.getSourceType() == null) {
            throw new VoucherException(VoucherException.SOUCETYPE_NULL);
        }
    }

    private void checkBudget(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getCategory() == null) {
            throw new VoucherException(VoucherException.CATEGORY_CANNOT_NULL);
        }
        if (voucherInfo.getCategory().equals((Object)VoucherCategoryEnum.BUDGET) || voucherInfo.getCategory().equals((Object)VoucherCategoryEnum.PARALLEL)) {
            LicenseChecker.check(ctx);
        }
        int count = 0;
        int size = 0;
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            AccountViewInfo account = voucherInfo.getEntries().get(i).getAccount();
            if (account == null) continue;
            if (account.isBudget()) {
                ++count;
            }
            ++size;
        }
        if (VoucherCategoryEnum.FINANCE.equals((Object)voucherInfo.getCategory())) {
            if (count > 0) {
                throw new VoucherException(VoucherException.FINANCE_MORE_BUDGET);
            }
        } else if (VoucherCategoryEnum.BUDGET.equals((Object)voucherInfo.getCategory())) {
            if (count == 0) {
                throw new VoucherException(VoucherException.BUDGET_LESS_BUDGET);
            }
            if (count != size) {
                throw new VoucherException(VoucherException.BUDGET_MORE_FINANCE);
            }
        } else if (VoucherCategoryEnum.PARALLEL.equals((Object)voucherInfo.getCategory())) {
            if (count == 0) {
                throw new VoucherException(VoucherException.PARALLEL_LESS_BUDGET);
            }
            if (count == size) {
                throw new VoucherException(VoucherException.PARALLEL_LESS_FINANCE);
            }
        }
    }
}

