/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemType;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlLevelInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLAsstBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceCollection;
import com.kingdee.eas.fi.gl.GLBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceKey;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCategoryEnum;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.LicenseChecker;
import com.kingdee.eas.fi.gl.validator.AbstractVoucherBaseValidator;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherBaseSubmitValidator
extends AbstractVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(VoucherBaseSubmitValidator.class);
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.app.VoucherValidatorResource";
    protected Context ctx;
    protected GlParam sysParam;
    protected VoucherInfo voucherInfo;

    public String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    public VoucherBaseSubmitValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.ctx = ctx;
        this.voucherInfo = voucherInfo;
        this.checkMutex(ctx, voucherInfo);
        boolean isFzz = this.sysParam.getBoolean("GL_008");
        if (isFzz && voucherInfo.getCurrency() == null) {
            throw new VoucherException(VoucherException.VOUCHER_CURRENCY_NULL);
        }
        if (voucherInfo.getCompany() == null) {
            throw new VoucherException(VoucherException.COMPANY_CANNOT_NULL);
        }
        if (voucherInfo.getSourceSys() == null) {
            throw new VoucherException(VoucherException.SOUCESYS_NULL);
        }
        if (voucherInfo.getSourceType() == null) {
            throw new VoucherException(VoucherException.SOUCETYPE_NULL);
        }
        if (voucherInfo.getReportingCreditAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        if (voucherInfo.getReportingDebitAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        if (voucherInfo.isIsCheck()) {
            throw new VoucherException(VoucherException.VOUCHERCHECKED);
        }
        this.checkVoucherDate(ctx, voucherInfo);
        if (voucherInfo.isIncludeBNAccount() && voucherInfo.isIncludeBWAccount()) {
            throw new VoucherException(VoucherException.CANNOT_EXIST_BNANDBW);
        }
        if (!voucherInfo.isIncludeBWAccount() && voucherInfo.getEntries().size() < 2) {
            throw new VoucherException(VoucherException.ATLEAST_TOW_LINES);
        }
        this.checkIsOUSealUp(ctx, voucherInfo);
        this.checkVoucherType(ctx, voucherInfo);
        this.checkLimitMultDebitCredit(ctx, voucherInfo);
        this.checkVoucherTypeCtrlItem(ctx, voucherInfo);
        this.checkVoucherHeadAmount(ctx, voucherInfo);
        this.checkVoucherPeriod(ctx, voucherInfo);
        this.checkVoucherQty(ctx, voucherInfo);
        if ("WebService".equals(voucherInfo.getString("entrance"))) {
            this.checkVerifiedStatus(ctx, voucherInfo, VoucherOperateStatusEnum.SUBMIT);
        }
        this.checkBudget(ctx, voucherInfo);
        voucherInfo.setAccountUserProperty(this.getAccountUserProperty());
        this.checkAssistData(ctx, voucherInfo);
        this.checkAsstBalance(ctx, voucherInfo);
        this.checkRecordUserProperty(ctx, voucherInfo);
        this.checkAcNoticeVch(ctx, voucherInfo);
        int cashDeficitCtrl = this.sysParam.getInt("GL_013");
        int acDeficitCtrl = this.sysParam.getInt("GL_073");
        if (!(voucherInfo.isWebVoucher() || voucherInfo.get("isDeficitValidated") != null || cashDeficitCtrl != 0 && acDeficitCtrl != 0)) {
            this.checkDeficit(ctx, voucherInfo);
        } else if (voucherInfo.get("isDeficitValidated") != null) {
            voucherInfo.remove("isDeficitValidated");
        }
    }

    private void checkAcNoticeVch(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        boolean isGlStart;
        boolean isNoticeBySubmit;
        if (!voucherInfo.isIsACNotice()) {
            return;
        }
        boolean useACNotice = this.sysParam.getBoolean("GLG01");
        boolean bl = isNoticeBySubmit = this.sysParam.getInt("GLG01_2") == 2;
        if (useACNotice && isNoticeBySubmit && !(isGlStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)voucherInfo.getCompany()))) {
            throw new VoucherException(VoucherException.GLNOTSTART);
        }
    }

    private void checkDeficit(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        GLBalanceCollection deficitBalColl;
        boolean exist;
        VoucherInfo oldVoucher = null;
        int cashDeficitCtrl = this.sysParam.getInt("GL_013");
        int acDeficitCtrl = this.sysParam.getInt("GL_073");
        if (voucherInfo.getId() != null && (exist = VoucherFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString())))) {
            oldVoucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
        if ((deficitBalColl = AccountBalanceFactory.getLocalInstance(ctx).getDeficitBalance(oldVoucher, voucherInfo, 0)) == null || deficitBalColl.size() == 0) {
            return;
        }
        boolean hasCashAccount = false;
        boolean hasAcAccount = false;
        StringBuffer[] msgs = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        GLBalanceInfo balInfo = null;
        Iterator it = deficitBalColl.iterator();
        while (it.hasNext()) {
            balInfo = (GLBalanceInfo)it.next();
            if (!hasCashAccount && (balInfo.getKey().getAccount().isIsCash() || balInfo.getKey().getAccount().isIsBank() || balInfo.getKey().getAccount().isIsCashEquivalent())) {
                hasCashAccount = true;
            } else if (!hasAcAccount && balInfo.getKey().getAccount().isAC()) {
                hasAcAccount = true;
            }
            this.getDeficitMsg(ctx, balInfo, msgs);
        }
        if (hasCashAccount && cashDeficitCtrl == 0) {
            throw new VoucherException(new NumericExceptionSubItem(null, msgs[0].toString()));
        }
        if (hasAcAccount && acDeficitCtrl == 0) {
            throw new VoucherException(new NumericExceptionSubItem(null, msgs[1].toString()));
        }
        if (hasCashAccount && hasAcAccount && acDeficitCtrl == 0 && cashDeficitCtrl == 0) {
            throw new VoucherException(new NumericExceptionSubItem(null, msgs[0].toString() + msgs[1].toString()));
        }
    }

    private void getDeficitMsg(Context ctx, GLBalanceInfo balInfo, StringBuffer[] msgs) throws BOSException, EASBizException {
        GLBalanceKey key = balInfo.getKey();
        if (balInfo.compareToZero() < 0) {
            if (balInfo.getKey().getAccount().isIsCash() || balInfo.getKey().getAccount().isIsBank() || balInfo.getKey().getAccount().isIsCashEquivalent()) {
                msgs[0].append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitNegroCashAccount"), key.getAccount().getNumber(), key.getCurrency() == null ? "null" : key.getCurrency().getName())).append(";");
            }
            if (balInfo.getKey().getAccount().isAC()) {
                msgs[1].append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitNegroACAccount"), key.getAccount().getNumber(), key.getCurrency() == null ? "null" : key.getCurrency().getName())).append(";");
            }
        }
        if (balInfo.getAsstBalColl() != null && balInfo.getAsstBalColl().size() > 0) {
            Iterator asstIt = balInfo.getAsstBalColl().iterator();
            while (asstIt.hasNext()) {
                GLAsstBalanceInfo asstBalInfo = (GLAsstBalanceInfo)asstIt.next();
                if (asstBalInfo.compareToZero() >= 0) continue;
                AssistantHGInfo hg = asstBalInfo.getKey().getHg();
                String hgName = hg.getLongNameGroup();
                if (hgName == null) {
                    hgName = this.getLongName(ctx, hg.getId().toString());
                }
                if (balInfo.getKey().getAccount().isIsCash() || balInfo.getKey().getAccount().isIsBank() || balInfo.getKey().getAccount().isIsCashEquivalent()) {
                    msgs[0].append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitCashNegroAsst"), key.getAccount().getNumber(), key.getCurrency().getName(), hgName)).append(";");
                }
                if (!balInfo.getKey().getAccount().isAC()) continue;
                msgs[1].append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"SubmitNegroACAsst"), key.getAccount().getNumber(), key.getCurrency().getName(), hgName)).append(";");
            }
        }
    }

    private String getLongName(Context ctx, String hgId) throws EASBizException, BOSException {
        if (hgId == null || hgId.trim().length() == 0) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longNameGroup"));
        AssistantHGInfo info = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(hgId), sic);
        return info.getLongNameGroup();
    }

    public void checkVoucherQty(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        String comId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        HashMap<String, String> ins = new HashMap<String, String>();
        ins.put("GL_107", comId);
        ins.put("G010", comId);
        Map<String, Object> params = VoucherProcessCache.getParams(ctx, ins);
        boolean isQtyZeroPrompt = Boolean.valueOf(params.get("GL_107").toString());
        boolean isQtyByAcct = Boolean.valueOf(params.get("G010").toString());
        VoucherEntryCollection vchEntryColl = voucherInfo.getEntries();
        Iterator itrEntry = vchEntryColl.iterator();
        VoucherEntryInfo vchEntryInfo = null;
        while (itrEntry.hasNext()) {
            vchEntryInfo = (VoucherEntryInfo)itrEntry.next();
            AccountViewInfo acc = vchEntryInfo.getAccount();
            BigDecimal qtyEntry = vchEntryInfo.getQuantity() == null ? GlUtils.zero : vchEntryInfo.getQuantity();
            boolean isEntryQtyZero = qtyEntry.compareTo(GlUtils.zero) == 0;
            boolean promt = isQtyZeroPrompt && acc != null && acc.isIsQty() && (acc.getCAA() == null || !isQtyByAcct || isQtyByAcct && acc.getCAA() != null && acc.getCAA().isIsQty()) && isEntryQtyZero;
            if (!promt) continue;
            throw new VoucherException(VoucherException.ACC_ASSIST_QTY_ZERO);
        }
    }

    protected void checkMutex(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if ("WebService".equals(voucherInfo.getString("entrance"))) {
            return;
        }
        if (GlUtils.isExisted(ctx, voucherInfo)) {
            this.checkMutex(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
    }

    private void checkVoucherTypeCtrlItem(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Object[] para;
        VoucherUtil.fillVoucherTypeCtrlItem((Context)ctx, (VoucherInfo)voucherInfo);
        boolean vaildDebit = false;
        StringBuffer sbDebit = new StringBuffer();
        boolean vaildCredit = false;
        StringBuffer sbCredit = new StringBuffer();
        boolean vaildDC = false;
        StringBuffer sbDC = new StringBuffer();
        VoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
        VoucherTypeCtrlItemCollection voucherTypeCtrlItemCollection = voucherInfo.getVoucherType().getItems();
        Iterator iteratorVoucher = voucherTypeCtrlItemCollection.iterator();
        Iterator iteratorEntry = null;
        block8: while (iteratorVoucher.hasNext()) {
            VoucherTypeCtrlItemInfo voucherTypeCtrlItemInfo = (VoucherTypeCtrlItemInfo)iteratorVoucher.next();
            if (voucherTypeCtrlItemInfo == null) continue;
            VoucherTypeCtrlItemType voucherTypeCtrlItemType = voucherTypeCtrlItemInfo.getType();
            AccountViewInfo accountViewInfo = voucherTypeCtrlItemInfo.getAccount();
            if (accountViewInfo == null) continue;
            switch (voucherTypeCtrlItemType.getValue()) {
                case 0: {
                    if (vaildDebit) continue block8;
                    sbDebit.append(accountViewInfo.getNumber());
                    sbDebit.append(";");
                    for (VoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) || !voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        vaildDebit = true;
                        continue block8;
                    }
                    continue block8;
                }
                case 1: {
                    if (vaildCredit) continue block8;
                    sbCredit.append(accountViewInfo.getNumber());
                    sbCredit.append(";");
                    for (VoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT) || !voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        vaildCredit = true;
                        continue block8;
                    }
                    continue block8;
                }
                case 2: {
                    for (VoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) || !voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        Object[] para2 = new String[]{VoucherTypeCtrlItemType.DEBIT_MUST_NOT.toString(), accountViewInfo.getNumber()};
                        throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para2);
                    }
                    continue block8;
                }
                case 3: {
                    for (VoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT) || !voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        Object[] para3 = new String[]{VoucherTypeCtrlItemType.CREDIT_MUST_NOT.toString(), accountViewInfo.getNumber()};
                        throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para3);
                    }
                    continue block8;
                }
                case 4: {
                    if (vaildDC) continue block8;
                    sbDC.append(accountViewInfo.getNumber());
                    sbDC.append(";");
                    for (VoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        vaildDC = true;
                        continue block8;
                    }
                    continue block8;
                }
                case 5: {
                    for (VoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        Object[] para4 = new String[]{VoucherTypeCtrlItemType.DEBIT_AND_CREDIT_MUST_NOT.toString(), accountViewInfo.getNumber()};
                        throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para4);
                    }
                    continue block8;
                }
            }
        }
        if (sbDebit.length() != 0 && !vaildDebit) {
            para = new String[]{VoucherTypeCtrlItemType.DEBIT_MUST.toString(), sbDebit.toString().substring(0, sbDebit.length() - 1)};
            throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para);
        }
        if (sbCredit.length() != 0 && !vaildCredit) {
            para = new String[]{VoucherTypeCtrlItemType.CREDIT_MUST.toString(), sbCredit.toString().substring(0, sbCredit.length() - 1)};
            throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para);
        }
        if (sbDC.length() != 0 && !vaildDC) {
            para = new String[]{VoucherTypeCtrlItemType.DEBIT_OR_CREDIT_MUST.toString(), sbDC.toString().substring(0, sbDC.length() - 1)};
            throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para);
        }
    }

    private void checkEntryAccount(VoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = entryInfo.getAccount();
        if (accountViewInfo == null) {
            throw new VoucherException(VoucherException.ACCOUNT_CANNOT_NULL, new Object[]{entryInfo.getSeq()});
        }
    }

    private void checkVoucherDate(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getBookedDate() == null) {
            throw new VoucherException(VoucherException.BOOKEDDATE_NULL);
        }
        if (voucherInfo.getBizDate() == null) {
            throw new VoucherException(VoucherException.BIZDATE_NULL);
        }
        if (voucherInfo.isCheckDate() && voucherInfo.getBizDate().after(voucherInfo.getBookedDate())) {
            throw new VoucherException(VoucherException.NOTALLOWEDBIZAFTBOOK);
        }
    }

    private void checkVerifiedStatus(Context ctx, VoucherInfo vocuherInfo, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        boolean hasVerified;
        boolean isInTimeVerify;
        boolean bl = isInTimeVerify = this.sysParam.getInt("GL_052") == 0;
        if (!isInTimeVerify && this.voucherInfo.getId() != null && !this.voucherInfo.isFromSaveSubmit() && this.voucherInfo.getId() != null && (hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(this.voucherInfo.getId().toString()))) {
            throw new VoucherException(VoucherException.CANNOT_OPER_AFTER_VERIFIED, new Object[]{status.toString()});
        }
    }

    public void checkVoucherHeadAmount(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean bwMustBalance = this.sysParam.getBoolean("GL_056");
        if (!voucherInfo.isIncludeBWAccount() || voucherInfo.isIncludeBWAccount() && bwMustBalance) {
            boolean isFzz = this.sysParam.getBoolean("GL_008");
            CurrencyInfo localCur = null;
            localCur = isFzz ? voucherInfo.getCurrency() : voucherInfo.getCompany().getBaseCurrency();
            boolean isValidatorOriginalCurrency = this.sysParam.getBoolean("GL_101");
            if (!isFzz && isValidatorOriginalCurrency) {
                this.checkOriginalAmount(ctx, voucherInfo);
            }
            if (voucherInfo.getLocalCreditAmount().compareTo(voucherInfo.getLocalDebitAmount()) != 0) {
                throw new VoucherException(VoucherException.LOCAL_DC_NOT_EQUAL, new Object[]{GlUtils.formatNumber(voucherInfo.getLocalDebitAmount(), localCur.getPrecision()), GlUtils.formatNumber(voucherInfo.getLocalCreditAmount(), localCur.getPrecision())});
            }
            boolean useReportingCurrency = false;
            if (!isFzz) {
                useReportingCurrency = this.sysParam.getBoolean("G001");
            }
            if (useReportingCurrency && voucherInfo.getReportingCreditAmount().compareTo(voucherInfo.getReportingDebitAmount()) != 0) {
                throw new VoucherException(VoucherException.REPORT_DC_NOT_EQUAL);
            }
        }
    }

    private Map getAccountUserProperty() throws BOSException {
        VoucherCollection voucherColl = new VoucherCollection();
        voucherColl.add(this.voucherInfo);
        return VoucherUtil.getAccountUserProperty((Context)this.ctx, (VoucherCollection)voucherColl);
    }

    private void checkLimitMultDebitCredit(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherTypeCtrlLevelInfo levelInfo = VoucherUtil.getVoucherTypeCtrlLevelInfo((Context)ctx, (String)voucherInfo.getCompany().getId().toString(), (String)voucherInfo.getVoucherType().getId().toString());
        if (levelInfo != null && levelInfo.isLimitMultDebitCredit() && voucherInfo.getDebitEntryCount() > 1 && voucherInfo.getCreditEntryCount() > 1) {
            throw new VoucherException(VoucherException.LIMITVOUCHER);
        }
    }

    private void checkBudget(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getCategory() == null) {
            throw new VoucherException(VoucherException.CATEGORY_CANNOT_NULL);
        }
        if (voucherInfo.getCategory().equals((Object)VoucherCategoryEnum.BUDGET) || voucherInfo.getCategory().equals((Object)VoucherCategoryEnum.PARALLEL)) {
            LicenseChecker.check(ctx);
        }
        BigDecimal localDebitAmount = new BigDecimal("0.00");
        BigDecimal localCreditAmount = new BigDecimal("0.00");
        BigDecimal rptDebitAmount = new BigDecimal("0.00");
        BigDecimal rptCreditAmount = new BigDecimal("0.00");
        int count = 0;
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (entry.getAccount() == null || !entry.getAccount().isBudget()) continue;
            if (EntryDC.DEBIT.equals((Object)entry.getEntryDC())) {
                localDebitAmount = localDebitAmount.add(entry.getLocalAmount());
                rptDebitAmount = rptDebitAmount.add(entry.getReportingAmount());
            } else {
                localCreditAmount = localCreditAmount.add(entry.getLocalAmount());
                rptCreditAmount = rptCreditAmount.add(entry.getReportingAmount());
            }
            ++count;
        }
        if (VoucherCategoryEnum.FINANCE.equals((Object)voucherInfo.getCategory())) {
            if (count > 0) {
                throw new VoucherException(VoucherException.FINANCE_MORE_BUDGET);
            }
        } else if (VoucherCategoryEnum.BUDGET.equals((Object)voucherInfo.getCategory())) {
            if (count == 0) {
                throw new VoucherException(VoucherException.BUDGET_LESS_BUDGET);
            }
            if (count != voucherInfo.getEntries().size()) {
                throw new VoucherException(VoucherException.BUDGET_MORE_FINANCE);
            }
        } else if (VoucherCategoryEnum.PARALLEL.equals((Object)voucherInfo.getCategory())) {
            if (count == 0) {
                throw new VoucherException(VoucherException.PARALLEL_LESS_BUDGET);
            }
            if (count == voucherInfo.getEntries().size()) {
                throw new VoucherException(VoucherException.PARALLEL_LESS_FINANCE);
            }
        }
        boolean bwMustBalance = this.sysParam.getBoolean("GL_056");
        if (!voucherInfo.isIncludeBWAccount() || voucherInfo.isIncludeBWAccount() && bwMustBalance) {
            boolean useReportingCurrency;
            if (localDebitAmount.compareTo(localCreditAmount) != 0) {
                throw new VoucherException(VoucherException.BUDGETLOCAL_DC_NOT_EQUAL);
            }
            boolean isFzz = this.sysParam.getBoolean("GL_008");
            if (!isFzz && (useReportingCurrency = this.sysParam.getBoolean("G001")) && localDebitAmount.compareTo(localCreditAmount) != 0) {
                throw new VoucherException(VoucherException.BUDGETRPT_DC_NOT_EQUAL);
            }
        }
    }

    protected void checkCashflowAssistData(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Object loginType = ctx.get((Object)"LOGIN_TYPE");
        if (loginType != null && "WEBSERVICE".equals(loginType.toString()) && "WebService".equals(voucherInfo.getString("entrance"))) {
            return;
        }
        if (voucherInfo.getCashflowRecords() == null || voucherInfo.getCashflowRecords().size() == 0) {
            return;
        }
        if (!this.isNeedCheckAsstAct(ctx, voucherInfo)) {
            return;
        }
        HashMap<String, AssistantHGInfo> hgs = new HashMap<String, AssistantHGInfo>();
        HashMap hgIdss = new HashMap();
        HashMap asstActIdss = new HashMap();
        for (CashflowRecordInfo cashflowRecordInfo : voucherInfo.getCashflowRecords()) {
            CashFlowItemInfo primaryItem = cashflowRecordInfo.getPrimaryItem();
            if (primaryItem == null || primaryItem.getAsstAccount() == null || !primaryItem.isIsEnable() || cashflowRecordInfo.getAssGrp() == null) continue;
            String caaId = primaryItem.getAsstAccount().getId().toString();
            HashSet<String> hgIds = (HashSet<String>)hgIdss.get(caaId);
            if (hgIds == null) {
                hgIds = new HashSet<String>();
                hgIdss.put(caaId, hgIds);
            }
            AsstActTypeCollection asstActTypes = VoucherProcessCache.getAsstActTypes(ctx, caaId);
            AssistantHGInfo hg = cashflowRecordInfo.getAssGrp();
            String hgId = hg.getId().toString();
            if (hgs.containsKey(hgId) || hgIds.contains(hgId)) continue;
            if (hg.getAsstAccount() == null || hg.getAsstAccount().getId() == null) {
                hgIds.add(hg.getId().toString());
                continue;
            }
            boolean isFull = true;
            for (AsstActTypeInfo asstActType : asstActTypes) {
                DataBaseInfo data = (DataBaseInfo)hg.get(asstActType.getAsstHGAttribute());
                if (data != null && data.getId() != null) {
                    HashSet<String> asstActIds = (HashSet<String>)asstActIdss.get(asstActType.getId().toString());
                    if (asstActIds == null) {
                        asstActIds = new HashSet<String>();
                        asstActIdss.put(asstActType.getId().toString(), asstActIds);
                    }
                    asstActIds.add(data.getId().toString());
                    continue;
                }
                isFull = false;
            }
            if (isFull) {
                hgs.put(hg.getId().toString(), hg);
                continue;
            }
            hgIds.add(hg.getId().toString());
        }
        for (String caaId : hgIdss.keySet()) {
            Set hgIds = (Set)hgIdss.get(caaId);
            if (hgIds.size() <= 0) continue;
            AsstActTypeCollection asstActTypes = VoucherProcessCache.getAsstActTypes(ctx, caaId);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            Iterator it = asstActTypes.iterator();
            while (it.hasNext()) {
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo(((AsstActTypeInfo)it.next()).getAsstHGAttribute() + ".id"));
            }
            selector.add("asstAccount.id");
            view.setSelector(selector);
            int count = 0;
            List<Object> batchs = new ArrayList<Set>();
            if (hgIds.size() <= 200) {
                batchs.add(hgIds);
            } else {
                batchs = this.split(hgIds, 200);
            }
            for (Set set : batchs) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                view.setFilter(filter);
                AssistantHGCollection coll = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGCollection(view);
                count += coll.size();
                for (AssistantHGInfo hg : coll) {
                    hgs.put(hg.getId().toString(), hg);
                    if (!caaId.equals(hg.getAsstAccount().getId().toString())) {
                        hg.put("caa_error", (Object)Boolean.TRUE);
                        continue;
                    }
                    Iterator it2 = asstActTypes.iterator();
                    while (it2.hasNext()) {
                        DataBaseInfo data;
                        AsstActTypeInfo asstActType = (AsstActTypeInfo)it2.next();
                        HashSet<String> asstActIds = (HashSet<String>)asstActIdss.get(asstActType.getId().toString());
                        if (asstActIds == null) {
                            asstActIds = new HashSet<String>();
                            asstActIdss.put(asstActType.getId().toString(), asstActIds);
                        }
                        if ((data = (DataBaseInfo)hg.get(asstActType.getAsstHGAttribute())) == null) continue;
                        asstActIds.add(data.getId().toString());
                    }
                }
            }
        }
        HashMap<String, Object> asstActs = new HashMap<String, Object>();
        try {
            String cuId = null;
            if (voucherInfo.getCU() != null && voucherInfo.getCU().getId() != null) {
                cuId = voucherInfo.getCU().getId().toString();
            }
            if (cuId == null && voucherInfo.getCompany().getCU() != null && voucherInfo.getCompany().getCU().getId() != null) {
                cuId = voucherInfo.getCompany().getCU().getId().toString();
            }
            if (cuId == null) {
                cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            }
            String userId = null;
            if (voucherInfo.getCreator() != null && voucherInfo.getCreator().getId() != null) {
                userId = voucherInfo.getCreator().getId().toString();
            }
            if (userId == null) {
                userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            }
            for (String asstActTypeId : asstActIdss.keySet()) {
                AsstActTypeInfo asstActType = new AsstActTypeInfo();
                asstActType.setId(BOSUuid.read((String)asstActTypeId));
                Map<String, Object> aAsstActs = VoucherProcessCache.findAsstActByIds(ctx, asstActType, (Set)asstActIdss.get(asstActTypeId), voucherInfo.getCompany(), cuId, userId);
                asstActs.putAll(aAsstActs);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (CashflowRecordInfo cashflowRecordInfo : voucherInfo.getCashflowRecords()) {
            CashFlowItemInfo primaryItem = cashflowRecordInfo.getPrimaryItem();
            if (primaryItem == null || primaryItem.getAsstAccount() == null || !primaryItem.isIsEnable() || cashflowRecordInfo.getAssGrp() == null) continue;
            String caaId = primaryItem.getAsstAccount().getId().toString();
            AssistantHGInfo hg = cashflowRecordInfo.getAssGrp();
            if (hg.getId() == null || (hg = (AssistantHGInfo)hgs.get(hg.getId().toString())) == null) continue;
            AsstActTypeCollection asstActTypes = VoucherProcessCache.getAsstActTypes(ctx, caaId);
            for (AsstActTypeInfo asstActType : asstActTypes) {
                Object dt;
                DataBaseInfo dataBaseInfo = (DataBaseInfo)hg.get(asstActType.getAsstHGAttribute());
                if (dataBaseInfo == null || !((dt = asstActs.get(dataBaseInfo.getId().toString())) instanceof String)) continue;
                throw new VoucherException(VoucherException.CHECK_CASHFLOW_ASSISTDATA, new Object[]{cashflowRecordInfo.getEntry().getAccount().getNumber(), cashflowRecordInfo.getOpposingAccountEntry().getAccount().getNumber(), asstActType.getName(), dt});
            }
        }
    }

    protected void checkAssistData(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Object hg;
        String caaId;
        AsstAccountInfo caa;
        HashMap<String, AssistantHGInfo> hgs = new HashMap<String, AssistantHGInfo>();
        HashMap hgIdss = new HashMap();
        HashMap asstActIdss = new HashMap();
        HashMap<String, Set<String>> asstActInfoForAcNoticeMap = new HashMap<String, Set<String>>();
        HashSet<String> hgInfoForAcNoticeSet = new HashSet<String>();
        boolean voucherCommitWithNotInit = Boolean.valueOf(VoucherProcessCache.getParam(ctx, voucherInfo.getCompany().getId().toString(), "GLG01_4").toString());
        boolean isAcNotice = Boolean.valueOf(VoucherProcessCache.getParam(ctx, voucherInfo.getCompany().getId().toString(), "GLG01").toString());
        boolean isMasterAcctSch = true;
        if (isAcNotice && !voucherCommitWithNotInit) {
            if (voucherInfo.getCompany().getAccountScheme() == null || voucherInfo.getCompany().getAccountScheme().get("isMaster") == null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("accountScheme.id");
                selector.add("accountScheme.isMaster");
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(voucherInfo.getCompany().getId().toString()), selector);
                if (voucherInfo.getCompany().getAccountScheme() == null) {
                    voucherInfo.getCompany().setAccountScheme(company.getAccountScheme());
                }
                if (voucherInfo.getCompany().getAccountScheme() != null && voucherInfo.getCompany().getAccountScheme().get("isMaster") == null) {
                    voucherInfo.getCompany().getAccountScheme().setIsMaster(company.getAccountScheme().isIsMaster());
                }
            }
            if (voucherInfo.getCompany().getAccountScheme() != null && !voucherInfo.getCompany().getAccountScheme().isIsMaster()) {
                isMasterAcctSch = false;
            }
        }
        int sourceType = voucherInfo.getSourceType().getValue();
        for (Object entry : voucherInfo.getEntries()) {
            AccountViewInfo account = entry.getAccount();
            caa = entry.getCAA();
            if (caa == null || entry.getAssistRecords() == null || entry.getAssistRecords().size() == 0) continue;
            caaId = caa.getId().toString();
            HashSet<String> hgIds = (HashSet<String>)hgIdss.get(caaId);
            if (hgIds == null) {
                hgIds = new HashSet<String>();
                hgIdss.put(caaId, hgIds);
            }
            AsstActTypeCollection asstActTypes = VoucherProcessCache.getAsstActTypes(ctx, caaId);
            for (VoucherAssistRecordInfo record : entry.getAssistRecords()) {
                hg = record.getAssGrp();
                if (hg == null || hg.getId() == null) {
                    if (sourceType == 11) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(this.getResource(ctx, "org")).append(voucherInfo.getCompany().getNumber()).append("[").append(voucherInfo.getCompany().getId().toString()).append("]; ");
                        stringBuffer.append(this.getResource(ctx, "entry")).append(entry.getSeq()).append("[").append(entry.getDescription() != null ? entry.getDescription() : "").append("]; ");
                        stringBuffer.append(this.getResource(ctx, "account")).append(entry.getAccount().getNumber()).append("[").append(entry.getAccount().getId().toString()).append("]; ");
                        stringBuffer.append(this.getResource(ctx, "caa")).append(caa.getNumber()).append("[").append(caa.getName()).append(",").append(caa.getId().toString()).append("]; ");
                        stringBuffer.append(this.getResource(ctx, "assistrecord")).append(record.getSeq()).append("[").append(record.getDescription() != null ? record.getDescription() : "").append("]; ");
                        stringBuffer.append(this.getResource(ctx, "hg")).append(hg == null ? "[];" : hg).append(" ");
                        stringBuffer.append(this.getResource(ctx, "amount")).append(record.getOriginalAmount()).append(",").append(record.getLocalAmount()).append(",").append(record.getReportingAmount()).append(" ");
                        stringBuffer.append(this.getResource(ctx, "hg_not_integerity"));
                        throw new EASBizException(new NumericExceptionSubItem("101", stringBuffer.toString()));
                    }
                    throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_ASSGRP_CANNOT_NULL : VoucherException.ASSGRP_CANNOT_NULL, this.getSeq((VoucherEntryInfo)entry, record));
                }
                String string = hg.getId().toString();
                if (hgs.containsKey(string) || hgIds.contains(string)) continue;
                if (hg.getAsstAccount() == null || hg.getAsstAccount().getId() == null) {
                    hgIds.add(hg.getId().toString());
                    if (sourceType == 1 || sourceType == 2 || sourceType == 7 || sourceType == 11 || !isMasterAcctSch || !isAcNotice || voucherCommitWithNotInit || !account.isACNotice()) continue;
                    hgInfoForAcNoticeSet.add(string);
                    continue;
                }
                if (!caaId.equals(hg.getAsstAccount().getId().toString())) {
                    String msg;
                    if (voucherInfo.isWebVoucher()) {
                        msg = this.getResource(ctx, "caa_not_match1");
                        msg = MessageFormat.format(msg, entry.getSeq(), entry.getAccount().getNumber(), caaId, hg.getId());
                    } else {
                        msg = this.getResource(ctx, "caa_not_match2");
                        msg = MessageFormat.format(msg, entry.getSeq(), entry.getAccount().getNumber(), caaId, record.getSeq(), hg.getId());
                    }
                    throw new EASBizException(new NumericExceptionSubItem("101", msg));
                }
                boolean isFull = true;
                for (AsstActTypeInfo asstActType : asstActTypes) {
                    DataBaseInfo data = (DataBaseInfo)hg.get(asstActType.getAsstHGAttribute());
                    if (data != null && data.getId() != null) {
                        HashSet<String> asstActIds = (HashSet<String>)asstActIdss.get(asstActType.getId().toString());
                        if (asstActIds == null) {
                            asstActIds = new HashSet<String>();
                            asstActIdss.put(asstActType.getId().toString(), asstActIds);
                        }
                        asstActIds.add(data.getId().toString());
                    } else {
                        isFull = false;
                    }
                    String hgAttr = asstActType.getAsstHGAttribute();
                    if (sourceType == 1 || sourceType == 2 || sourceType == 7 || sourceType == 11 || !isMasterAcctSch || !isAcNotice || voucherCommitWithNotInit || !voucherInfo.isIsACNotice() || !"companyOrg".equalsIgnoreCase(hgAttr) && !"customer".equalsIgnoreCase(hgAttr) && !"provider".equalsIgnoreCase(hgAttr)) continue;
                    HashSet<String> asstActInfoForAcNotSet = (HashSet<String>)asstActInfoForAcNoticeMap.get(asstActType.getId().toString());
                    if (asstActInfoForAcNotSet == null) {
                        asstActInfoForAcNotSet = new HashSet<String>();
                        asstActInfoForAcNoticeMap.put(asstActType.getId().toString(), asstActInfoForAcNotSet);
                    }
                    if (data != null && data.getId() != null) {
                        asstActInfoForAcNotSet.add(data.getId().toString());
                        continue;
                    }
                    hgInfoForAcNoticeSet.add(string);
                }
                if (isFull) {
                    hgs.put(hg.getId().toString(), (AssistantHGInfo)hg);
                    continue;
                }
                hgIds.add(hg.getId().toString());
            }
        }
        if (sourceType == 1 && !this.isNeedCheckAsstActPNL(ctx, voucherInfo)) {
            return;
        }
        boolean foundError = false;
        for (String caaId2 : hgIdss.keySet()) {
            Set hgIds = (Set)hgIdss.get(caaId2);
            if (hgIds.size() <= 0) continue;
            AsstActTypeCollection asstActTypes = VoucherProcessCache.getAsstActTypes(ctx, caaId2);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            Iterator it = asstActTypes.iterator();
            while (it.hasNext()) {
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo(((AsstActTypeInfo)it.next()).getAsstHGAttribute() + ".id"));
            }
            selector.add("asstAccount.id");
            view.setSelector(selector);
            int count = 0;
            List<Object> batchs = new ArrayList<Set>();
            if (hgIds.size() <= 200) {
                batchs.add(hgIds);
            } else {
                batchs = this.split(hgIds, 200);
            }
            for (Set set : batchs) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                view.setFilter(filter);
                AssistantHGCollection coll = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGCollection(view);
                count += coll.size();
                block10: for (AssistantHGInfo hg2 : coll) {
                    hgs.put(hg2.getId().toString(), hg2);
                    if (!caaId2.equals(hg2.getAsstAccount().getId().toString())) {
                        hg2.put("caa_error", (Object)Boolean.TRUE);
                        foundError = true;
                        continue;
                    }
                    for (AsstActTypeInfo asstActType : asstActTypes) {
                        DataBaseInfo data;
                        HashSet<String> asstActIds = (HashSet<String>)asstActIdss.get(asstActType.getId().toString());
                        if (asstActIds == null) {
                            asstActIds = new HashSet<String>();
                            asstActIdss.put(asstActType.getId().toString(), asstActIds);
                        }
                        if ((data = (DataBaseInfo)hg2.get(asstActType.getAsstHGAttribute())) == null) {
                            hg2.put("act_error", (Object)Boolean.TRUE);
                            foundError = true;
                            continue block10;
                        }
                        asstActIds.add(data.getId().toString());
                        if (!hgInfoForAcNoticeSet.contains(hg2.getId().toString()) || !asstActInfoForAcNoticeMap.containsKey(asstActType.getId().toString()) || data == null) continue;
                        ((Set)asstActInfoForAcNoticeMap.get(asstActType.getId().toString())).add(data.getId().toString());
                    }
                }
            }
            if (count == hgIds.size()) continue;
            foundError = true;
        }
        if (foundError) {
            for (VoucherEntryInfo entry : voucherInfo.getEntries()) {
                caa = entry.getCAA();
                if (caa == null || entry.getAssistRecords() == null || entry.getAssistRecords().size() == 0) continue;
                caaId = caa.getId().toString();
                for (VoucherAssistRecordInfo record : entry.getAssistRecords()) {
                    CharSequence msg;
                    AssistantHGInfo hg3 = record.getAssGrp();
                    if (hg3 == null || hg3.getId() == null) continue;
                    if ((hg3 = (AssistantHGInfo)hgs.get(hg3.getId().toString())) == null || hg3.get("act_error") != null) {
                        if (sourceType == 11) {
                            msg = new StringBuffer();
                            ((StringBuffer)msg).append(this.getResource(ctx, "org")).append(voucherInfo.getCompany().getNumber()).append("[").append(voucherInfo.getCompany().getId().toString()).append("]; ");
                            ((StringBuffer)msg).append(this.getResource(ctx, "entry")).append(entry.getSeq()).append("[").append(entry.getDescription() != null ? entry.getDescription() : "").append("]; ");
                            ((StringBuffer)msg).append(this.getResource(ctx, "account")).append(entry.getAccount().getNumber()).append("[").append(entry.getAccount().getId().toString()).append("]; ");
                            ((StringBuffer)msg).append(this.getResource(ctx, "caa")).append(caa.getNumber()).append("[").append(caa.getName()).append(",").append(caa.getId().toString()).append("]; ");
                            ((StringBuffer)msg).append(this.getResource(ctx, "assistrecord")).append(record.getSeq()).append("[").append(record.getDescription() != null ? record.getDescription() : "").append("]; ");
                            ((StringBuffer)msg).append(this.getResource(ctx, "hg")).append((Object)(hg3 == null ? "[];" : hg3)).append(" ");
                            ((StringBuffer)msg).append(this.getResource(ctx, "amount")).append(record.getOriginalAmount()).append(",").append(record.getLocalAmount()).append(",").append(record.getReportingAmount()).append(" ");
                            ((StringBuffer)msg).append(this.getResource(ctx, "hg_not_integerity"));
                            throw new EASBizException(new NumericExceptionSubItem("101", ((StringBuffer)msg).toString()));
                        }
                        throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_ASSGRP_CANNOT_NULL : VoucherException.ASSGRP_CANNOT_NULL, this.getSeq(entry, record));
                    }
                    if (caaId.equals(hg3.getAsstAccount().getId().toString())) continue;
                    if (voucherInfo.isWebVoucher()) {
                        msg = this.getResource(ctx, "caa_not_match1");
                        msg = MessageFormat.format((String)msg, entry.getSeq(), entry.getAccount().getNumber(), caaId, hg3.getId());
                    } else {
                        msg = this.getResource(ctx, "caa_not_match2");
                        msg = MessageFormat.format((String)msg, entry.getSeq(), entry.getAccount().getNumber(), caaId, record.getSeq(), hg3.getId());
                    }
                    throw new EASBizException(new NumericExceptionSubItem("101", (String)msg));
                }
            }
        }
        this.checkAsstActIdForAcNotice(ctx, voucherInfo, hgs, asstActInfoForAcNoticeMap);
        Object loginType = ctx.get((Object)"LOGIN_TYPE");
        if (loginType != null && "WEBSERVICE".equals(loginType.toString()) && "WebService".equals(voucherInfo.getString("entrance"))) {
            return;
        }
        if (!this.isNeedCheckAsstAct(ctx, voucherInfo)) {
            return;
        }
        HashMap<String, Object> asstActs = new HashMap<String, Object>();
        try {
            String cuId = null;
            if (voucherInfo.getCU() != null && voucherInfo.getCU().getId() != null) {
                cuId = voucherInfo.getCU().getId().toString();
            }
            if (cuId == null && voucherInfo.getCompany().getCU() != null && voucherInfo.getCompany().getCU().getId() != null) {
                cuId = voucherInfo.getCompany().getCU().getId().toString();
            }
            if (cuId == null) {
                cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            }
            String userId = null;
            if (voucherInfo.getCreator() != null && voucherInfo.getCreator().getId() != null) {
                userId = voucherInfo.getCreator().getId().toString();
            }
            if (userId == null) {
                userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            }
            for (String asstActTypeId : asstActIdss.keySet()) {
                AsstActTypeInfo asstActType = new AsstActTypeInfo();
                asstActType.setId(BOSUuid.read((String)asstActTypeId));
                Map<String, Object> aAsstActs = VoucherProcessCache.findAsstActByIds(ctx, asstActType, (Set)asstActIdss.get(asstActTypeId), voucherInfo.getCompany(), cuId, userId);
                asstActs.putAll(aAsstActs);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (VoucherEntryInfo entry : voucherInfo.getEntries()) {
            AsstAccountInfo caa2 = entry.getCAA();
            if (caa2 == null || entry.getAssistRecords() == null || entry.getAssistRecords().size() == 0) continue;
            String caaId3 = caa2.getId().toString();
            for (VoucherAssistRecordInfo record : entry.getAssistRecords()) {
                hg = record.getAssGrp();
                if (hg == null || hg.getId() == null || (hg = (AssistantHGInfo)hgs.get(hg.getId().toString())) == null) continue;
                AsstActTypeCollection asstActTypeCollection = VoucherProcessCache.getAsstActTypes(ctx, caaId3);
                for (AsstActTypeInfo asstActType : asstActTypeCollection) {
                    AccountViewInfo account;
                    DataBaseInfo data = (DataBaseInfo)hg.get(asstActType.getAsstHGAttribute());
                    if (data == null) continue;
                    Object dt = asstActs.get(data.getId().toString());
                    if (dt instanceof String) {
                        String msg;
                        if (voucherInfo.isWebVoucher()) {
                            msg = this.getResource(ctx, "entry_idx");
                            msg = MessageFormat.format(msg, entry.getSeq(), asstActType.getName());
                        } else {
                            msg = this.getResource(ctx, "entry_assistrec_idx");
                            msg = MessageFormat.format(msg, entry.getSeq(), record.getSeq(), asstActType.getName());
                        }
                        throw new EASBizException(new NumericExceptionSubItem("101", msg + " " + dt));
                    }
                    if (!(dt instanceof AccountBankInfo)) continue;
                    AccountBankInfo bankAccount = (AccountBankInfo)dt;
                    if (bankAccount.getBank() != null && hg.getRegion() != null && !bankAccount.getBank().getId().equals((Object)hg.getRegion().getId())) {
                        throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_ACCOUNT_MISMATCH_BANK : VoucherException.ACCOUNT_MISMATCH_BANK, this.getSeq(entry, record));
                    }
                    if (entry.getAccount() != null && ((account = entry.getAccount()).isIsBank() || account.isIsCashEquivalent() && this.sysParam.getBoolean("GL_0155")) && (bankAccount.getAccount() == null || !account.getId().equals((Object)bankAccount.getAccount().getId()))) {
                        throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_ACCOUNT_MISMATCH_BANKACCOUNT : VoucherException.ACCOUNT_MISMATCH_BANKACCOUNT, this.getSeq(entry, record));
                    }
                    if (entry.getCurrency() == null) continue;
                    CurrencyInfo currency = entry.getCurrency();
                    if (!bankAccount.isIsByCurrency() || currency.getId().equals((Object)bankAccount.getCurrency().getId())) continue;
                    throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_BANKACCOUNT_MISMATCH_CURRENCY : VoucherException.BANKACCOUNT_MISMATCH_CURRENCY, this.getSeq(entry, record));
                }
            }
        }
    }

    private void checkAsstActIdForAcNotice(Context ctx, VoucherInfo voucherInfo, Map<String, AssistantHGInfo> hgs, Map<String, Set<String>> asstActInfoForAcNoticeMap) throws BOSException, EASBizException, VoucherException {
        if (asstActInfoForAcNoticeMap.size() > 0) {
            Map<String, Boolean> asstAcInfoForAcNotice = VoucherProcessCache.getCache(ctx).getAsstAcInfoForAcNotice();
            for (String asstActTypeId : asstActInfoForAcNoticeMap.keySet()) {
                String sql;
                AsstActTypeInfo asstActTypeInfo = VoucherProcessCache.findAsstActType(ctx, asstActTypeId);
                Set<String> asstActIds = asstActInfoForAcNoticeMap.get(asstActTypeId);
                String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
                if (asstActIds.size() <= 0) continue;
                Set<Object> internalAsstActIds = new HashSet<String>();
                if ("companyOrg".equals(asstHGAttribute)) {
                    internalAsstActIds.addAll(asstActIds);
                } else {
                    internalAsstActIds = this.getInternalCustomerOrSupplier(asstHGAttribute, asstActIds);
                }
                StringBuilder strs = new StringBuilder();
                HashSet<String> notCacheActIds = new HashSet<String>();
                for (String string : internalAsstActIds) {
                    if (asstAcInfoForAcNotice != null && asstAcInfoForAcNotice.containsKey(string)) continue;
                    strs.append("'").append(string).append("',");
                    notCacheActIds.add(string);
                }
                if (strs.length() <= 0 || (sql = this.getSystemIsInitSqlByHgAttr(asstActTypeInfo.getAsstHGAttribute(), strs.substring(0, strs.length() - 1))).length() <= 0) continue;
                try {
                    IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (iRowSet.next()) {
                        String asstActId = iRowSet.getString("bd_id");
                        boolean isStart = iRowSet.getBoolean("is_start");
                        VoucherProcessCache.getCache(ctx).putAsstActInfoForAcNotice(asstActId, isStart);
                        notCacheActIds.remove(asstActId);
                    }
                    for (String asstActId : notCacheActIds) {
                        VoucherProcessCache.getCache(ctx).putAsstActInfoForAcNotice(asstActId, false);
                    }
                }
                catch (SQLException sQLException) {
                    logger.error((Object)"query data error.", (Throwable)sQLException);
                }
            }
            Map<String, Boolean> asstAcInfoForAcNotice2 = VoucherProcessCache.getCache(ctx).getAsstAcInfoForAcNotice();
            if (asstAcInfoForAcNotice2 != null) {
                for (VoucherEntryInfo entry : voucherInfo.getEntries()) {
                    AccountViewInfo account = entry.getAccount();
                    AsstAccountInfo caa = entry.getCAA();
                    if (caa == null || entry.getAssistRecords() == null || entry.getAssistRecords().size() == 0 || !account.isACNotice()) continue;
                    String caaId = caa.getId().toString();
                    for (VoucherAssistRecordInfo record : entry.getAssistRecords()) {
                        AssistantHGInfo hg = record.getAssGrp();
                        if (hg == null || hg.getId() == null || (hg = hgs.get(hg.getId().toString())) == null) continue;
                        AsstActTypeCollection asstActTypeCollection = VoucherProcessCache.getAsstActTypes(ctx, caaId);
                        for (AsstActTypeInfo asstActType : asstActTypeCollection) {
                            String hgAttr;
                            DataBaseInfo data = (DataBaseInfo)hg.get(asstActType.getAsstHGAttribute());
                            if (data == null || !"companyOrg".equalsIgnoreCase(hgAttr = asstActType.getAsstHGAttribute()) && !"customer".equalsIgnoreCase(hgAttr) && !"provider".equalsIgnoreCase(hgAttr) || !asstAcInfoForAcNotice2.containsKey(data.getId().toString()) || Boolean.valueOf(asstAcInfoForAcNotice2.get(data.getId().toString())).booleanValue()) continue;
                            Object[] assistSeq = new Integer[voucherInfo.isWebVoucher() ? 1 : 2];
                            assistSeq[0] = new Integer(entry.getSeq());
                            if (!voucherInfo.isWebVoucher()) {
                                assistSeq[1] = new Integer(record.getSeq());
                            }
                            throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_ASSTGRP_ACNOTICE : VoucherException.ASSTGRP_ACNOTICE, assistSeq);
                        }
                    }
                }
            }
        }
    }

    private Integer[] getSeq(VoucherEntryInfo entryInfo, VoucherAssistRecordInfo recordInfo) {
        Integer[] assistSeq = new Integer[this.voucherInfo.isWebVoucher() ? 1 : 2];
        assistSeq[0] = new Integer(entryInfo.getSeq());
        if (!this.voucherInfo.isWebVoucher()) {
            assistSeq[1] = new Integer(recordInfo.getSeq());
        }
        return assistSeq;
    }

    protected boolean isNeedCheckAsstAct(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        try {
            Object obj = VoucherProcessCache.getParam(ctx, voucherInfo.getCompany().getId().toString(), "GL_CheckAsstActData");
            if (obj != null) {
                return Boolean.valueOf(obj.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return false;
    }

    protected boolean isNeedCheckAsstActPNL(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        try {
            Object obj = VoucherProcessCache.getParam(ctx, voucherInfo.getCompany().getId().toString(), "GL_CheckAsstActData_PNL");
            if (obj != null) {
                return Boolean.valueOf(obj.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return true;
    }

    private List<Set<String>> split(Set<String> set, int size) {
        ArrayList<Set<String>> list = new ArrayList<Set<String>>();
        if (set.size() <= size) {
            HashSet<String> part = new HashSet<String>();
            part.addAll(set);
            list.add(part);
        } else {
            HashSet<String> part = new HashSet<String>();
            for (String str : set) {
                part.add(str);
                if (part.size() < size) continue;
                list.add(part);
                part = new HashSet();
            }
            if (part.size() > 0) {
                list.add(part);
            }
        }
        return list;
    }

    private void checkAsstBalance(Context ctx, VoucherInfo editData) throws BOSException, EASBizException {
        BigDecimal amoumt2;
        BigDecimal amoumt;
        if (!this.sysParam.getBoolean("GL_057") || this.sysParam.getString("GL_058") == null || editData == null || editData.getEntries() == null) {
            return;
        }
        String assgrp = this.sysParam.getString("GL_058");
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        HashMap<String, DataBaseInfo> dataBase = new HashMap<String, DataBaseInfo>();
        HashMap<String, BigDecimal> dataBaseCredit = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> dataBaseDebit = new HashMap<String, BigDecimal>();
        Iterator iteratorEntry = editData.getEntries().iterator();
        VoucherAssistRecordCollection voucherAssistRecordCollection = null;
        VoucherEntryInfo voucherEntryInfo = null;
        while (iteratorEntry.hasNext()) {
            voucherEntryInfo = (VoucherEntryInfo)iteratorEntry.next();
            AccountViewInfo accountInfo = voucherEntryInfo.getAccount();
            AsstAccountInfo caa = voucherEntryInfo.getCAA();
            boolean hasRec = accountInfo != null && caa != null;
            if (!hasRec || voucherEntryInfo.getAssistRecords() == null) continue;
            voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
            Iterator iteratorAssist = voucherAssistRecordCollection.iterator();
            VoucherAssistRecordInfo voucherAssistRecordInfo = null;
            while (iteratorAssist.hasNext()) {
                voucherAssistRecordInfo = (VoucherAssistRecordInfo)iteratorAssist.next();
                AsstActTypeCollection asstActTypes = VoucherProcessCache.getAsstActTypes(ctx, caa.getId().toString());
                for (int i = 0; i < asstActTypes.size(); ++i) {
                    BigDecimal amoumt22;
                    BigDecimal amoumt3;
                    AsstActTypeInfo colInfo = asstActTypes.get(i);
                    String colKey = colInfo.getAsstHGAttribute();
                    if (!assgrp.equals(colKey)) continue;
                    AssistantHGInfo hg = voucherAssistRecordInfo.getAssGrp();
                    DataBaseInfo dabaseInfo = (DataBaseInfo)hg.get(colKey);
                    if (dabaseInfo == null && hg.getId() != null) {
                        ObjectUuidPK objectUUidPK = new ObjectUuidPK(hg.getId().toString());
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("id"));
                        selector.add(new SelectorItemInfo(colKey + ".id"));
                        selector.add(new SelectorItemInfo(colKey + ".name"));
                        selector.add(new SelectorItemInfo(colKey + ".number"));
                        hg = assistantHG.getAssistantHGInfo((IObjectPK)objectUUidPK, selector);
                        dabaseInfo = (DataBaseInfo)hg.get(colKey);
                    }
                    if (dabaseInfo == null) continue;
                    String id = dabaseInfo.getId().toString();
                    if (dataBase.get(id) == null) {
                        dataBase.put(id, dabaseInfo);
                    }
                    if ((amoumt3 = voucherAssistRecordInfo.getLocalAmount()) == null) continue;
                    if (voucherEntryInfo.getEntryDC().getValue() == 0) {
                        if (dataBaseCredit.get(id) != null) {
                            amoumt22 = (BigDecimal)dataBaseCredit.get(id);
                            dataBaseCredit.put(id, amoumt22.add(amoumt3));
                            continue;
                        }
                        dataBaseCredit.put(id, amoumt3);
                        continue;
                    }
                    if (dataBaseDebit.get(id) != null) {
                        amoumt22 = (BigDecimal)dataBaseDebit.get(id);
                        dataBaseDebit.put(id, amoumt22.add(amoumt3));
                        continue;
                    }
                    dataBaseDebit.put(id, amoumt3);
                }
            }
        }
        String select = this.getResource(ctx, "detail_not_balance");
        Set creditSet = dataBaseCredit.keySet();
        for (String key : creditSet) {
            amoumt = (BigDecimal)dataBaseCredit.get(key);
            amoumt2 = (BigDecimal)dataBaseDebit.get(key);
            if (amoumt.compareTo(GlUtils.zero) == 0 || amoumt2 != null && amoumt.compareTo(amoumt2) == 0) continue;
            DataBaseInfo dabaseInfo = (DataBaseInfo)dataBase.get(key);
            throw new EASBizException(new NumericExceptionSubItem("101", select.replace("{0}", dabaseInfo.getNumber() + "," + dabaseInfo.getName())));
        }
        creditSet = dataBaseDebit.keySet();
        for (String key : creditSet) {
            amoumt = (BigDecimal)dataBaseDebit.get(key);
            amoumt2 = (BigDecimal)dataBaseCredit.get(key);
            if (amoumt.compareTo(GlUtils.zero) == 0 || amoumt2 != null && amoumt.compareTo(amoumt2) == 0) continue;
            DataBaseInfo dabaseInfo = (DataBaseInfo)dataBase.get(key);
            throw new EASBizException(new NumericExceptionSubItem("101", select.replace("{0}", dabaseInfo.getNumber() + "," + dabaseInfo.getName())));
        }
    }

    private void checkRecordUserProperty(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        Object[] obj;
        Object list;
        AccountViewInfo account;
        VoucherEntryInfo entryInfo;
        HashMap userPropertiesMap = new HashMap();
        boolean isAdj = voucherInfo.getSourceType() != null && voucherInfo.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT);
        HashMap typeSetMap = new HashMap();
        Iterator entryIt = voucherInfo.getEntries().iterator();
        while (!isAdj && entryIt.hasNext()) {
            entryInfo = (VoucherEntryInfo)entryIt.next();
            if (entryInfo.getAssistRecords() == null || entryInfo.getAssistRecords().size() == 0 || (account = entryInfo.getAccount()) == null) continue;
            String acountID = account.getId().toString();
            list = (List)voucherInfo.getAccountUserProperty().get(acountID);
            HashSet<String> typeSet = (HashSet<String>)typeSetMap.get(acountID);
            if (typeSet == null) {
                typeSet = new HashSet<String>();
            }
            if (list != null && list.size() > 0 && typeSet.size() == 0) {
                for (int i = 0; i < list.size(); ++i) {
                    obj = (Object[])list.get(i);
                    String mappingPropName = (String)obj[2];
                    typeSet.add(mappingPropName);
                }
                typeSetMap.put(acountID, typeSet);
            }
            for (VoucherAssistRecordInfo recordInfo : entryInfo.getAssistRecords()) {
                if (recordInfo.get("orgUnit") != null && recordInfo.get("orgUnit") instanceof CompanyOrgUnitInfo && recordInfo.getOrgUnit() != null && !typeSet.contains("orgUnit")) {
                    recordInfo.setOrgUnit(null);
                }
                if (recordInfo.getCustomer() != null && !typeSet.contains("customer")) {
                    recordInfo.setCustomer(null);
                }
                if (recordInfo.getMaterial() != null && !typeSet.contains("material")) {
                    recordInfo.setMaterial(null);
                }
                if (recordInfo.get("feeType") != null && !"".equals(recordInfo.get("feeType").toString()) && recordInfo.getFeeType() != null && !typeSet.contains("feeType")) {
                    recordInfo.setFeeType(null);
                }
                if (recordInfo.getHandler() != null && !typeSet.contains("handler")) {
                    recordInfo.setHandler(null);
                }
                if (recordInfo.getBizNumber() != null && !typeSet.contains("bizNumber")) {
                    recordInfo.setBizNumber(null);
                }
                if (recordInfo.getTicketNumber() != null && !typeSet.contains("ticketNumber")) {
                    recordInfo.setTicketNumber(null);
                }
                if (recordInfo.getInvoiceNumber() != null && !typeSet.contains("invoiceNumber")) {
                    recordInfo.setInvoiceNumber(null);
                }
                if (recordInfo.getSettlementCode() != null && !typeSet.contains("settlementCode")) {
                    recordInfo.setSettlementCode(null);
                }
                if (recordInfo.getSettlementType() == null || typeSet.contains("settlementType")) continue;
                recordInfo.setSettlementType(null);
            }
        }
        entryIt = voucherInfo.getEntries().iterator();
        while (!isAdj && entryIt.hasNext()) {
            entryInfo = (VoucherEntryInfo)entryIt.next();
            account = entryInfo.getAccount();
            boolean hasUserProperty = account != null && account.isHasUserProperty();
            if (!hasUserProperty || (list = (List)voucherInfo.getAccountUserProperty().get(account.getId().toString())) == null || list.size() <= 0) continue;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                obj = (Object[])list.get(i);
                for (VoucherAssistRecordInfo recordInfo : entryInfo.getAssistRecords()) {
                    Object val = recordInfo.get((String)obj[2]);
                    if (val != null) {
                        if (obj[2].equals("supplier")) {
                            HashSet<String> supplierSet = (HashSet<String>)userPropertiesMap.get("supplier");
                            if (supplierSet == null) {
                                supplierSet = new HashSet<String>();
                                userPropertiesMap.put("supplier", supplierSet);
                            }
                            if (recordInfo.get("supplier") instanceof DataBaseInfo) {
                                supplierSet.add(((DataBaseInfo)recordInfo.get("supplier")).getId().toString());
                            }
                        } else if (obj[2].equals("customer")) {
                            HashSet<String> customerSet = (HashSet<String>)userPropertiesMap.get("customer");
                            if (customerSet == null) {
                                customerSet = new HashSet<String>();
                                userPropertiesMap.put("customer", customerSet);
                            }
                            if (recordInfo.get("customer") instanceof DataBaseInfo) {
                                customerSet.add(((DataBaseInfo)recordInfo.get("customer")).getId().toString());
                            }
                        } else if (obj[2].equals("material")) {
                            HashSet<String> materialSet = (HashSet<String>)userPropertiesMap.get("material");
                            if (materialSet == null) {
                                materialSet = new HashSet<String>();
                                userPropertiesMap.put("material", materialSet);
                            }
                            if (recordInfo.get("material") instanceof DataBaseInfo) {
                                materialSet.add(((DataBaseInfo)recordInfo.get("material")).getId().toString());
                            }
                        }
                    }
                    if ((!entryInfo.getEntryDC().equals((Object)EntryDC.CREDIT) || !((Boolean)obj[1]).booleanValue()) && (!entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) || !((Boolean)obj[0]).booleanValue()) || !(val instanceof String ? val == null || ((String)val).length() == 0 : val == null)) continue;
                    throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_USERPROPERTY_IS_NULL : VoucherException.USERPROPERTY_IS_NULL, this.getSeq(entryInfo, recordInfo));
                }
            }
        }
        HashMap<String, Object> userPropertiess = new HashMap<String, Object>();
        try {
            String cuId = null;
            if (voucherInfo.getCU() != null && voucherInfo.getCU().getId() != null) {
                cuId = voucherInfo.getCU().getId().toString();
            }
            if (cuId == null && voucherInfo.getCompany().getCU() != null && voucherInfo.getCompany().getCU().getId() != null) {
                cuId = voucherInfo.getCompany().getCU().getId().toString();
            }
            if (cuId == null) {
                cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            }
            String userId = null;
            if (voucherInfo.getCreator() != null && voucherInfo.getCreator().getId() != null) {
                userId = voucherInfo.getCreator().getId().toString();
            }
            if (userId == null) {
                userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            }
            for (String userPropertyType : userPropertiesMap.keySet()) {
                Map<String, Object> userProperties = VoucherProcessCache.findUserPropertiesByIds(ctx, userPropertyType, (Set)userPropertiesMap.get(userPropertyType), voucherInfo.getCompany(), cuId, userId);
                userPropertiess.putAll(userProperties);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (VoucherEntryInfo entryInfo2 : voucherInfo.getEntries()) {
            AccountViewInfo account2 = entryInfo2.getAccount();
            boolean hasUserProperty = account2 != null && account2.isHasUserProperty();
            if (!hasUserProperty) continue;
            for (VoucherAssistRecordInfo recordInfo : entryInfo2.getAssistRecords()) {
                List list2 = (List)voucherInfo.getAccountUserProperty().get(account2.getId().toString());
                if (list2 == null || list2.size() <= 0) continue;
                int size = list2.size();
                for (int i = 0; i < size; ++i) {
                    String msg;
                    Object[] obj2 = (Object[])list2.get(i);
                    Object userPropertyVal = recordInfo.get((String)obj2[2]);
                    Object dt = null;
                    String userPropertyTypeName = null;
                    if (userPropertyVal instanceof CustomerInfo) {
                        dt = userPropertiess.get(((CustomerInfo)userPropertyVal).getId().toString());
                        userPropertyTypeName = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"AccountCustomPropCustomer");
                    } else if (userPropertyVal instanceof SupplierInfo) {
                        dt = userPropertiess.get(((SupplierInfo)userPropertyVal).getId().toString());
                        userPropertyTypeName = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"AccountCustomPropSupplier");
                    } else {
                        if (!(userPropertyVal instanceof MaterialInfo)) continue;
                        dt = userPropertiess.get(((MaterialInfo)userPropertyVal).getId().toString());
                        userPropertyTypeName = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"AccountCustomPropMaterial");
                    }
                    if (dt == null || !(dt instanceof String)) continue;
                    if (voucherInfo.isWebVoucher()) {
                        msg = this.getResource(ctx, "userProperty_idx");
                        msg = MessageFormat.format(msg, entryInfo2.getSeq(), userPropertyTypeName);
                    } else {
                        msg = this.getResource(ctx, "userProperty_assisrec_idx");
                        msg = MessageFormat.format(msg, entryInfo2.getSeq(), recordInfo.getSeq(), userPropertyTypeName);
                    }
                    throw new EASBizException(new NumericExceptionSubItem("101", msg + " " + dt));
                }
            }
        }
    }

    private String getSystemIsInitSqlByHgAttr(String hgAttr, String idsStr) throws BOSException {
        StringBuilder sql = new StringBuilder();
        if ("companyOrg".equalsIgnoreCase(hgAttr)) {
            sql.append("select ssc.fcompanyid bd_id,ssc.fisstart is_start ");
            sql.append(" from  T_BD_SystemStatusCtrol ssc ");
            sql.append(" inner join T_BD_SystemStatus ss on ss.fid = ssc.fsystemstatusid ");
            sql.append(" where ss.fname = 6 and ssc.fcompanyid in(");
            sql.append(idsStr).append(")");
        } else if ("customer".equalsIgnoreCase(hgAttr)) {
            sql.append("select bd.fid bd_id,ssc.fisstart is_start");
            sql.append(" from  T_BD_SystemStatusCtrol ssc ");
            sql.append(" inner join T_BD_SystemStatus ss on ss.fid = ssc.fsystemstatusid ");
            sql.append(" inner join t_bd_customer bd on bd.FINTERNALCOMPANYID = ssc.fcompanyid ");
            sql.append(" where ss.fname = 6 and bd.fid in(");
            sql.append(idsStr).append(")");
        } else if ("provider".equalsIgnoreCase(hgAttr)) {
            sql.append("select bd.fid bd_id,ssc.fisstart is_start ");
            sql.append(" from  T_BD_SystemStatusCtrol ssc ");
            sql.append(" inner join T_BD_SystemStatus ss on ss.fid = ssc.fsystemstatusid ");
            sql.append(" inner join T_BD_Supplier bd on bd.FINTERNALCOMPANYID = ssc.fcompanyid ");
            sql.append(" where ss.fname = 6 and bd.fid in(");
            sql.append(idsStr).append(")");
        }
        return sql.toString();
    }

    private Set<String> getInternalCustomerOrSupplier(String asstHGAttribute, Set<String> asstActIds) throws BOSException {
        HashSet<String> internalAsstActIds;
        block4: {
            ISupplier supplier;
            SupplierCollection supplierCollection;
            EntityViewInfo ev;
            block3: {
                internalAsstActIds = new HashSet<String>();
                ev = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                ev.setSelector(selector);
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("isInternalCompany"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", asstActIds, CompareType.INCLUDE));
                ev.setFilter(filter);
                if (!"customer".equals(asstHGAttribute)) break block3;
                ICustomer customer = CustomerFactory.getLocalInstance((Context)this.ctx);
                CustomerCollection customerCollection = customer.getCustomerCollection(ev);
                if (customerCollection == null || customerCollection.size() <= 0) break block4;
                for (CustomerInfo cus : customerCollection) {
                    if (!cus.isIsInternalCompany()) continue;
                    internalAsstActIds.add(cus.getId().toString());
                }
                break block4;
            }
            if ("provider".equals(asstHGAttribute) && (supplierCollection = (supplier = SupplierFactory.getLocalInstance((Context)this.ctx)).getSupplierCollection(ev)) != null && supplierCollection.size() > 0) {
                for (SupplierInfo sup : supplierCollection) {
                    if (!sup.isIsInternalCompany()) continue;
                    internalAsstActIds.add(sup.getId().toString());
                }
            }
        }
        return internalAsstActIds;
    }
}

