/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.client;

import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.extend.KDImagePrinter;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.data.GanttChartData;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import com.kingdee.bos.ctrl.swing.chart.util.ChartDataUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.client.AbstractCommRptChartUI;
import com.kingdee.eas.framework.report.util.ChartData;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;

public class CommRptChartUI
extends AbstractCommRptChartUI
implements IPrintActionListener {
    private static final Logger logger = CoreUIObject.getLogger(CommRptChartUI.class);
    private KDChart[] chart;
    private ChartData[] data;
    private int count;
    private int activeChartIdx = 0;
    ChartType[] supports = new ChartType[]{ChartType.CT_PIE, ChartType.CT_PIEEXPLODED, ChartType.CT_PIE3D, ChartType.CT_COLUMNCLUSTERED, ChartType.CT_COLUMNSTACKED, ChartType.CT_COLUMNCLUSTERED3D, ChartType.CT_COLUMNSTACKED3D, ChartType.CT_BARCLUSTERED, ChartType.CT_BARSTACKED, ChartType.CT_BARCLUSTERED3D, ChartType.CT_BARSTACKED3D, ChartType.CT_LINE, ChartType.CT_LINESTACKED, ChartType.CT_LINEMARKERS, ChartType.CT_LINEMARKERSSTACKED, ChartType.CT_XYSCATTER, ChartType.CT_XYSCATTERLINES, ChartType.CT_XYSCATTERLINESNOMARKERS, ChartType.CT_AREA, ChartType.CT_AREASTACKED, ChartType.CT_GANTT, ChartType.CT_COMBINED_CATEGORYPLOT, ChartType.CT_COMBINED_XYPLOT};

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        List list = (List)this.getUIContext().get("chartDatas");
        if (list != null && list.size() > 0) {
            this.data = new ChartData[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.data[i] = (ChartData)list.get(i);
            }
        }
        if (this.data != null) {
            this.setupChart();
        }
    }

    protected void setupChart() {
        this.count = this.data.length;
        this.chart = new KDChart[this.count];
        if (this.count > 1) {
            KDTabbedPane page = new KDTabbedPane();
            for (int i = 0; i < this.count; ++i) {
                this.chart[i] = new KDChart();
                this.drawChart(this.chart[i], this.data[i]);
                page.addTab(this.data[i].getTitle(), (Component)this.chart[i]);
            }
            page.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    KDTabbedPane tabbedPane = (KDTabbedPane)e.getSource();
                    CommRptChartUI.this.activeChartIdx = tabbedPane.getSelectedIndex();
                }
            });
            this.add((Component)page, "Center");
        } else {
            this.chart[0] = new KDChart();
            this.drawChart(this.chart[0], this.data[0]);
            this.add((Component)this.chart[0], "Center");
        }
    }

    protected void drawChart(KDChart chart, ChartData data) {
        if (data.getType() == 0 || data.getType() == 1 || data.getType() == 2) {
            this.initPieChart(chart, data);
        } else if (data.getType() == 20) {
            this.initGanttChart(chart, data);
        } else if (data.getType() == 22 || data.getType() == 21) {
            this.initCombindChart(chart, data);
        } else {
            this.initCommChart(chart, data);
        }
    }

    protected void initPieChart(KDChart chart, ChartData data) {
        chart.setChartType(this.supports[data.getType()]);
        chart.getChartTitle().setText(data.getTitle());
        chart.getAxes(0).getCategotyAxis().getTitle().setText(data.getCategoryTitle());
        chart.getAxes(0).getValueAxis().getTitle().setText(data.getValueTitle());
        PieChartData pieChartData = ChartDataUtil.createPieChartData((String[])data.getGroupsKeys(), (double[])data.getValues()[0]);
        chart.addChartData((IChartData)pieChartData);
    }

    protected void initCommChart(KDChart chart, ChartData data) {
        chart.setChartType(this.supports[data.getType()]);
        chart.getChartTitle().setText(data.getTitle());
        chart.getAxes(0).getCategotyAxis().getTitle().setText(data.getCategoryTitle());
        chart.getAxes(0).getValueAxis().getTitle().setText(data.getValueTitle());
        CommonChartData commonChartData = ChartDataUtil.createCommonChartData((String[])data.getSeriesKeys(), (String[])data.getGroupsKeys(), (double[][])data.getValues());
        chart.addChartData((IChartData)commonChartData);
    }

    protected void initGanttChart(KDChart chart, ChartData data) {
        chart.setChartType(this.supports[data.getType()]);
        chart.getChartTitle().setText(data.getTitle());
        chart.getAxes(0).getCategotyAxis().getTitle().setText(data.getCategoryTitle());
        chart.getAxes(0).getValueAxis().getTitle().setText(data.getValueTitle());
        GanttChartData ganttChartData = ChartDataUtil.createGanttData((String[])data.getSeriesKeys(), (String[])data.getGroupsKeys(), (Date[][][])data.getDates());
        chart.addChartData((IChartData)ganttChartData);
    }

    protected void initCombindChart(KDChart chart, ChartData data) {
        chart.setChartType(this.supports[data.getType()]);
        chart.getChartTitle().setText(data.getTitle());
        chart.getAxes(0).getCategotyAxis().getTitle().setText(data.getCategoryTitle());
        chart.getAxes(0).getValueAxis().getTitle().setText(data.getValueTitle());
        for (int i = 0; i < data.getCount(); ++i) {
            CommonChartData commonChartData = ChartDataUtil.createCommonChartData((String[])data.getSeriesKeys(), (String[])data.getGroupsKeys(), (double[][])data.getCombinedValues()[i]);
            chart.addChartData((IChartData)commonChartData);
        }
        if (data.getCombinedTitles() != null) {
            String[] titles = data.getCombinedTitles();
            CombinedDomainCategoryPlot plot = (CombinedDomainCategoryPlot)chart.getDelegate().getPlot();
            List subs = plot.getSubplots();
            for (int i = 0; i < subs.size() && i < titles.length; ++i) {
                ((CategoryPlot)subs.get(i)).getRangeAxis().setLabel(titles[i]);
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPreview);
        this.btnPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPreview_actionPerformed(e);
        this.print(false);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.print(true);
    }

    protected void print(boolean toPrinter) {
        if (this.chart[this.activeChartIdx] != null) {
            KDImagePrinter imageManager = new KDImagePrinter();
            BufferedImage img = this.chart[this.activeChartIdx].createBufferedImage(this.getWidth(), this.getHeight());
            Image[] imgs = new Image[]{img};
            imageManager.setData(imgs);
            imageManager.setParent((Component)this.chart[this.activeChartIdx].getParent());
            KDPrinter printer = imageManager.getPrinter();
            printer.addPrintActionListener((IPrintActionListener)this);
            if (toPrinter) {
                imageManager.print();
            } else {
                imageManager.printPreview();
            }
            printer.removePrintActionListener((IPrintActionListener)this);
        }
    }

    public void beforePrintOrPreview() {
    }

    public void beforePreview() {
    }

    public void beforePrint() {
    }

    public void closePreview() {
    }
}

