/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.DBUtilConfig;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class DBUtils {
    private static final String DIALECT_TAG = "/*dialect*/";
    private static final DBUtils dbutil = new DBUtils();
    public static final IDialect DIALECT_KSQL = dbutil.new KSQLDialect();
    private DBUtilConfig config;

    private DBUtils() {
        this.config = new DBUtilConfig();
    }

    public DBUtils(DBUtilConfig config) {
        this.config = config;
    }

    public static DBUtilConfig getConfig() {
        return DBUtils.dbutil.config;
    }

    public static KSQLDialect getKSQLDialect() {
        return (KSQLDialect)DIALECT_KSQL;
    }

    private static IDialect getDialect(Connection con) throws SQLException {
        return DIALECT_KSQL;
    }

    public static boolean clearTable(String tableName, Connection con) throws SQLException {
        IDialect dialect = DBUtils.getDialect(con);
        String sql = dialect.getClearTable(tableName);
        return DBUtils.execute(sql, con);
    }

    public static CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con) throws Exception {
        IDialect dialect = DBUtils.getDialect(con);
        return dialect.executeSelectIntoForTempTable(ctx, sql, pp, con);
    }

    public static CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con, String ais) throws Exception {
        IDialect dialect = DBUtils.getDialect(con);
        return dialect.executeSelectIntoForTempTable(ctx, sql, pp, con, ais);
    }

    public static int executeSelectInto(String sql, SqlParams pp, Connection con) throws SQLException {
        IDialect dialect = DBUtils.getDialect(con);
        return dialect.executeSelectInto(sql, pp, con);
    }

    public static boolean execute(String sql, Connection con) throws SQLException {
        return DBUtils.execute(sql, null, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(String sql, SqlParams pp, Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            if (pp != null) {
                pp.putToStatement(ps);
            }
            boolean bl = ps.execute();
            return bl;
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    public static int executeUpdate(String sql, Connection con) throws SQLException {
        return DBUtils.executeUpdate(sql, null, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, SqlParams pp, Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            if (pp != null) {
                pp.putToStatement(ps);
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    public static RptRowSet executeQuery(String sql, Connection con) throws SQLException {
        return DBUtils.executeQuery(sql, null, con);
    }

    public static RptRowSet executeQuery(String sql, SqlParams pp, Connection con) throws SQLException {
        return DBUtils.executeQuery(sql, pp, 0, -1, con);
    }

    public static RptRowSet executeQuery(String sql, SqlParams pp, int from, Connection con) throws SQLException {
        return DBUtils.executeQuery(sql, pp, from, -1, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RptRowSet executeQuery(String sql, SqlParams pp, int from, int length, Connection con) throws SQLException {
        RptRowSet rptRowSet;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean noLimit = from < 0 && length < 0;
            IDialect dialect = DBUtils.getDialect(con);
            if (!noLimit) {
                sql = dialect.getLimitString(sql, from, length);
            }
            ps = con.prepareStatement(sql, 1004, 1007);
            if (pp != null) {
                pp.putToStatement(ps);
            }
            rs = ps.executeQuery();
            rptRowSet = dialect.parseResultSet(rs, from, length);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, ps);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return rptRowSet;
    }

    public class KSQLDialect
    extends BaseDialect {
        @Override
        public String translateSql(String sql) throws SQLException {
            return sql;
        }

        @Override
        public String getLimitString(String sql, int from, int length) {
            if (length < 0) {
                return sql;
            }
            int topCount = from + length;
            int i = sql.toLowerCase().indexOf("select ");
            String s = "select top " + topCount + " " + sql.substring(i + 7);
            return s;
        }

        @Override
        public int executeSelectInto(String sql, SqlParams pp, Connection con) throws SQLException {
            return this.executeSelectInto(sql, pp, con, DBUtils.this.config);
        }

        @Override
        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con) throws Exception {
            return this.executeSelectIntoForTempTable(ctx, sql, pp, con, DBUtils.this.config);
        }

        @Override
        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con, String ais) throws Exception {
            return this.executeSelectIntoForTempTable(ctx, sql, pp, con, ais, DBUtils.this.config);
        }

        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con, DBUtilConfig config) throws Exception {
            return this.executeSelectIntoForTempTable(ctx, sql, pp, con, null, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con, String ais, DBUtilConfig config) throws Exception {
            BaseDialect.SelectIntoSql siq = new BaseDialect.SelectIntoSql(sql);
            siq.analysisSelectInto();
            StringBuffer sb = new StringBuffer().append("select * from(").append(siq.selectFields).append(siq.fromWhere).append(") as temp_ where 1=0");
            PreparedStatement ps = con.prepareStatement(sb.toString(), 1004, 1007);
            ResultSet rs = null;
            CreateTempTableResult result = new CreateTempTableResult();
            try {
                if (pp != null) {
                    pp.putToStatement(ps);
                }
                rs = ps.executeQuery();
                String createTableSql = this.buildCreateTableString(siq.intoTableName, rs.getMetaData(), config);
                try {
                    siq.intoTableName = TempTablePool.getInstanceForRead((Context)ctx, (String)ais).createTempTable(createTableSql);
                    result.setTempTable(siq.intoTableName);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            }
            StringBuffer si = new StringBuffer().append("insert into ").append(siq.intoTableName).append(" ").append(siq.selectFields).append(siq.fromWhere);
            result.setSuccessNum(DBUtils.executeUpdate(si.toString(), pp, con));
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int executeSelectInto(String sql, SqlParams pp, Connection con, DBUtilConfig config) throws SQLException {
            BaseDialect.SelectIntoSql siq = new BaseDialect.SelectIntoSql(sql);
            siq.analysisSelectInto();
            StringBuffer sb = new StringBuffer().append("select * from(").append(siq.selectFields).append(siq.fromWhere).append(") as temp_ where 1=0");
            Statement stmt = null;
            PreparedStatement ps = con.prepareStatement(sb.toString(), 1004, 1007);
            ResultSet rs = null;
            try {
                if (pp != null) {
                    pp.putToStatement(ps);
                }
                rs = ps.executeQuery();
                String createTableSql = this.buildCreateTableString(siq.intoTableName, rs.getMetaData(), config);
                stmt = con.createStatement();
                stmt.execute(createTableSql);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            SQLUtils.cleanup((Statement)stmt);
            StringBuffer si = new StringBuffer().append("insert into ").append(siq.intoTableName).append(" ").append(siq.selectFields).append(siq.fromWhere);
            return DBUtils.executeUpdate(si.toString(), pp, con);
        }
    }

    class MSsqlDialect
    extends KSQLDialect {
        MSsqlDialect() {
        }
    }

    class DB2Dialect
    extends BaseDialect {
        DB2Dialect() {
        }

        @Override
        public String translateSql(String sql) throws SQLException {
            try {
                return TransUtil.Translate((String)sql, (int)1);
            }
            catch (SqlTranslateException e) {
                throw new SQLException("translate sql exception, message is \n" + e.getMessage());
            }
        }

        @Override
        public String getLimitString(String ksql, int from, int length) throws SQLException {
            String sql = this.translateSql(ksql);
            sql = sql.substring(DBUtils.DIALECT_TAG.length());
            int startOfSelect = sql.toLowerCase().indexOf("select");
            StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append(DBUtils.DIALECT_TAG).append(sql.substring(0, startOfSelect)).append("select * from ( select ").append(this.getRowNumber(sql));
            if (this.hasDistinct(sql)) {
                pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
            } else {
                pagingSelect.append(sql.substring(startOfSelect + 6));
            }
            pagingSelect.append(" ) as temp_ where rownumber_ ");
            if (length >= 0) {
                pagingSelect.append("between " + (from < 0 ? 0 : from) + " and " + (from < 0 ? 0 : from + length - 1));
            } else {
                pagingSelect.append(">= " + (from < 0 ? 0 : from));
            }
            return pagingSelect.toString();
        }

        private boolean hasDistinct(String sql) {
            return sql.toLowerCase().indexOf("select distinct") >= 0;
        }

        private String getRowNumber(String sql) {
            StringBuffer rownumber = new StringBuffer(50).append("rownumber() over(");
            int orderByIndex = sql.toLowerCase().lastIndexOf("order by");
            if (orderByIndex > 0 && !this.hasDistinct(sql)) {
                rownumber.append(sql.substring(orderByIndex));
            }
            rownumber.append(") as rownumber_,");
            return rownumber.toString();
        }

        @Override
        public RptRowSet parseResultSet(ResultSet rs, int startIndex, int length) throws SQLException {
            return super.parseResultSet(rs, 0, -1);
        }

        @Override
        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con) throws Exception {
            return this.executeSelectIntoForTempTable(ctx, sql, pp, con, DBUtils.this.config);
        }

        @Override
        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con, String ais) throws Exception {
            return this.executeSelectIntoForTempTable(ctx, sql, pp, con, ais, DBUtils.this.config);
        }

        @Override
        public int executeSelectInto(String sql, SqlParams pp, Connection con) throws SQLException {
            return this.executeSelectInto(sql, pp, con, DBUtils.this.config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con, String ais, DBUtilConfig config) throws Exception {
            StringBuffer sb = new StringBuffer();
            BaseDialect.SelectIntoSql siq = this.analysisSelectInto(sql);
            siq.fromWhere = this.translateFromWhere(siq.fromWhere);
            siq.selectFields = this.translateSelect(siq.selectFields);
            sb.append(DBUtils.DIALECT_TAG).append(siq.selectFields).append(' ').append(siq.fromWhere).append(" FETCH FIRST 1 ROWS ONLY");
            Statement stmt = null;
            PreparedStatement ps = con.prepareStatement(sb.toString(), 1004, 1007);
            ResultSet rs = null;
            CreateTempTableResult result = new CreateTempTableResult();
            try {
                if (pp != null) {
                    pp.putToStatement(ps);
                }
                rs = ps.executeQuery();
                String createTableSql = this.buildCreateTableString(siq.intoTableName, rs.getMetaData(), config);
                siq.intoTableName = TempTablePool.getInstanceForRead((Context)ctx, (String)ais).createTempTable(createTableSql);
                result.setTempTable(siq.intoTableName);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                SQLUtils.cleanup(stmt);
            }
            StringBuffer si = new StringBuffer();
            si.append(DBUtils.DIALECT_TAG).append(" insert into ").append(siq.intoTableName).append(' ').append(siq.selectFields).append(' ').append(siq.fromWhere);
            result.setSuccessNum(DBUtils.executeUpdate(si.toString(), pp, con));
            return result;
        }

        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con, DBUtilConfig config) throws Exception {
            return this.executeSelectIntoForTempTable(ctx, sql, pp, con, null, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int executeSelectInto(String sql, SqlParams pp, Connection con, DBUtilConfig config) throws SQLException {
            StringBuffer sb = new StringBuffer();
            BaseDialect.SelectIntoSql siq = this.analysisSelectInto(sql);
            siq.fromWhere = this.translateFromWhere(siq.fromWhere);
            siq.selectFields = this.translateSelect(siq.selectFields);
            sb.append(DBUtils.DIALECT_TAG).append(siq.selectFields).append(' ').append(siq.fromWhere).append(" FETCH FIRST 1 ROWS ONLY");
            Statement stmt = null;
            PreparedStatement ps = con.prepareStatement(sb.toString(), 1004, 1007);
            ResultSet rs = null;
            try {
                if (pp != null) {
                    pp.putToStatement(ps);
                }
                rs = ps.executeQuery();
                String createTableSql = this.buildCreateTableString(siq.intoTableName, rs.getMetaData(), config);
                stmt = con.createStatement();
                stmt.execute(createTableSql);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            SQLUtils.cleanup((Statement)stmt);
            StringBuffer si = new StringBuffer();
            si.append(DBUtils.DIALECT_TAG).append(" insert into ").append(siq.intoTableName).append(' ').append(siq.selectFields).append(' ').append(siq.fromWhere);
            return DBUtils.executeUpdate(si.toString(), pp, con);
        }
    }

    class OracleDialect
    extends BaseDialect {
        OracleDialect() {
        }

        @Override
        public String translateSql(String sql) throws SQLException {
            try {
                return TransUtil.Translate((String)sql, (int)2);
            }
            catch (SqlTranslateException e) {
                throw new SQLException("translate sql exception, message is \n" + e.getMessage());
            }
        }

        @Override
        public String getLimitString(String sql, int from, int length) {
            boolean limitLength = length >= 0;
            StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
            pagingSelect.append(DBUtils.DIALECT_TAG);
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
            pagingSelect.append(sql);
            if (limitLength) {
                pagingSelect.append(" ) row_ where rownum < " + (from < 0 ? 0 : (from + length < 0 ? 0 : length)) + ") where rownum_ >= " + (from < 0 ? 0 : from));
            } else {
                pagingSelect.append(" ) ) where rownum >= " + (from < 0 ? 0 : from));
            }
            return pagingSelect.toString();
        }

        @Override
        public String getClearTable(String tableName) {
            return "/*dialect*/truncate table " + tableName + " drop storage";
        }

        @Override
        public RptRowSet parseResultSet(ResultSet rs, int startIndex, int length) throws SQLException {
            return super.parseResultSet(rs, 0, -1);
        }

        @Override
        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String sql, SqlParams pp, Connection con) throws Exception {
            return DIALECT_KSQL.executeSelectIntoForTempTable(ctx, sql, pp, con);
        }

        @Override
        public int executeSelectInto(String sql, SqlParams pp, Connection con) throws SQLException {
            return DIALECT_KSQL.executeSelectInto(sql, pp, con);
        }

        @Override
        public CreateTempTableResult executeSelectIntoForTempTable(Context ctx, String eksql, SqlParams pp, Connection con, String ais) throws Exception {
            return DIALECT_KSQL.executeSelectIntoForTempTable(ctx, eksql, pp, con, ais);
        }
    }

    abstract class BaseDialect
    implements IDialect {
        BaseDialect() {
        }

        @Override
        public abstract String translateSql(String var1) throws SQLException;

        @Override
        public abstract String getLimitString(String var1, int var2, int var3) throws SQLException;

        @Override
        public abstract CreateTempTableResult executeSelectIntoForTempTable(Context var1, String var2, SqlParams var3, Connection var4) throws Exception;

        @Override
        public abstract int executeSelectInto(String var1, SqlParams var2, Connection var3) throws SQLException;

        @Override
        public String getClearTable(String tableName) {
            return "/*dialect*/delete from " + tableName;
        }

        @Override
        public RptRowSet parseResultSet(ResultSet rs, int startIndex, int length) throws SQLException {
            return RptRowSet.parse((ResultSet)rs, (int)startIndex, (int)length);
        }

        protected SelectIntoSql analysisSelectInto(String eKsql) {
            SelectIntoSql siq = new SelectIntoSql(eKsql);
            siq.analysisSelectInto();
            return siq;
        }

        public String buildCreateTableString(String tableName, ResultSetMetaData rsm) throws SQLException {
            return this.buildCreateTableString(tableName, rsm, DBUtils.this.config);
        }

        public String buildCreateTableString(String tableName, ResultSetMetaData rsm, DBUtilConfig config) throws SQLException {
            StringBuffer sql = new StringBuffer();
            sql.append("create table ").append(tableName).append("(\n");
            int columnCount = rsm.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String typeName = rsm.getColumnTypeName(i);
                int type = rsm.getColumnType(i);
                int colSize = rsm.getColumnDisplaySize(i);
                String colName = rsm.getColumnName(i);
                sql.append("\n").append(colName).append("\t");
                switch (type) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        sql.append("int");
                        break;
                    }
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: {
                        DBUtilConfig.NumberField nf = config.getTempTableDefaultNumberField(colName);
                        sql.append("decimal(").append(nf.integerPartLength).append(",").append(nf.precision).append(")");
                        break;
                    }
                    case 3: {
                        DBUtilConfig.NumberField nf = config.getTempTableDefaultNumberField(colName);
                        if (nf.isDefaultNumberField() && rsm.getPrecision(i) != 0) {
                            sql.append("decimal(").append(rsm.getPrecision(i)).append(",").append(rsm.getScale(i)).append(")");
                            break;
                        }
                        sql.append("decimal(").append(nf.integerPartLength).append(",").append(nf.precision).append(")");
                        break;
                    }
                    case -9: 
                    case 1: 
                    case 12: {
                        int factor = config.getVarcharFactor();
                        colSize = colSize * factor > 4000 ? 4000 : colSize * factor;
                        sql.append("varchar(" + colSize + ")");
                        break;
                    }
                    case -16: 
                    case -1: {
                        int factor = config.getVarcharFactor();
                        colSize = colSize * factor > 4000 ? 4000 : colSize * factor;
                        sql.append("varchar(" + colSize + ")");
                        break;
                    }
                    case -2: {
                        sql.append("BINARY(" + colSize + ")");
                        break;
                    }
                    case -4: 
                    case -3: {
                        sql.append("VARBINARY(" + colSize + ")");
                        break;
                    }
                    case 2004: {
                        sql.append("BLOB(" + colSize + ")");
                        break;
                    }
                    case 2005: {
                        sql.append("CLOB(" + colSize + ")");
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        sql.append("DateTime");
                        break;
                    }
                    default: {
                        throw new SQLException("invalid col.DataType:" + typeName + " Type(" + type + ")", "");
                    }
                }
                sql.append(",");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append("\n)");
            return sql.toString();
        }

        protected String translateSelect(String selectPartKsql) throws SQLException {
            String select = this.translateSql(selectPartKsql + " FROM A");
            select = select.substring(0, select.length() - " FROM A".length());
            return select;
        }

        protected String translateFromWhere(String fromWherePartKsql) throws SQLException {
            String fw = this.translateSql("SELECT 1 " + fromWherePartKsql);
            fw = fw.substring("SELECT 1 ".length());
            return fw;
        }

        class SelectIntoSql {
            String originalSql;
            String selectFields;
            String intoTableName;
            String fromWhere;

            SelectIntoSql(String sql) {
                this.originalSql = sql;
            }

            public SelectIntoSql analysisSelectInto() {
                char[] chs = this.originalSql.toCharArray();
                int intoPos = -1;
                StringBuffer sf = new StringBuffer();
                int quote = 0;
                for (int i = 0; i < chs.length; ++i) {
                    char ch = chs[i];
                    if (ch == '\'') {
                        ++quote;
                    } else if (ch == ' ' && quote % 2 == 0 && (intoPos = this.nextIsInto(chs, i + 1)) != -1) {
                        sf.append(ch);
                        break;
                    }
                    sf.append(ch);
                }
                this.selectFields = sf.toString();
                int tabPos = intoPos + "into ".length();
                this.intoTableName = this.nextWord(chs, tabPos);
                String buf = this.originalSql.substring(tabPos);
                int fromWherePos = buf.indexOf(this.intoTableName);
                this.fromWhere = buf.substring(fromWherePos + this.intoTableName.length() + 1);
                return this;
            }

            private int nextIsInto(char[] chs, int from) {
                int beginPos = -1;
                StringBuffer sb = new StringBuffer();
                int len = chs.length;
                boolean enterWord = false;
                for (int i = from; i < len; ++i) {
                    char ch = chs[i];
                    if (ch == ' ') {
                        if (!enterWord) continue;
                        break;
                    }
                    if (!enterWord) {
                        enterWord = true;
                        beginPos = i;
                    }
                    sb.append(ch);
                }
                if ("into".equalsIgnoreCase(sb.toString())) {
                    return beginPos;
                }
                return -1;
            }

            private String nextWord(char[] chs, int from) {
                StringBuffer sb = new StringBuffer();
                int len = chs.length;
                boolean enterWord = false;
                for (int i = from; i < len; ++i) {
                    char ch = chs[i];
                    if (ch == ' ' || ch == '\n') {
                        if (!enterWord) continue;
                        break;
                    }
                    if (!enterWord) {
                        enterWord = true;
                    }
                    sb.append(ch);
                }
                return sb.toString();
            }
        }
    }

    static interface IDialect {
        public String translateSql(String var1) throws SQLException;

        public String getLimitString(String var1, int var2, int var3) throws SQLException;

        public CreateTempTableResult executeSelectIntoForTempTable(Context var1, String var2, SqlParams var3, Connection var4) throws Exception;

        public CreateTempTableResult executeSelectIntoForTempTable(Context var1, String var2, SqlParams var3, Connection var4, String var5) throws Exception;

        public int executeSelectInto(String var1, SqlParams var2, Connection var3) throws SQLException;

        public String getClearTable(String var1);

        public RptRowSet parseResultSet(ResultSet var1, int var2, int var3) throws SQLException;
    }
}

