/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.IRptFilterObject;
import com.kingdee.eas.framework.report.RptFilterInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PeriodEntity
implements Serializable,
IRptFilterObject {
    private List usedList = new ArrayList();
    private List queryList = new ArrayList();
    private int[] cur;
    private boolean isUsedPeriod = false;
    private transient PeriodEntity usedPeriod = null;
    private transient PeriodEntity queryPeriod = null;

    public PeriodEntity() {
    }

    public static PeriodEntity requestPeriodEntity(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return new PeriodEntity(CommRptBaseFactory.getRemoteInstance().getPeriodRange(company));
    }

    public static PeriodEntity requestPeriodEntity(CompanyOrgUnitInfo company, Context ctx) throws BOSException, EASBizException {
        return new PeriodEntity(CommRptBaseFactory.getLocalInstance(ctx).getPeriodRange(company));
    }

    public PeriodEntity(Map allMap) {
        this.cur = (int[])allMap.get("currentPeriod");
        this.usedList = this.buildPeriodEntity((Map)allMap.get("usedPeriod"));
        this.queryList = this.buildPeriodEntity((Map)allMap.get("queryPeriod"));
    }

    private List buildPeriodEntity(Map map) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Object key : map.keySet()) {
            int[] value = (int[])map.get(key);
            list.add(new Entity((Integer)key, value));
        }
        return list;
    }

    public PeriodEntity getUsedPeriod() {
        if (this.usedPeriod == null) {
            this.usedPeriod = new PeriodEntity();
            this.usedPeriod.usedList = this.usedList;
            this.usedPeriod.queryList = this.queryList;
            this.usedPeriod.cur = this.cur;
            this.usedPeriod.isUsedPeriod = true;
        }
        return this.usedPeriod;
    }

    public PeriodEntity getQueryPeriod() {
        if (this.queryPeriod == null) {
            this.queryPeriod = new PeriodEntity();
            this.queryPeriod.usedList = this.usedList;
            this.queryPeriod.queryList = this.queryList;
            this.queryPeriod.cur = this.cur;
            this.queryPeriod.isUsedPeriod = false;
        }
        return this.queryPeriod;
    }

    public int getCurrentYear() {
        return this.cur[0];
    }

    public int getCurrentPeriod() {
        return this.cur[1];
    }

    public Iterator iterator() {
        return this.getRealUsedList().iterator();
    }

    public int getMaxYear() {
        int maxYear = -1;
        List list = this.getRealUsedList();
        for (int i = 0; i < list.size(); ++i) {
            int year = ((Entity)list.get((int)i)).year;
            if (maxYear >= year) continue;
            maxYear = year;
        }
        return maxYear;
    }

    public int getMinYear() {
        int minYear = -1;
        List list = this.getRealUsedList();
        for (int i = 0; i < list.size(); ++i) {
            int year = ((Entity)list.get((int)i)).year;
            if (minYear <= year && i != 0) continue;
            minYear = year;
        }
        return minYear;
    }

    public int getMaxPeriod(int year) {
        List list = this.getRealUsedList();
        for (int i = 0; i < list.size(); ++i) {
            Entity e = (Entity)list.get(i);
            if (year != e.year) continue;
            return e.maxPeriod;
        }
        return -1;
    }

    public int getMinPeriod(int year) {
        List list = this.getRealUsedList();
        for (int i = 0; i < list.size(); ++i) {
            Entity e = (Entity)list.get(i);
            if (year != e.year) continue;
            return e.minPeriod;
        }
        return -1;
    }

    public List getPeriodRangeList(int fromYear, int fromPeriod, int toYear, int toPeriod) {
        List list = this.getRealUsedList();
        ArrayList<int[]> result = new ArrayList<int[]>();
        int minValue = fromYear * 100 + fromPeriod;
        int maxValue = toYear * 100 + toPeriod;
        for (int i = 0; i < list.size(); ++i) {
            Entity en = (Entity)list.get(i);
            if (en.year < fromYear || en.year > toYear) continue;
            for (int j = en.minPeriod; j <= en.maxPeriod; ++j) {
                int value = en.year * 100 + j;
                if (value < minValue || value > maxValue) continue;
                result.add(new int[]{en.year, j});
            }
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                int[] p1 = (int[])o1;
                int[] p2 = (int[])o2;
                return p1[0] * 100 + p1[1] - (p2[0] * 100 + p2[1]);
            }
        });
        return result;
    }

    public IRptFilterObject toIRptFilerObject(RptFilterInfo rptFilterMap) {
        PeriodEntity pe = new PeriodEntity();
        pe.queryList = (List)rptFilterMap.getObject("queryList");
        pe.usedList = (List)rptFilterMap.getObject("usedList");
        pe.cur = rptFilterMap.getIntArray("cur");
        pe.isUsedPeriod = rptFilterMap.getBoolean("isUsedPeriod");
        return pe;
    }

    public RptFilterInfo toRptFilterInfo() {
        RptFilterInfo rptInfo = new RptFilterInfo();
        rptInfo.setRptFilterObjectClassName(this.getClass().getName());
        rptInfo.setObject("queryList", (Object)this.queryList);
        rptInfo.setObject("usedList", (Object)this.usedList);
        rptInfo.setIntArray("cur", this.cur);
        rptInfo.setBoolean("isUsedPeriod", this.isUsedPeriod);
        return rptInfo;
    }

    private List getRealUsedList() {
        if (this.isUsedPeriod) {
            return this.usedList;
        }
        return this.queryList;
    }

    public static class Entity
    implements Serializable,
    IRptFilterObject {
        private static final long serialVersionUID = -4754025185815369906L;
        int year;
        int minPeriod;
        int maxPeriod;

        public Entity() {
        }

        public Entity(Integer year, int[] periodRange) {
            this.year = year;
            this.minPeriod = periodRange[0];
            this.maxPeriod = periodRange[1];
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entity) {
                return this.year == ((Entity)obj).year;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.year;
            return result;
        }

        public IRptFilterObject toIRptFilerObject(RptFilterInfo rptFilterMap) {
            Integer year = (Integer)rptFilterMap.getObject("year");
            int minPeriod = rptFilterMap.getInt("minPeriod");
            int maxPeriod = rptFilterMap.getInt("maxPeriod");
            Entity param = new Entity(year, new int[]{minPeriod, maxPeriod});
            return param;
        }

        public RptFilterInfo toRptFilterInfo() {
            RptFilterInfo rptInfo = new RptFilterInfo();
            rptInfo.setRptFilterObjectClassName(this.getClass().getName());
            rptInfo.setObject("year", (Object)new Integer(this.year));
            rptInfo.setInt("minPeriod", this.minPeriod);
            rptInfo.setInt("maxPeriod", this.maxPeriod);
            return rptInfo;
        }
    }
}

