/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.eas.framework.report.util.CommRptResourceUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinnerUtil {
    public static boolean checkAccountCodeRange(String startCode, String endCode) {
        int dotCount2;
        String code1 = startCode.replaceAll("\\.", "");
        String code2 = endCode.replaceAll("\\.", "");
        int dotCount1 = startCode.length() - code1.length();
        int dotCount = Math.max(dotCount1, dotCount2 = endCode.length() - code2.length());
        if (dotCount > 0) {
            int i;
            for (i = dotCount - dotCount1; i > 0; --i) {
                code1 = code1 + "00";
            }
            for (i = dotCount - dotCount2; i > 0; --i) {
                code2 = code2 + "00";
            }
        }
        return Long.parseLong(code1) <= Long.parseLong(code2);
    }

    public static String[] getMaxAccountCodeRange(Set codeSet) {
        if (codeSet.isEmpty()) {
            return new String[]{null, null};
        }
        String maxCode = null;
        String minCode = null;
        Iterator iter = codeSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i == 0) {
                minCode = maxCode = (String)iter.next();
            } else {
                String buf = (String)iter.next();
                if (!SpinnerUtil.checkAccountCodeRange(minCode, buf)) {
                    minCode = buf;
                }
                if (!SpinnerUtil.checkAccountCodeRange(buf, maxCode)) {
                    maxCode = buf;
                }
            }
            ++i;
        }
        return new String[]{minCode, maxCode};
    }

    public static void manageAccountLevelRange(int min, int max, KDSpinner from, KDSpinner to) {
        from.setModel((SpinnerModel)new SpinnerNumberExModel(min, min, max, 1));
        to.setModel((SpinnerModel)new SpinnerNumberExModel(min, min, max, 1));
        from.addChangeListener((ChangeListener)new TwoSpinnerLimiter(min, max, from, to));
        to.addChangeListener((ChangeListener)new TwoSpinnerLimiter(min, max, from, to));
    }

    public static void manageAccountLevelRange2(int min, int max, KDSpinner from, KDSpinner to) {
        from.setModel((SpinnerModel)new SpinnerNumberExModel(min, min, max, 1));
        to.setModel((SpinnerModel)new SpinnerNumberExModel(max, min, max, 1));
        from.addChangeListener((ChangeListener)new TwoSpinnerLimiter(min, max, from, to));
        to.addChangeListener((ChangeListener)new TwoSpinnerLimiter(min, max, from, to));
    }

    public static void managePeriodRange(PeriodEntity pe, KDSpinner fromYear, KDSpinner fromPeriod, KDSpinner toYear, KDSpinner toPeriod, boolean unlimitToPeriod) {
        SpinnerUtil.managePeriodRange(pe, fromYear, fromPeriod, toYear, toPeriod, true, !unlimitToPeriod);
    }

    public static void managePeriodRange(PeriodEntity pe, KDSpinner fromYear, KDSpinner fromPeriod, KDSpinner toYear, KDSpinner toPeriod, boolean limitFromPeriod, boolean limitToPeriod) {
        int i;
        PeriodEntity peFrom = limitFromPeriod ? pe.getUsedPeriod() : pe.getQueryPeriod();
        PeriodEntity peTo = limitToPeriod ? pe.getUsedPeriod() : pe.getQueryPeriod();
        int curYear = peTo.getCurrentYear();
        int cuePeriod = peTo.getCurrentPeriod();
        toYear.setModel((SpinnerModel)new SpinnerNumberExModel(curYear, pe.getUsedPeriod().getMinYear(), peTo.getMaxYear(), 1));
        toPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(cuePeriod, pe.getUsedPeriod().getMinPeriod(curYear), peTo.getMaxPeriod(curYear), 1));
        fromYear.setModel((SpinnerModel)new SpinnerNumberExModel(curYear, pe.getUsedPeriod().getMinYear(), peFrom.getMaxYear(), 1));
        fromPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(cuePeriod, pe.getUsedPeriod().getMinPeriod(curYear), peFrom.getMaxPeriod(curYear), 1));
        for (i = 0; i < fromYear.getChangeListeners().length; ++i) {
            if (!(fromYear.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            fromYear.removeChangeListener(fromYear.getChangeListeners()[i]);
        }
        for (i = 0; i < toYear.getChangeListeners().length; ++i) {
            if (!(toYear.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            toYear.removeChangeListener(toYear.getChangeListeners()[i]);
        }
        for (i = 0; i < fromPeriod.getChangeListeners().length; ++i) {
            if (!(fromPeriod.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            fromPeriod.removeChangeListener(fromPeriod.getChangeListeners()[i]);
        }
        for (i = 0; i < toPeriod.getChangeListeners().length; ++i) {
            if (!(toPeriod.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            toPeriod.removeChangeListener(toPeriod.getChangeListeners()[i]);
        }
        fromYear.addChangeListener((ChangeListener)new FourSpinnerLimiter(1, peFrom, peTo, fromYear, fromPeriod, toYear, toPeriod));
        fromPeriod.addChangeListener((ChangeListener)new FourSpinnerLimiter(2, peFrom, peTo, fromYear, fromPeriod, toYear, toPeriod));
        toYear.addChangeListener((ChangeListener)new FourSpinnerLimiter(3, peFrom, peTo, fromYear, fromPeriod, toYear, toPeriod));
        toPeriod.addChangeListener((ChangeListener)new FourSpinnerLimiter(4, peFrom, peTo, fromYear, fromPeriod, toYear, toPeriod));
    }

    private static class FourSpinnerLimiter
    implements ChangeListener {
        private int tag;
        private KDSpinner fromYear;
        private KDSpinner fromPeriod;
        private KDSpinner toYear;
        private KDSpinner toPeriod;
        private PeriodEntity peFrom;
        private PeriodEntity peTo;

        public FourSpinnerLimiter(int tag, PeriodEntity peFrom, PeriodEntity peTo, KDSpinner fromYear, KDSpinner fromPeriod, KDSpinner toYear, KDSpinner toPeriod) {
            this.tag = tag;
            this.peFrom = peFrom;
            this.peTo = peTo;
            this.fromYear = fromYear;
            this.fromPeriod = fromPeriod;
            this.toYear = toYear;
            this.toPeriod = toPeriod;
        }

        private int getValue(KDSpinner spn) {
            return (Integer)spn.getValue();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int year1 = this.getValue(this.fromYear);
            int year2 = this.getValue(this.toYear);
            int period1 = this.getValue(this.fromPeriod);
            int period2 = this.getValue(this.toPeriod);
            switch (this.tag) {
                case 1: {
                    if (year1 > year2) {
                        this.toYear.setValue(this.fromYear.getValue());
                    }
                    this.suitPeriodOnYearChanged(true, ((SpinnerNumberExModel)this.fromYear.getModel()).isUp());
                    break;
                }
                case 2: {
                    if (year1 != year2 || period1 <= period2) break;
                    this.toPeriod.setValue(this.fromPeriod.getValue());
                    break;
                }
                case 3: {
                    if (year2 < year1) {
                        this.fromYear.setValue(this.toYear.getValue());
                    }
                    this.suitPeriodOnYearChanged(false, ((SpinnerNumberExModel)this.toYear.getModel()).isUp());
                    break;
                }
                case 4: {
                    if (year1 != year2 || period2 >= period1) break;
                    this.fromPeriod.setValue(this.toPeriod.getValue());
                }
            }
        }

        private void suitPeriodOnYearChanged(boolean formChanged, boolean yearUp) {
            int year1 = this.getValue(this.fromYear);
            int year2 = this.getValue(this.toYear);
            int period1 = this.getValue(this.fromPeriod);
            int period2 = this.getValue(this.toPeriod);
            int max1 = this.peFrom.getMaxPeriod(year1);
            int min1 = this.peFrom.getMinPeriod(year1);
            if (period1 < min1 || period1 > max1) {
                period1 = yearUp ? min1 : max1;
            }
            int max2 = this.peTo.getMaxPeriod(year2);
            int min2 = this.peTo.getMinPeriod(year2);
            if (period2 < min2 || period2 > max2) {
                period2 = yearUp ? min2 : (period2 < min2 ? min2 : max2);
            }
            if (year1 == year2 && period1 > period2) {
                if (formChanged) {
                    period2 = period1;
                } else {
                    period1 = period2;
                }
            }
            this.fromPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(period1, min1, max1, 1));
            this.toPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(period2, min2, max2, 1));
        }
    }

    private static class TwoSpinnerLimiter
    implements ChangeListener {
        private int min;
        private int max;
        private KDSpinner from;
        private KDSpinner to;

        TwoSpinnerLimiter(int min, int max, KDSpinner from, KDSpinner to) {
            this.min = min;
            this.max = max;
            this.from = from;
            this.to = to;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int fromValue = this.getValue(this.from);
            int toValue = this.getValue(this.to);
            if (e.getSource() == this.from) {
                if (toValue < fromValue) {
                    this.to.setValue((Object)new Integer(fromValue));
                }
            } else if (fromValue > toValue) {
                this.from.setValue((Object)new Integer(toValue));
            }
        }

        private int getValue(KDSpinner spinner) {
            return (Integer)spinner.getValue();
        }
    }

    private static class SpinnerNumberExModel
    extends SpinnerNumberModel {
        private Object lastValue = null;

        public SpinnerNumberExModel(int value, int minimum, int maximum, int stepSize) {
            super(value, minimum, maximum, stepSize);
            this.lastValue = new Integer(value);
        }

        @Override
        public void setValue(Object value) {
            Object curValue = this.getValue();
            super.setValue(value);
            if (curValue != value) {
                this.lastValue = value;
            }
        }

        public int getLastValue() {
            if (this.lastValue == null) {
                throw new RuntimeException(CommRptResourceUtil.getRes((String)"not_init"));
            }
            return (Integer)this.lastValue;
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }

        public boolean isUp() {
            return this.getIntValue() > this.getLastValue();
        }
    }
}

