/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.bi.BIItemFactory;
import com.kingdee.eas.fi.gr.bi.RptItemAnalysisFacadeFactory;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.util.Calendar;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class ExtractItemDataUI
extends KDDialog {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.bi.client.ExtractItemDataUI");
    protected ResourceBundleHelper resHelper = null;
    protected KDButton btnOK;
    protected KDComboBox periodType;
    protected KDDatePicker date;
    protected KDTextField txtYear;
    protected KDComboBox comboOrgTree;
    protected KDLabel kDLabel1;
    protected KDLabel kDLabel2;
    protected KDLabel kDLabel3;
    protected KDLabel kDLabel4;
    protected KDLabel kDLabel5;
    protected KDSpinner spCurPeriod;

    public static ExtractItemDataUI createDialog(Frame owner) {
        return new ExtractItemDataUI(owner);
    }

    public ExtractItemDataUI(Frame owner) {
        super(owner, true);
        this.init();
        logger.info((Object)this.getName());
    }

    private void jbInit() {
        this.btnOK = new KDButton();
        this.periodType = new KDComboBox();
        this.date = new KDDatePicker();
        this.txtYear = new KDTextField();
        this.comboOrgTree = new KDComboBox();
        this.kDLabel1 = new KDLabel();
        this.kDLabel2 = new KDLabel();
        this.kDLabel3 = new KDLabel();
        this.kDLabel4 = new KDLabel();
        this.kDLabel5 = new KDLabel();
        this.spCurPeriod = new KDSpinner();
        this.setName("ExtractItemDataUI");
        this.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"41_ExtractItemDataUI"));
        this.btnOK.setName("btnOK");
        this.periodType.setName("periodType");
        this.date.setName("date");
        this.txtYear.setName("txtYear");
        this.comboOrgTree.setName("prmtOrgTree");
        this.kDLabel1.setName("kDLabel1");
        this.kDLabel2.setName("kDLabel2");
        this.kDLabel3.setName("kDLabel3");
        this.kDLabel4.setName("kDLabel4");
        this.kDLabel5.setName("kDLabel5");
        this.spCurPeriod.setName("spCurPeriod");
        this.date.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ExtractItemDataUI.this.dateChanged(ExtractItemDataUI.this.date.getSqlDate());
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Throwable)exc);
                }
            }
        });
        this.periodType.addItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.periodType.addItem((Object)RptPeriodTypeEnum.QUARTERLY);
        this.periodType.addItem((Object)RptPeriodTypeEnum.SEMIYEARLY);
        this.periodType.addItem((Object)RptPeriodTypeEnum.YEARLY);
        this.periodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.periodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExtractItemDataUI.this.dateChanged(ExtractItemDataUI.this.date.getSqlDate());
            }
        });
        this.btnOK.setAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OrgTreeInfo orgTreeInfo;
                    int year = Integer.parseInt(ExtractItemDataUI.this.txtYear.getText());
                    int period = (Integer)ExtractItemDataUI.this.spCurPeriod.getValue() != null ? (Integer)ExtractItemDataUI.this.spCurPeriod.getValue() : 0;
                    int periodTypeValue = ((RptPeriodTypeEnum)ExtractItemDataUI.this.periodType.getSelectedItem()).getValue();
                    String periodId = RptBiUtil.generatePeriodID(year, period) + periodTypeValue;
                    boolean existsExtractedItemData = RptItemAnalysisFacadeFactory.getRemoteInstance().existsExtractedItemData(periodId);
                    boolean isOverride = false;
                    if (existsExtractedItemData) {
                        int choose = MsgBox.showConfirm3((Component)((Object)ExtractItemDataUI.this), (String)RptBiUtil.getString("dataExistOverride"));
                        switch (choose) {
                            case 0: {
                                isOverride = true;
                                break;
                            }
                            case 1: {
                                isOverride = false;
                                break;
                            }
                            default: {
                                SysUtil.abort();
                                break;
                            }
                        }
                    } else {
                        isOverride = true;
                    }
                    if ((orgTreeInfo = (OrgTreeInfo)ExtractItemDataUI.this.comboOrgTree.getSelectedItem()) == null) {
                        return;
                    }
                    String orgTreeId = orgTreeInfo.getId().toString();
                    BIItemFactory.getRemoteInstance().extractItemData(new Integer(year), new Integer(period), new Integer(periodTypeValue), orgTreeId, isOverride);
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"42_ExtractItemDataUI"));
                    ExtractItemDataUI.this.dispose();
                }
                catch (Exception e1) {
                    logger.error((Object)"btnOK.setAction_Exception", (Throwable)e1);
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.btnOK.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"43_ExtractItemDataUI"));
        this.spCurPeriod.setEnabled(false);
        this.kDLabel1.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"785_ExtractItemDataUI"));
        this.kDLabel2.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"44_ExtractItemDataUI"));
        this.kDLabel3.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"45_ExtractItemDataUI"));
        this.kDLabel4.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"786_ExtractItemDataUI"));
        this.kDLabel5.setText(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"46_ExtractItemDataUI"));
        this.dateChanged(new Date(Calendar.getInstance().getTimeInMillis()));
    }

    protected void dateChanged(Date d) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.periodType.getSelectedItem();
        if (p == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod(d, p);
        this.txtYear.setText(times.get(0).toString());
        this.spCurPeriod.setValue(times.get(1));
        this.date.setValue(times.get(2));
        this.refresh13Period();
        try {
            this.refreshOrgBound(d);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void refreshOrgBound(Date date) throws EASBizException, BOSException {
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection(date);
        OrgTreeInfo tree = null;
        OrgTreeInfo info = null;
        IOrgTree itree = OrgTreeFactory.getRemoteInstance();
        for (int i = otc.size() - 1; i >= 0; --i) {
            tree = otc.get(i);
            info = itree.getOrgTreeInfo((IObjectPK)new ObjectUuidPK(tree.getId()));
            if (!info.isIsHide()) continue;
            otc.remove(tree);
        }
        if (otc == null) {
            return;
        }
        this.comboOrgTree.removeAllItems();
        this.comboOrgTree.addItems(otc.toArray());
        for (OrgTreeInfo element : otc) {
            if (!element.isBasic()) continue;
            this.comboOrgTree.getModel().setSelectedItem(element);
            break;
        }
    }

    protected void init() {
        this.jbInit();
        this.setBounds(new Rectangle(10, 10, 350, 148));
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        this.btnOK.setBounds(new Rectangle(253, 94, 85, 21));
        this.getContentPane().add((Component)this.btnOK, new KDLayout.Constraints(253, 62, 85, 21, 0));
        this.periodType.setBounds(new Rectangle(74, 9, 86, 19));
        this.getContentPane().add((Component)this.periodType, new KDLayout.Constraints(74, 9, 86, 19, 0));
        this.date.setBounds(new Rectangle(210, 9, 124, 19));
        this.getContentPane().add((Component)this.date, new KDLayout.Constraints(210, 9, 124, 19, 0));
        this.txtYear.setBounds(new Rectangle(74, 37, 86, 19));
        this.getContentPane().add((Component)this.txtYear, new KDLayout.Constraints(74, 37, 86, 19, 0));
        this.spCurPeriod.setBounds(new Rectangle(210, 37, 124, 19));
        this.getContentPane().add((Component)this.spCurPeriod, new KDLayout.Constraints(210, 37, 124, 19, 0));
        this.comboOrgTree.setBounds(new Rectangle(74, 65, 260, 19));
        this.getContentPane().add((Component)this.comboOrgTree, new KDLayout.Constraints(74, 65, 260, 19, 0));
        this.kDLabel1.setBounds(new Rectangle(10, 37, 19, 19));
        this.getContentPane().add((Component)this.kDLabel1, new KDLayout.Constraints(10, 37, 19, 19, 0));
        this.kDLabel2.setBounds(new Rectangle(10, 9, 61, 19));
        this.getContentPane().add((Component)this.kDLabel2, new KDLayout.Constraints(10, 9, 61, 19, 0));
        this.kDLabel3.setBounds(new Rectangle(169, 9, 36, 19));
        this.getContentPane().add((Component)this.kDLabel3, new KDLayout.Constraints(169, 9, 36, 19, 0));
        this.kDLabel4.setBounds(new Rectangle(169, 37, 39, 19));
        this.getContentPane().add((Component)this.kDLabel4, new KDLayout.Constraints(169, 37, 39, 19, 0));
        this.kDLabel5.setBounds(new Rectangle(10, 65, 50, 19));
        this.getContentPane().add((Component)this.kDLabel5, new KDLayout.Constraints(10, 65, 50, 19, 0));
        ExtractItemDataUI.setToScreenCenter((Window)((Object)this));
    }

    public static void setToScreenCenter(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = window.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refresh13Period() {
        if (!CslRptUtil.isSupport13Period(null)) return;
        RptPeriodTypeEnum RptPeriodTypeEnum2 = (RptPeriodTypeEnum)this.periodType.getSelectedItem();
        int periodType = RptPeriodTypeEnum2 == null ? 0 : RptPeriodTypeEnum2.getValue();
        if (3 == periodType) {
            if (RPTDateUtil.isYearLastPeriod((java.util.Date)this.date.getValue(), RptPeriodTypeEnum.MONTHLY)) {
                this.spCurPeriod.setEnabled(true);
                CslRptUIUtil.setSpineRange(this.spCurPeriod, 12, 13);
                return;
            }
        }
        this.spCurPeriod.setEnabled(false);
        CslRptUIUtil.setSpineRange(this.spCurPeriod, 0, 365);
    }
}

