/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.fi.gr.bi.client.AbstractRptBiBaseFilterUI;
import com.kingdee.eas.fi.gr.bi.client.EnumChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserContentProvider;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public abstract class RptBiBaseFilterUI
extends AbstractRptBiBaseFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptBiBaseFilterUI.class);
    private int result = 2;
    private boolean isOpenOnMainui;
    private Action okAction;
    protected boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);

    abstract String getMainUIName();

    int isQueryBudget() {
        return 0;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isMergeByFiscalPeriod && this.getUIContext().get("BOOK_PROVIDER") != null) {
            ReportBaseInfo info = (ReportBaseInfo)((IBookProvider)this.getUIContext().get("BOOK_PROVIDER")).getEditValue();
            if (info instanceof ReportInfo) {
                this.getUIContext().put("periodCollection", InitDataFacadaFactory.getRemoteInstance().getFiscal());
            } else if (info instanceof CslReportInfo) {
                this.getUIContext().put("periodCollection", FiscalPeriodHelper.getPeriodCollection(null, info));
            }
        }
        AbstractAction myaction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == RptBiBaseFilterUI.this.btnOK) {
                    if (RptBiBaseFilterUI.this.verify()) {
                        RptBiBaseFilterUI.this.result = 0;
                        if (!RptBiBaseFilterUI.this.isOpenOnMainui) {
                            RptBiBaseFilterUI.this.getUIWindow().close();
                            Map ctx = RptBiBaseFilterUI.this.getUIContext();
                            ctx.put("com.kingdee.eas.framework.bireport.client.BireportBaseMainUI#UICONTEXT_KEY_BE_JOINQUERY", true);
                            ctx.put("com.kingdee.eas.framework.bireport.client.BireportBaseMainUI#UICONTEXT_KEY_JOINQUERY_PARAMS", RptBiBaseFilterUI.this.getCustomCondition());
                            ctx.put("Owner", RptBiBaseFilterUI.this.getUIContext().get("Owner"));
                            ctx.put("ISQUERYBUDGET", new Integer(RptBiBaseFilterUI.this.isQueryBudget()));
                            ctx.put("SINGLE" + System.currentTimeMillis(), "");
                            try {
                                IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RptBiBaseFilterUI.this.getMainUIName(), ctx, RptBiBaseFilterUI.this.dataObjects);
                                win.show();
                            }
                            catch (UIException e1) {
                                ExceptionHandler.handle((Throwable)e1);
                            }
                        } else {
                            RptBiBaseFilterUI.this.okAction.actionPerformed(e);
                            RptBiBaseFilterUI.this.getUIWindow().close();
                        }
                    }
                } else if (e.getSource() == RptBiBaseFilterUI.this.btnCancel) {
                    RptBiBaseFilterUI.this.result = 2;
                    RptBiBaseFilterUI.this.getUIWindow().close();
                }
            }
        };
        String text = this.btnOK.getText();
        this.btnOK.setAction((Action)myaction);
        this.btnOK.setText(text);
        text = this.btnCancel.getText();
        this.btnCancel.setAction((Action)myaction);
        this.btnCancel.setText(text);
        this.btnOK.setActionCommand("OK");
        this.btnCancel.setActionCommand("CANCEL");
    }

    public int getResult() {
        return this.result;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected SumcalcRange getRange(String text) {
        try {
            return new SumcalcRange(text);
        }
        catch (Exception e) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"1_RptBiBaseFilterUI");
            MsgBox.showError((Component)((Object)this), (String)MessageFormat.format(msg, text));
            return null;
        }
    }

    protected void setPeriodRange(KDSpinner sp, int period_type, int year) {
        int max = 1;
        int min = 1;
        switch (period_type) {
            case 6: {
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 3: {
                if (CslRptUtil.isSupport13Period(null)) {
                    max = 13;
                    break;
                }
                max = 12;
                break;
            }
            case 2: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(3, 1);
                } while (cal.get(1) == year);
                max = count;
                break;
            }
            case 1: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(6, 1);
                } while (cal.get(1) == year);
                max = count;
            }
        }
        this.setSpineRange(sp, min, max);
    }

    protected void setSpineRange(KDSpinner sp, int minVal, int maxVal) {
        Integer n2;
        if (sp == null) {
            return;
        }
        SpinnerModel sm = sp.getModel();
        if (!(sm instanceof SpinnerNumberModel)) {
            return;
        }
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        try {
            n2 = new Integer(maxVal);
            nm.setMaximum(n2);
            if (n2 < 0) {
                nm.setValue(n2);
            }
        }
        catch (NumberFormatException n2) {
            // empty catch block
        }
        try {
            n2 = new Integer(minVal);
            nm.setMinimum(n2);
            if (n2 > 0) {
                nm.setValue(n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setIsOpenOnMainUI(boolean b) {
        this.isOpenOnMainui = b;
    }

    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }

    public void setInitParams(RptParams params) {
    }

    public boolean isOpenOnMainui() {
        return this.isOpenOnMainui;
    }

    protected void createDataSrcPromp(final KDBizPromptBox dataTypePromp) {
        dataTypePromp.setEditable(false);
        dataTypePromp.setSelectAllOnFocus(false);
        dataTypePromp.setSelector((KDPromptSelector)new SortableChooser(new IChooserContentProvider(){
            List contents = null;

            @Override
            public int compare(Object obj1, Object obj2) {
                return obj1 == obj2 ? 0 : 1;
            }

            @Override
            public boolean enableFilter() {
                return false;
            }

            @Override
            public List getContents() throws Exception {
                if (this.contents == null) {
                    this.contents = new ArrayList();
                    this.contents.add(ValueTypeEnum.MONEY);
                    this.contents.add(ValueTypeEnum.QUANTITY);
                }
                return this.contents;
            }

            @Override
            public List getSelected() {
                return (List)dataTypePromp.getData();
            }

            @Override
            public boolean matchFilter(Object item, int column, String filterString) {
                return false;
            }

            @Override
            public void setContents(ArrayList contents) {
                this.contents = contents;
            }

            @Override
            public boolean enableTemplateFilter() {
                return false;
            }
        }, new EnumChooserLabelProvider(), (IUIObject)this));
        dataTypePromp.setData(Arrays.asList(new Object[]{ValueTypeEnum.MONEY}));
        dataTypePromp.setRequired(true);
    }
}

