/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.bi.client.AbstractSortableItemChooserUI;
import com.kingdee.eas.fi.gr.bi.client.IChooserContentProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletItemListCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletItemListFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletItemListInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFacadeFactory;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SortableItemChooserUI
extends AbstractSortableItemChooserUI {
    private static final long serialVersionUID = -4410364240590266800L;
    private static final Logger logger = CoreUIObject.getLogger(SortableItemChooserUI.class);
    protected IChooserContentProvider contentProvider;
    protected IChooserLabelProvider labelProvider;
    private String displayInfo = null;
    protected BitSet selectedRowIds = new BitSet();
    private int result = 1;
    protected Set selectedRows = new HashSet();
    private Set selectedRowNumbers = new HashSet();
    private List sortedRows = new ArrayList();
    private boolean isFromQingAnalyze = false;
    private boolean isQueryAnalyzeIndex = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map context = this.getUIContext();
        this.contentProvider = (IChooserContentProvider)context.get("CONTENT_PROVIDER");
        this.labelProvider = (IChooserLabelProvider)context.get("LABEL_PROVIDER");
        this.displayInfo = (String)context.get("DISPLAYINFO");
        if (context.containsKey("isFromQingAnalyze")) {
            this.isFromQingAnalyze = true;
        } else {
            this.kDLabel1.setVisible(false);
            this.kDSeparator1.setVisible(false);
            this.tblLeft.setBounds(new Rectangle(8, 81, 293, 448));
            this.add((Component)this.tblLeft, new KDLayout.Constraints(8, 81, 293, 448, 356));
            this.tblRight.setBounds(new Rectangle(334, 81, 295, 448));
            this.add((Component)this.tblRight, new KDLayout.Constraints(334, 81, 295, 448, 232));
        }
        if (context.containsKey("isQueryAnalyzeIndex")) {
            this.isQueryAnalyzeIndex = true;
            this.contTemplate.setBoundLabelLength(60);
            this.contTemplate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", (String)"34_indexType"));
        }
        this.setOnlyDisplayCheckData();
        this.createControl();
        this.initFilter();
        if (this.isQueryAnalyzeIndex) {
            this.templatePromp.setQueryInfo("com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexTypeQuery");
            this.templatePromp.setDisplayFormat("$number$-$name$");
            this.templatePromp.setEditFormat("$number$");
            this.templatePromp.setEditable(true);
            this.templatePromp.setCommitFormat("$number$");
        } else {
            this.initTemplatePromptBoxViewInfo();
        }
        this.initTables();
        this.initDisplayInfo();
        this.templatePromp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SortableItemChooserUI.this.isFromQingAnalyze) {
                    SortableItemChooserUI.this.initDynaItemList();
                } else if (SortableItemChooserUI.this.isQueryAnalyzeIndex) {
                    SortableItemChooserUI.this.initAnalyzeIndexList();
                } else {
                    SortableItemChooserUI.this.initItemList();
                }
            }
        });
    }

    protected void setOnlyDisplayCheckData() throws Exception {
    }

    private void initDisplayInfo() {
        if (!StringUtils.isEmpty((String)this.displayInfo)) {
            this.displayInfoLabel.setText(this.displayInfo);
        } else {
            this.adjustUISize((JComponent)this.displayInfoLabel);
            Rectangle rectangle = null;
            for (Component component : this.getComponents()) {
                if (component instanceof KDLabel && ((KDLabel)component).getName().equals(this.displayInfoLabel)) continue;
                KDLayout.Constraints cons = (KDLayout.Constraints)((JComponent)component).getClientProperty("KDLayoutConstraints");
                rectangle = cons.originalBounds;
                rectangle.y -= 25;
                cons.originalBounds = rectangle;
            }
        }
    }

    private void adjustUISize(JComponent hideComponent) {
        Rectangle containerOriginalBounds = (Rectangle)this.getClientProperty("OriginalBounds");
        containerOriginalBounds.height -= hideComponent.getHeight();
    }

    private void initFilter() {
        if (!this.contentProvider.enableFilter()) {
            this.filterBtn.setVisible(false);
            this.filterItemComb.setVisible(false);
            this.contFiter.setVisible(false);
            this.filterStringTxt.setVisible(false);
        } else {
            this.filterItemComb.addItems((Object[])this.labelProvider.getHeaderText());
        }
        if (!this.contentProvider.enableTemplateFilter()) {
            this.adjustUISize((JComponent)this.contTemplate);
            this.contTemplate.setVisible(false);
            this.adjustComponent();
        }
    }

    private void adjustComponent() {
        Rectangle rectangle = null;
        for (Component component : this.getComponents()) {
            if (component instanceof KDLabelContainer && ((KDLabelContainer)component).getName().equals(this.contTemplate)) continue;
            KDLayout.Constraints cons = (KDLayout.Constraints)((JComponent)component).getClientProperty("KDLayoutConstraints");
            rectangle = cons.originalBounds;
            rectangle.y -= 25;
            cons.originalBounds = rectangle;
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initTables() throws Exception {
        this.tblLeft.getSelectManager().setSelectMode(10);
        this.tblRight.getSelectManager().setSelectMode(10);
        this.tblLeft.setEditable(false);
        this.tblRight.setEditable(false);
        IRow headl = this.tblLeft.addHeadRow();
        IRow headr = this.tblRight.addHeadRow();
        String[] header = this.labelProvider.getHeaderText();
        int leftWidth = (this.tblLeft.getWidth() + 25) / header.length;
        int rightWidth = (this.tblRight.getWidth() + 25) / header.length;
        for (int i = 0; i < header.length; ++i) {
            IColumn c = this.tblLeft.addColumn();
            IColumn c2 = this.tblRight.addColumn();
            if (header.length == 1) {
                c.setWidth(200);
                c2.setWidth(200);
            } else {
                c.setWidth(leftWidth);
                c2.setWidth(rightWidth);
            }
            headl.getCell(i).setValue((Object)header[i]);
            headr.getCell(i).setValue((Object)header[i]);
        }
        this.initLeft();
        this.initRight();
        this.tblLeft.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int rowIndex;
                if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2 && (rowIndex = e.getRowIndex()) > -1) {
                    SortableItemChooserUI.this.moveRowRight(SortableItemChooserUI.this.tblLeft.getRow(rowIndex));
                }
            }
        });
        this.tblRight.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int rowIndex;
                if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2 && (rowIndex = e.getRowIndex()) > -1) {
                    SortableItemChooserUI.this.moveRowLeft(SortableItemChooserUI.this.tblRight.getRow(rowIndex));
                    SortableItemChooserUI.this.tblRight.removeRow(rowIndex);
                }
            }
        });
    }

    protected void initRight() {
        List coll = this.contentProvider.getSelected();
        if (coll == null) {
            return;
        }
        Iterator it = coll.iterator();
        String[] head = this.labelProvider.getHeaderText();
        block0: while (it.hasNext()) {
            Object next = it.next();
            int rowCount = this.tblLeft.getRowCount();
            if (this.isFromQingAnalyze && rowCount == 0 && !coll.isEmpty()) {
                IRow rightrow = this.tblRight.addRow();
                for (int x = 0; x < head.length; ++x) {
                    rightrow.getCell(x).setValue((Object)this.labelProvider.getColumnText(next, x));
                }
                this.selectedRows.add(next);
                this.sortedRows.add(next);
                if (!(next instanceof DynaItemInfo)) continue;
                this.selectedRowNumbers.add(((DynaItemInfo)next).getDitemNumber());
                continue;
            }
            for (int i = 0; i <= rowCount; ++i) {
                Object obj2;
                IRow leftrow = this.tblLeft.getRow(i);
                if (leftrow == null || this.contentProvider.compare(next, obj2 = leftrow.getUserObject()) != 0) continue;
                leftrow.getStyleAttributes().setHided(true);
                this.selectedRowIds.set(i);
                this.selectedRows.add(obj2);
                this.sortedRows.add(obj2);
                if (obj2 instanceof DataBaseInfo) {
                    this.selectedRowNumbers.add(((DataBaseInfo)obj2).getNumber());
                } else if (obj2 instanceof DynaItemInfo) {
                    this.selectedRowNumbers.add(((DynaItemInfo)obj2).getDitemNumber());
                } else if (obj2 instanceof AnalyzeIndexInfo) {
                    this.selectedRowNumbers.add(((AnalyzeIndexInfo)obj2).getNumber());
                }
                IRow rightrow = this.tblRight.addRow();
                for (int x = 0; x < head.length; ++x) {
                    rightrow.getCell(x).setValue((Object)this.labelProvider.getColumnText(next, x));
                }
                rightrow.setUserObject((Object)new Integer(leftrow.getRowIndex()));
                continue block0;
            }
        }
    }

    protected void initLeft() throws Exception {
        String[] header = this.labelProvider.getHeaderText();
        List collSelected = this.contentProvider.getSelected();
        if (this.isQueryAnalyzeIndex) {
            TemplateTypeInfo index = (TemplateTypeInfo)this.templatePromp.getValue();
            if (index == null) {
                this.contentProvider.setContents(null);
            }
        } else {
            TemplateInfo template = (TemplateInfo)this.templatePromp.getValue();
            if (template == null) {
                if (this.isFromQingAnalyze) {
                    this.contentProvider.setContents(null);
                } else if (collSelected != null) {
                    this.contentProvider.setContents(null);
                }
            }
        }
        List coll = this.contentProvider.getContents();
        this.tblLeft.removeRows();
        if (coll == null) {
            return;
        }
        for (Object next : coll) {
            IRow row = this.tblLeft.addRow();
            for (int i = 0; i < header.length; ++i) {
                row.getCell(i).setValue((Object)this.labelProvider.getColumnText(next, i));
                row.setUserObject(next);
            }
        }
    }

    protected void createControl() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("LEFT".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.moveLeft();
                } else if ("RIGHT".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.moveRight();
                } else if ("ALL_LEFT".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.moveAllLeft();
                } else if ("ALL_RIGHT".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.moveAllRight();
                } else if ("TOP".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.moveTop();
                } else if ("BOTTOM".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.moveBottom();
                } else if ("UP".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.moveUp();
                } else if ("DOWN".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.moveDown();
                } else if ("OK".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.result = 0;
                    SortableItemChooserUI.this.getUIWindow().close();
                } else if ("CANCEL".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.result = 2;
                    SortableItemChooserUI.this.getUIWindow().close();
                } else if ("FILTER".equals(e.getActionCommand())) {
                    SortableItemChooserUI.this.filter();
                }
            }
        };
        this.setButtonAction((JButton)this.ntbl, action);
        this.setButtonAction((JButton)this.ntbl, action);
        this.setButtonAction((JButton)this.ntbr, action);
        this.setButtonAction((JButton)this.btnalll, action);
        this.setButtonAction((JButton)this.ntballr, action);
        this.setButtonAction((JButton)this.btntop, action);
        this.setButtonAction((JButton)this.btnbuttom, action);
        this.setButtonAction((JButton)this.btnup, action);
        this.setButtonAction((JButton)this.btndown, action);
        this.setButtonAction((JButton)this.btnOK, action);
        this.setButtonAction((JButton)this.btnCancel, action);
        this.setButtonAction((JButton)this.filterBtn, action);
        this.ntbr.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.ntbl.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnalll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.ntballr.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btntop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnbuttom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnup.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btndown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.filterBtn.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.ntbl.setActionCommand("LEFT");
        this.ntbr.setActionCommand("RIGHT");
        this.btnalll.setActionCommand("ALL_LEFT");
        this.ntballr.setActionCommand("ALL_RIGHT");
        this.btntop.setActionCommand("TOP");
        this.btnbuttom.setActionCommand("BOTTOM");
        this.btnup.setActionCommand("UP");
        this.btndown.setActionCommand("DOWN");
        this.btnOK.setActionCommand("OK");
        this.btnCancel.setActionCommand("CANCEL");
        this.filterBtn.setActionCommand("FILTER");
    }

    private void filter() {
        int rowCount = this.tblLeft.getRowCount();
        int col = this.filterItemComb.getSelectedIndex();
        for (int i = 0; i <= rowCount; ++i) {
            IRow row = this.tblLeft.getRow(i);
            if (row == null) continue;
            Object obj = row.getUserObject();
            String text = this.filterStringTxt.getText();
            boolean match = true;
            match = StringUtils.isEmpty((String)text) ? true : this.contentProvider.matchFilter(obj, col, this.filterStringTxt.getText());
            String number = null;
            if (obj instanceof DataBaseInfo) {
                number = ((DataBaseInfo)obj).getNumber();
            } else if (obj instanceof DynaItemInfo) {
                number = ((DynaItemInfo)obj).getDitemNumber();
            }
            if (this.inRightHasItem(number)) continue;
            if (!match) {
                row.getStyleAttributes().setHided(true);
                continue;
            }
            row.getStyleAttributes().setHided(false);
        }
    }

    protected boolean inRightHasItem(String number) {
        return this.selectedRowNumbers.contains(number);
    }

    private void setButtonAction(JButton btn, Action act) {
        String t1 = btn.getText();
        String t2 = btn.getToolTipText();
        Icon i = btn.getIcon();
        btn.setAction(act);
        btn.setText(t1);
        btn.setToolTipText(t2);
        btn.setIcon(i);
    }

    protected boolean moveDown() {
        IRow row;
        int r;
        int rowcount = this.tblRight.getRowCount();
        IRow[] rows = this.getTableSelection(this.tblRight);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[rows.length - 1].getRowIndex() == rowcount - 1) {
                return false;
            }
        } else {
            return false;
        }
        this.tblRight.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = rows.length - 1; i >= 0 && (r = (row = rows[i]).getRowIndex()) != rowcount - 1; --i) {
            moved = true;
            this.tblRight.removeRow(r);
            this.tblRight.addRow(r + 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.tblRight);
            sel.setTop(r + 1);
            sel.setBottom(r + 1);
            sel.setMode(2);
            this.tblRight.getSelectManager().add(sel);
            this.tblRight.getLayoutManager().scrollRowToShow(r + 1);
        }
        if (moved) {
            this.tblRight.setRefresh(true);
            this.getSortedDataOfRightTable();
        }
        return true;
    }

    protected boolean moveUp() {
        IRow[] rows = this.getTableSelection(this.tblRight);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[0].getRowIndex() == 0) {
                return false;
            }
        } else {
            return false;
        }
        this.tblRight.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            int r = rows[i].getRowIndex();
            if (r == 0) break;
            moved = true;
            this.tblRight.removeRow(r);
            this.tblRight.addRow(r - 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.tblRight);
            sel.setTop(r - 1);
            sel.setBottom(r - 1);
            sel.setMode(2);
            this.tblRight.getSelectManager().add(sel);
            this.tblRight.getLayoutManager().scrollRowToShow(r - 1);
        }
        if (moved) {
            this.tblRight.setRefresh(true);
            this.getSortedDataOfRightTable();
        }
        return true;
    }

    protected void moveBottom() {
        while (this.moveDown()) {
        }
    }

    protected void moveTop() {
        while (this.moveUp()) {
        }
    }

    protected void moveAllRight() {
        int rowcount = this.tblLeft.getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            this.moveRowRight(this.tblLeft.getRow(i));
        }
    }

    protected void moveAllLeft() {
        int rowcount = this.tblRight.getRowCount();
        int leftRowCount = this.tblLeft.getRowCount();
        if (this.isFromQingAnalyze && rowcount > 0 && leftRowCount == 0) {
            this.tblRight.removeRows();
            this.selectedRows.clear();
            this.sortedRows.clear();
            this.selectedRowNumbers.clear();
        } else {
            for (int i = 0; i < rowcount; ++i) {
                this.moveRowLeft(this.tblRight.getRow(i));
            }
            this.tblRight.removeRows();
        }
    }

    protected void moveRight() {
        IRow[] leftsel = this.getTableSelection(this.tblLeft);
        for (int i = 0; i < leftsel.length; ++i) {
            IRow row = leftsel[i];
            this.moveRowRight(row);
        }
    }

    protected void moveRowRight(IRow row) {
        if (row == null) {
            return;
        }
        if (row.getStyleAttributes().isHided()) {
            return;
        }
        row.getStyleAttributes().setHided(true);
        this.selectedRowIds.set(row.getRowIndex());
        Object obj = row.getUserObject();
        this.selectedRows.add(obj);
        this.sortedRows.add(obj);
        if (obj instanceof DataBaseInfo) {
            this.selectedRowNumbers.add(((DataBaseInfo)obj).getNumber());
        } else if (obj instanceof DynaItemInfo) {
            this.selectedRowNumbers.add(((DynaItemInfo)obj).getDitemNumber());
        } else if (obj instanceof AnalyzeIndexInfo) {
            this.selectedRowNumbers.add(((AnalyzeIndexInfo)obj).getNumber());
        }
        IRow newRow = this.tblRight.addRow();
        String[] header = this.labelProvider.getHeaderText();
        for (int x = 0; x < header.length; ++x) {
            newRow.getCell(x).setValue((Object)this.labelProvider.getColumnText(obj, x));
            newRow.setUserObject((Object)new Integer(row.getRowIndex()));
        }
    }

    protected void moveLeft() {
        IRow row;
        int i;
        IRow[] rightsel = this.getTableSelection(this.tblRight);
        Arrays.sort(rightsel, new RowIdxComparer());
        int leftRowCount = this.tblLeft.getRowCount();
        for (i = rightsel.length - 1; i >= 0; --i) {
            row = rightsel[i];
            if (this.isFromQingAnalyze && leftRowCount == 0) {
                String num = (String)row.getCell(0).getValue();
                String name = (String)row.getCell(1).getValue();
                DynaItemInfo dyObj = new DynaItemInfo(name, num);
                this.selectedRowNumbers.remove(num);
                this.selectedRows.remove(dyObj);
                this.sortedRows.remove(dyObj);
            }
            this.tblRight.removeRow(row.getRowIndex());
        }
        for (i = 0; i < rightsel.length; ++i) {
            row = rightsel[i];
            this.moveRowLeft(row);
        }
    }

    protected void moveRowLeft(IRow row) {
        if (row == null) {
            return;
        }
        Integer leftIdx = (Integer)row.getUserObject();
        IRow leftRow = this.tblLeft.getRow(leftIdx.intValue());
        if (this.contentProvider.enableFilter()) {
            int rowCount = this.tblLeft.getRowCount();
            int col = this.filterItemComb.getSelectedIndex();
            String leftNumber = null;
            for (int i = 0; i <= rowCount; ++i) {
                IRow leftrow = this.tblLeft.getRow(i);
                if (leftrow == null) continue;
                Object obj = leftrow.getUserObject();
                if (obj instanceof DataBaseInfo) {
                    DataBaseInfo dbObj = (DataBaseInfo)obj;
                    leftNumber = dbObj.getNumber();
                } else if (obj instanceof DynaItemInfo) {
                    DynaItemInfo dyObj = (DynaItemInfo)obj;
                    leftNumber = dyObj.getDitemNumber();
                } else if (obj instanceof AnalyzeIndexInfo) {
                    AnalyzeIndexInfo dbobj = (AnalyzeIndexInfo)obj;
                    leftNumber = dbobj.getNumber();
                }
                String number = row.getCell(0).getValue().toString();
                if (!number.equals(leftNumber)) continue;
                leftrow.getStyleAttributes().setHided(false);
            }
            this.removeRightTableRows(row);
        } else {
            leftRow.getStyleAttributes().setHided(false);
        }
        this.selectedRowIds.clear(leftIdx);
    }

    private void removeRightTableRows(IRow row) {
        String number = (String)row.getCell(0).getValue();
        Iterator it = this.selectedRows.iterator();
        String num = null;
        Object obj = null;
        while (it.hasNext()) {
            obj = it.next();
            if (obj instanceof DataBaseInfo) {
                DataBaseInfo dbObj = obj;
                num = dbObj.getNumber();
            } else if (obj instanceof DynaItemInfo) {
                DynaItemInfo dyObj = obj;
                num = dyObj.getDitemNumber();
            } else if (obj instanceof AnalyzeIndexInfo) {
                AnalyzeIndexInfo dbobj = obj;
                num = dbobj.getNumber();
            }
            if (StringUtils.isEmpty((String)num) || !num.equals(number)) continue;
            this.selectedRows.remove(obj);
            this.sortedRows.remove(obj);
            this.selectedRowNumbers.remove(num);
            break;
        }
    }

    private void getSortedDataOfRightTable() {
        int rowcount = this.tblRight.getRowCount();
        this.sortedRows.clear();
        for (int i = 0; i < rowcount; ++i) {
            IRow row = this.tblRight.getRow(i);
            String number = row.getCell(0).getValue().toString();
            Iterator it = this.selectedRows.iterator();
            String num = null;
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj instanceof DataBaseInfo) {
                    DataBaseInfo dbObj = (DataBaseInfo)obj;
                    num = dbObj.getNumber();
                } else if (obj instanceof DynaItemInfo) {
                    DynaItemInfo dyObj = (DynaItemInfo)obj;
                    num = dyObj.getDitemNumber();
                } else if (obj instanceof AnalyzeIndexInfo) {
                    AnalyzeIndexInfo dbobj = (AnalyzeIndexInfo)obj;
                    num = dbobj.getNumber();
                }
                if (!number.equals(num)) continue;
                this.sortedRows.add(obj);
            }
        }
    }

    protected IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            if (block.getMode() == 8) {
                for (int j = 0; j < tbl.getRowCount(); ++j) {
                    rows.add(tbl.getRow(j));
                }
                break;
            }
            int smallLine = block.getBeginRow() < block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            int bigLine = block.getBeginRow() > block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            for (int row = smallLine; row <= bigLine; ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }

    public Object getData() {
        ArrayList<Object> rs = new ArrayList<Object>();
        if (this.contentProvider.enableFilter()) {
            for (Object obj : this.sortedRows) {
                rs.add(obj);
            }
        } else {
            int rowCount = this.tblRight.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Integer idx = (Integer)this.tblRight.getRow(i).getUserObject();
                rs.add(this.tblLeft.getRow(idx.intValue()).getUserObject());
            }
        }
        return rs.isEmpty() ? null : rs;
    }

    public void setContentProvider(IChooserContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(IChooserLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public int getResult() {
        return this.result;
    }

    private void initItemList() {
        ArrayList contents = new ArrayList();
        TemplateInfo template = (TemplateInfo)this.templatePromp.getValue();
        try {
            if (template != null) {
                String id = template.getId().toString();
                TempletItemListCollection coll = TempletItemListFactory.getRemoteInstance().getTempletItemListCollection("select itemNumber where template='" + id + "'");
                if (coll != null && coll.size() > 0) {
                    List itemNumberList = this.getItemFormulaFromSheet(coll);
                    if (itemNumberList.size() > 0) {
                        RPTItemCollection rptItemCL = this.getRptItemCol(itemNumberList);
                        CslRptUtil.addCollectionToArrayList(contents, (IObjectCollection)rptItemCL);
                        this.setContentProviderContent(contents);
                        this.initLeft();
                    } else {
                        this.tblLeft.removeRows();
                    }
                } else {
                    this.tblLeft.removeRows();
                }
            } else {
                this.contentProvider.setContents(null);
                this.initLeft();
            }
            this.hideRows();
        }
        catch (Exception e) {
            logger.error((Object)"SortableItemChooserUI", (Throwable)e);
        }
    }

    private void initDynaItemList() {
        TemplateInfo template = (TemplateInfo)this.templatePromp.getValue();
        try {
            if (template != null) {
                Map params = this.getParams(template);
                ArrayList dynaItemList = RptQingAnalyzeFacadeFactory.getRemoteInstance().getDynaItems(params);
                if (dynaItemList != null && !dynaItemList.isEmpty()) {
                    this.setContentProviderContent(dynaItemList);
                    this.initLeft();
                } else {
                    this.tblLeft.removeRows();
                }
            } else {
                this.contentProvider.setContents(null);
                this.initLeft();
            }
            this.hideRows();
        }
        catch (Exception e) {
            logger.error((Object)"initDynaItemList: ", (Throwable)e);
        }
    }

    private void initAnalyzeIndexList() {
        TemplateTypeInfo tmplType = (TemplateTypeInfo)this.templatePromp.getValue();
        try {
            if (tmplType != null) {
                String tmplTypeId = tmplType.getId().toString();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("number"));
                view.getSelector().add(new SelectorItemInfo("name"));
                filter.getFilterItems().add(new FilterItemInfo("indexType", (Object)tmplTypeId, CompareType.EQUALS));
                view.getSorter().add(new SorterItemInfo("number"));
                view.setFilter(filter);
                AnalyzeIndexCollection analyzeIndexs = AnalyzeIndexFactory.getRemoteInstance().getAnalyzeIndexCollection(view);
                if (analyzeIndexs != null && !analyzeIndexs.isEmpty()) {
                    ArrayList<AnalyzeIndexInfo> analyzeIndexList = new ArrayList<AnalyzeIndexInfo>(analyzeIndexs.size());
                    for (AnalyzeIndexInfo analyzeIndex : analyzeIndexs) {
                        analyzeIndexList.add(analyzeIndex);
                    }
                    this.setContentProviderContent(analyzeIndexList);
                    this.initLeft();
                } else {
                    this.tblLeft.removeRows();
                }
            } else {
                this.contentProvider.setContents(null);
                this.initLeft();
            }
            this.hideRows();
        }
        catch (Exception e) {
            logger.error((Object)"initAnalyzeIndexList: ", (Throwable)e);
        }
    }

    private Map getParams(TemplateInfo template) {
        String templateNumber = template.getNumber();
        RptTmpTypeEnum tmplType = template.getTemplateType();
        OrgType orgType = template.getOrgType();
        Map context = this.getUIContext();
        int startYear = (Integer)context.get("startYear");
        int startPeriod = (Integer)context.get("startPeriod");
        int endYear = (Integer)context.get("endYear");
        int endPeriod = (Integer)context.get("endPeriod");
        Set orgTreeIds = null;
        if (context.containsKey("orgTreeIds")) {
            orgTreeIds = (Set)context.get("orgTreeIds");
        }
        Set companyIds = null;
        if (context.containsKey("companyIds")) {
            companyIds = (Set)context.get("companyIds");
        }
        Set unitIds = null;
        if (context.containsKey("orgIds")) {
            unitIds = (Set)context.get("orgIds");
        }
        Set currencyIds = (Set)context.get("currencyIds");
        String asstActNumber = null;
        if (context.containsKey("asstActNumber")) {
            asstActNumber = (String)context.get("asstActNumber");
        }
        int periodType = (Integer)context.get("periodType");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startYear", startYear);
        params.put("startPeriod", startPeriod);
        params.put("endYear", endYear);
        params.put("endPeriod", endPeriod);
        params.put("tmplNumber", templateNumber);
        params.put("orgTreeIds", orgTreeIds);
        params.put("companyIds", companyIds);
        params.put("orgIds", unitIds);
        params.put("currencyIds", currencyIds);
        params.put("tmplType", tmplType.getValue());
        params.put("periodType", periodType);
        params.put("orgType", orgType.getValue());
        if (asstActNumber != null) {
            params.put("asstActNumber", asstActNumber);
        }
        return params;
    }

    protected void setContentProviderContent(ArrayList contents) throws Exception {
        this.contentProvider.setContents(contents);
    }

    private void hideRows() {
        block5: {
            block4: {
                Set coll = this.selectedRows;
                if (coll == null || coll.isEmpty()) break block4;
                for (Object next : coll) {
                    int rowCount = this.tblLeft.getRowCount();
                    for (int i = 0; i <= rowCount; ++i) {
                        Object obj2;
                        IRow leftrow = this.tblLeft.getRow(i);
                        if (leftrow == null || this.contentProvider.compare(next, obj2 = leftrow.getUserObject()) != 0) continue;
                        leftrow.getStyleAttributes().setHided(true);
                    }
                }
                break block5;
            }
            int rightRowCount = this.tblRight.getRowCount();
            if (rightRowCount <= 0) break block5;
            block2: for (int i = 0; i <= rightRowCount; ++i) {
                IRow rightrow = this.tblRight.getRow(i);
                String rightNumber = (String)rightrow.getCell(0).getValue();
                int leftrowCount = this.tblLeft.getRowCount();
                for (int j = 0; j <= leftrowCount; ++j) {
                    IRow leftrow = this.tblLeft.getRow(j);
                    String leftNumber = (String)leftrow.getCell(0).getValue();
                    if (!rightNumber.equals(leftNumber)) continue;
                    leftrow.getStyleAttributes().setHided(true);
                    rightrow.setUserObject((Object)leftrow.getRowIndex());
                    this.selectedRowIds.set(leftrow.getRowIndex());
                    continue block2;
                }
            }
        }
    }

    private void initTemplatePromptBoxViewInfo() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set tmplType = this.getTemplateTypeSet();
        if (this.getUIContext().containsKey("periodType")) {
            int periodType = (Integer)this.getUIContext().get("periodType");
            filter.appendFilterItem("periodType", (Object)periodType);
        }
        filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)tmplType, CompareType.INCLUDE));
        filter.appendFilterItem("isFreezed", (Object)0);
        filter.appendFilterItem("auditedStatus", (Object)2);
        filter.appendFilterItem("publishedStatus", (Object)1);
        filter.appendFilterItem("isK3tpl", (Object)0);
        filter.appendFilterItem("versionStatus", (Object)1);
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("templateType"));
        view.getSelector().add(new SelectorItemInfo("periodType"));
        view.getSelector().add(new SelectorItemInfo("versionNumber"));
        view.getSelector().add(new SelectorItemInfo("orgType"));
        this.templatePromp.setEntityViewInfo(view);
        QueryAgent queryAgent = this.templatePromp.getQueryAgent();
        queryAgent.getQueryInfo().getUnits().getQueryFields().get("templateType").setExtendedProperty("isVisibleForKDTable", "true");
        this.templatePromp.setDisplayFormat("$number$-$name$");
        this.templatePromp.setEditFormat("$number$");
        this.templatePromp.setEditable(true);
        this.templatePromp.setCommitFormat("$number$");
    }

    private Set getTemplateTypeSet() {
        HashSet<Integer> set = new HashSet<Integer>();
        if (this.isFromQingAnalyze) {
            set.add(10);
            set.add(11);
            set.add(13);
        } else {
            set.add(3);
            set.add(5);
            set.add(6);
            if (!"false".equals(this.getUIContext().get("needDynRpt"))) {
                set.add(10);
                set.add(11);
                set.add(13);
            }
            if (!"false".equals(this.getUIContext().get("isNeedMultiDynRpt"))) {
                set.add(15);
                set.add(17);
                set.add(18);
            }
        }
        return set;
    }

    private List getItemFormulaFromSheet(TempletItemListCollection coll) {
        ArrayList<String> numberList = new ArrayList<String>();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            TempletItemListInfo info = (TempletItemListInfo)it.next();
            String number = info.getItemNumber();
            numberList.add(number);
        }
        return numberList;
    }

    private Set getNumberString(List<String> numberList) {
        HashSet<String> numbers = new HashSet<String>();
        for (int i = 0; i < numberList.size(); ++i) {
            String itemNumber = numberList.get(i);
            numbers.add(itemNumber);
        }
        return numbers;
    }

    private RPTItemCollection getRptItemCol(List<String> numberList) throws BOSException {
        Set numbers = this.getNumberString(numberList);
        RPTItemCollection rptItemCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("itemGroup"));
        view.getSelector().add(new SelectorItemInfo("reportClass.name"));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numbers, CompareType.INCLUDE));
        view.getSorter().add(new SorterItemInfo("number"));
        view.setFilter(filter);
        rptItemCol = RPTItemFactory.getRemoteInstance().getRPTItemCollection(view);
        return rptItemCol;
    }

    class RowIdxComparer
    implements Comparator {
        RowIdxComparer() {
        }

        public int compare(Object row1, Object row2) {
            return ((IRow)row1).getRowIndex() - ((IRow)row2).getRowIndex();
        }
    }
}

