/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.synchro2server.SyschroCslSysContext2Server;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.client.IReloginAction;
import com.kingdee.eas.util.client.ReloginHelper;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public final class CSLContext
implements ICSLContext,
Serializable,
Cloneable {
    private static CSLContext ctx = new CSLContext();
    private Hashtable list = new Hashtable();

    public CSLContext() {
        this.registReLoginAction2LinkedSys();
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        CSLContext o = (CSLContext)super.clone();
        o.list = (Hashtable)this.list.clone();
        return o;
    }

    private void registReLoginAction2LinkedSys() {
        ReloginHelper.getInstance().registReloginAction((IReloginAction)new SyschroCslSysContext2Server());
    }

    public int hashCode() {
        int hashCode = 13;
        hashCode = this.list == null ? hashCode * 13 + 1 : hashCode * 11 + this.list.hashCode();
        return hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        boolean flag = true;
        if (obj == null) return false;
        if (!(obj instanceof CSLContext)) return false;
        CSLContext c = (CSLContext)obj;
        try {
            if (c.getCurOrgBound() == null || this.getCurOrgBound() == null || !c.getCurOrgBound().getId().equals((Object)this.getCurOrgBound().getId())) {
                flag = false;
            }
            if (c.getCurOrgGroup() == null || this.getCurOrgGroup() == null || !c.getCurOrgGroup().getId().equals((Object)this.getCurOrgGroup().getId())) {
                flag = false;
            }
            if (c.getCurReportDate() == null || this.getCurReportDate() == null || !c.getCurReportDate().equals(this.getCurReportDate())) {
                flag = false;
            }
            if (c.getCurRptPeriodType() == null || this.getCurRptPeriodType() == null || c.getCurRptPeriodType().getValue() != this.getCurRptPeriodType().getValue()) {
                flag = false;
            }
            if (c.getCurRptYear() == -1 || this.getCurRptYear() == -1 || c.getCurRptYear() != this.getCurRptYear()) {
                flag = false;
            }
            if (c.getCurRptPeriod() == -1 || this.getCurRptPeriod() == -1 || c.getCurRptPeriod() != this.getCurRptPeriod()) {
                flag = false;
            }
            if (c.getCurPublishedStatus() != this.getCurPublishedStatus()) {
                flag = false;
            }
            if (c.getCurDataCollect() == null || this.getCurDataCollect() == null || !c.getCurDataCollect().getId().equals((Object)this.getCurDataCollect().getId())) {
                flag = false;
            }
            if (c.isQueryBudget() == this.isQueryBudget()) return flag;
            return false;
        }
        catch (BOSException e) {
            return false;
        }
    }

    public static CSLContext getInstance() {
        return ctx;
    }

    @Override
    public boolean isInitialized() {
        return !this.list.isEmpty();
    }

    @Override
    public OrgTreeInfo getCurOrgBound() throws BOSException {
        return (OrgTreeInfo)this.getDetailValue(CSLRPT_CURRENT_ORGBOUND);
    }

    public void setCurOrgBound(OrgTreeInfo orgTree) {
        this.setDetailValue(CSLRPT_CURRENT_ORGBOUND, orgTree);
    }

    @Override
    public OrgUnitInfo getCurOrgGroup() throws BOSException {
        return (OrgUnitInfo)this.getDetailValue(CSLRPT_CURRENT_ORGGROUP);
    }

    public void setCurOrgGroup(OrgUnitInfo orgGroup) {
        this.setDetailValue(CSLRPT_CURRENT_ORGGROUP, orgGroup);
    }

    @Override
    public Date getCurReportDate() throws BOSException {
        return (Date)this.getDetailValue(CSLRPT_CURRENT_REPORTDATE);
    }

    public void setCurReportDate(Date date) throws BOSException {
        DateFormat format = CslRptUIUtil.getNationalDateFormat();
        try {
            if (format != null) {
                String d = format.format(date);
                this.setDetailValue(CSLRPT_CURRENT_REPORTDATE, format.parse(d));
            } else {
                SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd");
                String d = simpleFormat.format(date);
                this.setDetailValue(CSLRPT_CURRENT_REPORTDATE, simpleFormat.parse(d));
            }
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public RptPeriodTypeEnum getCurRptPeriodType() throws BOSException {
        return (RptPeriodTypeEnum)this.getDetailValue(CSLRPT_CURRENT_RPTPERIODTYPE);
    }

    public void setCurRptPeriodType(RptPeriodTypeEnum rptPeriodType) {
        this.setDetailValue(CSLRPT_CURRENT_RPTPERIODTYPE, rptPeriodType);
    }

    @Override
    public int getCurRptYear() throws BOSException {
        try {
            Object o = this.getDetailValue(CSLRPT_CURRENT_RPTYEAR);
            if (o != null) {
                return Integer.parseInt(o.toString());
            }
            return -1;
        }
        catch (NumberFormatException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void setCurRptYear(int year) {
        this.setDetailValue(CSLRPT_CURRENT_RPTYEAR, new Integer(year));
    }

    @Override
    public int getCurRptPeriod() throws BOSException {
        try {
            Object o = this.getDetailValue(CSLRPT_CURRENT_RPTPERIOD);
            if (o != null) {
                return Integer.parseInt(o.toString());
            }
            return -1;
        }
        catch (NumberFormatException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void setCurRptPeriod(int period) {
        this.setDetailValue(CSLRPT_CURRENT_RPTPERIOD, new Integer(period));
    }

    @Override
    public boolean getCurPublishedStatus() throws BOSException {
        try {
            Object o = this.getDetailValue(CSLRPT_CURRENT_PUBLISHEDSTATUS);
            if (o != null && o instanceof Boolean) {
                return (Boolean)o;
            }
            return false;
        }
        catch (NumberFormatException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void setCurPublishedStatus(boolean status) {
        this.setDetailValue(CSLRPT_CURRENT_PUBLISHEDSTATUS, new Boolean(status));
    }

    @Override
    public boolean isUpdatedTemplate() throws BOSException {
        try {
            Object o = this.getDetailValue(CSLRPT_CURRENT_UPDATEDTEMPLATE);
            if (o != null && o instanceof Boolean) {
                return (Boolean)o;
            }
            return false;
        }
        catch (NumberFormatException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void setUpdatedTemplate(boolean b) {
        this.setDetailValue(CSLRPT_CURRENT_UPDATEDTEMPLATE, new Boolean(b));
    }

    public void destroyContext() {
        this.list.clear();
    }

    private synchronized void setDetailValue(Integer key, Object value) {
        if (this.list.containsKey(key)) {
            this.list.remove(key);
        }
        this.list.put(key, value);
    }

    private Object getDetailValue(Integer key) {
        if (this.list.containsKey(key)) {
            return this.list.get(key);
        }
        return null;
    }

    public static final void main(String[] arags) {
    }

    @Override
    public DataCollectInfo getCurDataCollect() throws BOSException {
        return (DataCollectInfo)this.getDetailValue(CSLRPT_CURRENT_DATACOLLECT);
    }

    public void setCurDataCollect(DataCollectInfo dataCollectInfo) {
        this.setDetailValue(CSLRPT_CURRENT_DATACOLLECT, dataCollectInfo);
    }

    @Override
    public boolean isQueryBudget() throws BOSException {
        try {
            Object o = this.getDetailValue(CSLRPT_CURRENT_ISQUERYBUDGET);
            if (o != null && o instanceof Boolean) {
                return (Boolean)o;
            }
            return false;
        }
        catch (NumberFormatException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void setQueryBudget(boolean b) {
        this.setDetailValue(CSLRPT_CURRENT_ISQUERYBUDGET, new Boolean(b));
    }

    @Override
    public CurrencyInfo getCurCurrency() throws BOSException {
        return (CurrencyInfo)this.getDetailValue(CSLRPT_CURRENT_CURRENCY);
    }
}

