/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public final class MnsColFormula
implements Serializable,
Cloneable {
    public static final Integer MNS_FORMULATYPE = new Integer(0);
    public static final Integer MNS_COMPANY = new Integer(1);
    public static final Integer MNS_YEAR = new Integer(3);
    public static final Integer MNS_PERIOD = new Integer(4);
    public static final Integer MNS_DATAELEMENT = new Integer(5);
    public static final Integer MNS_VALUETYPE = new Integer(6);
    private static final Logger logger = Logger.getLogger(MnsColFormula.class);
    private Map props = new Hashtable();

    public MnsColFormula(String formulaString) {
        this.FormulaToObject(formulaString);
    }

    public MnsColFormula(int formulaType, String company, int year, int period, int dataElement, int valueType) {
    }

    public String getCompany() {
        if (this.props.containsKey(MNS_COMPANY)) {
            return this.props.get(MNS_COMPANY).toString();
        }
        return null;
    }

    public int getDataElement() {
        if (this.props.containsKey(MNS_DATAELEMENT)) {
            return new Integer(this.props.get(MNS_DATAELEMENT).toString());
        }
        return -1;
    }

    public String getFormula() {
        return this.toString();
    }

    public int getFormulaType() {
        if (this.props.containsKey(MNS_FORMULATYPE)) {
            return new Integer(this.props.get(MNS_FORMULATYPE).toString());
        }
        return -1;
    }

    public int getPeriod() {
        if (this.props.containsKey(MNS_PERIOD)) {
            return new Integer(this.props.get(MNS_PERIOD).toString());
        }
        return -1;
    }

    public int getValueType() {
        if (this.props.containsKey(MNS_VALUETYPE)) {
            return new Integer(this.props.get(MNS_VALUETYPE).toString());
        }
        return -1;
    }

    public int getYear() {
        if (this.props.containsKey(MNS_YEAR)) {
            return new Integer(this.props.get(MNS_YEAR).toString());
        }
        return -1;
    }

    public Object clone() {
        try {
            MnsColFormula o = (MnsColFormula)super.clone();
            o.props = (Map)((Hashtable)this.props).clone();
            return o;
        }
        catch (Exception e) {
            logger.debug((Object)("clone err:" + e.getLocalizedMessage()));
            return null;
        }
    }

    public String toString() {
        StringBuffer sbFormula = new StringBuffer();
        switch (this.getFormulaType()) {
            case 3: {
                sbFormula.append("COMBINE(");
                break;
            }
            case 5: {
                sbFormula.append("ELIMCREDIT(");
                break;
            }
            case 4: {
                sbFormula.append("ELIMDEBIT(");
                break;
            }
            case 1: {
                sbFormula.append("SINGLE(");
                break;
            }
            case 2: {
                sbFormula.append("SUMMARY(");
            }
        }
        sbFormula.append("," + this.getYear());
        sbFormula.append("," + this.getPeriod());
        sbFormula.append("," + this.getDataElement());
        sbFormula.append("," + this.getValueType());
        sbFormula.append(")");
        return sbFormula.toString();
    }

    protected MnsColFormula FormulaToObject(String formulaString) {
        if (formulaString == null || formulaString.indexOf("(") == -1 || formulaString.indexOf(")") == -1) {
            return null;
        }
        if (formulaString.startsWith("COMBINE")) {
            this.props.put(new Integer(0), new Integer(3));
        } else if (formulaString.startsWith("ELIMCREDIT")) {
            this.props.put(new Integer(0), new Integer(5));
        } else if (formulaString.startsWith("ELIMDEBIT")) {
            this.props.put(new Integer(0), new Integer(4));
        } else if (formulaString.startsWith("SINGLE")) {
            this.props.put(new Integer(0), new Integer(1));
        } else if (formulaString.startsWith("SUMMARY")) {
            this.props.put(new Integer(0), new Integer(2));
        }
        String props = formulaString.substring(formulaString.indexOf("(") + 1, formulaString.indexOf(")"));
        String[] valueString = props.split(",", 0);
        Integer key = null;
        for (int i = 1; i <= valueString.length; ++i) {
            key = new Integer(i);
            if (this.props.containsKey(key)) {
                this.props.remove(key);
            }
            this.props.put(key, valueString[i]);
        }
        return this;
    }
}

