/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.Formula;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.util.ResourceBase;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class ArticulationInfo
implements Serializable {
    private static final long serialVersionUID = 4920003823517150427L;
    public static final int IFCLAUSE_CHECK_FALSE = 1;
    public static final int ITEM_CHECK_FALSE = 2;
    public static final int ARTICULATION_PASS = 257;
    public static final int ARTICULATION_FAIL = 258;
    private int statusCode;
    private int checkResultCode;
    private boolean isAvailable = true;
    private Map detailFormulaMap = new HashMap();
    private OrgTreeInfo orgTreeInfo;
    protected String id;
    protected String number;
    protected String name;
    protected String ifClause;
    protected BigDecimal range;

    public abstract void paserFormula(Context var1) throws BOSException;

    public abstract int getArticulationCheckType();

    protected Expression paserFormula(Context ctx, String formula) throws BOSException {
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)formula);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"125_CheckFormulaControllerBean", (Locale)ctx.getOriginLocale()) + formula + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"126_CheckFormulaControllerBean", (Locale)ctx.getOriginLocale()));
        }
        return expression;
    }

    protected Expression paserFormulaExpression(Expression expression) {
        if (expression instanceof FunctionExpr) {
            Formula formula = new Formula(this, (Expression)((FunctionExpr)expression));
            this.detailFormulaMap.put(formula.getFunctionExpr().toString().toUpperCase(), formula);
        } else if (expression instanceof BinaryOperationExpr) {
            Expression expr;
            ((BinaryOperationExpr)expression).left = expr = this.paserFormulaExpression(((BinaryOperationExpr)expression).left);
            ((BinaryOperationExpr)expression).right = expr = this.paserFormulaExpression(((BinaryOperationExpr)expression).right);
        } else if (expression instanceof UnaryOperationExpr) {
            Expression expr;
            ((UnaryOperationExpr)expression).operand = expr = this.paserFormulaExpression(((UnaryOperationExpr)expression).operand);
        }
        return expression;
    }

    public Map getDetailFormulaMap() {
        return this.detailFormulaMap;
    }

    public void setDetailFormulaMap(Map detailFormulaMap) {
        this.detailFormulaMap = detailFormulaMap;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void setAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getCheckResultCode() {
        return this.checkResultCode;
    }

    public void setCheckResultCode(int checkResultCode) {
        this.checkResultCode = checkResultCode;
    }

    public OrgTreeInfo getOrgTreeInfo() {
        return this.orgTreeInfo;
    }

    public void setOrgTreeInfo(OrgTreeInfo orgTreeInfo) {
        this.orgTreeInfo = orgTreeInfo;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIfClause() {
        return this.ifClause;
    }

    public void setIfClause(String ifClause) {
        this.ifClause = ifClause;
    }

    public BigDecimal getRange() {
        return this.range;
    }

    public void setRange(BigDecimal range) {
        this.range = range;
    }

    public boolean isPassArticulation() {
        return this.checkResultCode == 257;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(super.toString());
        if (this.orgTreeInfo != null) {
            str.append("orgTreeInfo: ").append(this.orgTreeInfo.toString()).append("\n");
        }
        str.append("detailFormula: ").append(this.detailFormulaMap);
        return str.toString();
    }
}

