/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.AbstractSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.ICombineHandler;
import com.kingdee.eas.fi.rpt.batch.ICombineRowSetHandler;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.RowSetCombineHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CellPostilBatchQuery {
    private static Logger logger = Logger.getLogger(CellPostilBatchQuery.class);
    private BatchHelper batchHelper;
    private IBatchSQLProcessor sqlProcessor;
    private ParameterContext parameterContext;

    public CellPostilBatchQuery(Context context, ParameterContext parameterContext) {
        this.parameterContext = parameterContext;
        this.batchHelper = new BatchHelper(context);
        this.sqlProcessor = new CellPostilBatchProcessor();
    }

    public void registerFormula(ItemFormulaInfo itemFormulaInfo) {
        this.sqlProcessor.getFormulaCalculators().add(new CellPostil(itemFormulaInfo));
    }

    public void executeCellPostilBatchQuery() throws BOSException {
        RowSetCombineHandler combineHandler = new RowSetCombineHandler(new ICombineRowSetHandler(){

            public void processRowSet(IRowSet rs, IFormulaCalculator formula, IBatchSQLProcessor sqlBuilder) throws SQLException {
                CellPostil cellPostil = (CellPostil)formula;
                ItemFormulaInfo itemFormulaInfo = cellPostil.itemFormulaInfo;
                itemFormulaInfo.setPostil(rs.getString("description"));
            }
        });
        this.batchHelper.batchCalculateBigDecimal(this.sqlProcessor, (ICombineHandler)combineHandler);
    }

    class CellPostilBatchProcessor
    extends AbstractSQLProcessor {
        private List formulaList = new ArrayList();

        CellPostilBatchProcessor() {
        }

        public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
            CellPostil cellPostil = (CellPostil)formula;
            ItemFormulaInfo itemFormulaInfo = cellPostil.itemFormulaInfo;
            ArrayList<Object> fields = new ArrayList<Object>();
            fields.add(itemFormulaInfo.getReportId());
            fields.add(itemFormulaInfo.getItemNumber());
            fields.add(new Integer(itemFormulaInfo.getDataElement()));
            fields.add(new Integer(itemFormulaInfo.getValueType()));
            Object[][] result = new Object[1][fields.size()];
            result[0] = fields.toArray();
            return result;
        }

        public String[] getIndexResultSetFields() {
            ArrayList<String> indexedFields = new ArrayList<String>();
            indexedFields.add("reportId");
            indexedFields.add("itemNumber");
            indexedFields.add("dataElement");
            indexedFields.add("valueType");
            String[] result = new String[indexedFields.size()];
            indexedFields.toArray(result);
            return result;
        }

        public void buildSelectPart(Set nullSet, StringBuffer sql) {
            sql.append("select postil.FDescription description, postil.FReportId reportId, postil.FItemNumber itemNumber, ");
            sql.append("postil.FDataElement dataElement, postil.FValueType valueType");
        }

        public void buildFromPart(Set nullSet, StringBuffer sql) {
            sql.append(" from T_CSL_CslPostil postil ");
        }

        public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
            sql.append(" where FPostilType = ").append(3);
            sql.append(" and (");
        }

        public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
            CellPostil cellPostil = (CellPostil)formula;
            ItemFormulaInfo itemFormulaInfo = cellPostil.itemFormulaInfo;
            sql.append(" (postil.FReportId = ?");
            params.add(itemFormulaInfo.getReportId());
            sql.append(" and postil.FItemNumber = ?");
            params.add(itemFormulaInfo.getItemNumber());
            sql.append(" and postil.FDataElement = ?");
            params.add(new Integer(itemFormulaInfo.getDataElement()));
            sql.append(" and postil.FValueType = ?)");
            params.add(new Integer(itemFormulaInfo.getValueType()));
        }

        public void buildGroupByPart(Set nullSet, StringBuffer sql) {
            sql.append(")");
        }

        public List getFormulaCalculators() {
            return this.formulaList;
        }

        public int getMaxSQLVaribleSize() {
            Object batchSize = CellPostilBatchQuery.this.parameterContext.getAttribute("KEY_CSLPARAM_CHECKFORMULA_ITEMBATCH_SIZE");
            if (batchSize != null) {
                try {
                    return (Integer)batchSize;
                }
                catch (Exception e) {
                    return 500;
                }
            }
            return 500;
        }
    }

    class CellPostil
    extends AbstractFormulaCalculator {
        ItemFormulaInfo itemFormulaInfo;

        CellPostil(ItemFormulaInfo itemFormulaInfo) {
            this.itemFormulaInfo = itemFormulaInfo;
        }
    }
}

