/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery;

import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.ItemFormulaInfoSortState;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ItemFormulaInfoSQLProcessor
extends AbstractSQLProcessor {
    private int maxsqlvar = 300;
    private ParameterContext parameterContext;

    ItemFormulaInfoSQLProcessor(ParameterContext parameterContext) {
        this.parameterContext = parameterContext;
        this.initMaxSQLVaribleSize();
    }

    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        ItemFormulaInfoSortState itemFormulaInfoSortState = this.getItemFormulaInfoSortState();
        ItemFormula itemFormula = (ItemFormula)formula;
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(itemFormula.itemNumber);
        fields.add(new Integer(itemFormula.dataElement));
        Object[][] result = new Object[1][fields.size()];
        result[0] = fields.toArray();
        return result;
    }

    public String[] getIndexResultSetFields() {
        ItemFormulaInfoSortState itemFormulaInfoSortState = this.getItemFormulaInfoSortState();
        ArrayList<String> indexedFields = new ArrayList<String>();
        indexedFields.add("itemNumber");
        indexedFields.add("dataElement");
        String[] result = new String[indexedFields.size()];
        indexedFields.toArray(result);
        return result;
    }

    public ItemFormulaInfoSortState getItemFormulaInfoSortState() {
        return (ItemFormulaInfoSortState)this.sortState;
    }

    public int getMaxSQLVaribleSize() {
        return this.maxsqlvar;
    }

    private void initMaxSQLVaribleSize() {
        Object batchSize = this.parameterContext.getAttribute("KEY_CSLPARAM_CHECKFORMULA_ITEMBATCH_SIZE");
        if (batchSize != null) {
            try {
                this.maxsqlvar = (Integer)batchSize;
            }
            catch (Exception e) {
                this.maxsqlvar = 300;
            }
        }
    }

    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(" select distinct tmpl.templateId templateId,tmpl.reportId reportId,itemList.FItemNumber itemNumber,");
        ItemFormulaInfoSortState itemFormulaInfoSortState = this.getItemFormulaInfoSortState();
        if (!itemFormulaInfoSortState.isKeyNumberEmpty) {
            sql.append(" itemList.FKeyNumber keyNumber, \n");
        }
        sql.append(" itemList.FDataElement dataElement,itemList.FValueType valueType,itemList.FSheetId sheetId, itemList.FPosX cellCol, itemList.FPosY cellRow \n");
    }

    public void buildFromPart(Set nullSet, StringBuffer sql) {
        CslReportInfo reportInfo = (CslReportInfo)this.parameterContext.getAttribute("cslReportInfo");
        String tblName = (String)this.parameterContext.getAttribute("tempTblName");
        this.innerBuildFromPart(sql, reportInfo, tblName);
    }

    private void innerBuildFromPart(StringBuffer sql, CslReportInfo reportInfo, String tblName) {
        int templateType = reportInfo.getTemplate().getTemplateType().getValue();
        int periodType = reportInfo.getPeriodType().getValue();
        ItemFormulaInfoSortState itemFormulaInfoSortState = this.getItemFormulaInfoSortState();
        String orgBoundId = itemFormulaInfoSortState.orgBoundId;
        boolean isCslRpt = this.isCslReport(reportInfo.getReportSourceType());
        sql.append(" from T_CSL_TempletItemList itemList  \n");
        sql.append(" inner join (  \n");
        sql.append(" select case when template.FGroupTemplateID is null then template.FID else template.FGroupTemplateID end templateId, report.FID reportId \n");
        sql.append(" from T_CSL_CslReport report \n");
        sql.append(" inner join T_RPT_Template template on report.FTemplateID = template.FID \n");
        if (isCslRpt) {
            sql.append(" inner join T_ORG_BaseUnit rptOrgUnit on rptOrgUnit.FID = report.FOrgUnitID   \n");
        }
        if (!StringUtils.isEmpty((String)orgBoundId)) {
            sql.append(" inner join t_csl_rptreceived rec on rec.freportid=report.fid \n");
        }
        sql.append(" where ");
        if (templateType == 6 || templateType == 10 || templateType == 2 || templateType == 12 || templateType == 15 || templateType == 16) {
            sql.append(" (template.FTemplateType = 6 or template.FTemplateType = 10 or template.FTemplateType = 2");
            sql.append(" or template.FTemplateType =12 or template.FTemplateType =15 or template.FTemplateType =16) \n");
        } else if (templateType == 3 || templateType == 11 || templateType == 17) {
            sql.append(" (template.FTemplateType = 3 or template.FTemplateType = 11 or template.FTemplateType = 17) \n");
        } else {
            sql.append(" (template.FTemplateType = " + templateType + ") \n");
        }
        sql.append("  and  template.FPeriodType = " + periodType + " \n");
        sql.append(" and report.fyear = " + itemFormulaInfoSortState.year + " \n");
        sql.append(" and report.fperiod = " + itemFormulaInfoSortState.period + " \n");
        sql.append(" and report.FPeriodType = " + periodType + " \n");
        sql.append(" and report.FAdjustStatus = " + reportInfo.getAdjustStatus().getValue() + " \n");
        sql.append(" and report.FCurrencyID = '" + reportInfo.getCurrency().getId().toString() + "' \n");
        sql.append(" and report.FDataCollectNumber ='" + reportInfo.getDataCollectNumber() + "' \n");
        if (itemFormulaInfoSortState.isDItem) {
            if (CslRptUtil.isCslRpt(reportInfo.getReportSourceType().getValue())) {
                sql.append(" and report.FSourceType=").append(reportInfo.getReportSourceType().getValue()).append(" \n ");
            } else {
                sql.append(" and report.FSourceType in (10,11,12,13,14,32,35,44) \n");
            }
        } else {
            sql.append(" and report.FSourceType in (1,2,3,4,6,7,8,31,34) \n");
        }
        if (isCslRpt) {
            sql.append(" and rptOrgUnit.FNumber = '" + reportInfo.getOrgUnit().getNumber() + "' \n");
        } else {
            sql.append(" and report.FOrgUnitID = '" + reportInfo.getOrgUnit().getId().toString() + "' \n");
        }
        if (!StringUtils.isEmpty((String)orgBoundId)) {
            sql.append(" and rec.forgtreeid = '" + orgBoundId + "' \n");
        }
        sql.append(" ) as tmpl  on  tmpl.templateId = itemList.FTemplateId \n");
        sql.append(" inner join ").append(tblName).append(" temp on temp.FItemNumber = itemList.FItemNumber and temp.FDataElement = itemList.FDataElement \n");
        sql.append(" inner join T_RPT_RptSheetPara sheetParam  on tmpl.reportId = sheetParam.Freportid  and sheetParam.FSheetID = itemList.FSheetId \n");
    }

    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        ItemFormulaInfoSortState itemFormulaInfoSortState = this.getItemFormulaInfoSortState();
        sql.append(" where sheetParam.FReportClass = 1 \n");
        if (itemFormulaInfoSortState.isDItem) {
            if (itemFormulaInfoSortState.isKeyNumberEmpty) {
                sql.append(" and (itemList.FKeyNumber = '' or itemList.FKeyNumber is NULL)    \n");
            }
        } else {
            sql.append(" and ucase(itemList.FKeyNumber) = 'NULL' \n");
        }
        sql.append(" and itemList.FValueType = " + itemFormulaInfoSortState.valueType + " \n");
    }

    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
    }

    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
    }

    private boolean isCslReport(RptSrcTypeEnum rptSourceType) {
        return RptSrcTypeEnum.CONSOLIDATION.equals((Object)rptSourceType) || RptSrcTypeEnum.SUM.equals((Object)rptSourceType) || RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)rptSourceType) || RptSrcTypeEnum.DYNAMICSUMREPORT.equals((Object)rptSourceType) || RptSrcTypeEnum.MANUSCRIPT.equals((Object)rptSourceType);
    }
}

