/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.assist;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.BookExpressionHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ExcelFormulaPaserHelperExt;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.IHandleReferenceExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellExprUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import java.util.List;

public class ConvertCellFormula {
    private static final ILog log = LogFactory.getLog("AUTOITEM", ConvertCellFormula.class);
    private IHandleReferenceExpr handleReferExpr;

    public void action(List<Cell> cells) {
        Cell cell = null;
        int cellSize = cells.size();
        for (int cellIndex = 0; cellIndex < cellSize; ++cellIndex) {
            cell = cells.get(cellIndex);
            this.exec(cell, true);
        }
    }

    public String exec(Cell cell, boolean directSetToCell) {
        Sheet sheet = cell.getSheet();
        String formula = null;
        if (cell.getFormula() == null || "".equals(cell.getFormula())) {
            return formula;
        }
        Expression expression = null;
        try {
            log.info("before convert,formula is {0}", new Object[]{cell.getFormula()});
            expression = ExcelFormulaPaserHelperExt.parse(cell.getFormula());
            BookExpressionHandler handler = new BookExpressionHandler(sheet);
            handler.setHandleReferenceExpr(this.handleReferExpr);
            expression = ExcelFormulaPaserHelperExt.walk(expression, handler);
        }
        catch (Exception e) {
            log.error("", e);
        }
        if (expression != null) {
            StringBuffer buffer;
            if (CellExprUtil.isFunctionExpr(expression)) {
                buffer = new StringBuffer();
                expression.output(buffer);
                this.setCellFormula(cell, "=" + buffer.toString());
                log.info("after convert,formula is {0}", new Object[]{buffer.toString()});
                formula = "=" + buffer.toString();
            } else if (CellExprUtil.isNumberExpr(expression)) {
                buffer = new StringBuffer();
                expression.output(buffer);
                if (!"".equals(buffer.toString())) {
                    formula = "=" + buffer.toString();
                }
                log.info("after convert,formula not be found!, constant formula is {0}", new Object[]{buffer.toString()});
            } else if (CellExprUtil.isEmptyExpr(expression)) {
                if (!"".equals(cell.getFormula())) {
                    // empty if block
                }
                log.info("after convert,formula not be found!, formula is empty");
            }
        }
        if (directSetToCell) {
            this.setCellFormula(cell, formula);
        }
        return formula;
    }

    protected void setCellFormula(Cell cell, String formula) {
        Variant value = cell.getValue();
        cell.setFormula(formula);
        cell.setValue(value);
    }

    public void registerHandle(IHandleReferenceExpr handleReferExpr) {
        this.handleReferExpr = handleReferExpr;
    }
}

