/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.assist;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ConvertCellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.HandleReferExprForItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ConvertRefFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;

public class CreateFormulaScheme {
    private static final ILog log = LogFactory.getLog("AUTOITEM", CreateFormulaScheme.class);
    private DBHandler dao;

    public CreateFormulaScheme(DBHandler dao) {
        this.dao = dao;
    }

    public FormulaSchemeInfo by(Cell cell) throws EASBizException, BOSException {
        Object itemFormula = cell.getUserObjectValue("ITEM");
        if (!(itemFormula instanceof ItemFormula)) {
            log.info("this cell({0}) can not contain item formula", new Object[]{cell});
            return null;
        }
        return this.by(cell, (ItemFormula)itemFormula);
    }

    public FormulaSchemeInfo by(Cell cell, ItemFormula itemFormula) throws EASBizException, BOSException {
        if (itemFormula == null) {
            log.info("this cell({0}) can not contain item formula", new Object[]{cell});
            return null;
        }
        if (cell.getFormula() != null && StringUtil.isBigDecimal(cell.getFormula())) {
            Variant value = cell.getValue();
            cell.setFormula("=constant(" + cell.getFormula() + ")");
            cell.setValue(value);
        } else {
            if (!CellUtil.isValidValueFormula(cell)) {
                log.info("this cell({0}) can not contain value formula", new Object[]{cell});
                return null;
            }
            log.info("find a cell with item formula({0})", new Object[]{itemFormula.getFormula()});
            ConvertCellFormula convertCellFormula = new ConvertCellFormula();
            convertCellFormula.registerHandle(new HandleReferExprForItemFormula());
            convertCellFormula.exec(cell, true);
            log.info("after excel formula convert,formula is {0}", new Object[]{cell.getFormula()});
            String valueFormula = CellUtil.getValueFormula(cell);
            ConvertRefFormula convertRefFormula = new ConvertRefFormula(this.dao, true);
            if (convertRefFormula.isMeet(valueFormula)) {
                IFormula valueFormulaAfter = convertRefFormula.exec(valueFormula);
                if (valueFormulaAfter != null) {
                    valueFormula = "=" + valueFormulaAfter.formulaString(true);
                    cell.setFormula(valueFormula);
                } else {
                    return null;
                }
            }
        }
        if (!CellUtil.isValidValueFormula(cell)) {
            log.info("this cell({0}) can not contain valid value formula", new Object[]{cell});
            return null;
        }
        FormulaSchemeInfo scheme = new FormulaSchemeInfo();
        scheme.setItemFormula(itemFormula.getFormula());
        scheme.setFormulaSheetID(cell.getSheet().getID());
        scheme.setValueFormula(CellUtil.getValueFormula(cell));
        scheme.setId(BOSUuid.create((BOSObjectType)scheme.getBOSType()));
        scheme.setEnvParam((RptSheetParamInfo)cell.getSheet().getUserObjectValue("SHEET_PARAM"));
        return scheme;
    }
}

