/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.HandleDynFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.HandleDynFormulaForCache;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ILevels;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaCalcUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.DynaGradeInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildFormulaCalcUnit {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", BuildFormulaCalcUnit.class);
    protected DBHandler dao;

    public BuildFormulaCalcUnit(DBHandler dao) {
        this.dao = dao;
    }

    public List<Set<FormulaCalcUnit>> scan(FormulaCalcContextInfo calcContextDefine, FormulaSchemeCollection formulaSchemes, ILevels levels) throws EASBizException, BOSException {
        ArrayList<Set<FormulaCalcUnit>> allCalcUnits = new ArrayList<Set<FormulaCalcUnit>>();
        List<Object> oneCompanyCalcUnits = new ArrayList();
        FormulaCalcContextCompanyCollection companys = calcContextDefine.getCompanys();
        int size = companys.size();
        for (int i = 0; i < size; ++i) {
            oneCompanyCalcUnits = this.scan(calcContextDefine, formulaSchemes, (OrgUnitInfo)companys.get(i).getCompany(), levels);
            if (oneCompanyCalcUnits.isEmpty()) continue;
            if (allCalcUnits.isEmpty()) {
                allCalcUnits.addAll(oneCompanyCalcUnits);
                continue;
            }
            for (int j = 0; j < oneCompanyCalcUnits.size(); ++j) {
                if (j >= allCalcUnits.size()) {
                    allCalcUnits.add((Set<FormulaCalcUnit>)oneCompanyCalcUnits.get(j));
                    continue;
                }
                ((Set)allCalcUnits.get(j)).addAll((Collection)oneCompanyCalcUnits.get(j));
            }
        }
        return allCalcUnits;
    }

    public List<Set<FormulaCalcUnit>> scan(FormulaCalcContextInfo calcContextDefine, FormulaSchemeCollection formulaSchemesParam, OrgUnitInfo company, ILevels levels) throws EASBizException, BOSException {
        ArrayList<Set<FormulaCalcUnit>> levelCalcUnits = new ArrayList<Set<FormulaCalcUnit>>(1);
        FormulaSchemeInfo schemeInfo = null;
        Set<FormulaCalcUnit> calcUnits = new HashSet();
        HandleDynFormulaForCache handleDynFormula = new HandleDynFormulaForCache(this.dao);
        int level = 0;
        FormulaSchemeCollection formulaSchemes = new FormulaSchemeCollection();
        formulaSchemes.addCollection(formulaSchemesParam);
        int schemeSize = formulaSchemes.size();
        for (int schemeIndex = 0; schemeIndex < schemeSize; ++schemeIndex) {
            schemeInfo = formulaSchemes.get(schemeIndex);
            level = levels.get(schemeInfo.getItemFormula().formulaString(true));
            if (level < 0) continue;
            while (level >= levelCalcUnits.size()) {
                levelCalcUnits.add(new HashSet(1));
            }
            calcUnits = (Set)levelCalcUnits.get(level);
            calcUnits.addAll(this.scanOneCompany(calcContextDefine, schemeInfo, company, handleDynFormula));
        }
        ((HandleDynFormula)handleDynFormula).clear();
        calcUnits = null;
        return levelCalcUnits;
    }

    protected Set<FormulaCalcUnit> scanOneCompany(FormulaCalcContextInfo calcContextDefine, FormulaSchemeInfo schemeInfo, OrgUnitInfo company, HandleDynFormula handleDynFormula) throws EASBizException, BOSException {
        FormulaCalcUnit calcUnit = null;
        HashSet<FormulaCalcUnit> calcUnits = new HashSet<FormulaCalcUnit>(0);
        if (schemeInfo.getCompany() != null && schemeInfo.getCompany().getId() != null && !schemeInfo.getCompany().getId().equals((Object)company.getId())) {
            return calcUnits;
        }
        if (handleDynFormula.isMeet(schemeInfo)) {
            Map<IFormula, IFormula> dynaFormulas = handleDynFormula.exec(company, schemeInfo);
            LOG.info("build {0} dynamic item/value formula", new Object[]{dynaFormulas.size()});
            for (Map.Entry<IFormula, IFormula> dynaFormula : dynaFormulas.entrySet()) {
                calcUnit = this.buildCalcUnit(calcContextDefine, company, dynaFormula.getKey(), dynaFormula.getValue(), schemeInfo);
                if (calcUnit == null) continue;
                calcUnits.add(calcUnit);
            }
            return calcUnits;
        }
        calcUnit = this.buildCalcUnit(calcContextDefine, company, null, null, schemeInfo);
        if (calcUnit != null) {
            calcUnits.add(calcUnit);
        }
        LOG.info("build one normula item/value formula.({0})", new Object[0]);
        return calcUnits;
    }

    protected FormulaCalcUnit buildCalcUnit(FormulaCalcContextInfo calcContextDefine, OrgUnitInfo company, IFormula itemFormula, IFormula valueFormula, FormulaSchemeInfo schemeInfo) {
        FormulaCalcUnit calcUnit = new FormulaCalcUnit();
        if (itemFormula == null) {
            itemFormula = schemeInfo.getItemFormula();
            if (schemeInfo.getDynaAsstType() != null && itemFormula != null && !(itemFormula.getExtendProperty("AssistType") instanceof String)) {
                itemFormula.putExtendProperty("AssistType", schemeInfo.getDynaAsstType());
            }
            if (schemeInfo.getItemDynaGrade() != null && itemFormula.getExtendProperty(DynaGradeInfo.class) == null) {
                itemFormula.putExtendProperty(DynaGradeInfo.class, new DynaGradeInfo(schemeInfo.getItemDynaGrade(), false));
            }
        }
        itemFormula = (IFormula)itemFormula.clone();
        if (valueFormula == null && (valueFormula = schemeInfo.getValueFormulaInfo()) == null) {
            return null;
        }
        valueFormula = (IFormula)valueFormula.clone();
        calcUnit.setItemFormula(itemFormula);
        calcUnit.setValueFormula(valueFormula);
        calcUnit.getCalcContext().setDefine(calcContextDefine, company);
        calcUnit.getCalcContext().setSheetParam(schemeInfo.getEnvParam());
        calcUnit.setTemplate(schemeInfo.getTemplate());
        calcUnit.initValueFormula();
        return calcUnit;
    }
}

