/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckAndSupplyTemplateForFormulaCalc;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.FindBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.FindFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.SaveFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.ReportEntityForTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QuerySheetParams;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.List;

public class ExtractFormulaScheme {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ExtractFormulaScheme.class);
    protected DBHandler dao;

    public ExtractFormulaScheme(DBHandler dao) {
        this.dao = dao;
    }

    public FormulaSchemeCollection action(TemplateInfo template, OrgUnitInfo company) throws EASBizException, BOSException {
        LOG.info("start check template");
        new CheckAndSupplyTemplateForFormulaCalc(this.dao).exec(template);
        QuerySheetParams querySheetParams = new QuerySheetParams(this.dao);
        List<IBasePoint> itemFormulaAreaes = new FindBasePoint(new ReportEntityForTemplate(template, querySheetParams)).scan();
        LOG.info("find {0} base point {1}", new Object[]{itemFormulaAreaes.size(), itemFormulaAreaes});
        this.emptyDataHandle(itemFormulaAreaes.isEmpty(), template);
        FormulaSchemeCollection formulaSchemes = new FindFormulaScheme(this.dao).scan(itemFormulaAreaes);
        LOG.info("start save formula scheme(size:{0})", new Object[]{new Integer(formulaSchemes.size())});
        this.emptyDataHandle(formulaSchemes.isEmpty(), template);
        if (!formulaSchemes.isEmpty()) {
            new SaveFormulaScheme(this.dao).save(template, company, formulaSchemes);
        }
        return formulaSchemes;
    }

    protected void emptyDataHandle(boolean empty, TemplateInfo template) throws AutoItemException {
        if (!empty) {
            return;
        }
        throw new AutoItemException(AutoItemException.INVALID_FORMULA_DEFINE, new Object[]{template.getName()});
    }

    public FormulaSchemeCollection repeatAction(TemplateInfo template, OrgUnitInfo company) throws EASBizException, BOSException {
        FilterInfo existFlagFilter = new FilterInfo();
        existFlagFilter.appendFilterItem("number", (Object)template.getNumber());
        existFlagFilter.appendFilterItem("hasExtrItem", (Object)true);
        if (!this.dao.get(ITemplate.class).exists(existFlagFilter)) {
            return null;
        }
        return this.action(template, company);
    }

    public void clearScheme(TemplateInfo template, OrgUnitInfo company) {
        FilterInfo clearFilter = new FilterInfo();
        clearFilter.appendFilterItem("template.number", (Object)template.getNumber());
        if (company != null) {
            clearFilter.appendFilterItem("company", (Object)company.getId().toString());
        } else {
            clearFilter.getFilterItems().add(new FilterItemInfo("company", null, CompareType.EQUALS));
        }
        try {
            this.dao.get(IFormulaScheme.class).delete(clearFilter);
        }
        catch (EASBizException e) {
            LOG.error("", e);
        }
        catch (BOSException e) {
            LOG.error("", e);
        }
    }
}

