/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.FormulaSchemeParserLink;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.List;

public class FindFormulaScheme {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FindFormulaScheme.class);
    private DBHandler dao;

    public FindFormulaScheme(DBHandler dao) {
        this.dao = dao;
    }

    public FormulaSchemeCollection scan(List<IBasePoint> basePointes) {
        FormulaSchemeCollection schemes = new FormulaSchemeCollection();
        FormulaSchemeParserLink parsers = this.getFormulaSchemeParserLink();
        FormulaSchemeCollection schemeForParse = null;
        for (IBasePoint basePoint : basePointes) {
            schemeForParse = parsers.parse(basePoint);
            if (schemeForParse.isEmpty()) {
                log.info("fail to parse {0} in parser list({1})", new Object[]{basePoint, parsers});
                continue;
            }
            log.info("success to parse {0},scheme is {1}", new Object[]{basePoint, schemeForParse});
            schemes.addCollection(schemeForParse);
        }
        log.info("find {0} scheme", new Object[]{new Integer(schemes.size())});
        return schemes;
    }

    protected FormulaSchemeParserLink getFormulaSchemeParserLink() {
        return new FormulaSchemeParserLink(this.dao);
    }
}

