/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.AbstractFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaParameter;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SingleFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringExpressionCalculator;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CombineFormula
extends AbstractFormula {
    private static final long serialVersionUID = 4192283811312729135L;
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CombineFormula.class);
    protected List<SingleFormula> subFormulas = new ArrayList<SingleFormula>();
    protected StringBuffer formulaExpress = new StringBuffer();
    protected Object result;

    private CombineFormula() {
    }

    public CombineFormula(List<SingleFormula> subFormulas, String formulaExpress) {
        this();
        this.subFormulas.addAll(subFormulas);
        this.formulaExpress.append(formulaExpress);
    }

    public int addFunc(IFormula func, String c) {
        if (this.formulaExpress.length() != 0) {
            this.formulaExpress.append(c);
        }
        int index = this.subFormulas.size();
        if (func instanceof CombineFormula) {
            CombineFormula subCombineFormula = (CombineFormula)func;
            String subFormulaExpress = subCombineFormula.getFormulaExpress().toString();
            subFormulaExpress = StringUtil.changeMessageFormat(subFormulaExpress, index);
            this.formulaExpress.append(subFormulaExpress);
            this.subFormulas.addAll(subCombineFormula.getSubFormulas());
            return index + 1;
        }
        if (func instanceof SingleFormula) {
            this.subFormulas.add((SingleFormula)func);
            this.formulaExpress.append("{" + index + "}");
            return index;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.subFormulas.isEmpty();
    }

    @Override
    public boolean isValid() {
        if (this.subFormulas.isEmpty()) {
            return false;
        }
        boolean valid = false;
        for (IFormula iFormula : this.subFormulas) {
            valid = valid || iFormula.isValid();
        }
        return valid;
    }

    @Override
    public boolean isRealFormula() {
        if (super.isRealFormula()) {
            return true;
        }
        for (IFormula iFormula : this.subFormulas) {
            if (!iFormula.isRealFormula()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.formulaString(true);
    }

    @Override
    public String formulaString(boolean displayNestedFormula) {
        try {
            Object[] subFormulasPara = this.subFormulas.toArray();
            return MessageFormat.format(this.formulaExpress.toString(), subFormulasPara);
        }
        catch (Exception e) {
            LOG.warn("", ILog.EMPTY_PARAMS, e);
            return super.toString();
        }
    }

    public boolean contains(IFormula func) {
        return this.subFormulas.contains(func);
    }

    @Override
    public void setResult(Map<String, Object> paramResults) {
        super.setResult(paramResults);
        ArrayList<String> realValues = new ArrayList<String>();
        int size = this.subFormulas.size();
        for (int i = 0; i < size; ++i) {
            SingleFormula param = this.subFormulas.get(i);
            if (!(param instanceof IFormula)) continue;
            ((IFormula)param).setResult(paramResults);
            Object subResult = ((IFormula)param).getResult();
            if (subResult instanceof BigDecimal) {
                subResult = ((BigDecimal)subResult).setScale(4);
            } else if (subResult == null) {
                subResult = new BigDecimal("0.0");
            } else if (subResult instanceof String) {
                this.result = new BigDecimal("0.0");
                return;
            }
            realValues.add(subResult + "");
        }
        String numberExpress = MessageFormat.format(this.formulaExpress.toString(), realValues.toArray());
        this.result = new StringExpressionCalculator().calc(numberExpress);
        if (this.result instanceof Double) {
            this.result = new BigDecimal((Double)this.result).setScale(4, 5);
        }
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    public StringBuffer getFormulaExpress() {
        return this.formulaExpress;
    }

    public int replace(IFormula func, IFormula param) {
        if (!this.subFormulas.contains(func)) {
            LOG.info("func({0}) not be found in combine formula({1}) ", new Object[]{func, this});
            return -1;
        }
        int indexOf = this.subFormulas.indexOf(func);
        if (param instanceof CombineFormula) {
            this.subFormulas.remove(func);
            CombineFormula subCombineFormula = (CombineFormula)param;
            String subFormulaExpress = subCombineFormula.getFormulaExpress().toString();
            subFormulaExpress = StringUtil.changeMessageFormat(subFormulaExpress, this.subFormulas.size());
            if ("BLOCK".equals(func.getName())) {
                subFormulaExpress = "(" + subFormulaExpress + ")";
            }
            String newExpress = this.formulaExpress.toString().replaceAll("\\{" + indexOf + "\\}", subFormulaExpress);
            this.formulaExpress.setLength(0);
            this.formulaExpress.append(newExpress);
            this.subFormulas.addAll(subCombineFormula.getSubFormulas());
            for (IFormula iFormula : subCombineFormula.getSubFormulas()) {
                if (!(iFormula instanceof CombineFormula)) continue;
                this.replace(iFormula, iFormula);
            }
        } else if (param instanceof SingleFormula) {
            this.subFormulas.set(indexOf, (SingleFormula)param);
        }
        return indexOf;
    }

    @Override
    public boolean replace(Object oldParam, Object newParam) {
        for (int i = 0; i < this.subFormulas.size(); ++i) {
            if (oldParam == this.subFormulas.get(i) && newParam instanceof SingleFormula) {
                this.subFormulas.set(i, (SingleFormula)newParam);
                continue;
            }
            if (!(this.subFormulas.get(i) instanceof IFormula)) continue;
            ((IFormula)this.subFormulas.get(i)).replace(oldParam, newParam);
        }
        return true;
    }

    public IFormula getSingleFormula() {
        if (this.subFormulas.size() != 1 || !"{0}".equals(this.formulaExpress.toString())) {
            return null;
        }
        IFormula realFormula = this.subFormulas.get(0);
        while (realFormula instanceof CombineFormula) {
            realFormula = ((CombineFormula)realFormula).getSingleFormula();
        }
        return realFormula;
    }

    public List<SingleFormula> getSubFormulas() {
        return this.subFormulas;
    }

    @Override
    public Set<FormulaParameter> buildParameter(ParameterType type, String sheetParam, Integer keepCalcLevel) {
        if (!this.formulaParams.isEmpty()) {
            return this.formulaParams;
        }
        HashSet<FormulaParameter> currFormulaParams = new HashSet<FormulaParameter>();
        for (IFormula iFormula : this.subFormulas) {
            currFormulaParams.addAll(iFormula.buildParameter(type, sheetParam, keepCalcLevel));
        }
        this.formulaParams.addAll(currFormulaParams);
        return currFormulaParams;
    }

    @Override
    public boolean isNestedSubFormula() {
        for (IFormula iFormula : this.subFormulas) {
            if (!iFormula.isNestedSubFormula()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FormulaParameter getParameter() {
        return null;
    }

    @Override
    public Object clone() {
        CombineFormula formula = (CombineFormula)super.clone();
        formula.formulaExpress = new StringBuffer(this.formulaExpress);
        formula.subFormulas = new ArrayList<SingleFormula>(this.subFormulas.size());
        for (IFormula iFormula : this.subFormulas) {
            formula.subFormulas.add((SingleFormula)iFormula.clone());
        }
        formula.result = this.result;
        return formula;
    }

    @Override
    public IFormula newInstance() {
        return new CombineFormula();
    }

    @Override
    public List<Object> getParams() {
        if (this.params.isEmpty() && !this.subFormulas.isEmpty()) {
            return new ArrayList<Object>(this.subFormulas);
        }
        return this.params;
    }
}

