/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.IHandleReferenceExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import java.math.BigDecimal;

public class HandleReferenceExprByCellValue
implements IHandleReferenceExpr {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", HandleReferenceExprByCellValue.class);

    @Override
    public Expression exec(ReferenceExpr expr, Cell cell) {
        if (cell == null || cell.getValue() == null) {
            return null;
        }
        Object value = cell.getValue().getValue();
        if (value != null) {
            if (!StringUtil.isEmpty((String)cell.getFormula()) && CellFormula.isFromHere(cell)) {
                return null;
            }
            if (value instanceof Integer) {
                return new NumberExpr(new BigDecimal((Integer)value));
            }
            if (value instanceof BigDecimal) {
                return new NumberExpr((BigDecimal)value);
            }
            if (value instanceof Number) {
                return new NumberExpr(new BigDecimal(((Number)value).doubleValue()));
            }
            if (value instanceof String) {
                return new StringExpr((String)value);
            }
            return null;
        }
        return null;
    }
}

