/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaParameter;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.GetNestedFormulaValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SheetParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SingleFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.ExecuteSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.StringSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringFormulaParser;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParameterDao
implements Serializable {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ParameterDao.class);
    private static final long serialVersionUID = 2384954868728209257L;
    private static final FilterInfo DEFAULT_FILTER_INFO = new FilterInfo();
    protected Uuid currentCalcFlag;
    protected transient DBHandler dao;

    public ParameterDao(DBHandler dao, Uuid currentCalcFlag) {
        this.currentCalcFlag = currentCalcFlag;
        this.dao = dao;
    }

    public void save(Collection<FormulaParameter> params) throws BOSException {
        StringSQL insertSql = new StringSQL();
        insertSql.append(" insert into T_CSL_FormulaCalcUnit ");
        insertSql.append(" (fid,ftaskId,fcalcLevel,fcontextKey,fsheetParam,formula,formulaName,fresult) ");
        insertSql.append(" values ");
        insertSql.append(" (?,?,?,?,?,?,?,?) ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(params.size());
        ExecuteSQL executeSQL = this.getExecuteSQL();
        LOG.info("start_save_params");
        for (FormulaParameter param : params) {
            paramsList.add(new Object[]{param.getParamKey(), this.currentCalcFlag.toString(), param.getType().getCalcLevel(), param.getType().getContextKey().serialString(), param.getSheetParam().serialString(), param.getFormula(), param.getFormulaName(), param.getRealValue() != null ? StringUtil.serialize(param.getRealValue()) : null});
            if (paramsList.size() <= 5000) continue;
            LOG.info("start_batch_params");
            executeSQL.executeBatchAndReturn(insertSql.toString(), paramsList);
            LOG.info("end___batch_params");
            paramsList.clear();
        }
        if (!paramsList.isEmpty()) {
            LOG.info("start_batch_params:");
            executeSQL.executeBatchAndReturn(insertSql.toString(), paramsList);
            LOG.info("end___batch_params:");
            paramsList.clear();
        }
        LOG.info("end___save_params");
    }

    public Set<FormulaParameter> getParam(ParameterType type, Set<SheetParam> returnSheetParams) throws BOSException {
        StringSQL selectSql = new StringSQL();
        selectSql.append(" select * from T_CSL_FormulaCalcUnit ");
        selectSql.append(" where fresult is null and ftaskid = ? and fcalcLevel = ? and fcontextKey = ? ");
        IRowSet rows = this.getExecuteSQL().executeQuery(selectSql.toString(), new Object[]{this.currentCalcFlag.toString(), type.getCalcLevel(), type.getContextKey().serialString()});
        HashSet<FormulaParameter> params = new HashSet<FormulaParameter>();
        GetNestedFormulaValue getNestedFormulaValue = new GetNestedFormulaValue(this);
        try {
            FormulaParameter param = null;
            String paramKey = null;
            String sheetParam = null;
            String formula = null;
            IFormula formulaInfo = null;
            StringFormulaParser parser = new StringFormulaParser();
            while (rows.next()) {
                paramKey = rows.getString("fid");
                sheetParam = rows.getString("fsheetParam");
                formula = rows.getString("formula");
                formulaInfo = parser.parse(formula);
                if (!(formulaInfo instanceof SingleFormula)) continue;
                formulaInfo.buildParameter(type, sheetParam, type.getCalcLevel());
                param = ((SingleFormula)formulaInfo).getParameter();
                param.setParamKey(paramKey);
                param.setParameterDao(this);
                params.add(param);
                returnSheetParams.add(param.getSheetParam());
                getNestedFormulaValue.add((SingleFormula)formulaInfo);
            }
            getNestedFormulaValue.exec(type);
            getNestedFormulaValue.clear();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return params;
    }

    public void saveValue(Collection<FormulaParameter> params) throws BOSException {
        StringSQL updateSql = new StringSQL();
        updateSql.append(" update  T_CSL_FormulaCalcUnit ");
        updateSql.append(" set fresult = ? ");
        updateSql.append(" where fid = ?");
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(params.size());
        Object[] sqlParam = null;
        for (FormulaParameter param : params) {
            String result = StringUtil.serialize(param.getRealValue());
            if (result != null && result.length() > 50) {
                result = result.substring(0, 50);
            }
            sqlParam = new Object[]{result, param.getParamKey()};
            sqlParams.add(sqlParam);
        }
        this.getExecuteSQL().executeBatchAndReturn(updateSql.toString(), sqlParams);
        sqlParams.clear();
    }

    public Map<String, Object> getParameterValues() throws BOSException {
        return this.getParameterValues(DEFAULT_FILTER_INFO);
    }

    public Map<String, Object> getParameterValues(FilterInfo filterInfo) throws BOSException {
        HashMap<String, Object> paramResults = new HashMap<String, Object>();
        StringSQL selectSql = new StringSQL();
        selectSql.append(" select * from T_CSL_FormulaCalcUnit ");
        selectSql.append(" where ftaskid = ?");
        if (!"".equals(filterInfo.toSql())) {
            selectSql.append(" and ( ");
            selectSql.append(filterInfo.toSql());
            selectSql.append(" ) ");
        }
        IRowSet rows = this.getExecuteSQL().executeQuery(selectSql.toString(), new Object[]{this.currentCalcFlag.toString()});
        try {
            String paramKey = null;
            String result = null;
            String formula = null;
            Object resultValue = null;
            while (rows.next()) {
                paramKey = rows.getString("fid");
                result = rows.getString("fresult");
                formula = rows.getString("formula");
                resultValue = StringUtil.unSerialize(result);
                if (resultValue == null) continue;
                if (paramResults.containsKey(paramKey) || paramResults.containsKey(formula)) {
                    // empty if block
                }
                paramResults.put(paramKey, resultValue);
                paramResults.put(formula, resultValue);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return paramResults;
    }

    public void deleteTaskParam() throws BOSException {
        this.deleteTaskParam(null);
    }

    public void deleteTaskParam(String calcFlag) throws BOSException {
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append(" delete from  T_CSL_FormulaCalcUnit ");
        deleteSql.append(" where ftaskid = ?");
        if (calcFlag == null) {
            calcFlag = this.currentCalcFlag.toString();
        }
        this.getExecuteSQL().execute(deleteSql.toString(), new Object[]{calcFlag});
    }

    protected ExecuteSQL getExecuteSQL() {
        return this.dao.getExecuteSQL();
    }

    public void deleteParamByIds(List<String> paramIds) throws BOSException {
        StringBuffer deleteSqlFormat = new StringBuffer();
        deleteSqlFormat.append(" delete from  T_CSL_FormulaCalcUnit ");
        deleteSqlFormat.append(" where fid in {0}");
        int paramSize = paramIds.size();
        int oneBatchSize = 3000;
        int currSize = 0;
        Object[] sqlParams = null;
        String inFormatSql = StringUtil.getSQLVariable(oneBatchSize);
        String deleteSql = MessageFormat.format(deleteSqlFormat.toString(), inFormatSql);
        for (int index = 0; index < paramSize; ++index) {
            if (currSize == 0) {
                sqlParams = paramSize - index < oneBatchSize ? new Object[paramSize - index] : new Object[oneBatchSize];
            }
            if (++currSize < oneBatchSize && index + 1 < paramSize) {
                sqlParams[currSize - 1] = paramIds.get(index);
                continue;
            }
            if (sqlParams != null && currSize < oneBatchSize) {
                inFormatSql = StringUtil.getSQLVariable(sqlParams.length);
                deleteSql = MessageFormat.format(deleteSqlFormat.toString(), inFormatSql);
            }
            this.getExecuteSQL().execute(deleteSql, sqlParams);
            currSize = 0;
        }
    }
}

