/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import java.io.Serializable;

public class SheetParam
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4531229572951220487L;
    public static final SheetParam DEFAULT = new SheetParam("DEFAULT", "000");
    protected String sheetName;
    protected boolean isIncludeUnpost;
    protected boolean isIncludeSubAccount;
    protected boolean isIncludeLeafAccount;
    protected boolean isIncludeSubAsstItem;
    protected boolean isIncludeLeafAsstItem;
    protected boolean isIncludeAllAssist;

    public SheetParam(String sheetName, String sheetParam) {
        this.sheetName = sheetName;
        this.unSerialString(sheetParam);
    }

    public SheetParam(RptSheetParamInfo sheetParam) {
        if (sheetParam == null) {
            this.sheetName = SheetParam.DEFAULT.sheetName;
            this.unSerialString(DEFAULT.serialString());
            return;
        }
        this.sheetName = sheetParam.getSheetName();
        this.unSerialString((sheetParam.isIsIncludingUnposted() ? "1" : "0") + (sheetParam.getAcctParam() == null ? "00" : sheetParam.getAcctParam()));
    }

    public SheetParam(RptSheetParamInfo sheetParam, ReportVariables reportVariables) {
        this.sheetName = sheetParam.getSheetName();
        this.isIncludeUnpost = sheetParam.isIsIncludingUnposted();
        this.isIncludeSubAccount = this.getVariables("IncludeSubAccount", sheetParam.getSheetName(), reportVariables, false);
        this.isIncludeLeafAccount = this.getVariables("IncludeLeafAccount", sheetParam.getSheetName(), reportVariables, false);
        this.isIncludeSubAsstItem = this.getVariables("IncludeSub", sheetParam.getSheetName(), reportVariables, false);
        this.isIncludeLeafAsstItem = this.getVariables("IncludeLeaf", sheetParam.getSheetName(), reportVariables, false);
        this.isIncludeAllAssist = this.getVariables("IncludeAllAssistItems", sheetParam.getSheetName(), reportVariables, false);
    }

    public SheetParam(String sheetName, ReportVariables reportVariables) {
        this.sheetName = sheetName;
        this.isIncludeUnpost = this.getVariables("IncludePosted", sheetName, reportVariables, false);
        this.isIncludeSubAccount = this.getVariables("IncludeSubAccount", sheetName, reportVariables, false);
        this.isIncludeLeafAccount = this.getVariables("IncludeLeafAccount", sheetName, reportVariables, false);
        this.isIncludeSubAsstItem = this.getVariables("IncludeSub", sheetName, reportVariables, false);
        this.isIncludeLeafAsstItem = this.getVariables("IncludeLeaf", sheetName, reportVariables, false);
        this.isIncludeAllAssist = this.getVariables("IncludeAllAssistItems", sheetName, reportVariables, false);
    }

    protected boolean getVariables(String variableName, String sheetName, ReportVariables reportVariables, boolean defaultValue) {
        if (reportVariables == null || reportVariables.get(variableName, sheetName) == null) {
            return defaultValue;
        }
        return reportVariables.get(variableName, sheetName).getBoolValue(defaultValue);
    }

    public SheetParam(String sheetName, boolean isIncludeUnpost, boolean isIncludeSubAccount, boolean isIncludeLeafAccount, boolean isIncludeSubAsstItem, boolean isIncludeLeafAsstItem, boolean isIncludeAllAssist) {
        this.sheetName = sheetName;
        this.isIncludeUnpost = isIncludeUnpost;
        this.isIncludeSubAccount = isIncludeSubAccount;
        this.isIncludeLeafAccount = isIncludeLeafAccount;
        this.isIncludeSubAsstItem = isIncludeSubAsstItem;
        this.isIncludeLeafAsstItem = isIncludeLeafAsstItem;
        this.isIncludeAllAssist = isIncludeAllAssist;
    }

    public void unSerialString(String sheetParam) {
        if (sheetParam.length() != 3) {
            return;
        }
        this.isIncludeUnpost = sheetParam.charAt(0) == '1';
        this.isIncludeSubAccount = sheetParam.charAt(1) == '1';
        this.isIncludeLeafAccount = sheetParam.charAt(1) == '2';
        this.isIncludeSubAsstItem = sheetParam.charAt(1) == '3';
        this.isIncludeLeafAsstItem = sheetParam.charAt(1) == '4';
        this.isIncludeAllAssist = sheetParam.charAt(2) == '1';
    }

    public String serialString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.isIncludeUnpost ? 1 : 0);
        sb.append(this.getAcctParam());
        return sb.toString();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public boolean isIncludeUnpost() {
        return this.isIncludeUnpost;
    }

    public boolean isIncludeSubAccount() {
        return this.isIncludeSubAccount;
    }

    public boolean isIncludeLeafAccount() {
        return this.isIncludeLeafAccount;
    }

    public boolean isIncludeSubAsstItem() {
        return this.isIncludeSubAsstItem;
    }

    public boolean isIncludeLeafAsstItem() {
        return this.isIncludeLeafAsstItem;
    }

    public String toString() {
        return this.serialString();
    }

    public boolean isIncludeAllAssist() {
        return this.isIncludeAllAssist;
    }

    public String getAcctParam() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.isIncludeSubAccount ? "1" : "");
        sb.append(this.isIncludeLeafAccount ? "2" : "");
        sb.append(this.isIncludeSubAsstItem ? "3" : "");
        sb.append(this.isIncludeLeafAsstItem ? "4" : "");
        sb.append(this.isIncludeSubAccount || this.isIncludeLeafAccount || this.isIncludeSubAsstItem || this.isIncludeLeafAsstItem ? "" : "0");
        sb.append(this.isIncludeAllAssist ? 1 : 0);
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

