/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ConvertCellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CreateFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.HandleReferExprForItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckWheatheFilled;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IFindFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.DynaBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IsDynaArficFillClassificBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ConvertRefFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FreezeCellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.FindNormalScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.OrderGradeEntries;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.NextCell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class FindDynaArfiFillClassificScheme
implements IFindFormulaScheme {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FindDynaArfiFillClassificScheme.class);
    private DBHandler dao;

    public FindDynaArfiFillClassificScheme(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public boolean isMeet(IBasePoint basePoint) {
        return ActionFactory.get(IsDynaArficFillClassificBasePoint.class).is(basePoint);
    }

    @Override
    public FormulaSchemeCollection parse(IBasePoint basePoint) {
        DynaBasePoint dynaBasePoint = (DynaBasePoint)basePoint;
        DynaParameters dynaParam = dynaBasePoint.getDynaParam();
        DItemGradeInfo gradeInfo = dynaBasePoint.getGradeInfo();
        DItemGradeEntryInfo gradeEntry = null;
        NextCell nextCell = ActionFactory.get(NextCell.class);
        int spreadStyle = dynaParam.getSpreadStyle();
        FormulaSchemeCollection schemes = new FormulaSchemeCollection();
        int[] cellPos = new int[]{dynaBasePoint.getRow(), dynaBasePoint.getCol()};
        Cell cell = null;
        ItemFormula itemFormula = null;
        Sheet sheet = dynaBasePoint.getSheet();
        int[] arfiStartPos = null;
        int[] arfiEndPos = null;
        int[] arfiGradePos = null;
        FindNormalScheme normalParser = new FindNormalScheme(this.dao);
        int gradeCount = 1;
        boolean sumRowPosIsLeftUp = dynaParam.getPosition() == 1;
        List<Object> gradeEntries = new ArrayList(gradeInfo.getEntries().size());
        int[] subSumStart = null;
        int[] subSumEnd = null;
        gradeEntries = !sumRowPosIsLeftUp ? new OrderGradeEntries().exec(gradeInfo.getEntries()) : gradeInfo.getEntries();
        while ((cell = sheet.getCell((cellPos = nextCell.circle(cellPos, spreadStyle, true))[0], cellPos[1], false)) != null) {
            gradeCount = 1;
            itemFormula = CellUtil.getItemFormula(cell);
            if (itemFormula == null || itemFormula.getFormula() == null) break;
            log.info("find a cell with item formula({0})", new Object[]{itemFormula.getFormula()});
            int[] gradeSumPos = null;
            int gradeSize = gradeEntries.size();
            for (int gradeIndex = 0; gradeIndex < gradeSize; ++gradeIndex) {
                Cell sumCell;
                FormulaSchemeInfo scheme;
                gradeEntry = (DItemGradeEntryInfo)gradeEntries.get(gradeIndex);
                arfiStartPos = nextCell.circle(cellPos, spreadStyle, false, gradeCount);
                arfiEndPos = nextCell.circle(cellPos, spreadStyle, false, gradeCount + gradeEntry.getDetailCount());
                gradeSumPos = sumRowPosIsLeftUp ? arfiStartPos : arfiEndPos;
                int[] firstValueFormulaCellPos = null;
                Cell firstValueFormulaCell = null;
                if (sumRowPosIsLeftUp) {
                    subSumStart = firstValueFormulaCellPos = nextCell.circle(arfiStartPos, spreadStyle, false);
                    subSumEnd = arfiEndPos;
                    firstValueFormulaCell = sheet.getCell(firstValueFormulaCellPos[0], firstValueFormulaCellPos[1], true);
                } else {
                    firstValueFormulaCellPos = arfiStartPos;
                    firstValueFormulaCell = sheet.getCell(firstValueFormulaCellPos[0], firstValueFormulaCellPos[1], true);
                    subSumStart = arfiStartPos;
                    subSumEnd = nextCell.circle(cellPos, spreadStyle, false, gradeCount + gradeEntry.getDetailCount() - 1);
                }
                gradeCount += gradeEntry.getDetailCount() + (gradeEntry.isLeaf() ? 0 : 1);
                if (firstValueFormulaCellPos[0] <= arfiEndPos[0] && firstValueFormulaCellPos[1] <= arfiEndPos[1] && (firstValueFormulaCell == null || StringUtils.isEmpty((String)firstValueFormulaCell.getFormula()))) {
                    if (firstValueFormulaCell != null && StringUtils.isEmpty((String)firstValueFormulaCell.getFormula())) {
                        firstValueFormulaCell.setFormula("=constant(0)");
                    }
                } else {
                    FormulaSchemeCollection normalSchemes;
                    if (gradeEntry.getDetailSource() == 0) {
                        normalSchemes = normalParser.parse(sheet, arfiStartPos, arfiEndPos, basePoint);
                        log.info("find filled schemes ({0}) in dynamice base fill parse", new Object[]{normalSchemes});
                        schemes.addCollection(normalSchemes);
                        for (int i = 0; i < normalSchemes.size(); ++i) {
                            FormulaSchemeInfo formulaSchemeInfo = normalSchemes.get(i);
                            if (gradeEntry.getDetailAsstType() != null) {
                                formulaSchemeInfo.setDynaAsstType(gradeEntry.getDetailAsstType().getProperityName());
                            }
                            if (gradeEntry.getGrade() == null) continue;
                            formulaSchemeInfo.setItemDynaGrade(gradeEntry.getGrade());
                        }
                        continue;
                    }
                    arfiGradePos = sumRowPosIsLeftUp ? nextCell.circle(arfiStartPos, spreadStyle, false) : arfiStartPos;
                    if (new CheckWheatheFilled().isFilled(sheet.getCell(arfiGradePos[0], arfiGradePos[1], false), spreadStyle, gradeEntry.getDetailCount() + 1)) {
                        normalSchemes = new FindNormalScheme(this.dao).parse(sheet, arfiStartPos, arfiEndPos, basePoint);
                        log.info("find filled schemes ({0}) in dynamice base fill parse", new Object[]{normalSchemes});
                        schemes.addCollection(normalSchemes);
                        if (gradeEntry.getDetailAsstType() == null) continue;
                        for (int i = 0; i < normalSchemes.size(); ++i) {
                            normalSchemes.get(i).setDynaAsstType(gradeEntry.getDetailAsstType().getProperityName());
                        }
                        continue;
                    }
                }
                if ((scheme = this.create(firstValueFormulaCell, CellUtil.getItemFormula(sumCell = sheet.getCell(gradeSumPos[0], gradeSumPos[1], false)), dynaParam, gradeEntry)) == null) continue;
                FreezeCellFormula freezeCellFormula = new FreezeCellFormula(sumCell);
                freezeCellFormula.freeze();
                String sumFormula = this.getFormulaWithoutAsstItem(sumCell, subSumStart, subSumEnd, sheet);
                for (int i = 0; i < scheme.getDynFormulaDefine().size(); ++i) {
                    scheme.getDynFormulaDefine().get(i).setSumFormula(sumFormula);
                }
                freezeCellFormula.release();
                scheme.setEnvParam(basePoint.getEnvParam());
                schemes.add(scheme);
            }
        }
        return schemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormulaWithoutAsstItem(Cell sumCell, int[] subSumStart, int[] subSumEnd, Sheet sheet) {
        String subSumFormula;
        String sumFormula = sumCell.getFormula();
        if (sumFormula.indexOf(subSumFormula = this.getSubSumFormula(subSumStart, subSumEnd, sheet)) >= 0) {
            int start = sumFormula.indexOf(subSumFormula);
            int end = start + subSumFormula.length() - 1;
            StringBuffer c = new StringBuffer();
            if (start > 0) {
                c.append(sumFormula.substring(0, start));
            }
            c.append(0);
            if (end < sumFormula.length() - 1) {
                c.append(sumFormula.substring(end + 1));
            }
            if ((sumFormula = c.toString().trim()).startsWith("=")) {
                sumFormula = sumFormula.substring(1);
            }
            sumFormula = sumFormula.replaceAll("^[ ]*(0){0,1}[ ]*$", "");
            sumFormula = sumFormula.replaceAll("^[ ]*(0){0,1}[ ]*[+]", "");
            sumFormula = sumFormula.replaceAll("[+-][ ]*(0){0,1}[ ]*[+]", "");
            sumFormula = sumFormula.replaceAll("[+-][ ]*(0){0,1}[ ]*$", "");
            if (StringUtils.isEmpty((String)(sumFormula = sumFormula.trim()))) {
                return null;
            }
            if (StringUtil.isBigDecimal(sumFormula)) {
                return "=constant(" + sumFormula + ")";
            }
            FreezeCellFormula freezeCellFormula = new FreezeCellFormula(sumCell);
            freezeCellFormula.freeze();
            try {
                IFormula valueFormulaAfter;
                sumCell.setFormula("=" + sumFormula);
                ConvertCellFormula convertCellFormula = new ConvertCellFormula();
                convertCellFormula.registerHandle(new HandleReferExprForItemFormula());
                convertCellFormula.exec(sumCell, true);
                sumFormula = CellUtil.getValueFormula(sumCell);
                ConvertRefFormula convertRefFormula = new ConvertRefFormula(this.dao, true);
                if (convertRefFormula.isMeet(sumFormula) && (valueFormulaAfter = convertRefFormula.exec(sumFormula)) != null) {
                    sumFormula = "=" + valueFormulaAfter.formulaString(true);
                }
            }
            catch (EASBizException e) {
                log.warn("", e);
            }
            catch (BOSException e) {
                log.warn("", e);
            }
            finally {
                freezeCellFormula.release();
            }
        }
        if ((sumFormula = sumFormula.trim()).startsWith("=")) {
            return sumFormula.substring(1);
        }
        return sumFormula;
    }

    private String getSubSumFormula(int[] start, int[] end, Sheet sheet) {
        return "SUM(" + CellUtil.name(start[0], start[1]) + ":" + CellUtil.name(end[0], end[1]) + ")";
    }

    private FormulaSchemeInfo create(Cell cell, ItemFormula itemFormula, DynaParameters dynaParam, DItemGradeEntryInfo gradeEntry) {
        FormulaSchemeInfo scheme;
        try {
            scheme = new CreateFormulaScheme(this.dao).by(cell, itemFormula);
        }
        catch (EASBizException e) {
            log.error("", e);
            return null;
        }
        catch (BOSException e) {
            log.error("", e);
            return null;
        }
        if (scheme == null) {
            return null;
        }
        DynFormulaDefineInfo dynDefineInfo = new DynFormulaDefineInfo();
        dynDefineInfo.setFormulaScheme(scheme);
        dynDefineInfo.setAssistNum(gradeEntry.getDetailAsstType().getProperityName());
        dynDefineInfo.setAssistName(gradeEntry.getDetailAsstType().getProperityAlias());
        dynDefineInfo.setIsLevelManualSum(true);
        dynDefineInfo.setIsLevelSum(true);
        dynDefineInfo.setLevelName(gradeEntry.getName());
        String gradeNum = gradeEntry.getNumber() + (gradeEntry.isLeaf() ? ".D" : "");
        dynDefineInfo.setLevelOrderNum(gradeNum);
        scheme.setItemDynaGrade(gradeNum);
        scheme.getDynFormulaDefine().add(dynDefineInfo);
        scheme.setDynaAsstType(gradeEntry.getDetailAsstType().getProperityName());
        return scheme;
    }
}

