/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CreateFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckWheatheFilled;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IFindFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.DynaBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IsDynaBaseFillBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.FindNormalScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.NextCell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.util.StringUtils;

public class FindDynaBaseFillScheme
implements IFindFormulaScheme {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FindDynaBaseFillScheme.class);
    private DBHandler dao;

    public FindDynaBaseFillScheme(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public boolean isMeet(IBasePoint basePoint) {
        return ActionFactory.get(IsDynaBaseFillBasePoint.class).is(basePoint);
    }

    @Override
    public FormulaSchemeCollection parse(IBasePoint basePoint) {
        DynaBasePoint dynaBasePoint = (DynaBasePoint)basePoint;
        FormulaSchemeCollection schemes = new FormulaSchemeCollection();
        DynaParameters dynaParam = dynaBasePoint.getDynaParam();
        int[] pos = new int[]{dynaBasePoint.getRow(), dynaBasePoint.getCol()};
        int spreadStyle = dynaParam.getSpreadStyle();
        Sheet sheet = dynaBasePoint.getSheet();
        Cell cell = null;
        Cell valueFormulaCell = null;
        int[] valueFormulaPos = null;
        ItemFormula itemFormula = null;
        ItemFormula valueItemFormula = null;
        NextCell nextCell = ActionFactory.get(NextCell.class);
        while ((cell = sheet.getCell((pos = nextCell.circle(pos, spreadStyle, true))[0], pos[1], false)) != null && (itemFormula = CellUtil.getItemFormula(cell)) != null && itemFormula.getFormula() != null) {
            log.info("find a cell with item formula({0})", new Object[]{itemFormula.getFormula()});
            valueFormulaPos = nextCell.circle(pos, spreadStyle, false);
            if (dynaParam.isIncludeSum() && dynaParam.getPosition() == 1) {
                valueFormulaPos = nextCell.circle(valueFormulaPos, spreadStyle, false);
            }
            if ((valueFormulaCell = sheet.getCell(valueFormulaPos[0], valueFormulaPos[1], false)) == null) {
                log.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                continue;
            }
            int[] fillMaxPos = new int[2];
            if (new CheckWheatheFilled().isFilled(valueFormulaCell, spreadStyle, dynaParam.getDefaultCounter(), fillMaxPos)) {
                FormulaSchemeCollection normalSchemes = new FindNormalScheme(this.dao).parse(sheet, new int[]{valueFormulaCell.getRow(), valueFormulaCell.getCol()}, fillMaxPos, basePoint);
                log.info("find filled schemes ({0}) in dynamice base fill parse", new Object[]{normalSchemes});
                schemes.addCollection(normalSchemes);
                if (dynaParam.getAssistantType().getProperityName() == null) continue;
                for (int i = 0; i < normalSchemes.size(); ++i) {
                    normalSchemes.get(i).setDynaAsstType(dynaParam.getAssistantType().getProperityName());
                }
                continue;
            }
            valueItemFormula = CellUtil.getItemFormula(valueFormulaCell);
            if (valueItemFormula != null) continue;
            if (StringUtils.isEmpty((String)valueFormulaCell.getFormula())) {
                log.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                continue;
            }
            FormulaSchemeInfo scheme = this.create(valueFormulaCell, itemFormula, dynaParam);
            if (scheme == null) continue;
            if (scheme.getValueFormula() != null && scheme.getValueFormula().indexOf("@") == -1) {
                log.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                continue;
            }
            log.info("find a scheme:{0}", new Object[]{scheme});
            scheme.setEnvParam(basePoint.getEnvParam());
            schemes.add(scheme);
        }
        return schemes;
    }

    private FormulaSchemeInfo create(Cell cell, ItemFormula itemFormula, DynaParameters dynaParam) {
        FormulaSchemeInfo scheme;
        try {
            scheme = new CreateFormulaScheme(this.dao).by(cell, itemFormula);
            if (scheme == null) {
                return null;
            }
        }
        catch (EASBizException e) {
            log.error("", e);
            return null;
        }
        catch (BOSException e) {
            log.error("", e);
            return null;
        }
        DynFormulaDefineInfo dynDefineInfo = new DynFormulaDefineInfo();
        dynDefineInfo.setFormulaScheme(scheme);
        dynDefineInfo.setAssistNum(dynaParam.getAssistantType().getProperityName());
        dynDefineInfo.setAssistName(dynaParam.getAssistantType().getProperityAlias());
        dynDefineInfo.setIsLevelManualSum(false);
        dynDefineInfo.setIsLevelSum(dynaParam.isGrade());
        scheme.getDynFormulaDefine().add(dynDefineInfo);
        scheme.setDynaAsstType(dynaParam.getAssistantType().getProperityName());
        return scheme;
    }
}

