/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckWheatheFilled;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.DynaBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IsDynaBaseFillBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.FindNormalInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IFindInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IImportOtherHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.CreateDynaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.NextCell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import java.util.Collection;

public class FindDynaBaseFillInfo
implements IFindInfo {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FindDynaBaseFillInfo.class);
    private DBHandler dao;

    public FindDynaBaseFillInfo(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public boolean isMeet(IBasePoint basePoint) {
        return ActionFactory.get(IsDynaBaseFillBasePoint.class).is(basePoint);
    }

    @Override
    public <T> Collection<T> parse(IBasePoint basePoint, IInfoHandler<T> handler) {
        DynaBasePoint dynaBasePoint = (DynaBasePoint)basePoint;
        DynaParameters dynaParam = dynaBasePoint.getDynaParam();
        int[] pos = new int[]{dynaBasePoint.getRow(), dynaBasePoint.getCol()};
        int spreadStyle = dynaParam.getSpreadStyle();
        Sheet sheet = dynaBasePoint.getSheet();
        Cell cell = null;
        Cell valueFormulaCell = null;
        int[] valueFormulaPos = null;
        ItemFormula itemFormula = null;
        ItemFormula valueItemFormula = null;
        NextCell nextCell = ActionFactory.get(NextCell.class);
        while ((cell = sheet.getCell((pos = nextCell.circle(pos, spreadStyle, true))[0], pos[1], false)) != null && handler.checkItemFormula(itemFormula = CellUtil.getItemFormula(cell))) {
            if (itemFormula != null) {
                itemFormula.putExt("dynaDefine", ActionFactory.get(CreateDynaDefineInfo.class).exec(dynaParam));
            }
            log.info("find a cell with item formula({0})", new Object[]{itemFormula.getFormula()});
            valueFormulaPos = nextCell.circle(pos, spreadStyle, false);
            if (dynaParam.isIncludeSum() && dynaParam.getPosition() == 1) {
                valueFormulaPos = nextCell.circle(valueFormulaPos, spreadStyle, false);
            }
            if ((valueFormulaCell = sheet.getCell(valueFormulaPos[0], valueFormulaPos[1], false)) == null) {
                if (handler.checkValueFormula(null)) {
                    handler.put(itemFormula, null, null, null);
                }
                log.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                continue;
            }
            int[] fillMaxPos = new int[2];
            if (new CheckWheatheFilled().isFilled(valueFormulaCell, spreadStyle, dynaParam.getDefaultCounter(), fillMaxPos)) {
                if (!(handler instanceof IImportOtherHandler) || ((IImportOtherHandler)((Object)handler)).other("normal") == null) continue;
                IInfoHandler normalHandler = ((IImportOtherHandler)((Object)handler)).other("normal");
                Collection normalSchemes = new FindNormalInfo(this.dao).parse(sheet, new int[]{valueFormulaCell.getRow(), valueFormulaCell.getCol()}, fillMaxPos, basePoint, normalHandler);
                handler.infos().addAll(normalHandler.infos());
                log.info("find filled schemes ({0}) in dynamice base fill parse", new Object[]{normalSchemes});
                if (dynaParam.getAssistantType().getProperityName() == null) continue;
                for (Object normalScheme : normalSchemes) {
                    if (!(normalScheme instanceof FormulaSchemeInfo)) continue;
                    ((FormulaSchemeInfo)normalScheme).setDynaAsstType(dynaParam.getAssistantType().getProperityName());
                }
                continue;
            }
            valueItemFormula = CellUtil.getItemFormula(valueFormulaCell);
            if (valueItemFormula != null) continue;
            if (!handler.checkValueFormula(valueFormulaCell.getFormula())) {
                log.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                continue;
            }
            handler.put(itemFormula, valueFormulaCell.getFormula(), valueFormulaCell, null);
        }
        return handler.infos();
    }
}

