/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckWheatheFilled;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.EliminationBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IsEliminationBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.FindNormalInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IFindInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IImportOtherHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.CreateDynaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEliminationAsstNum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEliminationItemKey;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.NextCell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.Collection;

public class FindEliminationInfo
implements IFindInfo {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FindEliminationInfo.class);
    private DBHandler dao;

    public FindEliminationInfo(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public boolean isMeet(IBasePoint basePoint) {
        return ActionFactory.get(IsEliminationBasePoint.class).is(basePoint);
    }

    @Override
    public <T> Collection<T> parse(IBasePoint eliminationBasePoint, IInfoHandler<T> handler) {
        EliminationBasePoint basePoint = (EliminationBasePoint)eliminationBasePoint;
        int[] pos = new int[]{basePoint.getRow(), basePoint.getCol()};
        int spreadStyle = 0;
        Sheet sheet = basePoint.getSheet();
        Cell cell = null;
        Cell valueFormulaCell = null;
        int[] valueFormulaPos = null;
        ItemFormula itemFormula = null;
        ItemFormula valueItemFormula = null;
        NextCell nextCell = ActionFactory.get(NextCell.class);
        while ((cell = sheet.getCell((pos = nextCell.circle(pos, spreadStyle, true))[0], pos[1], false)) != null && handler.checkItemFormula(itemFormula = CellUtil.getItemFormula(cell))) {
            if (itemFormula != null) {
                String itemKey = new GetEliminationItemKey().exec(basePoint.getEnvParam().getReportClass());
                itemFormula.putExt("elimination", itemKey);
                itemFormula.putExt("dynaDefine", ActionFactory.get(CreateDynaDefineInfo.class).assist(new GetEliminationAsstNum().exec(itemKey)));
            }
            log.info("find a cell with item formula({0})", new Object[]{itemFormula.getFormula()});
            valueFormulaPos = nextCell.circle(pos, spreadStyle, false);
            valueFormulaCell = sheet.getCell(valueFormulaPos[0], valueFormulaPos[1], false);
            if (valueFormulaCell == null) {
                log.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                continue;
            }
            int[] fillMaxPos = new int[2];
            if (new CheckWheatheFilled().isFilled(valueFormulaCell, spreadStyle, Integer.MAX_VALUE, fillMaxPos)) {
                if (!(handler instanceof IImportOtherHandler) || ((IImportOtherHandler)((Object)handler)).other("normal") == null) continue;
                IInfoHandler normalHandler = ((IImportOtherHandler)((Object)handler)).other("normal");
                Collection normalSchemes = new FindNormalInfo(this.dao).parse(sheet, new int[]{valueFormulaCell.getRow(), valueFormulaCell.getCol()}, fillMaxPos, basePoint, normalHandler);
                handler.infos().addAll(normalHandler.infos());
                log.info("find filled schemes ({0}) in dynamice base fill parse", new Object[]{normalSchemes});
                continue;
            }
            valueItemFormula = CellUtil.getItemFormula(valueFormulaCell);
            if (valueItemFormula != null) continue;
            if (!handler.checkValueFormula(valueFormulaCell.getFormula())) {
                log.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                continue;
            }
            handler.put(itemFormula, valueFormulaCell.getFormula(), valueFormulaCell, null);
        }
        return handler.infos();
    }
}

