/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.TemplateAndCompany;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.IsCommitReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class QueryReport {
    private DBHandler dao;

    public QueryReport(DBHandler dao) {
        this.dao = dao;
    }

    public boolean exists(TemplateInfo template, OrgUnitInfo company, FormulaCalcContextInfo formulaCalcContext) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("template.number", (Object)template.getNumber());
        filter.appendFilterItem("company", (Object)company.getId().toString());
        filter.appendFilterItem("year", (Object)formulaCalcContext.getYear());
        filter.appendFilterItem("period", (Object)formulaCalcContext.getPeriod());
        filter.appendFilterItem("periodType", (Object)formulaCalcContext.getPeriodType().getValue());
        filter.appendFilterItem("currency", (Object)formulaCalcContext.getCurrentCurrency().getId().toString());
        Set<Integer> commitTypes = new IsCommitReport().exec();
        filter.getFilterItems().add(new FilterItemInfo("sourceType", commitTypes, CompareType.INCLUDE));
        return this.dao.get(IReport.class).exists(filter);
    }

    public Collection<ReportInfo> exec(FormulaCalcContextInfo formulaCalcContext, SelectorItemCollection selector) throws EASBizException, BOSException {
        Set<Integer> commitTypes = new IsCommitReport().exec();
        return this.exec(formulaCalcContext, selector, commitTypes);
    }

    public Collection<ReportInfo> exec(FormulaCalcContextInfo formulaCalcContext, SelectorItemCollection selector, Set<Integer> commitTypes) throws EASBizException, BOSException {
        HashSet<ReportInfo> reports = new HashSet<ReportInfo>(1);
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer();
        int maskIndex = 0;
        filter.appendFilterItem("year", (Object)formulaCalcContext.getYear());
        mask.append("#" + maskIndex++);
        filter.appendFilterItem("period", (Object)formulaCalcContext.getPeriod());
        mask.append(" and #" + maskIndex++);
        filter.appendFilterItem("periodType", (Object)formulaCalcContext.getPeriodType().getValue());
        mask.append(" and #" + maskIndex++);
        filter.appendFilterItem("currency", (Object)formulaCalcContext.getCurrentCurrency().getId().toString());
        mask.append(" and #" + maskIndex++);
        filter.getFilterItems().add(new FilterItemInfo("sourceType", commitTypes, CompareType.INCLUDE));
        mask.append(" and #" + maskIndex++);
        Iterator<TemplateAndCompany> it = formulaCalcContext.iterator();
        TemplateAndCompany templateAndCompany = null;
        StringBuffer tplAndCompMask = new StringBuffer();
        String joinChar = " OR ";
        while (it.hasNext()) {
            templateAndCompany = it.next();
            tplAndCompMask.append(joinChar);
            filter.appendFilterItem("template.number", (Object)templateAndCompany.getTemplate().getNumber());
            tplAndCompMask.append(" ( #" + maskIndex++);
            filter.appendFilterItem("company", (Object)templateAndCompany.getCompany().getId().toString());
            tplAndCompMask.append(" AND #" + maskIndex++);
            tplAndCompMask.append(" ) ");
        }
        if (tplAndCompMask.length() == 0) {
            return reports;
        }
        mask.append(" and ( " + tplAndCompMask.substring(joinChar.length()) + " ) ");
        filter.setMaskString(mask.toString());
        EntityViewInfo view = new EntityViewInfo();
        if (selector == null) {
            selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("name");
            selector.add("number");
            selector.add("template.id");
            selector.add("template.number");
            selector.add("company.id");
            selector.add("company.number");
        }
        view.setSelector(selector);
        view.setFilter(filter);
        ReportCollection reportInfos = this.dao.get(IReport.class).getReportCollection(view);
        for (int i = 0; i < reportInfos.size(); ++i) {
            reports.add(reportInfos.get(i));
        }
        return reports;
    }
}

