/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;

public class QuerySheetParams {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", QuerySheetParams.class);
    private DBHandler dao;

    public QuerySheetParams(DBHandler dao) {
        this.dao = dao;
    }

    public void exec(VirtualSheetParamInfo templateOrReport) throws BOSException {
        RptSheetParamCollection sheetParams = templateOrReport.getSheetParam();
        IRptSheetParam rptSheetParamDao = this.dao.get(IRptSheetParam.class);
        if (!sheetParams.isEmpty()) {
            return;
        }
        RptSheetParamCollection dbSheetParams = rptSheetParamDao.getRptSheetParamCollection("where report = '" + templateOrReport.getId() + "'");
        if (dbSheetParams.isEmpty()) {
            // empty if block
        }
        sheetParams.addCollection(dbSheetParams);
        LOG.info("find report's sheet param(report: {0})", new Object[]{templateOrReport.getId()});
    }

    public RptSheetParamInfo exec(Book book, Sheet sheet, VirtualSheetParamInfo templateOrReport) {
        ReportVariables reportVariables = (ReportVariables)book.getUserObjectValue("VARIABLES");
        int reportClassForInt = reportVariables.getIntValue("SheetClass", sheet.getSheetName(), 1);
        CSLReportGroupEnum reportClass = CSLReportGroupEnum.getEnum(reportClassForInt);
        RptSheetParamInfo param = new RptSheetParamInfo();
        param.setReportClass(reportClass);
        param.setSheetID(sheet.getID());
        param.setSheetName(sheet.getSheetName());
        param.setReport(templateOrReport);
        return param;
    }
}

