/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ExtractFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.GeneralUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.KDTableUtilForRpt;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEntityInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class TemplateExecExtrFormula {
    protected DBHandler dao;

    public TemplateExecExtrFormula(DBHandler dao) {
        this.dao = dao;
    }

    public Collection<TemplateInfo> extr(KDTable templateTable, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        HashSet<TemplateInfo> successTemplateInfos = new HashSet<TemplateInfo>(1);
        TemplateCollection templates = new TemplateCollection();
        boolean success = this.checkExtrTemplate(templates, templateTable);
        if (!success) {
            return successTemplateInfos;
        }
        ExtractFormulaScheme extrAction = new ExtractFormulaScheme(new DBHandler(null));
        int rptItemCount = 0;
        FormulaSchemeCollection schemes = null;
        StringBuffer formulaDetail = new StringBuffer();
        BizFormulaDefine getBizFormulaDefine = ActionFactory.get(BizFormulaDefine.class);
        FormulaSchemeInfo scheme = null;
        ShowEntityInfo showEntityInfo = ActionFactory.get(ShowEntityInfo.class);
        int successTemplateNum = 0;
        int failureTemplateNum = 0;
        int tplSize = templates.size();
        for (int tplIndex = 0; tplIndex < tplSize; ++tplIndex) {
            try {
                schemes = extrAction.action(templates.get(tplIndex), (OrgUnitInfo)company);
                rptItemCount += schemes.size();
                formulaDetail.append(templates.get(tplIndex).getName());
                formulaDetail.append("(");
                formulaDetail.append(templates.get(tplIndex).getNumber());
                formulaDetail.append(")\n");
                formulaDetail.append("------------------------------------\n");
                if (schemes.isEmpty()) {
                    formulaDetail.append(ResourceDebugUtil.res("fail.to.extract.beacuse.defined.item.not.be.found"));
                    formulaDetail.append("\n");
                    ++failureTemplateNum;
                } else {
                    ++successTemplateNum;
                    successTemplateInfos.add(templates.get(tplIndex));
                }
                for (int schemeIndex = 0; schemeIndex < schemes.size(); ++schemeIndex) {
                    scheme = schemes.get(schemeIndex);
                    formulaDetail.append(getBizFormulaDefine.showFormula(scheme.getItemFormula().formulaString(true), scheme.getItemFormula().getName()));
                    formulaDetail.append("\n" + ResourceDebugUtil.res("value.formula"));
                    if (!scheme.getDynFormulaDefine().isEmpty() && !StringUtils.isEmpty((String)scheme.getDynFormulaDefine().get(0).getSumFormula())) {
                        formulaDetail.append(scheme.getValueFormula());
                        formulaDetail.append('+');
                        formulaDetail.append(scheme.getDynFormulaDefine().get(0).getSumFormula());
                    } else {
                        formulaDetail.append(scheme.getValueFormula());
                    }
                    if (!scheme.getDynFormulaDefine().isEmpty()) {
                        for (int dynDefineIndex = 0; dynDefineIndex < scheme.getDynFormulaDefine().size(); ++dynDefineIndex) {
                            formulaDetail.append("\n" + showEntityInfo.exec(scheme.getDynFormulaDefine().get(dynDefineIndex)));
                        }
                    }
                    formulaDetail.append("\n\n");
                }
                formulaDetail.append("====================================\n");
                continue;
            }
            catch (AutoItemException e) {
                ++failureTemplateNum;
                formulaDetail.append(templates.get(tplIndex).getName());
                formulaDetail.append("(");
                formulaDetail.append(templates.get(tplIndex).getNumber());
                formulaDetail.append(")\n");
                formulaDetail.append("------------------------------------\n");
                formulaDetail.append(ResourceDebugUtil.res("fail.to.extract") + ":" + e.getMessage());
                formulaDetail.append("\n");
                formulaDetail.append("====================================\n");
            }
        }
        MsgBox.showConfirm3a((String)MessageFormat.format(ResourceDebugUtil.res("success.to.extract.and.show.result"), successTemplateNum, failureTemplateNum, new Integer(rptItemCount)), (String)formulaDetail.toString());
        return successTemplateInfos;
    }

    protected boolean checkExtrTemplate(TemplateCollection templates, KDTable templateTable) throws BOSException {
        List[] templateDatas = KDTableUtilForRpt.getSelectedFieldsValueBy(templateTable, new String[]{"id", "number", "name"});
        HashSet<String> ids = new HashSet<String>();
        int size = templateDatas.length;
        for (int i = 0; i < size; ++i) {
            ids.add((String)templateDatas[i].get(0));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.getSelector().add("data");
        view.getSelector().add("templateType");
        view.getSelector().add("versionStatus");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.appendFilterItem("auditedStatus", (Object)2);
        filter.appendFilterItem("versionStatus", (Object)1);
        filter.appendFilterItem("isFreezed", (Object)new Integer(0));
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        HashSet<Integer> templateTypes = new HashSet<Integer>(GeneralUtil.toIntCollection(FormulaSchemeInfo.supportTemplateTypeForExtr()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("templateType", templateTypes, CompareType.INCLUDE));
        templates.addCollection(this.dao.get(ITemplate.class).getTemplateCollection(view));
        if (templates.size() == templateDatas.length) {
            return true;
        }
        StringBuffer errorMsg = new StringBuffer();
        int size2 = templates.size();
        for (int i = 0; i < size2; ++i) {
            ids.remove(templates.get(i).getId().toString());
        }
        StringBuffer errorTemplateStatements = new StringBuffer();
        int size3 = templateDatas.length;
        for (int i = 0; i < size3; ++i) {
            if (!ids.contains(templateDatas[i].get(0))) continue;
            errorTemplateStatements.append(MessageFormat.format("{0}({1})", templateDatas[i].get(2), templateDatas[i].get(1)));
            errorTemplateStatements.append("\n");
        }
        errorMsg.append(MessageFormat.format(ResourceDebugUtil.res("templates.cannot.be.extracted.for.some.reason.with.format"), errorTemplateStatements, new ShowEntityInfo().exec(FormulaSchemeInfo.supportTemplateTypeForExtr(), " / ")));
        errorMsg.append("\r\n");
        if (errorMsg.length() != 0) {
            if (templates.isEmpty()) {
                MsgBox.showConfirm3(null, (String)ResourceDebugUtil.res("extracting.template.is.failure.please.check.detail.information"), (String)errorMsg.toString());
                return false;
            }
            return MsgBox.showConfirm3(null, (String)ResourceDebugUtil.res("beacuse.some.templates.cannot.be.extracted.is.exclude.those.for.extracting"), (String)errorMsg.toString()) == 0;
        }
        return false;
    }
}

