/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.HandleDynFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.OnlyItemDefineInfoStrategy;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryAllItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryDataElement;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ClearItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.CreateDynaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IClearItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryItemDefineFromTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.GeneralUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KeepSingleItemData {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", KeepSingleItemData.class);
    private DBHandler dao;
    private Collection<Integer> supportedReport;

    public KeepSingleItemData(DBHandler dao) {
        this.dao = dao;
        this.supportedReport = IItemSourceType.SOURCE_TYPE_REPORT;
    }

    public void exec(String reportId) throws EASBizException, BOSException {
        CslReportInfo report;
        SelectorItemCollection selector = this.defineReportToNeedSelector();
        try {
            report = this.dao.get(ICslReport.class).getCslReportInfo((IObjectPK)new ObjectUuidPK(reportId), selector);
        }
        catch (Exception e) {
            LOG.error("", e);
            return;
        }
        this.exec(report);
    }

    public void exec(CslReportInfo report) throws EASBizException, BOSException {
        List<ItemFormula> formulas;
        if (report == null || report.getSourceType() != null && !this.supportedReport.isEmpty() && !this.supportedReport.contains(report.getSourceType().getValue())) {
            return;
        }
        TemplateInfo template = report.getTemplate();
        ItemContext baseItemContext = new ItemContext((OrgUnitInfo)report.getCompany(), report.getCurrency(), report.getPeriodType(), report.getYear(), report.getPeriod());
        QueryItemDefineFromTemplate<ItemFormula> query = new QueryItemDefineFromTemplate<ItemFormula>(this.dao, new OnlyItemDefineInfoStrategy());
        try {
            formulas = query.action(template);
        }
        catch (AutoItemException e) {
            LOG.error("", (Throwable)((Object)e));
            return;
        }
        QueryAllItem queryAllItem = new QueryAllItem(this.dao);
        QueryDataElement queryDataElement = new QueryDataElement(this.dao);
        Map<String, Integer> allDataElements = queryDataElement.exec();
        HandleDynFormula handler = new HandleDynFormula(this.dao);
        for (ItemFormula formula : formulas) {
            if ((BizFormulaDefine.belongType(formula.getFormulaKey(), new String[]{"DITEM", "LEITEM", "CEITEM", "REITEM"}) || BizFormulaDefine.belongType(formula.getExt("elimination"), new String[]{"LEITEM", "CEITEM", "REITEM"})) && StringUtils.isEmpty((String)formula.getDItemNumber()) && !StringUtils.isEmpty((String)formula.getExt("dynaDefine"))) {
                String dynaDefine = formula.getExt("dynaDefine");
                DynFormulaDefineInfo dynaParam = ActionFactory.get(CreateDynaDefineInfo.class).exec(dynaDefine);
                FormulaSchemeInfo schemeInfo = new FormulaSchemeInfo();
                schemeInfo.setItemFormula(formula.getFormula());
                if (BizFormulaDefine.belongType(formula.getExt("elimination"), new String[]{"LEITEM", "CEITEM", "REITEM"})) {
                    IFormula newFormula = schemeInfo.getItemFormula();
                    newFormula.setName(formula.getExt("elimination"));
                    newFormula.getParams().add(1, "");
                }
                schemeInfo.setDynaAsstType(dynaParam.getAssistNum());
                schemeInfo.getDynFormulaDefine().add(dynaParam);
                Map<IFormula, IFormula> items = handler.exec((OrgUnitInfo)report.getCompany(), schemeInfo);
                if (items == null || items.isEmpty()) continue;
                Set<IFormula> filledItemFormulas = items.keySet();
                for (IFormula filledItemFormula : filledItemFormulas) {
                    AutoItemItemFormula item = new AutoItemItemFormula(filledItemFormula.formulaString(true), allDataElements);
                    queryAllItem.register(baseItemContext, item);
                }
                continue;
            }
            AutoItemItemFormula item = new AutoItemItemFormula(formula.getFormula(), allDataElements);
            queryAllItem.register(baseItemContext, item);
        }
        Map<IItemQueryUnit, ItemResult> results = queryAllItem.queryItemValues(this.defineExcludedTypes(), report.getOrgType());
        IClearItemValue clear = this.getIClearItemValue();
        for (Map.Entry<IItemQueryUnit, ItemResult> entry : results.entrySet()) {
            entry.getKey();
            entry.getValue();
            clear.add(entry.getKey().getType(), entry.getKey().getNumber(), entry.getKey().getDataElement(), entry.getValue().getEntryId());
        }
        clear.exec();
    }

    public void exec(Collection<IItemQueryUnit> queryUnits, OrgType orgType) throws EASBizException, BOSException {
        QueryAllItem queryAllItem = new QueryAllItem(this.dao);
        Map<IItemQueryUnit, ItemResult> results = queryAllItem.queryItemValues(queryUnits, this.defineExcludedTypes(), orgType);
        IClearItemValue clear = this.getIClearItemValue();
        for (Map.Entry<IItemQueryUnit, ItemResult> entry : results.entrySet()) {
            entry.getKey();
            entry.getValue();
            clear.add(entry.getKey().getType(), entry.getKey().getNumber(), entry.getKey().getDataElement(), entry.getValue().getEntryId());
        }
        clear.exec();
    }

    public SelectorItemCollection defineReportToNeedSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("year");
        selector.add("period");
        selector.add("periodType");
        selector.add("sourceType");
        selector.add("orgType");
        selector.add("company.id");
        selector.add("company.number");
        selector.add("company.name");
        selector.add("currency.id");
        selector.add("currency.number");
        selector.add("currency.name");
        selector.add("template.id");
        selector.add("template.number");
        selector.add("template.data");
        selector.add("template.dynaRptType");
        selector.add("template.hasExtrItem");
        selector.add("template.group");
        selector.add("template.versionNumber");
        selector.add("template.versionStatus");
        selector.add("template.templateType");
        return selector;
    }

    protected Collection<Integer> defineExcludedTypes() {
        return GeneralUtil.toCollection(new Integer[]{100});
    }

    protected IClearItemValue getIClearItemValue() {
        return new ClearItemValue(this.dao);
    }
}

