/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.NonMatchOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayMap<T1, T2>
implements Map<T1, T2>,
NonMatchOperation<T1, T2> {
    private List<T1> keys = new ArrayListExt();
    private List<T2> values = new ArrayListExt<T2>();

    public ArrayMap(int size) {
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public T2 get(Object key) {
        int index = this.keys.indexOf(key);
        if (index < 0) {
            return null;
        }
        return this.values.get(index);
    }

    @Override
    public T2 put(T1 key, T2 value) {
        int index = this.keys.indexOf(key);
        if (index < 0) {
            this.keys.add(key);
            this.values.add(value);
            return null;
        }
        T2 oldValue = this.values.get(index);
        this.values.set(index, value);
        return oldValue;
    }

    @Override
    public T2 putForNonMatch(T1 key, T2 value) {
        this.keys.add(key);
        this.values.add(value);
        return null;
    }

    @Override
    public T2 remove(Object key) {
        int index = this.keys.indexOf(key);
        if (index < 0) {
            return null;
        }
        this.keys.remove(index);
        return this.values.remove(index);
    }

    @Override
    public void putAll(Map<? extends T1, ? extends T2> t) {
        if (this.isEmpty()) {
            for (Map.Entry<T1, T2> entry : t.entrySet()) {
                this.keys.add(entry.getKey());
                this.values.add(entry.getValue());
            }
            return;
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public Set<T1> keySet() {
        return new HashSet<T1>(this.keys);
    }

    @Override
    public Collection<T2> values() {
        return new HashSet<T2>(this.values);
    }

    @Override
    public Set<Map.Entry<T1, T2>> entrySet() {
        HashSet<Map.Entry<T1, T2>> entrys = new HashSet<Map.Entry<T1, T2>>(this.keys.size());
        for (int i = 0; i < this.keys.size(); ++i) {
            entrys.add(new ArrayEntry<T1, T2>(this.keys.get(i), this.values.get(i)));
        }
        return entrys;
    }

    private static class ArrayListExt<T1>
    extends ArrayList<T1> {
        private static final long serialVersionUID = -1555250679922303129L;

        private ArrayListExt() {
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i) != o) continue;
                    return i;
                }
            }
            return -1;
        }
    }

    private static class ArrayEntry<T1, T2>
    implements Map.Entry<T1, T2> {
        private T1 key;
        private T2 value;

        public ArrayEntry(T1 key, T2 value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public T1 getKey() {
            return this.key;
        }

        @Override
        public T2 getValue() {
            return this.value;
        }

        @Override
        public T2 setValue(T2 value) {
            T2 oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

