/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util;

import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SingleFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringFormulaParser;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import java.util.Locale;
import java.util.Map;

public class AutoItemItemFormula {
    protected IFormula formulaInfo;
    protected int dataElement;
    protected ValueTypeEnum valueType;

    public AutoItemItemFormula(String formula, Map<String, Integer> dataElementStr2Number) {
        this(new StringFormulaParser().parse(formula), dataElementStr2Number);
    }

    public AutoItemItemFormula(IFormula formula, Map<String, Integer> dataElementStr2Number) {
        if (!(formula instanceof SingleFormula)) {
            return;
        }
        this.formulaInfo = formula;
        this.perfect(dataElementStr2Number);
    }

    public AutoItemItemFormula(String itemKey, String number, String dynaItem, int year, int period, String dataElement, String valueType, Map<String, Integer> dataElementStr2Number) {
        this.formulaInfo = new SingleFormula();
        this.formulaInfo.setName(itemKey);
        this.formulaInfo.addParam("number", number);
        if (!"ITEM".equalsIgnoreCase(this.formulaInfo.getName())) {
            this.formulaInfo.addParam("dynaItem", dynaItem);
        }
        this.formulaInfo.addParam("year", year);
        this.formulaInfo.addParam("period", period);
        this.formulaInfo.addParam("dataElement", dataElement);
        this.formulaInfo.addParam("valueType", valueType);
        this.perfect(dataElementStr2Number);
    }

    protected void perfect(Map<String, Integer> dataElementStr2Number) {
        this.formulaInfo.setParamNames(new BizFormulaDefine().exec(this.formulaInfo.getName()));
        this.initDataElement(dataElementStr2Number);
        String valueTypeStr = (String)this.formulaInfo.getParam("valueType");
        if (valueTypeStr == null) {
            return;
        }
        this.valueType = ValueTypeEnum.getEnum(valueTypeStr.toUpperCase());
    }

    public void initDataElement(Map<String, Integer> dataElementStr2Number) {
        if (dataElementStr2Number != null && dataElementStr2Number.containsKey(this.getDataElementStr())) {
            this.dataElement = dataElementStr2Number.get(this.getDataElementStr());
        }
    }

    public void setDynaItem(String dynaItem) {
        this.formulaInfo.addParam("dynaItem", dynaItem);
    }

    public String getDynaItem() {
        return (String)this.formulaInfo.getParam("dynaItem");
    }

    public String getDynaItemName() {
        if (!(this.formulaInfo.getExtendProperty("AssistName") instanceof String)) {
            return null;
        }
        return (String)this.formulaInfo.getExtendProperty("AssistName");
    }

    public IFormula getFormulaInfo() {
        return this.formulaInfo;
    }

    public String getType() {
        if (this.formulaInfo == null || this.formulaInfo.getName() == null) {
            return null;
        }
        return this.formulaInfo.getName().trim().toUpperCase(Locale.ENGLISH);
    }

    public String getNumber() {
        Object param = this.formulaInfo.getParam("number");
        if (param instanceof String) {
            return (String)param;
        }
        if (param == null) {
            return null;
        }
        return param.toString();
    }

    public int getYear() {
        return (Integer)this.formulaInfo.getParam("year");
    }

    public int getPeriod() {
        return (Integer)this.formulaInfo.getParam("period");
    }

    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public int getDataElement() {
        return this.dataElement;
    }

    public void setDataElement(int dataElement) {
        this.dataElement = dataElement;
    }

    public String getDataElementStr() {
        return (String)this.formulaInfo.getParam("dataElement");
    }

    public void setYear(int year) {
        this.formulaInfo.addParam("year", year);
    }

    public void setPeriod(int period) {
        this.formulaInfo.addParam("period", period);
    }

    public void changeType(String itemType) {
        this.formulaInfo.setName(itemType);
        this.formulaInfo.setParamNames(new BizFormulaDefine().exec(this.formulaInfo.getName()));
    }

    public String toString() {
        return StringUtil.toStringByReflect(this);
    }
}

