/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CalculateStringExpression;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class StringExpressionCalculator {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", StringExpressionCalculator.class);
    private CalculateStringExpression calc = new CalculateStringExpression();

    public Object calc(String expression) {
        try {
            Object result;
            try {
                result = this.calc.exec(expression);
            }
            catch (CalculateStringExpression.UnKnownChar e) {
                result = this.calcByJavascript(expression);
            }
            return this.value(result);
        }
        catch (Exception e) {
            LOG.debug("occur error in string expression({0})'s calculate", new Object[]{expression}, e);
            return new Double("0");
        }
    }

    private Object calcByJavascript(String expression) {
        try {
            Object result = null;
            Context cx = Context.enter();
            result = cx.evaluateString((Scriptable)cx.initStandardObjects(), expression, "", 1, null);
            if (new Double("0.0").equals(result) && expression.contains("&")) {
                expression = expression.replaceAll("\\&", "+");
                result = cx.evaluateString((Scriptable)cx.initStandardObjects(), expression, "", 1, null);
            }
            return this.value(result);
        }
        catch (Exception e) {
            LOG.debug("occur error in string expression({0})'s calculate", new Object[]{expression}, e);
            return new Double("0");
        }
    }

    protected Object value(Object result) {
        if (result instanceof Double) {
            return result;
        }
        if (result instanceof Boolean) {
            return result;
        }
        if (result instanceof String) {
            return result;
        }
        return new Double(result.toString());
    }
}

