/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFormat {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", StringFormat.class);
    private String realFormat = "";
    private char prefix = (char)126;
    private String[] keys = new String[0];
    private Integer[] keepLength = new Integer[0];

    public StringFormat(String format) {
        this(format, '~');
    }

    public StringFormat(String format, char prefix) {
        this.prefix = prefix;
        this.format(format);
    }

    private void format(String format) {
        if (format.length() <= 0) {
            return;
        }
        this.realFormat = new String(format);
        Matcher matcher = Pattern.compile("\\{(([a-zA-Z0-9\\_]+)(\\:([0-9]+)){0,1})\\}").matcher(format);
        String key = null;
        String all = null;
        String fixLen = null;
        ArrayList<String> findedKeys = new ArrayList<String>(5);
        ArrayList<Integer> needKeepLengths = new ArrayList<Integer>(5);
        while (matcher.find()) {
            all = format.substring(matcher.start(1), matcher.end(1));
            key = format.substring(matcher.start(2), matcher.end(2));
            if (findedKeys.contains(key)) continue;
            if (matcher.start(4) != -1) {
                fixLen = format.substring(matcher.start(4), matcher.end(4));
                needKeepLengths.add(Integer.parseInt(fixLen));
            } else {
                needKeepLengths.add(-1);
            }
            findedKeys.add(key);
            this.realFormat = this.realFormat.replaceAll("\\{" + all + "\\}", "{" + (findedKeys.size() - 1) + "}");
        }
        this.keys = new String[findedKeys.size()];
        findedKeys.toArray(this.keys);
        this.keepLength = new Integer[needKeepLengths.size()];
        needKeepLengths.toArray(this.keepLength);
    }

    public String exec(Map<String, Object> param) {
        Object[] values = new Object[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            if (!param.containsKey(this.keys[i])) {
                return "";
            }
            values[i] = param.get(this.keys[i]);
            if (values[i] instanceof Number) {
                values[i] = values[i] + "";
            }
            if (this.keepLength[i] == -1 || values[i].toString().length() >= this.keepLength[i]) continue;
            values[i] = StringUtil.prefix(values[i].toString(), this.prefix, this.keepLength[i]);
        }
        return MessageFormat.format(this.realFormat, values);
    }

    public Map<String, Object> parse(String source) {
        Object[] values;
        HashMap<String, Object> params = new HashMap<String, Object>(this.keys.length);
        try {
            values = new MessageFormat(this.realFormat).parse(source);
        }
        catch (ParseException e) {
            LOG.error("", e);
            return params;
        }
        if (values.length != this.keys.length) {
            return params;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            params.put(this.keys[i], values[i]);
            if (this.keepLength[i] == -1 || values[i].toString().length() == 0) continue;
            String value = values[i].toString();
            int start = 0;
            while (value.charAt(start) == this.prefix) {
                ++start;
            }
            values[i] = value.substring(start);
        }
        return params;
    }

    public int getKeepLength(String key) {
        if (key == null) {
            return -1;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return this.keepLength[i];
        }
        return -1;
    }
}

