/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.IStorageForFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.ConvertExpr2Formula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.ParseExpression;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.ErrorExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.IExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;

public class StringFormulaParser {
    private static final ILog log = LogFactory.getLog("AUTOITEM", StringFormulaParser.class);
    private IStorageForFormulaDefine formulaDefine;
    private ParseExpression parseExpr = ActionFactory.get(ParseExpression.class);
    private ConvertExpr2Formula convertExpr2Formula = ActionFactory.get(ConvertExpr2Formula.class);

    public IFormula parse(String formulaStr) {
        IExpr expr;
        if (formulaStr == null) {
            return null;
        }
        if (formulaStr.trim().startsWith("=")) {
            formulaStr = formulaStr.trim().substring(1);
        }
        if ((expr = this.parseExpr.exec(formulaStr)) == null || expr instanceof ErrorExpr) {
            log.error("{0}", new Object[]{expr});
            return null;
        }
        IFormula formula = this.convertExpr2Formula.exec(expr);
        return this.value(formula);
    }

    protected IFormula value(IFormula formula) {
        Object templateType;
        if (formula == null || this.formulaDefine == null) {
            return formula;
        }
        String[] formulaParamNames = this.formulaDefine.exec(formula.getName());
        if (formula.getName() != null && "CSREF".equalsIgnoreCase(formula.getName()) && formula.getParams() != null && formula.getParams().size() > 4 && (templateType = formula.getParams().get(3)) != null) {
            try {
                RptTmpTypeEnum typeEnum = RptTmpTypeEnum.getEnum((String)templateType.toString().trim());
                if (typeEnum != null) {
                    formula.getParams().add(2, templateType);
                    formula.getParams().remove(4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (formulaParamNames != null) {
            formula.setParamNames(formulaParamNames);
        }
        return formula;
    }

    public void setFormulaDefine(IStorageForFormulaDefine formulaDefine) {
        this.formulaDefine = formulaDefine;
    }

    public void setParseExpr(ParseExpression parseExpr) {
        this.parseExpr = parseExpr;
    }
}

