/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", StringUtil.class);
    private static final String SINGLE_REGEX_FOR_ANY_REGEX_KEY = "[\\.\\*\\[\\]\\(\\)\\+\\?\\-\\^\\$\\,\\{\\}\\\\/\\&\\|]";

    public static String convertRegexChar(String matchKey) {
        return matchKey.replaceAll("([\\.\\*\\[\\]\\(\\)\\+\\?\\-\\^\\$\\,\\{\\}\\\\/\\&\\|])", "\\\\$0");
    }

    public static String changeMessageFormat(String format, int index) {
        Matcher matcher = Pattern.compile("(\\{([0-9]+)\\})").matcher(format);
        String oldStr = null;
        int newIndex = -1;
        String newFormat = format;
        while (matcher.find()) {
            oldStr = format.substring(matcher.start(1), matcher.end(1));
            oldStr = oldStr.replaceAll("\\{", "\\\\{");
            oldStr = oldStr.replaceAll("\\}", "\\\\}");
            newIndex = Integer.parseInt(format.substring(matcher.start(2), matcher.end(2))) + index;
            newFormat = newFormat.replaceAll(oldStr, "{[" + newIndex + "]}");
        }
        return newFormat.replaceAll("\\{\\[", "{").replaceAll("\\]\\}", "}");
    }

    public static String changeMessageFormatFromName(String format, List<String> names) {
        Matcher matcher = Pattern.compile("(\\{([a-zA-Z0-9_]+)\\})").matcher(format);
        String oldStr = null;
        int newIndex = 0;
        String indexName = null;
        String newFormat = new String(format);
        while (matcher.find()) {
            oldStr = format.substring(matcher.start(1), matcher.end(1));
            oldStr = oldStr.replaceAll("\\{", "\\\\{");
            oldStr = oldStr.replaceAll("\\}", "\\\\}");
            indexName = format.substring(matcher.start(2), matcher.end(2));
            if (names.contains(indexName)) continue;
            names.add(indexName);
            newFormat = newFormat.replaceAll(oldStr, "{" + newIndex + "}");
            ++newIndex;
        }
        return newFormat;
    }

    public static Map<String, String> parse(String format, String source) {
        HashMap<String, String> values = new HashMap<String, String>(5);
        ArrayList<String> names = new ArrayList<String>(5);
        String newFormat = StringUtil.changeMessageFormatFromName(format, names);
        Object[] valuesForArray = null;
        try {
            valuesForArray = new MessageFormat(newFormat).parse(source);
        }
        catch (ParseException e) {
            LOG.error("format:" + format + "\nsource:" + source, e);
            return values;
        }
        if (valuesForArray.length != names.size()) {
            LOG.error("", new Exception("message format's parse error!"));
            return values;
        }
        for (int i = 0; i < valuesForArray.length; ++i) {
            values.put((String)names.get(i), (String)valuesForArray[i]);
        }
        return values;
    }

    public static String format(String format, Map<String, String> values) {
        ArrayList<String> names = new ArrayList<String>(5);
        String newFormat = StringUtil.changeMessageFormatFromName(format, names);
        if (names.size() != values.size()) {
            return "";
        }
        Object[] valuesForArray = new Object[names.size()];
        int index = 0;
        for (String name : names) {
            valuesForArray[index] = values.get(name);
            ++index;
        }
        return new MessageFormat(newFormat).format(valuesForArray);
    }

    public static int findMaxMaskIndex(String mask) throws NumberFormatException {
        Matcher matcher = Pattern.compile("#([0-9]+)").matcher(mask);
        String index = null;
        int maxIndex = -1;
        int indexInt = 0;
        while (matcher.find()) {
            index = mask.substring(matcher.start(1), matcher.end(1));
            indexInt = Integer.parseInt(index);
            if (indexInt <= maxIndex) continue;
            maxIndex = indexInt;
        }
        return maxIndex;
    }

    public static boolean isBigDecimal(String num) {
        return num.matches("[0-9]+(\\.[0-9]+){0,1}");
    }

    public static String serialize(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + ":" + obj.toString();
    }

    public static Object unSerialize(String obj) {
        if (obj == null) {
            return null;
        }
        int firstChar = obj.indexOf(":");
        if (firstChar == -1) {
            return null;
        }
        String type = obj.substring(0, firstChar);
        String value = "";
        if (firstChar < obj.length() - 1) {
            value = obj.substring(firstChar + 1);
        }
        try {
            Class<?> clazz = Class.forName(type);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(value);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String toString(Object param) {
        StringBuffer sb = new StringBuffer();
        if (param instanceof String) {
            sb.append('\"');
            sb.append(param);
            sb.append('\"');
        } else if (param instanceof Number) {
            sb.append(param);
        } else {
            sb.append(param);
        }
        return sb.toString();
    }

    public static String toStringByReflect(Object obj, String[] excludeFieldNames) {
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            StringBuffer sb = new StringBuffer();
            if ("".equals(obj.getClass().getSimpleName())) {
                sb.append(obj.getClass().getName());
            } else {
                sb.append(obj.getClass().getSimpleName());
            }
            sb.append('{');
            int startLen = sb.length();
            List<String> excludeFieldNamesList = Arrays.asList(excludeFieldNames);
            for (Field field : fields) {
                if (Modifier.toString(field.getModifiers()).matches(".*((static)|(final)).*") || excludeFieldNamesList.contains(field.getName())) continue;
                field.setAccessible(true);
                sb.append(',');
                try {
                    sb.append(field.get(obj));
                }
                catch (Exception e) {
                    LOG.error("", e);
                    sb.append("<e>");
                }
            }
            if (sb.length() > startLen) {
                sb.deleteCharAt(startLen);
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            LOG.error("", e);
            return obj.toString();
        }
    }

    public static String toStringByReflect(Object obj) {
        return StringUtil.toStringByReflect(obj, new String[0]);
    }

    public static String toSql(Collection<? extends Object> fields, boolean withStringChar) {
        return StringUtil.toSql(fields, withStringChar, ",", null);
    }

    public static String toSql(Collection<? extends Object> fields, boolean withStringChar, String joinChar, String format) {
        if (fields.isEmpty()) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        MessageFormat formatInfo = null;
        if (format != null) {
            formatInfo = new MessageFormat(format);
        }
        char stringChar = ' ';
        if (withStringChar) {
            stringChar = '\'';
        }
        for (Object object : fields) {
            sql.append(joinChar);
            sql.append(stringChar);
            if (formatInfo == null) {
                sql.append(object);
            } else {
                sql.append(formatInfo.format(new Object[]{object}));
            }
            sql.append(stringChar);
        }
        return sql.substring(joinChar.length());
    }

    public static String prefix(String num, char c, int len) {
        StringBuffer charPrefix = new StringBuffer();
        int size = len - num.length();
        for (int i = 0; i < size; ++i) {
            charPrefix.append(c);
        }
        return charPrefix.toString() + num;
    }

    public static String suffix(String num, char c, int len) {
        StringBuffer charPrefix = new StringBuffer();
        int size = len - num.length();
        for (int i = 0; i < size; ++i) {
            charPrefix.append(c);
        }
        return num + charPrefix.toString();
    }

    public static String getSQLVariable(int size) {
        return StringUtil.getSQLVariable(size, ",?", ",");
    }

    public static String getSQLVariable(int size, String partSql, String join) {
        StringBuffer charPrefix = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            charPrefix.append(partSql);
        }
        if (charPrefix.length() == 0) {
            return "";
        }
        return charPrefix.substring(join.length());
    }

    public static String removeMaskString(String maskString, int removeIndex) {
        maskString = maskString.replaceAll("\\#" + removeIndex, " 1=1 ");
        int currRemoveIndex = removeIndex + 1;
        while (maskString.indexOf("" + currRemoveIndex) != -1) {
            maskString = maskString.replaceAll("\\#" + currRemoveIndex, "#" + (currRemoveIndex - 1));
        }
        return maskString;
    }

    public static Object unserialObject(String compValue) {
        if (compValue == null) {
            return null;
        }
        int sepCharIndex = compValue.indexOf(":");
        if (sepCharIndex == -1) {
            return null;
        }
        String className = compValue.substring(0, sepCharIndex);
        String value = compValue.substring(sepCharIndex + 1);
        try {
            Executable method;
            Class<Object> type = Class.forName(className);
            if (type.isAssignableFrom(IntEnum.class)) {
                method = type.getMethod("getEnum", Integer.TYPE);
                ((Method)method).invoke(type, Integer.parseInt(value));
            } else if (type.isAssignableFrom(Date.class)) {
                return new Date(Long.parseLong(value));
            }
            method = type.getConstructor(String.class);
            ((Constructor)method).setAccessible(true);
            return ((Constructor)method).newInstance(value);
        }
        catch (Exception e) {
            LOG.error("", e);
            return null;
        }
    }

    public static String serialObject(Object compValue) {
        Class<?> type = compValue.getClass();
        String value = null;
        value = compValue instanceof IntEnum ? "" + ((IntEnum)compValue).getValue() : (compValue instanceof Date ? "" + ((Date)compValue).getTime() : compValue.toString());
        return type.getName() + ":" + value;
    }

    public static String removeFormula(String sumFormula, String subSumFormula) {
        boolean startEqualChar = sumFormula.startsWith("=");
        if (startEqualChar) {
            sumFormula = sumFormula.substring(1);
        }
        while (sumFormula.indexOf(subSumFormula) != -1) {
            int start = sumFormula.indexOf(subSumFormula);
            int end = start + subSumFormula.length() - 1;
            StringBuffer c = new StringBuffer();
            if (start > 0) {
                c.append(sumFormula.substring(0, start));
            }
            c.append(0);
            if (end < sumFormula.length() - 1) {
                c.append(sumFormula.substring(end + 1));
            }
            sumFormula = c.toString().trim();
            sumFormula = sumFormula.replaceAll("^[ ]*(0){0,1}[ ]*$", "");
            sumFormula = sumFormula.replaceAll("^[ ]*(0){0,1}[ ]*[\\\\*\\\\/\\\\+\\\\-]", "");
            sumFormula = sumFormula.replaceAll("[\\\\*\\\\/\\\\+\\\\-][ ]*(0){0,1}[ ]*([\\\\*\\\\/\\\\+\\\\-])", "$2");
            sumFormula = sumFormula.replaceAll("[\\\\*\\\\/\\\\+\\\\-][ ]*(0){0,1}[ ]*$", "");
            sumFormula = sumFormula.trim();
        }
        return sumFormula;
    }

    public static String getSQLExpression(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        if (value instanceof Number) {
            return value + "";
        }
        return null;
    }

    public static String replaceAll(String str, String oldChars, String newChars) {
        return StringUtils.replace((String)str, (String)oldChars, (String)newChars);
    }

    public static String replaceFirst(String str, String oldChars, String newChars) {
        int pos;
        int len = newChars.length();
        int lastPos = pos = str.indexOf(oldChars);
        if (pos > -1) {
            String firstPart = str.substring(0, pos);
            String lastPart = str.substring(pos + oldChars.length(), str.length());
            str = firstPart + newChars + lastPart;
        }
        return str;
    }

    public static int getStringByteLength(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return 0;
        }
        try {
            return str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("getStringByteLength_error ", e);
            return str.length();
        }
    }
}

