/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util.client.databinder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.weaverpt.FormatJobProcessSettingAction;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.client.RptAutoWeaveRptSchmEditUI;
import com.kingdee.eas.fi.rpt.RptCalcSchemeFactory;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobProcessDefDataBindImp
extends Component {
    private static final long serialVersionUID = -3400004677802722012L;
    private static final Logger log = Logger.getLogger(JobProcessDefDataBindImp.class);
    public static final int OPERATION_RPT_SCHM = 0;
    public static final int OPERATION_SUM_SCHM = 1;
    KDTextArea taDispatchPeriod;
    private String jobProcessDef;
    private EASWfServiceClient workflowClient;
    private IUIObject ui;
    protected int operationIndex = 0;
    protected String jobProcessDefTitle = "RptAutoWeave";

    public JobProcessDefDataBindImp(KDTextArea taDispatchPeriod, IUIObject ui, String jobProcessDefTitle) {
        this.taDispatchPeriod = taDispatchPeriod;
        this.ui = ui;
        this.jobProcessDefTitle = jobProcessDefTitle;
    }

    public JobProcessDefDataBindImp(KDTextArea taDispatchPeriod, IUIObject ui, String jobProcessDefTitle, int operationIndex) {
        this(taDispatchPeriod, ui, jobProcessDefTitle);
        this.operationIndex = operationIndex;
    }

    public String getJobProcessDef() {
        try {
            ScheduleDef schedule = (ScheduleDef)this.taDispatchPeriod.getUserObject();
            RptAutoWeaveRptSchmEditUI edit = (RptAutoWeaveRptSchmEditUI)this.ui;
            if (schedule != null && (this.taDispatchPeriod.isDirty() || edit.isErrorVerifyInput)) {
                HashMap<String, String> jobContext = new HashMap<String, String>();
                ObjectUuidPK pk = this.createJobProcessDefPK();
                jobContext.put("pk", pk.toString());
                jobContext.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                FunctionObjectInfo function = this.buildFunctionObjectInfo();
                OperationInfo operation = this.buildOperationInfo(function);
                RptAutoWeaveSchmRptInfo info = (RptAutoWeaveSchmRptInfo)this.ui.getDataObject();
                String jobProcessDef = info.getJobProcessDef();
                String number = ((RptAutoWeaveSchmBaseInfo)this.ui.getDataObject()).getNumber();
                StringBuffer errorMsg = edit.verifyInput(info);
                if (errorMsg.length() > 0) {
                    return jobProcessDef;
                }
                if ("EDIT".equals(this.ui.getOprtState()) && jobProcessDef != null) {
                    this.getWorkflowClient().updateProcessSchedule(jobProcessDef, KpdlParser.scheduleToString((ScheduleDef)schedule));
                    return jobProcessDef;
                }
                if (number != null) {
                    this.jobProcessDefTitle = this.jobProcessDefTitle + ":" + number;
                }
                String jobProcessDefID = this.getWorkflowClient().createJobProcessDef(this.jobProcessDefTitle, function, operation, jobContext, KpdlParser.scheduleToString((ScheduleDef)schedule), SysContext.getSysContext().getLocale());
                this.setJobProcessDef(jobProcessDefID);
                return jobProcessDefID;
            }
        }
        catch (WfException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return this.jobProcessDef;
    }

    private OperationInfo buildOperationInfo(FunctionObjectInfo function) {
        OperationInfo operation = function.getOperation().get(this.operationIndex);
        return operation;
    }

    protected ObjectUuidPK createJobProcessDefPK() {
        BOSUuid uuid = null;
        IObjectValue editData = this.ui.getDataObject();
        if (editData == null) {
            return null;
        }
        if (editData.getBOSUuid(editData.getPKField()) == null) {
            uuid = BOSUuid.create((BOSObjectType)editData.getBOSType());
            if (editData != null) {
                editData.put(editData.getPKField(), (Object)uuid);
            }
        } else {
            uuid = editData.getBOSUuid(editData.getPKField());
        }
        return new ObjectUuidPK(uuid);
    }

    protected FunctionObjectInfo buildFunctionObjectInfo() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveSoluFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }

    public void setJobProcessDef(String jobProcessDefId) throws EASBizException, BOSException {
        if (jobProcessDefId != null) {
            this.jobProcessDef = jobProcessDefId;
            Map map = RptCalcSchemeFactory.getRemoteInstance().getProcessDef(jobProcessDefId);
            ScheduleDef schdef = null;
            if (map != null && !map.isEmpty()) {
                schdef = new ScheduleDef(null);
                String define = (String)map.get("rpt_cacl_scheme_define");
                String[] defines = define.split(":");
                schdef.setType(ScheduleType.getEnum((String)defines[0]));
                schdef.setDefine(defines[1]);
                schdef.setBeginTime((Date)map.get("rpt_cacl_scheme_begintime"));
                schdef.setUseCalendar(RptUtil.isTrue(map.get("rpt_cacl_scheme_is_use_calendar ")));
                schdef.setOrgUnitId((String)map.get("rpt_cacl_scheme_org"));
                schdef.setInstructionType(1);
                this.taDispatchPeriod.setText(new FormatJobProcessSettingAction().action(schdef));
                this.taDispatchPeriod.setUserObject((Object)schdef);
                this.taDispatchPeriod.setDirty(false);
            }
        } else {
            this.taDispatchPeriod.setText(null);
            this.taDispatchPeriod.setUserObject(null);
            this.taDispatchPeriod.setDirty(false);
        }
    }

    private EASWfServiceClient getWorkflowClient() throws Exception {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
        }
        return this.workflowClient;
    }
}

