/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util.db;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.StringSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.LinkedList;
import java.util.List;

public class UpdateTableField {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", UpdateTableField.class);
    private DBHandler dao;
    private List<String> tableNames;
    private List<Object[]> wheres;
    private List<Object[]> updateFields;

    public UpdateTableField(DBHandler dao) {
        this.dao = dao;
        this.tableNames = new LinkedList<String>();
        this.wheres = new LinkedList<Object[]>();
        this.updateFields = new LinkedList<Object[]>();
    }

    public void exec() throws BOSException {
        if (this.tableNames.isEmpty()) {
            return;
        }
        StringSQL sql = new StringSQL();
        String tableName = null;
        Object[] where = null;
        Object[] updateField = null;
        for (int i = 0; i < this.tableNames.size(); ++i) {
            tableName = this.tableNames.get(i);
            where = this.wheres.get(i);
            updateField = this.updateFields.get(i);
            sql.clear();
            sql.append(" update ");
            sql.append(tableName);
            sql.append(" set ");
            for (int j = 0; j < updateField.length; ++j) {
                if (j % 2 == 0) {
                    sql.append(updateField[j]);
                    sql.append(" = ");
                    continue;
                }
                sql.append(StringUtil.getSQLExpression(updateField[j]));
                sql.append(",");
            }
            sql.deleteAt(sql.length() - 1);
            sql.append(" where ");
            String join = " and ";
            for (int j = 0; j < where.length; ++j) {
                if (j % 2 == 0) {
                    sql.append(where[j]);
                    sql.append(" = ");
                    continue;
                }
                sql.append(StringUtil.getSQLExpression(where[j]));
                sql.append(" and ");
            }
            sql.delete(sql.length() - " and ".length(), sql.length());
            this.dao.getExecuteSQL().execute(sql.sql());
        }
    }

    public void add(String tableName, Object[] where, Object[] updateField) {
        this.tableNames.add(tableName);
        this.wheres.add(where);
        this.updateFields.add(updateField);
    }

    public void clear() {
        this.tableNames.clear();
        this.wheres.clear();
        this.updateFields.clear();
    }
}

