/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AcctItem {
    String _orgBoundNumber;
    String _orgUnitNumber;
    String _currencyNumber;
    String _covertCurrencyNumber;
    String _startItemNumber;
    String _endItemNumber;
    String _rptPeriodType;
    int _yearOffset;
    int _startPeriodOffset;
    int _endPeriodOffset;
    String _dataSource;
    String _dataElement;
    String _valueType;
    boolean _isAdjust;

    private AcctItem(String[] strs) {
        this._orgBoundNumber = this.removeDoubleQuotationMark(strs[0]);
        this._orgUnitNumber = this.removeDoubleQuotationMark(strs[1]);
        this._currencyNumber = this.removeDoubleQuotationMark(strs[2]);
        this._covertCurrencyNumber = this.removeDoubleQuotationMark(strs[3]);
        this._startItemNumber = this.removeDoubleQuotationMark(strs[4]);
        this._endItemNumber = this.removeDoubleQuotationMark(strs[5]);
        this._rptPeriodType = this.removeDoubleQuotationMark(strs[6]);
        this._yearOffset = Integer.parseInt(strs[7]);
        this._startPeriodOffset = Integer.parseInt(strs[8]);
        this._endPeriodOffset = Integer.parseInt(strs[9]);
        this._dataSource = this.removeDoubleQuotationMark(strs[10]);
        this._dataElement = this.removeDoubleQuotationMark(strs[11]);
        this._valueType = this.removeDoubleQuotationMark(strs[12]);
        this._isAdjust = Boolean.valueOf(strs[13]);
    }

    private String removeDoubleQuotationMark(String str) {
        return str.substring(1, str.length() - 1);
    }

    public static void checkIntegrality(String str) throws Exception {
        AcctItem.splitAcctItem(str);
    }

    private static void splitAcctItem(String str) {
        String pattern = "[Aa]cct[Ii]tem\\([^\\s&^\\)]{1,}\\)";
        Pattern patt = Pattern.compile(pattern);
        Matcher matcher = patt.matcher(str);
        String acctItemString = null;
        while (matcher.find()) {
            acctItemString = matcher.group();
            AcctItem.parseAcctItem(acctItemString);
        }
    }

    private static void parseAcctItem(String acctItem) {
        acctItem = acctItem.substring(acctItem.indexOf("\""));
        acctItem = acctItem.substring(0, acctItem.lastIndexOf(")"));
        String[] strs = acctItem.split("\\,");
        new AcctItem(strs);
    }
}

