/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustMode;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAdjustViewFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdjustViewFilterUI
extends AbstractAdjustViewFilterUI {
    private static final Logger logger = Logger.getLogger(AdjustViewFilterUI.class);
    private String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg";
    private String resName = "SelectAll";
    private String selectAll = null;
    private ICurrency iCurrency = null;
    private IAdjustMode iAdjustMode = null;
    private boolean isMerge = false;
    private Map uiContext = null;
    ArrayList permTreeIdList = new ArrayList();
    private boolean isMergeByFiscalPeriod;
    private boolean isSupport13Period;
    private Map fiterParam = null;

    public void setFiterParam(Map fiterParam) {
        this.fiterParam = fiterParam;
    }

    public AdjustViewFilterUI() throws Exception {
        this.init();
    }

    public AdjustViewFilterUI(Boolean isMerge) throws Exception {
        this.isMerge = isMerge;
        this.init();
    }

    public AdjustViewFilterUI(Boolean isMerge, Map uiContext) throws Exception {
        this.uiContext = uiContext;
        this.init();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        this.selectAll = EASResource.getString((String)this.resClassName, (String)this.resName);
        boolean[] values = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
        this.isMergeByFiscalPeriod = values[0];
        this.isSupport13Period = values[1];
        this.cbxAdjustMode.addItem((Object)this.selectAll);
        this.cbxAdjustMode.setSelectedIndex(0, false);
        this.cbxCurrency.addItem((Object)this.selectAll);
        this.cbxCurrency.setSelectedIndex(0, false);
        this.cbxSourceCurrency.addItem((Object)this.selectAll);
        this.cbxSourceCurrency.setSelectedIndex(0, false);
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        HashSet<String> set = new HashSet<String>();
        OrgTreeCollection treeCol = null;
        if (this.uiContext.get("isAdjustCompanyViewList") != null) {
            treeCol = CslRptUtil.getAllUnionTreesOrderByNumber(null, userInfo.getId().toString(), null);
            if (treeCol == null) {
                return;
            }
            OrgTreeInfo info = null;
            ArrayList<String> orgTreeIDList = new ArrayList<String>();
            for (int i = 0; i < treeCol.size(); ++i) {
                info = treeCol.get(i);
                if (info.isIsHide() || UnionVersionStatusEnum.UNSTART.equals((Object)info.getStatus())) continue;
                orgTreeIDList.add(info.getId().toString());
            }
            Object currentOrgUnitInfo = null;
            currentOrgUnitInfo = this.uiContext.get("isFromAdjustWorkSelectOrg") != null && ((FullOrgUnitInfo)this.uiContext.get("isFromAdjustWorkSelectOrg")).getId() != null ? (FullOrgUnitInfo)this.uiContext.get("isFromAdjustWorkSelectOrg") : SysContext.getSysContext().getCurrentOrgUnit();
            if (!orgTreeIDList.isEmpty()) {
                treeCol = this.getOrgTreeCollectionByCompanyPK(CslRptUtil.getPK((IObjectValue)currentOrgUnitInfo), orgTreeIDList);
            }
        } else {
            treeCol = CslRptUtil.getAllUnionTreesOrderByNumber(null, userInfo.getId().toString(), null);
        }
        if (!this.isMerge) {
            treeCol = CslRptUtil.getOrgTreeCollectionFilterProfitOrg(null, treeCol);
        }
        if (treeCol != null && treeCol.size() > 0) {
            for (int i = 0; i < treeCol.size(); ++i) {
                if (!this.permTreeIdList.contains(treeCol.get(i).getId().toString())) {
                    this.permTreeIdList.add(treeCol.get(i).getId().toString());
                }
                if (set.contains(treeCol.get(i).getNumber())) continue;
                set.add(treeCol.get(i).getNumber());
                this.cbxOrgBound.addItem((Object)treeCol.get(i));
            }
        }
        if (this.fiterParam != null) {
            this.setSelectedItemToCmb(this.cbxOrgBound, this.fiterParam.get("orgBound"), true);
        } else if (this.cbxOrgBound.getItemCount() != 0) {
            this.cbxOrgBound.setSelectedIndex(0, false);
        }
        CurrencyCollection currencyCollection = null;
        AdjustModeCollection adjustModeCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        try {
            if (this.iCurrency == null) {
                this.iCurrency = CurrencyFactory.getRemoteInstance();
            }
            if (this.iAdjustMode == null) {
                this.iAdjustMode = AdjustModeFactory.getRemoteInstance();
            }
            currencyCollection = this.iCurrency.getCurrencyCollection(true);
            CslGradeManageUtil.filterAdjustModeGradeManage(null, (EntityViewInfo)viewInfo, null);
            adjustModeCollection = this.iAdjustMode.getAdjustModeCollection(viewInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.cbxCurrency.addItems(currencyCollection != null ? currencyCollection.toArray() : null);
        this.cbxSourceCurrency.addItems(currencyCollection != null ? currencyCollection.toArray() : null);
        this.cbxAdjustMode.addItems(adjustModeCollection != null ? adjustModeCollection.toArray() : null);
        this.bizPrmtItemFrom.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemFrom.setEditFormat("$number$");
        this.bizPrmtItemFrom.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemFrom.setEditable(true);
        this.bizPrmtItemFrom.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizPrmtItemFrom, null);
        this.bizPrmtItemTo.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizPrmtItemTo.setEditFormat("$number$");
        this.bizPrmtItemTo.setDisplayFormat("$number$ - $name$");
        this.bizPrmtItemTo.setEditable(true);
        this.bizPrmtItemTo.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizPrmtItemTo, null);
        this.txtDebitFrom.setDataType(1);
        this.txtDebitFrom.setPrecision(2);
        this.txtDebitFrom.setNegatived(true);
        this.txtDebitFrom.setEditable(true);
        this.txtDebitTo.setDataType(1);
        this.txtDebitTo.setPrecision(2);
        this.txtDebitTo.setNegatived(true);
        this.txtDebitTo.setEditable(true);
        this.txtCreditFrom.setDataType(1);
        this.txtCreditFrom.setPrecision(2);
        this.txtCreditFrom.setNegatived(true);
        this.txtCreditFrom.setEditable(true);
        this.txtCreditTo.setDataType(1);
        this.txtCreditTo.setPrecision(2);
        this.txtCreditTo.setNegatived(true);
        this.txtCreditTo.setEditable(true);
        this.cmbxAuditStatus.addItem((Object)this.selectAll);
        this.cmbxAuditStatus.addItems(CheckedStatusEnum.getEnumList().toArray());
        this.txtDebitFrom.setSupportedEmpty(true);
        this.txtDebitTo.setSupportedEmpty(true);
        this.txtCreditFrom.setSupportedEmpty(true);
        this.txtCreditTo.setSupportedEmpty(true);
        this.txtDebitFrom.setRemoveingZeroInDispaly(false);
        this.txtDebitTo.setRemoveingZeroInDispaly(false);
        this.txtCreditFrom.setRemoveingZeroInDispaly(false);
        this.txtCreditTo.setRemoveingZeroInDispaly(false);
        this.periodTypeCombo.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        this.periodTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptPeriodTypeEnum item = (RptPeriodTypeEnum)e.getItem();
                    if (AdjustViewFilterUI.this.isMergeByFiscalPeriod()) {
                        FiscalPeriodHelper.setSpineRangeByPeriodType(AdjustViewFilterUI.this.startPeriodSpin, item, false);
                        FiscalPeriodHelper.setSpineRangeByPeriodType(AdjustViewFilterUI.this.endPeriodSpin, item, false);
                    } else {
                        AdjustViewFilterUI.this.setPeriodRange(AdjustViewFilterUI.this.startPeriodSpin, item.getValue(), (Integer)AdjustViewFilterUI.this.startYearSpin.getValue());
                        AdjustViewFilterUI.this.setPeriodRange(AdjustViewFilterUI.this.endPeriodSpin, item.getValue(), (Integer)AdjustViewFilterUI.this.endYearSpin.getValue());
                    }
                    int[] period = AdjustViewFilterUI.this.getLastPeriod(item);
                    int curYear = new Integer(period[0]);
                    int curPeriod = new Integer(period[1]);
                    int endYear = new Integer(period[0]);
                    int endPeriod = new Integer(period[1]);
                    if (AdjustViewFilterUI.this.fiterParam != null) {
                        if (AdjustViewFilterUI.this.fiterParam.containsKey("year") && AdjustViewFilterUI.this.fiterParam.containsKey("period")) {
                            if ((Integer)AdjustViewFilterUI.this.fiterParam.get("year") > 0) {
                                curYear = (Integer)AdjustViewFilterUI.this.fiterParam.get("year");
                                endYear = (Integer)AdjustViewFilterUI.this.fiterParam.get("year");
                            }
                            if ((Integer)AdjustViewFilterUI.this.fiterParam.get("period") > 0) {
                                curPeriod = (Integer)AdjustViewFilterUI.this.fiterParam.get("period");
                                endPeriod = (Integer)AdjustViewFilterUI.this.fiterParam.get("period");
                            }
                        } else if (AdjustViewFilterUI.this.fiterParam.containsKey("startYear") && AdjustViewFilterUI.this.fiterParam.containsKey("startPeriod") && AdjustViewFilterUI.this.fiterParam.containsKey("endYear") && AdjustViewFilterUI.this.fiterParam.containsKey("endPeriod")) {
                            curYear = (Integer)AdjustViewFilterUI.this.fiterParam.get("startYear");
                            curPeriod = (Integer)AdjustViewFilterUI.this.fiterParam.get("startPeriod");
                            endYear = (Integer)AdjustViewFilterUI.this.fiterParam.get("endYear");
                            endPeriod = (Integer)AdjustViewFilterUI.this.fiterParam.get("endPeriod");
                        }
                    }
                    AdjustViewFilterUI.this.startYearSpin.setValue((Object)curYear);
                    AdjustViewFilterUI.this.endYearSpin.setValue((Object)endYear);
                    AdjustViewFilterUI.this.startPeriodSpin.setValue((Object)curPeriod);
                    AdjustViewFilterUI.this.endPeriodSpin.setValue((Object)endPeriod);
                }
            }
        });
        if (this.fiterParam != null && this.fiterParam.get("periodType") != null) {
            this.periodTypeCombo.setSelectedItem((Object)((RptPeriodTypeEnum)this.fiterParam.get("periodType")), true);
        } else {
            this.periodTypeCombo.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY, true);
        }
        if (this.fiterParam != null) {
            this.setSelectedItemToCmb(this.cmbxAuditStatus, this.fiterParam.get("auditStatus"), true);
        } else {
            this.cmbxAuditStatus.setSelectedIndex(0, false);
        }
    }

    private String getOrgTreeSQLByCompanyPK(IObjectPK companyPK, ArrayList orgTreeIDList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tree.fid ").append("FROM T_ORG_Tree tree ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.FTreeId =tree.fid ").append("WHERE structure.FunitId='").append(companyPK).append("' and tree.FTYPE=8 ").append("and tree.fid in (").append(CslRptUtil.collection2String(orgTreeIDList, ",", true)).append(")");
        return sql.toString();
    }

    private OrgTreeCollection getOrgTreeCollectionByCompanyPK(IObjectPK companyPK, ArrayList orgTreeIDList) throws BOSException {
        if (!StringUtils.isEmpty((String)companyPK.toString())) {
            String permFilterSql = this.getOrgTreeSQLByCompanyPK(companyPK, orgTreeIDList);
            OrgTreeCollection coll = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("select id,name,status,startDate,endDate,number where id in (" + permFilterSql + ")");
            return coll;
        }
        return null;
    }

    private int[] getLastPeriod(RptPeriodTypeEnum t) {
        Calendar c = Calendar.getInstance();
        int thismonth = c.get(2);
        do {
            c.add(5, -1);
        } while (c.get(2) == thismonth);
        int[] period = RPTDateUtil.getPeriod(new Date(c.getTimeInMillis()), t);
        return period;
    }

    protected void setPeriodRange(KDSpinner sp, int period_type, int year) {
        int max = 1;
        int min = 1;
        switch (period_type) {
            case 6: {
                break;
            }
            case 5: {
                max = 2;
                break;
            }
            case 4: {
                max = 4;
                break;
            }
            case 3: {
                max = "true".equalsIgnoreCase(String.valueOf(this.isSupport13Period)) ? 13 : 12;
                break;
            }
            case 2: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(3, 1);
                } while (cal.get(1) == year);
                max = count;
                break;
            }
            case 1: {
                Calendar cal = Calendar.getInstance();
                cal.set(1, year);
                cal.set(6, 1);
                int count = 0;
                do {
                    ++count;
                    cal.add(6, 1);
                } while (cal.get(1) == year);
                max = count;
            }
        }
        this.setSpineRange(sp, min, max);
    }

    protected void setSpineRange(KDSpinner sp, int minVal, int maxVal) {
        CslRptUIUtil.setSpineRange(sp, minVal, maxVal);
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    public FilterInfo getFilterInfo() {
        String summary;
        String customNumber;
        String auditor;
        String creator;
        FilterItemInfo filterItemCurrency;
        StringBuffer sbFormula;
        int formulaIndex;
        block43: {
            FilterItemInfo equalsStartYear;
            if (this.filterInfo == null) {
                this.filterInfo = new FilterInfo();
            } else {
                this.filterInfo.getFilterItems().clear();
            }
            formulaIndex = 0;
            sbFormula = new StringBuffer();
            RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
            FilterItemInfo filterItem0 = new FilterItemInfo("periodType", (Object)new Integer(periodType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            Integer startYear = (Integer)this.startYearSpin.getValue();
            Integer endYear = (Integer)this.endYearSpin.getValue();
            Integer permStartYear = null;
            Integer permEndYear = null;
            if (this.startYearSpin.getValue() != null && this.startPeriodSpin.getValue() != null && this.startPeriodSpin.getValue() != null) {
                FilterItemInfo greaterStartYear = new FilterItemInfo("year", (Object)new Integer(this.startYearSpin.getValue().toString()), CompareType.GREATER);
                this.filterInfo.getFilterItems().add(greaterStartYear);
                equalsStartYear = new FilterItemInfo("year", (Object)new Integer(this.startYearSpin.getValue().toString()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(equalsStartYear);
                FilterItemInfo startPeriod = new FilterItemInfo("period", (Object)new Integer(this.startPeriodSpin.getValue().toString()), CompareType.GREATER_EQUALS);
                this.filterInfo.getFilterItems().add(startPeriod);
                if (formulaIndex == 0) {
                    sbFormula.append(" (#" + formulaIndex++ + " or ( #" + formulaIndex++ + " and #" + formulaIndex++ + "))");
                } else {
                    sbFormula.append(" and (#" + formulaIndex++ + " or ( #" + formulaIndex++ + " and #" + formulaIndex++ + "))");
                }
            }
            if (this.endYearSpin.getValue() != null && this.endPeriodSpin.getValue() != null) {
                FilterItemInfo lessStartYear = new FilterItemInfo("year", (Object)new Integer(this.endYearSpin.getValue().toString()), CompareType.LESS);
                this.filterInfo.getFilterItems().add(lessStartYear);
                equalsStartYear = new FilterItemInfo("year", (Object)new Integer(this.endYearSpin.getValue().toString()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(equalsStartYear);
                FilterItemInfo equalsEndPeriod = new FilterItemInfo("period", (Object)new Integer(this.endPeriodSpin.getValue().toString()), CompareType.LESS_EQUALS);
                this.filterInfo.getFilterItems().add(equalsEndPeriod);
                if (formulaIndex == 0) {
                    sbFormula.append(" (#" + formulaIndex++ + " or ( #" + formulaIndex++ + " and #" + formulaIndex++ + "))");
                } else {
                    sbFormula.append(" and (#" + formulaIndex++ + " or ( #" + formulaIndex++ + " and #" + formulaIndex++ + "))");
                }
            }
            if (startYear <= endYear) {
                permStartYear = startYear;
                permEndYear = endYear;
            } else {
                permStartYear = endYear;
                permEndYear = startYear;
            }
            Integer startPeriod = (Integer)this.startPeriodSpin.getValue();
            Integer endPeriod = (Integer)this.endPeriodSpin.getValue();
            Integer permStartPeriod = null;
            Integer permEndPeriod = null;
            if (startPeriod <= endPeriod) {
                permStartPeriod = startPeriod;
                permEndPeriod = endPeriod;
            } else {
                permStartPeriod = endPeriod;
                permEndPeriod = startPeriod;
            }
            if (this.cbxAdjustMode.getSelectedItem() != null && !this.cbxAdjustMode.getSelectedItem().equals(this.selectAll)) {
                String adjustModeId = ((AdjustModeInfo)this.cbxAdjustMode.getSelectedItem()).getId().toString();
                FilterItemInfo filterItemAdjustMode = new FilterItemInfo("adjustMode.id", (Object)adjustModeId, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemAdjustMode);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if (this.cbxOrgBound.getItemCount() != 0 && this.cbxOrgBound.getSelectedItem() != null) {
                OrgTreeInfo tree = (OrgTreeInfo)this.cbxOrgBound.getSelectedItem();
                try {
                    PeriodCollection periods = null;
                    if (this.isMergeByFiscalPeriod()) {
                        periods = FiscalPeriodHelper.getPeriodCollection(null, tree);
                    }
                    Map mapResult = FiscalPeriodHelper.getOrgTreeByPeriods(null, periods, tree.getNumber(), permStartYear, permEndYear, startPeriod, endPeriod, periodType.getValue(), this.isMergeByFiscalPeriod, this.isSupport13Period);
                    String treeId = null;
                    if (mapResult.size() > 0 && !mapResult.isEmpty()) {
                        Iterator iter = mapResult.keySet().iterator();
                        if (iter.hasNext() && !this.permTreeIdList.contains(treeId = (String)iter.next())) {
                            treeId = null;
                        }
                        if (treeId != null) {
                            String treeNumber = tree.getNumber();
                            if (treeNumber != null && !treeNumber.equals("")) {
                                FilterItemInfo filterItemNumber = new FilterItemInfo("orgBound.number", (Object)treeNumber, CompareType.EQUALS);
                                this.filterInfo.getFilterItems().add(filterItemNumber);
                                sbFormula.append(" and #" + formulaIndex++);
                            }
                            FilterItemInfo filterItem1 = new FilterItemInfo("orgBound.id", (Object)treeId, CompareType.EQUALS);
                            this.filterInfo.getFilterItems().add(filterItem1);
                            if (formulaIndex > 0) {
                                sbFormula.append(" and #" + formulaIndex++);
                            } else {
                                sbFormula.append(" #" + formulaIndex++);
                            }
                        } else {
                            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"315_AdjustViewFilterUI"));
                            SysUtil.abort();
                        }
                        break block43;
                    }
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"315_AdjustViewFilterUI"));
                    SysUtil.abort();
                }
                catch (EASBizException e) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"315_AdjustViewFilterUI"));
                    SysUtil.abort();
                }
                catch (BOSException e) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"315_AdjustViewFilterUI"));
                    SysUtil.abort();
                }
            } else {
                FilterItemInfo filterItem1 = new FilterItemInfo("orgBound.id", (Object)"", CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItem1);
                if (formulaIndex > 0) {
                    sbFormula.append(" and #" + formulaIndex++);
                } else {
                    sbFormula.append(" #" + formulaIndex++);
                }
            }
        }
        if (this.cbxCurrency.getSelectedItem() != null && !this.cbxCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cbxSourceCurrency.getSelectedItem() != null && !this.cbxSourceCurrency.getSelectedItem().equals(this.selectAll)) {
            filterItemCurrency = new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.cbxSourceCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.bizPrmtItemFrom.getData() != null) {
            String itemNumberFrom = ((RPTItemInfo)this.bizPrmtItemFrom.getData()).getNumber();
            FilterItemInfo filterItemFrom = new FilterItemInfo("item.number", (Object)itemNumberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.bizPrmtItemTo.getData() != null) {
            String itemNumberTo = ((RPTItemInfo)this.bizPrmtItemTo.getData()).getNumber();
            FilterItemInfo filterItemTo = new FilterItemInfo("item.number", (Object)itemNumberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterItemTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            String numberFrom = this.txtNumberFrom.getText().trim();
            FilterItemInfo filterNumberFrom = new FilterItemInfo("number", (Object)numberFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            String numberTo = this.txtNumberTo.getText().trim();
            FilterItemInfo filterNumberTo = new FilterItemInfo("number", (Object)numberTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterNumberTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitFrom.getText() != null && this.txtDebitFrom.getText().trim().length() > 0) {
            BigDecimal debitFrom = this.txtDebitFrom.getBigDecimalValue();
            FilterItemInfo filterDebitFrom = new FilterItemInfo("entries.debit", (Object)debitFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtDebitTo.getText() != null && this.txtDebitTo.getText().trim().length() > 0) {
            BigDecimal debitTo = this.txtDebitTo.getBigDecimalValue();
            FilterItemInfo filterDebitTo = new FilterItemInfo("entries.debit", (Object)debitTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterDebitTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditFrom.getText() != null && this.txtCreditFrom.getText().trim().length() > 0) {
            BigDecimal creditFrom = this.txtCreditFrom.getBigDecimalValue();
            FilterItemInfo filterCreditFrom = new FilterItemInfo("entries.credit", (Object)creditFrom, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditFrom);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.txtCreditTo.getText() != null && this.txtCreditTo.getText().trim().length() > 0) {
            BigDecimal creditTo = this.txtCreditTo.getBigDecimalValue();
            FilterItemInfo filterCreditTo = new FilterItemInfo("entries.credit", (Object)creditTo, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterCreditTo);
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.cmbxAuditStatus.getSelectedItem() != null && !this.cmbxAuditStatus.getSelectedItem().equals(this.selectAll)) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("CheckedStatus", (Object)new Integer(this.cmbxAuditStatus.getSelectedIndex())));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)(creator = this.txtCreator.getText().trim()))) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("creator.name", (Object)creator));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)(auditor = this.txtAuditor.getText().trim()))) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("auditor.name", (Object)auditor));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)(customNumber = this.txtCustomNumber.getText().trim()))) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("customNumber", (Object)("%" + customNumber + "%"), CompareType.LIKE));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)(summary = this.txtSummary.getText().trim()))) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("entries.summary", (Object)("%" + summary + "%"), CompareType.LIKE));
            sbFormula.append(" and #" + formulaIndex++);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private void clearUI() {
        if (this.fiterParam != null) {
            this.setSelectedItemToCmb(this.cbxCurrency, this.fiterParam.get("currencyId"), true);
            this.setSelectedItemToCmb(this.cbxSourceCurrency, this.fiterParam.get("currencyId"), true);
            this.setSelectedItemToCmb(this.cbxAdjustMode, this.fiterParam.get("eliminationModeId"), true);
            this.setSelectedItemToCmb(this.cmbxAuditStatus, this.fiterParam.get("auditStatus"), true);
            this.setSelectedItemToCmb(this.cbxOrgBound, this.fiterParam.get("orgBound"), false);
            this.setSelectedItemToCmb(this.periodTypeCombo, this.fiterParam.get("periodType"), false);
        } else {
            this.cbxCurrency.setSelectedItem((Object)this.selectAll, false);
            this.cbxSourceCurrency.setSelectedItem((Object)this.selectAll, false);
            this.cbxAdjustMode.setSelectedItem((Object)this.selectAll, false);
            this.cmbxAuditStatus.setSelectedIndex(0, false);
            this.cbxOrgBound.setSelectedIndex(0, false);
            this.periodTypeCombo.setSelectedItem(null, false);
        }
        this.bizPrmtItemFrom.setData(null);
        this.bizPrmtItemTo.setData(null);
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.txtDebitFrom.setValue(null);
        this.txtDebitTo.setValue(null);
        this.txtCreditFrom.setValue(null);
        this.txtCreditTo.setValue(null);
        this.txtCreator.setText(null);
        this.txtAuditor.setText(null);
        this.txtCustomNumber.setText(null);
        this.txtSummary.setText(null);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        block2: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            CurrencyInfo currencyInfo;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("adjustMode.id")) {
                String adjustModeId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxAdjustMode.getItemCount(); ++j) {
                    AdjustModeInfo adjustModeInfo = (AdjustModeInfo)this.cbxAdjustMode.getItemAt(j);
                    if (!adjustModeInfo.getId().toString().equals(adjustModeId)) continue;
                    this.cbxAdjustMode.setSelectedIndex(j, false);
                    continue block2;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency.id")) {
                String currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxCurrency.setSelectedIndex(j, false);
                    continue block2;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("sourceCurrency.id")) {
                String currencyId = (String)filterItemInfo.getCompareValue();
                for (int j = 1; j < this.cbxSourceCurrency.getItemCount(); ++j) {
                    currencyInfo = (CurrencyInfo)this.cbxSourceCurrency.getItemAt(j);
                    if (!currencyInfo.getId().toString().equals(currencyId)) continue;
                    this.cbxSourceCurrency.setSelectedIndex(j, false);
                    continue block2;
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("item.number")) {
                String itemNumber = (String)filterItemInfo.getCompareValue();
                try {
                    RPTItemInfo rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo("select number, name where number = '" + itemNumber + "'");
                    if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                        this.bizPrmtItemFrom.setData((Object)rptItemInfo);
                        continue;
                    }
                    this.bizPrmtItemTo.setData((Object)rptItemInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtNumberFrom.setText(number);
                    continue;
                }
                this.txtNumberTo.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.debit")) {
                BigDecimal debit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtDebitFrom.setValue((Object)debit);
                    continue;
                }
                this.txtDebitTo.setValue((Object)debit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("entries.credit")) {
                BigDecimal credit = new BigDecimal(filterItemInfo.getCompareValue().toString());
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtCreditFrom.setValue((Object)credit);
                    continue;
                }
                this.txtCreditTo.setValue((Object)credit);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("CheckedStatus")) {
                int checkedStatus = (Integer)filterItemInfo.getCompareValue();
                if (checkedStatus <= 0) continue;
                this.cmbxAuditStatus.setSelectedIndex(checkedStatus, false);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("creator.name")) {
                String creator = filterItemInfo.getCompareValue().toString();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtCreator.setText(creator);
                    continue;
                }
                this.txtCreator.setText(creator);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("auditor.name")) {
                String auditor = filterItemInfo.getCompareValue().toString();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.txtAuditor.setText(auditor);
                    continue;
                }
                this.txtAuditor.setText(auditor);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgBound.number")) {
                String treeNumber = (String)filterItemInfo.getCompareValue();
                for (int j = 0; j < this.cbxOrgBound.getItemCount(); ++j) {
                    OrgTreeInfo treeInfo = (OrgTreeInfo)this.cbxOrgBound.getItemAt(j);
                    if (treeNumber == null || !treeNumber.equals(treeInfo.getNumber())) continue;
                    this.cbxOrgBound.setSelectedItem((Object)treeInfo, false);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("periodType")) {
                RptPeriodTypeEnum periodType = RptPeriodTypeEnum.getEnum((int)Integer.parseInt(filterItemInfo.getCompareValue().toString()));
                if (periodType == null) continue;
                this.periodTypeCombo.setSelectedItem((Object)periodType, false);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("year")) {
                if (CompareType.GREATER.equals((Object)filterItemInfo.getCompareType())) {
                    Integer startYear = new Integer(filterItemInfo.getCompareValue().toString());
                    this.startYearSpin.setValue((Object)startYear);
                    continue;
                }
                if (!CompareType.LESS.equals((Object)filterItemInfo.getCompareType())) continue;
                Integer endYear = new Integer(filterItemInfo.getCompareValue().toString());
                this.endYearSpin.setValue((Object)endYear);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("period")) {
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    Integer startPeriod = new Integer(filterItemInfo.getCompareValue().toString());
                    this.startPeriodSpin.setValue((Object)startPeriod);
                    continue;
                }
                Integer endPeriod = new Integer(filterItemInfo.getCompareValue().toString());
                this.endPeriodSpin.setValue((Object)endPeriod);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("customNumber")) {
                String customNumber = filterItemInfo.getCompareValue().toString();
                this.txtCustomNumber.setText(customNumber.replaceAll("%", ""));
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("entries.summary")) continue;
            String summary = filterItemInfo.getCompareValue().toString();
            this.txtSummary.setText(summary.replaceAll("%", ""));
        }
    }

    public boolean verify() {
        if (this.periodTypeCombo.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"50_ItemAnalysisFilterUI"));
            return false;
        }
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod()) {
            try {
                periods = FiscalPeriodHelper.getPeriodCollection(null, (OrgTreeInfo)this.cbxOrgBound.getSelectedItem());
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return FiscalPeriodHelper.HaveManyOrgTreeVersion((Component)((Object)this), this.periodTypeCombo, this.startYearSpin, this.endYearSpin, this.startPeriodSpin, this.endPeriodSpin, this.cbxOrgBound, periods, this.isMergeByFiscalPeriod, this.isSupport13Period);
    }

    public boolean isMergeByFiscalPeriod() {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
        if (p == null) {
            p = RptPeriodTypeEnum.MONTHLY;
        }
        return this.isMergeByFiscalPeriod && !p.equals((Object)RptPeriodTypeEnum.DAILY) && !p.equals((Object)RptPeriodTypeEnum.WEEKLY);
    }

    private void setSelectedItemToCmb(KDComboBox cmb, Object value, boolean isSelectFirst) {
        if (value == null) {
            return;
        }
        boolean isFound = false;
        for (int i = 0; i < cmb.getItemCount(); ++i) {
            String compareValue;
            Object item = cmb.getItemAt(i);
            if (item instanceof OrgTreeInfo) {
                String number = ((OrgTreeInfo)item).getNumber();
                compareValue = "";
                compareValue = value instanceof OrgTreeInfo ? ((OrgTreeInfo)value).getNumber() : value.toString();
                if (!compareValue.equals(number)) continue;
                cmb.setSelectedIndex(i, false);
                isFound = true;
                break;
            }
            if (item instanceof CoreBaseInfo) {
                String id = ((CoreBaseInfo)item).getId().toString();
                compareValue = "";
                compareValue = value instanceof CoreBaseInfo ? ((CoreBaseInfo)value).getId().toString() : value.toString();
                if (!compareValue.equals(id)) continue;
                cmb.setSelectedIndex(i, true);
                isFound = true;
                break;
            }
            if (item instanceof Enum) {
                if (!value.equals(item)) continue;
                cmb.setSelectedIndex(i, true);
                isFound = true;
                break;
            }
            if (!(item instanceof String) || !value.equals(item)) continue;
            cmb.setSelectedIndex(i, false);
            isFound = true;
            break;
        }
        if (isSelectFirst && !isFound && cmb.getItemCount() > 0) {
            cmb.setSelectedIndex(0, false);
        }
    }
}

