/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimImportBasicTreeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.IElimImportBasicTree;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class AllCompanyInOrgnizeImport
implements IElimImportBasicTree {
    private static final Logger logger = Logger.getLogger(AllCompanyInOrgnizeImport.class);
    private OrgTreeInfo orgTreeInfo = null;
    private OrgUnitInfo orgUnitInfo = null;
    private RptPeriodTypeEnum periodType;
    private int year;
    private int period;
    private MergeModeEnum mergeMode = null;
    IElimination iElim = EliminationFactory.getRemoteInstance();
    private Object sourceCurrencyinfo = null;
    private Object currencyinfo = null;
    private List curCompanyIds = null;
    private Object elimType = null;
    private Object elimMode = null;

    @Override
    public void addRecordToTable(EntityViewInfo eliminationImportQuery, List companyIds) throws BOSException, EASBizException {
        boolean isByLevel = this.mergeMode.equals((Object)MergeModeEnum.DIRECT);
        if (isByLevel) {
            this.filterShowImportElimByDirect(eliminationImportQuery);
        } else {
            this.filterShowImportElimByOrdinal(eliminationImportQuery);
        }
        String basicOrgTrees = this.getBasicTree();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("year", new Integer(this.year));
        param.put("period", new Integer(this.period));
        param.put("periodType", new Integer(this.periodType.getValue()));
        param.put("orgBound.id", basicOrgTrees.toString());
        param.put("orgUnitInfo", this.orgUnitInfo);
        param.put("importBasicTreeType", (Object)ElimImportBasicTreeEnum.AllCompanyInOrgnizeImport);
        param.put("curTreeInfo", this.orgTreeInfo);
        if (this.curCompanyIds == null) {
            this.curCompanyIds = this.iElim.getCurChildCompanyFromCurTree(param);
        }
        IRowSet rs = this.iElim.getElimCountByOrgUnit(param);
        ArrayList lastList = new ArrayList();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = 0;
        this.checkCurCompanyIsContainBasicCompany(rs, lastList);
        if (lastList.size() > 0) {
            sbFormula.append("(");
            for (int i = 0; i < lastList.size(); ++i) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)lastList.get(i).toString(), CompareType.EQUALS));
                if (i == lastList.size() - 1) {
                    sbFormula.append(" #" + formulaIndex++).append(")");
                    continue;
                }
                sbFormula.append(" #" + formulaIndex++).append(" or");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"", CompareType.EQUALS));
            sbFormula.append(" #" + formulaIndex++);
        }
        if (this.currencyinfo != null) {
            CurrencyInfo currency = (CurrencyInfo)this.currencyinfo;
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.sourceCurrencyinfo != null) {
            CurrencyInfo currency = (CurrencyInfo)this.sourceCurrencyinfo;
            filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)currency.getId().toString()));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.elimType != null) {
            ElimTypeEnum type = (ElimTypeEnum)((Object)this.elimType);
            filter.getFilterItems().add(new FilterItemInfo("elimType", (Object)new Integer(type.getValue())));
            sbFormula.append(" and #" + formulaIndex++);
        }
        if (this.elimMode != null) {
            if ("".equals(this.elimMode)) {
                filter.getFilterItems().add(new FilterItemInfo("eliminationMode.id", null));
            } else {
                EliminationModeInfo eliminationModeInfo = (EliminationModeInfo)this.elimMode;
                filter.getFilterItems().add(new FilterItemInfo("eliminationMode.id", (Object)eliminationModeInfo.getId().toString()));
            }
            sbFormula.append(" and #" + formulaIndex++);
        }
        filter.setMaskString(sbFormula.toString());
        eliminationImportQuery.setFilter(filter);
    }

    private void checkCurCompanyIsContainBasicCompany(IRowSet rs, ArrayList lastList) throws BOSException {
        if (rs != null) {
            try {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    EliminationEntryCollection col = EliminationEntryFactory.getRemoteInstance().getEliminationEntryCollection("select company where elimination ='" + id + "'");
                    boolean isContinue = true;
                    if (col != null && col.size() > 0) {
                        for (int i = 0; i < col.size(); ++i) {
                            EliminationEntryInfo elimInfo = col.get(i);
                            if (elimInfo.getCompany() == null) {
                                isContinue = false;
                                break;
                            }
                            String companyId = elimInfo.getCompany().getId().toString();
                            if (this.curCompanyIds != null && this.curCompanyIds.size() > 0) {
                                if (!this.curCompanyIds.contains(companyId)) {
                                    isContinue = false;
                                    break;
                                }
                            } else {
                                isContinue = false;
                                break;
                            }
                            isContinue = true;
                        }
                    } else {
                        isContinue = false;
                    }
                    if (!isContinue) continue;
                    int count = rs.getInt("entryCount");
                    EliminationEntryCollection collect = EliminationEntryFactory.getRemoteInstance().getEliminationEntryCollection("select id where elimination.id = '" + id + "'");
                    if (collect == null || collect.size() <= 0 || collect.size() != count) continue;
                    lastList.add(id);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private void filterShowImportElimByDirect(EntityViewInfo eliminationImportQuery) throws EASBizException, BOSException {
        String basicOrgTrees = this.getBasicTree();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("year", new Integer(this.year));
        param.put("period", new Integer(this.period));
        param.put("periodType", new Integer(this.periodType.getValue()));
        param.put("orgBound.id", basicOrgTrees.toString());
        param.put("orgUnitInfo", this.orgUnitInfo);
        param.put("importBasicTreeType", (Object)ElimImportBasicTreeEnum.AllCompanyInOrgnizeImport);
        param.put("curTreeInfo", this.orgTreeInfo);
        if (this.curCompanyIds == null) {
            this.curCompanyIds = this.iElim.getCurChildCompanyFromCurTree(param);
        }
        IRowSet rs = this.iElim.getElimCountByOrgUnit(param);
        ArrayList lastList = new ArrayList();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = 0;
        this.checkCurCompanyIsContainBasicCompany(rs, lastList);
        if (lastList.size() > 0) {
            for (int i = 0; i < lastList.size(); ++i) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)lastList.get(i).toString(), CompareType.EQUALS));
                if (i == lastList.size() - 1) {
                    sbFormula.append(" #" + formulaIndex++);
                    continue;
                }
                sbFormula.append(" #" + formulaIndex++).append(" or");
            }
            filter.setMaskString(sbFormula.toString());
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"", CompareType.EQUALS));
        }
        eliminationImportQuery.setFilter(filter);
    }

    private void filterShowImportElimByOrdinal(EntityViewInfo eliminationImportQuery) throws BOSException, EASBizException {
        ArrayList<String> lastList = new ArrayList<String>();
        if (this.orgUnitInfo == null) {
            return;
        }
        String basicOrgTrees = this.getBasicTree();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("year", new Integer(this.year));
        param.put("period", new Integer(this.period));
        param.put("periodType", new Integer(this.periodType.getValue()));
        param.put("orgBound.id", basicOrgTrees.toString());
        param.put("orgUnitInfo", this.orgUnitInfo);
        param.put("importBasicTreeType", (Object)ElimImportBasicTreeEnum.AllCompanyInOrgnizeImport);
        param.put("curTreeInfo", this.orgTreeInfo);
        if (this.curCompanyIds == null) {
            this.curCompanyIds = this.iElim.getCurChildCompanyFromCurTree(param);
        }
        IRowSet rs = this.iElim.getAllElimByOrgUnit(param);
        String lastId = null;
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        try {
            if (rs != null) {
                while (rs.next()) {
                    String id = rs.getString("fid");
                    if (this.curCompanyIds == null || this.curCompanyIds.size() <= 0 || !this.curCompanyIds.contains(id)) continue;
                    String longNumber = rs.getString("flongnumber");
                    if (lastId == null) {
                        lastId = id;
                    }
                    if (lastId.equals(id)) {
                        list.add(this.decomposeLongNumber(longNumber));
                        continue;
                    }
                    boolean isShow = this.checkIsCompanyForCurUnit(list);
                    if (isShow) {
                        lastList.add(lastId);
                    }
                    list.clear();
                    list.add(this.decomposeLongNumber(longNumber));
                    lastId = id;
                }
                if (list.size() > 0) {
                    boolean isShow = this.checkIsCompanyForCurUnit(list);
                    if (isShow) {
                        lastList.add(lastId);
                    }
                    list.clear();
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = 0;
        if (lastList.size() > 0) {
            for (int i = 0; i < lastList.size(); ++i) {
                String id = lastList.get(i).toString();
                boolean isShow = this.checkCurCompanyIsContainBasicCompanyForShunXu(id);
                if (!isShow) continue;
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
                if (i == lastList.size() - 1) {
                    sbFormula.append(" #" + formulaIndex++);
                    continue;
                }
                sbFormula.append(" #" + formulaIndex++).append(" or");
            }
            filter.setMaskString(sbFormula.toString());
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"", CompareType.EQUALS));
        }
        eliminationImportQuery.setFilter(filter);
    }

    private boolean checkCurCompanyIsContainBasicCompanyForShunXu(String id) throws BOSException {
        EliminationEntryCollection col = EliminationEntryFactory.getRemoteInstance().getEliminationEntryCollection("select company where elimination ='" + id + "'");
        boolean isContinue = true;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                EliminationEntryInfo elimInfo = col.get(i);
                String companyId = elimInfo.getCompany().getId().toString();
                if (this.curCompanyIds != null && this.curCompanyIds.size() > 0) {
                    if (!this.curCompanyIds.contains(companyId)) {
                        isContinue = false;
                        break;
                    }
                } else {
                    isContinue = false;
                    break;
                }
                isContinue = true;
            }
        } else {
            isContinue = false;
        }
        return isContinue;
    }

    private ArrayList decomposeLongNumber(String longNumber) {
        String topclassLongNumber = this.orgUnitInfo.getLongNumber();
        int leng = topclassLongNumber.length();
        String lastPart = longNumber.substring(leng, longNumber.length() - 1);
        longNumber = "@@" + lastPart;
        ArrayList<String> list = new ArrayList<String>(10);
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < longNumber.length(); ++i) {
            if (longNumber.charAt(i) == '!') {
                list.add(s.toString());
                s.delete(0, s.length());
                continue;
            }
            s.append(longNumber.charAt(i));
        }
        if (s.length() > 0) {
            list.add(s.toString());
        }
        s.delete(0, s.length());
        return list;
    }

    private boolean checkIsCompanyForCurUnit(ArrayList list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        boolean j = false;
        for (int i = 0; i < list.size(); ++i) {
            int size0;
            int size1 = ((ArrayList)list.get(i)).size();
            if (size1 >= (size0 = ((ArrayList)list.get(0)).size())) continue;
            Object temp = list.get(i);
            Object b = list.get(0);
            list.set(0, temp);
            list.set(i, b);
        }
        boolean isShow = true;
        ArrayList listLeastSize = (ArrayList)list.get(0);
        if (listLeastSize.size() == 1) {
            return false;
        }
        for (int w = listLeastSize.size() - 2; w >= 0; --w) {
            String node = listLeastSize.get(w).toString();
            int temp = 0;
            for (int k = list.size() - 1; k >= 1; --k) {
                ArrayList listOther = (ArrayList)list.get(k);
                String nodeOther = listOther.get(w).toString();
                if (w != 0 && !node.equals(nodeOther)) continue;
                if (w != 0 && node.equals(nodeOther)) {
                    ++temp;
                    continue;
                }
                if (w == 0 && !node.equals(nodeOther)) {
                    isShow = false;
                    break;
                }
                if (w != 0 || !node.equals(nodeOther)) continue;
                isShow = true;
                break;
            }
            if (temp == list.size() - 1) {
                isShow = false;
                break;
            }
            if (!isShow) break;
        }
        return isShow;
    }

    @Override
    public void setBasicParam(HashMap param) {
        this.orgUnitInfo = (OrgUnitInfo)param.get("orgUnitInfo");
        this.year = new Integer(param.get("year").toString());
        this.period = new Integer(param.get("period").toString());
        this.periodType = (RptPeriodTypeEnum)param.get("periodType");
        this.orgTreeInfo = (OrgTreeInfo)param.get("orgTreeInfo");
        this.mergeMode = (MergeModeEnum)((Object)param.get("mergeMode"));
    }

    private String getBasicTree() throws BOSException, EASBizException {
        IOrgTree iOrgTree = OrgTreeFactory.getRemoteInstance();
        Date rptDate = this.getPeriodLastDate();
        OrgTreeCollection orgBoundList = iOrgTree.getOrgTreeCollection("SELECT id WHERE basic = 1 and type = 8 and startdate <= '" + new Timestamp(rptDate.getTime()) + "' and (enddate is null or enddate >= '" + new Timestamp(rptDate.getTime()) + "')");
        StringBuffer basicOrgTrees = new StringBuffer("");
        OrgTreeInfo tree = null;
        if (orgBoundList != null && orgBoundList.size() > 0) {
            tree = orgBoundList.get(0);
            basicOrgTrees.append("'" + tree.getId().toString() + "'");
        }
        return basicOrgTrees.toString();
    }

    @Override
    public void setCurrency(HashMap map) {
        this.sourceCurrencyinfo = map.get("sourceCurrency");
        this.currencyinfo = map.get("currency");
    }

    @Override
    public void setElimType(Object elimType) {
        this.elimType = elimType;
    }

    private Date getPeriodLastDate() throws EASBizException, BOSException {
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(null);
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod(isMergeByFiscalPeriod, this.periodType)) {
            periods = FiscalPeriodHelper.getPeriodCollection(null, this.orgTreeInfo);
        }
        return FiscalPeriodHelper.getPeriodLastDate(periods, this.year, this.period, this.periodType, isMergeByFiscalPeriod);
    }

    private boolean isMergeByFiscalPeriod(boolean isMergeByFiscalPeriod, RptPeriodTypeEnum periodType) {
        RptPeriodTypeEnum p = RptPeriodTypeEnum.MONTHLY;
        if (periodType instanceof RptPeriodTypeEnum) {
            p = periodType;
        }
        return isMergeByFiscalPeriod && !p.equals((Object)RptPeriodTypeEnum.DAILY) && !p.equals((Object)RptPeriodTypeEnum.WEEKLY);
    }

    private boolean checkCurOrgUnitIsContainBasicCompanyForShunXu(String id) throws BOSException {
        EliminationEntryCollection col = EliminationEntryFactory.getRemoteInstance().getEliminationEntryCollection("select company where elimination ='" + id + "'");
        HashSet<String> idlist = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            EliminationEntryInfo elimInfo = col.get(i);
            if (elimInfo.getCompany() == null) {
                return false;
            }
            String companyId = elimInfo.getCompany().getId().toString();
            if (this.curCompanyIds != null && this.curCompanyIds.size() > 0 && !this.curCompanyIds.contains(companyId)) {
                return false;
            }
            idlist.add(companyId);
        }
        EntityViewInfo viewCompanyOrgUnit = new EntityViewInfo();
        SelectorItemCollection sicOrgRange = viewCompanyOrgUnit.getSelector();
        sicOrgRange.add(new SelectorItemInfo("longnumber"));
        FilterInfo filterCompanyOrgUnit = new FilterInfo();
        if (idlist.size() <= 0) {
            return false;
        }
        filterCompanyOrgUnit.getFilterItems().add(new FilterItemInfo("unit.id", idlist, CompareType.INCLUDE));
        filterCompanyOrgUnit.getFilterItems().add(new FilterItemInfo("tree.id", (Object)this.orgTreeInfo.getId().toString()));
        viewCompanyOrgUnit.setFilter(filterCompanyOrgUnit);
        OrgStructureCollection coll = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(viewCompanyOrgUnit);
        ArrayList<String> longnumberlist = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            longnumberlist.add(coll.get(i).getLongNumber());
        }
        String getgeneral = this.getGeneralString(longnumberlist);
        if (!getgeneral.equals("")) {
            if (this.orgUnitInfo != null) {
                return this.orgUnitInfo.getLongNumber().equals(getgeneral);
            }
            return false;
        }
        return false;
    }

    private String getGeneralString(List list) {
        if (list.size() > 0) {
            String number2 = (String)list.get(0);
            String[] num2 = null;
            if (number2 != null && !number2.equals("")) {
                num2 = number2.split("!");
                StringBuffer st = new StringBuffer();
                String ret = null;
                st.append(num2[0]);
                ret = st.toString();
                for (int i = 1; i < num2.length; ++i) {
                    if (i == 1) {
                        ret = st.toString();
                        st.append("!");
                    }
                    st.append(num2[i]);
                    for (int j = 0; j < list.size(); ++j) {
                        String longnumber = (String)list.get(j);
                        if (longnumber.startsWith(st.toString())) continue;
                        return ret;
                    }
                    ret = st.toString();
                    if (i + 1 >= num2.length) continue;
                    st.append("!");
                }
                if (ret.equals(number2)) {
                    ret.lastIndexOf("!");
                    ret = ret.substring(0, ret.lastIndexOf("!"));
                }
                return ret;
            }
            return "";
        }
        return "";
    }

    @Override
    public void setElimMode(Object elimMode) {
        this.elimMode = elimMode;
    }
}

