/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.IAutoItemBusinessFacade;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.QueryReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractAutoItemShowCreatingReportUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataForShowCreatingReport;
import com.kingdee.eas.fi.gr.cslrpt.client.MessageHandler;
import com.kingdee.eas.fi.gr.cslrpt.client.OpenReport;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.ITreeTableNodeEntity;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.SetTreeTable;
import com.kingdee.eas.fi.gr.cslrpt.client.util.FillTable;
import com.kingdee.eas.fi.gr.cslrpt.client.util.mutex.MutexLock;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.util.Uuid;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AutoItemShowCreatingReportUI
extends AbstractAutoItemShowCreatingReportUI {
    private static final long serialVersionUID = 8518323184139126752L;
    private static final Logger logger = CoreUIObject.getLogger(AutoItemShowCreatingReportUI.class);
    public static final String IS_NEW_CREATE = "NEW_CREATE";
    private FormulaCalcContextInfo calcContext;
    private boolean newCreate = false;
    private Uuid createReportMutexId;

    public AutoItemShowCreatingReportUI() throws Exception {
        this.table.checkParsed(false);
        this.table.getStyleAttributes().setLocked(true);
        this.table.getSelectManager().setSelectMode(2);
        if (this.getMainStatusBar() != null && this.getMainStatusBar().getStatusBar() != null) {
            this.getMainStatusBar().getStatusBar().setVisible(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        new SetTreeTable(false).exec(this.table, "companyOrReport", null, null);
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = e.getRowIndex();
                    Object rowData = AutoItemShowCreatingReportUI.this.table.getRow(row).getUserObject();
                    if (!(rowData instanceof ItemDataForShowCreatingReport) && ((ItemDataForShowCreatingReport)rowData).getStatus() == null) {
                        AutoItemShowCreatingReportUI.this.getMessageHandler().show(ResourceDebugUtil.res("wait.to.finish"));
                        return;
                    }
                    if (!(rowData instanceof ItemDataForShowCreatingReport) || ((ItemDataForShowCreatingReport)rowData).getReport() == null) {
                        Object companyOrReport = AutoItemShowCreatingReportUI.this.table.getRow(row).getCell("companyOrReport").getUserObject();
                        if (companyOrReport instanceof ITreeTableNodeEntity && !((ITreeTableNodeEntity)companyOrReport).isLeaf()) {
                            return;
                        }
                        AutoItemShowCreatingReportUI.this.getMessageHandler().show(ResourceDebugUtil.res("report.not.be.found"));
                        return;
                    }
                    try {
                        ReportInfo report = ((ItemDataForShowCreatingReport)rowData).getReport();
                        new OpenReport().exec(report.getId().toString(), (Object)AutoItemShowCreatingReportUI.this, true);
                    }
                    catch (UIException e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                }
            }
        });
        this.calcContext = (FormulaCalcContextInfo)this.getUIContext().get(FormulaCalcContextInfo.class);
        if (this.calcContext == null) {
            throw new BOSException("uicontext's error!please check. ");
        }
        CslRptUIUtil.setSpineRange(this.year, 1974, Integer.MAX_VALUE);
        FastMergeUtil.setPeriodRange(this.period, this.calcContext.getPeriodType().getValue(), this.calcContext.getYear());
        int[] yearAndPeriod = FastMergeUtil.getLastCalcYearAndPeriod(null, this.calcContext.getId().toString());
        if (yearAndPeriod != null && yearAndPeriod.length == 2) {
            this.calcContext.setYear(yearAndPeriod[0]);
            this.calcContext.setPeriod(yearAndPeriod[1]);
        }
        this.newCreate = this.getUIContext().containsKey(IS_NEW_CREATE) && (Boolean)this.getUIContext().get(IS_NEW_CREATE) != false;
        this.createReportMutexId = (Uuid)this.getUIContext().get(MutexLock.class);
        this.year.setEnabled(!this.newCreate);
        this.period.setEnabled(!this.newCreate);
        if (!this.newCreate) {
            this.setUITitle(ResourceDebugUtil.res("show.report"));
            this.year.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        if (!(AutoItemShowCreatingReportUI.this.year.getValue() instanceof Integer)) {
                            AutoItemShowCreatingReportUI.this.getMessageHandler().show(ResourceDebugUtil.res("error.for.setting.year"));
                        }
                        AutoItemShowCreatingReportUI.this.calcContext.setYear((Integer)AutoItemShowCreatingReportUI.this.year.getValue());
                        AutoItemShowCreatingReportUI.this.loadItemValue();
                    }
                    catch (EASBizException e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                    catch (BOSException e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                }
            });
            this.period.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        if (!(AutoItemShowCreatingReportUI.this.period.getValue() instanceof Integer)) {
                            AutoItemShowCreatingReportUI.this.getMessageHandler().show(ResourceDebugUtil.res("error.for.setting.period"));
                        }
                        AutoItemShowCreatingReportUI.this.calcContext.setPeriod((Integer)AutoItemShowCreatingReportUI.this.period.getValue());
                        AutoItemShowCreatingReportUI.this.loadItemValue();
                    }
                    catch (EASBizException e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                    catch (BOSException e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                }
            });
        }
        this.loadFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.year.setValue((Object)this.calcContext.getYear());
        this.period.setValue((Object)this.calcContext.getPeriod());
        this.txtPeriodType.setText(this.calcContext.getPeriodType().getAlias());
        this.txtCurrency.setText(this.calcContext.getCurrentCurrency().getName());
        try {
            this.loadItemValue();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void loadItemValue() throws EASBizException, BOSException {
        this.table.removeRows();
        FullOrgUnitInfo company = null;
        TemplateInfo template = null;
        FillTable fill = new FillTable(this.table, new String[]{"companyOrReport", "status"});
        int currRow = -1;
        ItemDataForShowCreatingReport rowData = null;
        AbstractCollection conditions = null;
        conditions = this.newCreate ? new ArrayList() : new HashSet();
        int size = this.calcContext.getCompanys().size();
        for (int companyIndex = 0; companyIndex < size; ++companyIndex) {
            company = this.calcContext.getCompanys().get(companyIndex).getCompany();
            fill.save(new ItemDataForShowCreatingReport((OrgUnitInfo)company, null, "", null), ++currRow);
            for (int templateIndex = 0; templateIndex < this.calcContext.getTemplates().size(); ++templateIndex) {
                template = this.calcContext.getTemplates().get(templateIndex).getTemplate();
                ++currRow;
                rowData = new ItemDataForShowCreatingReport((OrgUnitInfo)company, template, "", null);
                if (this.newCreate) {
                    rowData.setStatus(ResourceDebugUtil.res("wait.for.creating.report"));
                } else {
                    rowData.setStatus(ResourceDebugUtil.res("doing.query.report"));
                }
                fill.save(rowData, currRow);
                conditions.add((LazyFillReportCondition)new LazyFillReportCondition((OrgUnitInfo)company, template, rowData, currRow));
            }
        }
        if (this.newCreate) {
            this.layzCreateReport(conditions, fill);
        } else {
            this.lazyFillReport(conditions, fill);
        }
    }

    protected void lazyFillReport(final Collection<LazyFillReportCondition> conditions, final FillTable fill) throws EASBizException, BOSException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Collection<ReportInfo> reports = null;
                try {
                    reports = new QueryReport(new DBHandler(null)).exec(AutoItemShowCreatingReportUI.this.calcContext, null);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    this.error(ResourceDebugUtil.res("fail.to.query") + ":" + e.getMessage());
                    return;
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    this.error(ResourceDebugUtil.res("fail.to.query") + ":" + e.getMessage());
                    return;
                }
                HashMap<String, ReportInfo> cacheReports = new HashMap<String, ReportInfo>(reports.size());
                String key = null;
                for (ReportInfo report : reports) {
                    key = report.getCompany().getNumber() + "|" + report.getTemplate().getNumber();
                    cacheReports.put(key, report);
                }
                ReportInfo rowReport = null;
                for (LazyFillReportCondition condition : conditions) {
                    key = condition.getCompany().getNumber() + "|" + condition.getTemplate().getNumber();
                    rowReport = (ReportInfo)cacheReports.get(key);
                    if (rowReport == null) {
                        condition.getRowData().setStatus(ResourceDebugUtil.res("report.not.be.found"));
                    } else {
                        condition.getRowData().setReport(rowReport);
                        condition.getRowData().setStatus("(" + ResourceDebugUtil.res("double.click.to.open") + ")");
                    }
                    fill.save(condition.getRowData(), condition.getCurrRow());
                }
            }

            public void error(String error) {
                for (LazyFillReportCondition condition : conditions) {
                    condition.getRowData().setStatus(error);
                    fill.save(condition.getRowData(), condition.getCurrRow());
                }
            }
        }).start();
    }

    private void layzCreateReport(final Collection<LazyFillReportCondition> conditions, final FillTable fill) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IAutoItemBusinessFacade autoitemFacadeDao;
                    ItemDataForShowCreatingReport rowData = null;
                    int currRow = -1;
                    try {
                        autoitemFacadeDao = new DBHandler(null).get(IAutoItemBusinessFacade.class);
                    }
                    catch (BOSException e1) {
                        logger.error((Object)"", (Throwable)e1);
                        if (AutoItemShowCreatingReportUI.this.newCreate && AutoItemShowCreatingReportUI.this.createReportMutexId != null) {
                            MutexUtil.releaseMutex(AutoItemShowCreatingReportUI.this.createReportMutexId);
                        }
                        return;
                    }
                    for (LazyFillReportCondition condition : conditions) {
                        rowData = condition.getRowData();
                        currRow = condition.getCurrRow();
                        TemplateInfo template = condition.getTemplate();
                        OrgUnitInfo company = condition.getCompany();
                        rowData.setStatus(ResourceDebugUtil.res("creating"));
                        fill.save(rowData, currRow);
                        try {
                            ReportInfo report = autoitemFacadeDao.createOneReport(AutoItemShowCreatingReportUI.this.calcContext, template, company, true);
                            String status = null;
                            status = report == null ? ResourceDebugUtil.res("fail.to.create.for.unknown.exception") : (report.containsKey("existedReport") ? ResourceDebugUtil.res("it.exist.report.and.refill.item.data") : ResourceDebugUtil.res("success.to.create.report.and.double.click.to.open"));
                            rowData.setStatus(status);
                            if (report != null) {
                                rowData.setReport(report);
                            }
                            fill.save(rowData, currRow);
                        }
                        catch (EASBizException e) {
                            logger.error((Object)"", (Throwable)e);
                            rowData.setStatus(ResourceDebugUtil.res("fail.to.create.report") + ":" + e.getMessage());
                            fill.save(rowData, currRow);
                        }
                        catch (BOSException e) {
                            logger.error((Object)"", (Throwable)e);
                            rowData.setStatus(ResourceDebugUtil.res("fail.to.create.report") + ":" + e.getMessage());
                            fill.save(rowData, currRow);
                        }
                    }
                }
                finally {
                    if (AutoItemShowCreatingReportUI.this.newCreate && AutoItemShowCreatingReportUI.this.createReportMutexId != null) {
                        MutexUtil.releaseMutex(AutoItemShowCreatingReportUI.this.createReportMutexId);
                    }
                }
            }
        }).start();
    }

    protected MessageHandler getMessageHandler() {
        return new MessageHandler(1);
    }

    private static class LazyFillReportCondition {
        private OrgUnitInfo company;
        private TemplateInfo template;
        private ItemDataForShowCreatingReport rowData;
        private int currRow;

        public LazyFillReportCondition(OrgUnitInfo company, TemplateInfo template, ItemDataForShowCreatingReport rowData, int currRow) {
            this.company = company;
            this.template = template;
            this.rowData = rowData;
            this.currRow = currRow;
        }

        public OrgUnitInfo getCompany() {
            return this.company;
        }

        public TemplateInfo getTemplate() {
            return this.template;
        }

        public ItemDataForShowCreatingReport getRowData() {
            return this.rowData;
        }

        public int getCurrRow() {
            return this.currRow;
        }
    }
}

