/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptShareTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsGuideOrgUnitTabUI;
import com.kingdee.eas.fi.gr.cslrpt.client.query.CommonQueryDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import org.apache.log4j.Logger;

public class BaseRptCalcGuideUI
extends CommonQueryDialog {
    private static Logger logger = Logger.getLogger(BaseRptCalcGuideUI.class);
    protected MnsGuideOrgUnitTabUI guideOrgUnitTabUI;
    protected boolean isSetting = false;
    protected CslReportInfo cslReportInfo;
    protected boolean isFastMerge = false;
    private boolean isHideDyRptCalcPanel = true;
    private QuerySolutionInfo querySolutionInfo = null;

    public BaseRptCalcGuideUI(IUIObject owner, CslReportInfo cslReportInfo) throws Exception {
        this.cslReportInfo = cslReportInfo;
    }

    public BaseRptCalcGuideUI(IUIObject owner, CslReportInfo cslReportInfo, QuerySolutionInfo querySolutionInfo, boolean isFastMerge) throws Exception {
        this.cslReportInfo = cslReportInfo;
        this.isFastMerge = isFastMerge;
        this.querySolutionInfo = querySolutionInfo;
    }

    protected void initUI(IUIObject owner) throws Exception {
        this.setDisShowRowCount(true);
        this.setOwner((Component)owner);
        MetaDataPK mainQueryPK = MetaDataPK.create((String)this.getQueryName());
        this.setQueryObjectPK((IMetaDataPK)mainQueryPK);
        this.setShowFilter(false);
        this.setShowSorter(false);
        this.setWidth(650);
        this.setHeight(450);
        this.addPanel();
        this.setParentUIClassName(this.getParentUIClassName());
        if (this.querySolutionInfo != null) {
            this.setSolution(this.querySolutionInfo);
        }
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
    }

    public void setSettingGuide(boolean isSetting) {
        this.isSetting = isSetting;
    }

    public String getParentUIClassName() {
        return "com.kingdee.eas.fi.gr.cslrpt.client.MnsRptGuide_" + this.cslReportInfo.getOrgTree().getNumber() + "_" + this.cslReportInfo.getOrgUnit().getNumber();
    }

    public String getQueryName() {
        return "com.kingdee.eas.fi.gr.cslrpt.HisMnsRptQuery";
    }

    @Override
    public void init() throws UIException {
        super.init();
        if (this.getCommonqueryPanel() != null) {
            this.getCommonqueryPanel().setDefaultViewVisible(true);
            KDComboBox shareTypeComboBox = this.getCommonqueryPanel().getDefaultToolBar().getShareTypeComboBox();
            shareTypeComboBox.removeAllItems();
            shareTypeComboBox.addItem((Object)CslRptShareTypeEnum.Union);
            shareTypeComboBox.addItem((Object)CslRptShareTypeEnum.UnionAndUser);
            shareTypeComboBox.setEnabled(true);
            try {
                ShareTypeEnum shareType;
                CslRptShareTypeEnum selectShareType = CslRptShareTypeEnum.UnionAndUser;
                QuerySolutionInfo defaultSolution = this.getDefaultSolution();
                if (defaultSolution != null && !ShareTypeEnum.USER_NOORG_LEVEL.equals((Object)(shareType = defaultSolution.getShareType()))) {
                    selectShareType = CslRptShareTypeEnum.Union;
                }
                shareTypeComboBox.setSelectedItem((Object)selectShareType);
            }
            catch (Exception ex) {
                logger.error((Object)"getDefaultSolution error", (Throwable)ex);
                SysUtil.abort();
            }
        }
    }

    public QuerySolutionInfo getDefaultSolution() throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo queryFilterItem = new FilterItemInfo("queryObjectName", (Object)this.getQueryName());
        FilterItemInfo parentUIFilterItem = new FilterItemInfo("parentUIName", (Object)this.getParentUIClassName());
        FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        FilterItemInfo isUserDefaultFilterItem = new FilterItemInfo("isUserDefaultSolu", (Object)Boolean.TRUE);
        filterInfo.getFilterItems().add(queryFilterItem);
        filterInfo.getFilterItems().add(parentUIFilterItem);
        filterInfo.getFilterItems().add(ownerFilterItem);
        filterInfo.getFilterItems().add(isUserDefaultFilterItem);
        filterInfo.setMaskString("#0 and #1 and #2 and #3");
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("shareType"));
        SorterItemInfo sort = new SorterItemInfo("solutionType");
        sort.setSortType(SortType.DESCEND);
        entityViewInfo.getSorter().add(sort);
        QuerySolutionCollection q = QuerySolutionFactory.getRemoteInstance().getQuerySolutionCollection(entityViewInfo);
        if (q != null && q.size() > 0) {
            return q.get(0);
        }
        return null;
    }

    private void addPanel() throws Exception {
        this.guideOrgUnitTabUI = this.getPanelUI();
        this.guideOrgUnitTabUI.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"75MnsRptGuideTabTitle"));
        this.guideOrgUnitTabUI.setCslReportInfo(this.cslReportInfo);
        this.addUserPanel((KDPanel)this.guideOrgUnitTabUI);
        this.guideOrgUnitTabUI.setFastMerge(this.isFastMerge);
    }

    public MnsGuideOrgUnitTabUI getPanelUI() throws Exception {
        return new MnsGuideOrgUnitTabUI(this.isHideDyRptCalcPanel);
    }

    public void setBook(Book book) {
        if (this.guideOrgUnitTabUI != null) {
            this.guideOrgUnitTabUI.setBook(book);
        }
    }

    public void setHideDyRptCalcPanel(boolean isHideDyRptCalcPanel) {
        this.isHideDyRptCalcPanel = isHideDyRptCalcPanel;
    }
}

