/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ExportFileTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ExportModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ExportSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.IExportSchemeEntry;
import com.kingdee.eas.fi.gr.cslrpt.IRptReceiveFacade;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RptReceiveFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.AbstractBatchExportSchemeListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.BatchExportToExcelUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ExportShemeShareListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ExportShemeUnShareListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GetDataDialog;
import com.kingdee.eas.fi.gr.cslrpt.client.GetDataTaskAdapter;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.ExportNameRule;
import com.kingdee.eas.fi.gr.cslrpt.util.ReceiveFilterCondition;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BatchExportSchemeListUI
extends AbstractBatchExportSchemeListUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchExportSchemeListUI.class);
    private ExportNameRule nameRule;
    private Map viewPermissionMap = new HashMap();
    public int exportTypeValue = 0;
    private int year;
    private int period;
    private String filePath;
    private ExportFileTypeEnum fileType;
    private boolean isSubFile;
    private String exportType;
    private int isQueryBudget;
    private ReceiveFilterCondition condition = null;
    boolean iscomplete = false;
    private int exportValueType = -1;
    private Set<String> filleNames = new HashSet<String>();
    private boolean isRemove;
    private boolean isNoPermissionOfEdit = false;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.condition != null) {
            this.year = this.condition.getYear();
            this.period = this.condition.getPeriod();
        }
        this.btnShare.setEnabled(true);
        this.btnShare.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnUnShare.setEnabled(true);
        this.btnUnShare.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(this.isQueryBudget));
        uiContext.put((Object)"ReceiveFilterCondition", this.getUIContext().get("ReceiveFilterCondition"));
    }

    protected FilterInfo getDefaultFilterForQuery() {
        Map uiContext = this.getUIContext();
        this.condition = (ReceiveFilterCondition)uiContext.get("ReceiveFilterCondition");
        this.isQueryBudget = this.condition.isQueryBudget() ? 1 : 0;
        FilterInfo filter = new FilterInfo();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)userInfo.getId().toString()));
        StringBuffer sbFormula = new StringBuffer();
        int formulaIndex = 0;
        filter.getFilterItems().add(new FilterItemInfo("ExportSchemeOfShare.shareUser", (Object)userInfo.getId().toString()));
        sbFormula.append("  (#" + formulaIndex++ + " or #" + formulaIndex++ + ") ");
        filter.setMaskString(sbFormula.toString());
        try {
            filter.mergeFilter(super.getDefaultFilterForQuery(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"super.getDefaultFilterForQuery()_BOSException", (Throwable)e);
        }
        FilterItemCollection fic = filter.getFilterItems();
        StringBuffer maskString = new StringBuffer();
        int index = fic.size();
        maskString.append("(" + filter.getMaskString() + ")");
        fic.add(new FilterItemInfo("isQueryBudget", (Object)new Integer(this.isQueryBudget), CompareType.EQUALS));
        maskString.append(" and #" + index++);
        filter.setMaskString(maskString.toString());
        return filter;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionBatchExport_actionPerformed(ActionEvent e) throws Exception {
        if (this.condition != null) {
            this.year = this.condition.getYear();
            this.period = this.condition.getPeriod();
        }
        this.exportValueType = CslRptUIUtil.getExportValueType((Object)this);
        if (this.exportValueType < 0) {
            return;
        }
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        if (ownerWindow instanceof Frame) {
            this.DialogHandle();
            return;
        }
        dlg = ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null);
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            @Override
            public Object exec() {
                try {
                    BatchExportSchemeListUI.this.excuteExportAction();
                }
                catch (Exception e) {
                    BatchExportSchemeListUI.this.handleException(e);
                }
                return null;
            }
        });
        dlg.show();
    }

    private void DialogHandle() {
        ProgressDialogNew progressDialog = ProgressDialogHelper.createProgressDialogNew((CoreUI)this, (boolean)true);
        String companyNumber = SysContext.getSysContext().getCurrentOrgUnit().getNumber();
        progressDialog.setCompanyNumber(companyNumber);
        try {
            progressDialog.run(true, true, this.getRunnableWithProgress(), progressDialog);
        }
        catch (Exception ex) {
            logger.error((Object)"batchExport error", (Throwable)ex);
        }
    }

    protected IRunnableWithProgress getRunnableWithProgress() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.setTaskName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"888_BatchExport"));
                    monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"889_Exporting"), -1);
                    BatchExportSchemeListUI.this.excuteExportAction();
                }
                catch (Exception e) {
                    BatchExportSchemeListUI.this.handleException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private void excuteExportAction() throws Exception {
        ArrayList<Object> params;
        this.checkSelected();
        String id = null;
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 1) {
            id = this.getSelectedKeyValue();
        } else if (idList.size() > 1) {
            MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("oneSchemeAtOnce"));
            SysUtil.abort();
        }
        ExportSchemeInfo scheme = ExportSchemeFactory.getRemoteInstance().getExportSchemeInfo((IObjectPK)new ObjectUuidPK(id));
        boolean isExportOneFile = scheme.isIsExportOneFile();
        this.nameRule = ExportNameRule.getFromString(scheme.getNameRule());
        this.isSubFile = scheme.isIsSubFile();
        this.exportType = String.valueOf(scheme.getExportType() + 1);
        this.filePath = scheme.getPath();
        this.fileType = scheme.getFileType();
        File file = new File(this.filePath);
        if (!file.exists() && !file.mkdirs()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"exportFileNotExist"));
            SysUtil.abort();
        }
        boolean isReceived = scheme.isIsReceived();
        boolean isCommitted = scheme.isIsCommitted();
        boolean isAudited = scheme.isIsAudited();
        boolean isUnaudited = scheme.isIsUnAudited();
        RptPeriodTypeEnum periodType = scheme.getPeriodType();
        String currencyId = null;
        if (scheme.getCurrency() != null) {
            currencyId = scheme.getCurrency().getId().toString();
        }
        String dataCollect = scheme.getDataCollectNumber();
        List selectTemplate = new ArrayList();
        Map selectUnit = new LinkedHashMap();
        IExportSchemeEntry ientry = ExportSchemeEntryFactory.getRemoteInstance();
        selectTemplate = ientry.getTemplateList(id);
        selectUnit = ientry.getUnitMap(id);
        int count = 0;
        int fileCount = 0;
        StringBuffer error = new StringBuffer();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        IRptReceiveFacade receiveFacade = RptReceiveFacadeFactory.getRemoteInstance();
        this.filleNames.clear();
        if (scheme.getMode().equals((Object)ExportModeEnum.EXPORTBYTEMPLATE)) {
            int i;
            params = new ArrayList<Object>();
            TemplateInfo info = null;
            StringBuffer key = new StringBuffer();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("currencyId", currencyId);
            param.put("year", new Integer(this.year));
            param.put("period", new Integer(this.period));
            param.put("periodType", new Integer(periodType.getValue()));
            param.put("isReceived", isReceived);
            param.put("isCommitted", isCommitted);
            param.put("isAudited", isAudited);
            param.put("isUnaudited", isUnaudited);
            param.put("selectedUnit", selectUnit);
            param.put("dataCollect", dataCollect);
            param.put("ISQUERYBUDGET", new Integer(this.isQueryBudget));
            param.put("template", selectTemplate);
            param.put("isIgnoreTree", true);
            if (this.isQueryBudget != 1) {
                param.put("isIncludeBook", false);
            }
            params.add(param);
            Map reportsMap = receiveFacade.batchGetReportsByTmp(params);
            params = new ArrayList();
            AbstractObjectCollection reports = null;
            ArrayList<ReportBaseInfo> allRpts = new ArrayList<ReportBaseInfo>();
            for (i = 0; i < selectTemplate.size(); ++i) {
                info = (TemplateInfo)selectTemplate.get(i);
                key.setLength(0);
                key.append(info.getId().toString()).append(info.getTemplateType().getValue()).append(currencyId).append(this.year).append(this.period).append(periodType.getValue()).append(isReceived).append(isCommitted).append(isAudited).append(isUnaudited).append(dataCollect);
                reports = this.isQueryBudget == 1 ? (reportsMap.get(key.toString()) == null ? new HisCslReportCollection() : (HisCslReportCollection)((Object)reportsMap.get(key.toString()))) : (reportsMap.get(key.toString()) == null ? new CslReportCollection() : (CslReportCollection)((Object)reportsMap.get(key.toString())));
                Object[] object = new Object[]{};
                HisCslReportInfo hisReportInfo = null;
                CslReportInfo reportInfo = null;
                Iterator iter = reports.iterator();
                while (iter.hasNext()) {
                    if (this.isQueryBudget == 1) {
                        hisReportInfo = (HisCslReportInfo)iter.next();
                        object = new Object[]{new ObjectUuidPK(userInfo.getId()), new ObjectUuidPK(hisReportInfo.getOrgUnit().getId()), hisReportInfo.getSourceType()};
                        allRpts.add(hisReportInfo);
                    } else {
                        reportInfo = (CslReportInfo)iter.next();
                        object = new Object[]{new ObjectUuidPK(userInfo.getId()), new ObjectUuidPK(reportInfo.getOrgUnit().getId()), reportInfo.getSourceType()};
                        allRpts.add(reportInfo);
                    }
                    params.add(object);
                }
            }
            this.viewPermissionMap = receiveFacade.checkViewPermission(params);
            if (!isExportOneFile) {
                Map msg = this.exportReport(allRpts);
                if (msg.containsKey("SuccessCount")) {
                    count += ((Integer)msg.get("SuccessCount")).intValue();
                }
                if (msg.containsKey("FailMsg")) {
                    error.append(msg.get("FailMsg"));
                }
            } else {
                this.batchInitBook(allRpts, 0, true);
                for (i = 0; i < selectTemplate.size(); ++i) {
                    info = (TemplateInfo)selectTemplate.get(i);
                    key.setLength(0);
                    key.append(info.getId().toString()).append(info.getTemplateType().getValue()).append(currencyId).append(this.year).append(this.period).append(periodType.getValue()).append(isReceived).append(isCommitted).append(isAudited).append(isUnaudited).append(dataCollect);
                    reports = this.isQueryBudget == 1 ? (HisCslReportCollection)((Object)reportsMap.get(key.toString())) : (CslReportCollection)((Object)reportsMap.get(key.toString()));
                    if (reports == null || reports.size() == 0) continue;
                    Map msg = this.exportRptToOneExcelFile((IObjectCollection)reports, null, true);
                    if (msg.containsKey("SuccessCount")) {
                        count += ((Integer)msg.get("SuccessCount")).intValue();
                    }
                    if (msg.containsKey("SuccessFileCount")) {
                        fileCount += ((Integer)msg.get("SuccessFileCount")).intValue();
                    }
                    if (!msg.containsKey("FailMsg")) continue;
                    error.append(msg.get("FailMsg"));
                }
            }
            allRpts.clear();
        } else {
            int i;
            params = new ArrayList();
            OrgTreeInfo tree2 = null;
            List list = null;
            OrgUnitInfo unit = null;
            StringBuffer key = new StringBuffer();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("currencyId", currencyId);
            param.put("year", new Integer(this.year));
            param.put("period", new Integer(this.period));
            param.put("periodType", new Integer(periodType.getValue()));
            param.put("isReceived", isReceived);
            param.put("isCommitted", isCommitted);
            param.put("isAudited", isAudited);
            param.put("isUnaudited", isUnaudited);
            param.put("selectedTemplate", selectTemplate);
            param.put("dataCollect", dataCollect);
            param.put("ISQUERYBUDGET", new Integer(this.isQueryBudget));
            param.put("baseUnit", selectUnit);
            param.put("isIgnoreTree", true);
            if (this.isQueryBudget != 1) {
                param.put("isIncludeBook", false);
            }
            params.add(param);
            Map reportsMap = receiveFacade.batchGetReportsByOrg(params);
            params = new ArrayList();
            AbstractObjectCollection reports = null;
            ArrayList<ReportBaseInfo> allRpts = new ArrayList<ReportBaseInfo>();
            for (OrgTreeInfo tree2 : selectUnit.keySet()) {
                list = (List)selectUnit.get(tree2);
                for (i = 0; i < list.size(); ++i) {
                    unit = (OrgUnitInfo)list.get(i);
                    key.setLength(0);
                    if (this.isQueryBudget == 1) {
                        key.append(tree2.getId().toString());
                    }
                    key.append(unit.getId()).append(currencyId).append(this.year).append(this.period).append(periodType.getValue()).append(isReceived).append(isCommitted).append(isAudited).append(isUnaudited).append(dataCollect);
                    for (int j = 0; j < selectTemplate.size(); ++j) {
                        key.append(((TemplateInfo)selectTemplate.get(j)).getId());
                    }
                    reports = this.isQueryBudget == 1 ? (reportsMap.get(key.toString()) == null ? new HisCslReportCollection() : (HisCslReportCollection)((Object)reportsMap.get(key.toString()))) : (reportsMap.get(key.toString()) == null ? new CslReportCollection() : (CslReportCollection)((Object)reportsMap.get(key.toString())));
                    Object[] object = new Object[]{};
                    HisCslReportInfo hisReportInfo = null;
                    CslReportInfo reportInfo = null;
                    Iterator iter2 = reports.iterator();
                    while (iter2.hasNext()) {
                        if (this.isQueryBudget == 1) {
                            hisReportInfo = (HisCslReportInfo)iter2.next();
                            object = new Object[]{new ObjectUuidPK(userInfo.getId()), new ObjectUuidPK(hisReportInfo.getOrgUnit().getId()), hisReportInfo.getSourceType()};
                            allRpts.add(hisReportInfo);
                        } else {
                            reportInfo = (CslReportInfo)iter2.next();
                            object = new Object[]{new ObjectUuidPK(userInfo.getId()), new ObjectUuidPK(reportInfo.getOrgUnit().getId()), reportInfo.getSourceType()};
                            allRpts.add(reportInfo);
                        }
                        params.add(object);
                    }
                }
            }
            this.viewPermissionMap = receiveFacade.checkViewPermission(params);
            if (!isExportOneFile) {
                Map msg = this.exportReport(allRpts);
                if (msg.containsKey("SuccessCount")) {
                    count += ((Integer)msg.get("SuccessCount")).intValue();
                }
                if (msg.containsKey("SuccessFileCount")) {
                    fileCount += ((Integer)msg.get("SuccessFileCount")).intValue();
                }
                if (msg.containsKey("FailMsg")) {
                    error.append(msg.get("FailMsg"));
                }
            } else {
                this.batchInitBook(allRpts, 0, true);
                for (OrgTreeInfo tree2 : selectUnit.keySet()) {
                    list = (List)selectUnit.get(tree2);
                    for (i = 0; i < list.size(); ++i) {
                        unit = (OrgUnitInfo)list.get(i);
                        key.setLength(0);
                        if (this.isQueryBudget == 1) {
                            key.append(tree2.getId().toString());
                        }
                        key.append(unit.getId()).append(currencyId).append(this.year).append(this.period).append(periodType.getValue()).append(isReceived).append(isCommitted).append(isAudited).append(isUnaudited).append(dataCollect);
                        for (int j = 0; j < selectTemplate.size(); ++j) {
                            key.append(((TemplateInfo)selectTemplate.get(j)).getId());
                        }
                        reports = this.isQueryBudget == 1 ? (HisCslReportCollection)((Object)reportsMap.get(key.toString())) : (CslReportCollection)((Object)reportsMap.get(key.toString()));
                        if (reports == null || reports.size() == 0) continue;
                        Map msg = this.exportRptToOneExcelFile((IObjectCollection)reports, null, false);
                        if (msg.containsKey("SuccessCount")) {
                            count += ((Integer)msg.get("SuccessCount")).intValue();
                        }
                        if (msg.containsKey("SuccessFileCount")) {
                            fileCount += ((Integer)msg.get("SuccessFileCount")).intValue();
                        }
                        if (!msg.containsKey("FailMsg")) continue;
                        error.append(msg.get("FailMsg"));
                    }
                }
            }
            allRpts.clear();
        }
        CslRptUIUtil.exportToExcel2007After();
        this.filleNames.clear();
        StringBuffer msgStr = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"19_BatchExportSchemeListUI"));
        if (isExportOneFile) {
            msgStr.append(fileCount);
            msgStr.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"395_CSLTemplateExportSelectUI"));
        }
        if (error.length() > 0) {
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"318_BatchExportSchemeListUI"));
            ctx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
            SimpleNotePad.showMessageByModel(ctx, MessageFormat.format(msgStr.toString(), count) + "\n\n" + error.toString());
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(msgStr.toString(), count));
        }
    }

    private Map exportReport(List reports) throws EASBizException, BOSException {
        StringBuffer fail = new StringBuffer();
        int count = 0;
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ReportBaseInfo info = null;
        CslReportInfo cslRptInfo = null;
        FullOrgUnitInfo orgUnitInfo = null;
        StringBuffer key = new StringBuffer();
        for (int i = 0; i < reports.size(); ++i) {
            Book book;
            String fileName;
            block13: {
                info = (ReportBaseInfo)reports.get(i);
                if (this.isQueryBudget == 1) {
                    orgUnitInfo = ((HisCslReportInfo)info).getOrgUnit();
                } else {
                    cslRptInfo = (CslReportInfo)info;
                    orgUnitInfo = cslRptInfo.getOrgUnit();
                }
                key.setLength(0);
                key.append(userInfo.getId().toString()).append(orgUnitInfo.getId()).append(info.getSourceType().getValue());
                boolean canView = (Boolean)this.viewPermissionMap.get(key.toString());
                if (!canView) {
                    this.addFailMsg(fail, info, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"322_BatchExportSchemeListUI"));
                    continue;
                }
                fileName = this.makeFileName(info, orgUnitInfo, fail);
                if (fileName == null) continue;
                File file = new File(fileName);
                if (this.filleNames.contains(fileName) || file.exists()) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"20_BatchExportSchemeListUI");
                    this.addFailMsg(fail, info, orgUnitInfo, MessageFormat.format(msg, fileName));
                    continue;
                }
                book = null;
                try {
                    this.batchInitBook(reports, i, false);
                    book = info.getBook();
                    if (book == null) break block13;
                    book.setCalculate(false);
                }
                catch (Exception e1) {
                    logger.error((Object)"exportReport error", (Throwable)e1);
                    this.addFailMsg(fail, info, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"325_BatchExportSchemeListUI"));
                    continue;
                }
            }
            if (book == null) {
                this.addFailMsg(fail, info, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"326_BatchExportSchemeListUI"));
                continue;
            }
            try {
                if (!ExportFileTypeEnum.XLSX.equals((Object)this.fileType)) {
                    ExportManager em = new ExportManager();
                    this.setExportManagerParam(em);
                    KDSBook kdsbook = BookToKDSBook.traslate((Book)book);
                    em.exportToExcel(kdsbook, fileName);
                } else {
                    CslRptUIUtil.exportToExcel2007(book, fileName, this.exportValueType);
                }
                info.setData(null);
            }
            catch (Exception e) {
                logger.error((Object)"exportReport error", (Throwable)e);
                this.addFailMsg(fail, info, orgUnitInfo, e.getMessage());
                continue;
            }
            this.filleNames.add(fileName);
            ++count;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (fail.length() > 0) {
            map.put("FailMsg", fail.toString());
        }
        map.put("SuccessCount", new Integer(count));
        return map;
    }

    private void batchInitBook(List reports, int startIndex, boolean isGetAll) throws EASBizException, BOSException {
        block7: {
            try {
                if (this.isQueryBudget == 1) break block7;
                if (reports == null || reports.size() < startIndex + 1 || ((ReportBaseInfo)reports.get(startIndex)).getData() != null) {
                    return;
                }
                int batchSize = 10;
                try {
                    batchSize = Integer.valueOf(CSLParamUtil.getStringCslParamValue(null, "KEY_CSLPARAM_REPORTEXPORTSIZE"));
                }
                catch (Exception ex) {
                    logger.error((Object)"KEY_CSLPARAM_REPORTEXPORTSIZE erro.", (Throwable)ex);
                }
                HashMap<String, ReportBaseInfo> rptIds = new HashMap<String, ReportBaseInfo>();
                ReportBaseInfo info = null;
                for (int i = startIndex; i < reports.size(); ++i) {
                    info = (ReportBaseInfo)reports.get(i);
                    rptIds.put(info.getId().toString(), info);
                    if (rptIds.size() < batchSize) continue;
                    this.initBook(rptIds);
                    rptIds.clear();
                    if (isGetAll) continue;
                    return;
                }
                if (rptIds.size() > 0) {
                    this.initBook(rptIds);
                    rptIds.clear();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"batchInitBook error.", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
    }

    private void initBook(Map<String, ReportBaseInfo> rptIds) throws Exception {
        if (rptIds != null && !rptIds.isEmpty()) {
            String oql = "select id,data where id in(" + CslRptUtil.collection2String(rptIds.keySet(), ",", true) + ")";
            CslReportCollection coll = null;
            coll = rptIds.get(rptIds.keySet().iterator().next()) instanceof CslReportInfo ? CslReportFactory.getRemoteInstance().getCslReportCollection(oql) : ReportFactory.getRemoteInstance().getReportCollection(oql);
            if (coll != null) {
                ReportBaseInfo info = null;
                for (int i = 0; i < coll.size(); ++i) {
                    info = (ReportBaseInfo)coll.getObject(i);
                    rptIds.get(info.getId().toString()).setData(info.getData());
                }
            }
        }
    }

    private void setExportManagerParam(ExportManager em) {
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
        switch (this.exportValueType) {
            case 0: {
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                break;
            }
            case 1: {
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                break;
            }
            case 2: {
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
                em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            }
        }
    }

    private void exportToExcel2003(Book book, String fileName, StringBuffer fail, ReportBaseInfo info, FullOrgUnitInfo orgUnitInfo) throws Exception {
        Book tempBook = book;
        boolean isConfirm = false;
        boolean isBreak = false;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = tempBook.getSheet(i);
            if (sheet.getMaxColIndex() <= 255 && sheet.getMaxRowIndex() <= 65535) continue;
            if (!isConfirm) {
                this.addFailMsg(fail, info, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource", (String)"excel255_65535_OK"));
            } else {
                isConfirm = true;
            }
            try {
                if (tempBook == book) {
                    tempBook = SpreadHelper.copyBook((Book)book);
                    sheet = tempBook.getSheet(i);
                }
                if (sheet.getMaxColIndex() > 255) {
                    sheet.getColRange(256, sheet.getMaxColIndex()).delete();
                }
                if (sheet.getMaxRowIndex() <= 65535) continue;
                sheet.getRowRange(65536, sheet.getMaxRowIndex()).delete();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"exportToExcel2003 error", (Throwable)e);
                this.addFailMsg(fail, info, orgUnitInfo, e.getCause().getMessage());
                isBreak = true;
                break;
            }
        }
        if (isBreak) {
            return;
        }
        KDSBook kdsbook = BookToKDSBook.traslate((Book)tempBook);
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        em.exportToExcel(kdsbook, fileName);
    }

    private void addFailMsg(StringBuffer fail, ReportBaseInfo report, FullOrgUnitInfo orgUnitInfo, String error) {
        fail.append(report.getTemplate().getName()).append(" ");
        fail.append(orgUnitInfo.getName()).append(" ");
        fail.append(report.getYear()).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"785_ExtractItemDataUI"));
        fail.append(report.getPeriod()).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"786_ExtractItemDataUI"));
        fail.append(report.getPeriodType().getAlias()).append(" ");
        fail.append(report.getCurrency()).append("\n");
        fail.append(error).append("\n\n");
    }

    private String makeFileName(ReportBaseInfo report, FullOrgUnitInfo orgUnitInfo, StringBuffer fail) {
        String separator = File.separator;
        if (this.nameRule == null || this.nameRule.getOrder() == null || this.nameRule.getOperator() == null) {
            return null;
        }
        Map order = this.nameRule.getOrder();
        String oper = this.nameRule.getOperator();
        StringBuffer fileName = new StringBuffer();
        if (this.isSubFile) {
            File file;
            if (this.exportType.equals(String.valueOf(2))) {
                fileName.append(orgUnitInfo.getName() + separator);
            }
            if (this.exportType.equals(String.valueOf(1))) {
                fileName.append(orgUnitInfo.getNumber() + separator);
            }
            if (this.exportType.equals(String.valueOf(4))) {
                fileName.append(report.getTemplate().getName() + separator);
            }
            if (this.exportType.equals(String.valueOf(3))) {
                fileName.append(report.getTemplate().getNumber() + separator);
            }
            if (!(file = new File(this.filePath + separator + fileName.toString().substring(0, fileName.length() - 1))).exists()) {
                file.mkdir();
            }
        }
        block20: for (int i = 0; i < order.size(); ++i) {
            int condNumber = -876;
            try {
                condNumber = (Integer)order.get(new Integer(i));
            }
            catch (NullPointerException e) {
                logger.error((Object)"condNumber_NullPointerException", (Throwable)e);
                continue;
            }
            switch (condNumber) {
                case 1: {
                    fileName.append(orgUnitInfo.getNumber());
                    fileName.append(oper);
                    continue block20;
                }
                case 2: {
                    fileName.append(orgUnitInfo.getName());
                    fileName.append(oper);
                    continue block20;
                }
                case 3: {
                    fileName.append(report.getTemplate().getNumber());
                    fileName.append(oper);
                    continue block20;
                }
                case 4: {
                    fileName.append(report.getTemplate().getName());
                    fileName.append(oper);
                    continue block20;
                }
                case 11: {
                    fileName.append(report.getNumber());
                    fileName.append(oper);
                    continue block20;
                }
                case 12: {
                    fileName.append(report.getName());
                    fileName.append(oper);
                    continue block20;
                }
                case 13: {
                    fileName.append(report.getPeriodType().getAlias(SysContext.getSysContext().getLocale()));
                    fileName.append(oper);
                    continue block20;
                }
                case 5: {
                    fileName.append(this.year);
                    fileName.append(oper);
                    continue block20;
                }
                case 6: {
                    fileName.append(this.period);
                    fileName.append(oper);
                    continue block20;
                }
                case 7: {
                    fileName.append(report.getCurrency().getName());
                    fileName.append(oper);
                    continue block20;
                }
                case 8: {
                    fileName.append(RPTDateUtil.formateDate(new Date(), "yyyy-MM-dd"));
                    fileName.append(oper);
                    continue block20;
                }
                case 9: {
                    fileName.append(this.nameRule.getSolidValue());
                    fileName.append(oper);
                    continue block20;
                }
                case 10: {
                    String dataCollectNumber = null;
                    dataCollectNumber = this.isQueryBudget == 1 ? ((HisCslReportInfo)report).getDataCollectNumber() : ((CslReportInfo)report).getDataCollectNumber();
                    if (StringUtils.isEmpty((String)dataCollectNumber)) continue block20;
                    if (dataCollectNumber.equals("ACTUALDATA")) {
                        fileName.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource.Actual"));
                    } else if (dataCollectNumber.equals("BUDGETDATA")) {
                        fileName.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLReportAnlysisResource.Budget"));
                    } else {
                        fileName.append(dataCollectNumber);
                    }
                    fileName.append(oper);
                    continue block20;
                }
                case 14: {
                    String companyPresentation = null;
                    if (orgUnitInfo.isIsCompanyOrgUnit()) {
                        if (orgUnitInfo.getPartFI() != null) {
                            companyPresentation = orgUnitInfo.getPartFI().getCompanyDescription();
                        }
                        if (StringUtils.isEmpty((String)companyPresentation) && StringUtils.isEmpty((String)(companyPresentation = orgUnitInfo.getSimpleName()))) {
                            continue block20;
                        }
                    } else {
                        companyPresentation = orgUnitInfo.getSimpleName();
                        if (StringUtils.isEmpty((String)companyPresentation)) continue block20;
                    }
                    fileName.append(companyPresentation);
                    fileName.append(oper);
                    continue block20;
                }
                case 15: {
                    if (StringUtils.isEmpty((String)orgUnitInfo.getCode())) continue block20;
                    fileName.append(orgUnitInfo.getCode());
                    fileName.append(oper);
                    continue block20;
                }
                case 16: {
                    if (StringUtils.isEmpty((String)orgUnitInfo.getEnglishName())) continue block20;
                    fileName.append(orgUnitInfo.getEnglishName());
                    fileName.append(oper);
                }
            }
        }
        int length = 0;
        length = fileName.length();
        if (length == 0) {
            this.addFailMsg(fail, report, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"noBuildFileName"));
            return null;
        }
        fileName.delete(length - oper.length(), length);
        boolean hasOnlyOnePath = false;
        int indexOfLine = fileName.toString().indexOf(separator);
        if (indexOfLine != -1 && indexOfLine + 1 < fileName.length() && fileName.toString().indexOf(separator, indexOfLine + 1) != -1) {
            hasOnlyOnePath = true;
        }
        if (hasOnlyOnePath || fileName.toString().indexOf("/") >= 0 || fileName.toString().indexOf("?") >= 0 || fileName.toString().indexOf(":") >= 0 || fileName.toString().indexOf("*") >= 0 || fileName.toString().indexOf("<") >= 0 || fileName.toString().indexOf(">") >= 0 || fileName.toString().indexOf("|") >= 0 || fileName.toString().indexOf("\"") >= 0) {
            this.addFailMsg(fail, report, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"327_BatchExportSchemeListUI"));
            return null;
        }
        fileName.append(this.fileType.getValue());
        return this.filePath + separator + fileName.toString();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.VerifyPermissions(true);
        this.openEditUI(OprtState.EDIT);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            String creator;
            ICell creatorCell;
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row != null && (creatorCell = row.getCell("creator")) != null && !(creator = (String)creatorCell.getValue()).isEmpty() && !creator.equals(user)) {
                this.isNoPermissionOfEdit = true;
            }
        }
        this.openEditUI(OprtState.VIEW);
    }

    private void openEditUI(String state) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(this.isQueryBudget));
        uiContext.put((Object)"ReceiveFilterCondition", (Object)this.condition);
        if (state.equals(OprtState.VIEW) && this.isNoPermissionOfEdit) {
            uiContext.put((Object)"isNoPermissionOfEdit", (Object)Boolean.TRUE);
            this.isNoPermissionOfEdit = false;
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(this.getEditUIName(), (Map)uiContext, null, state);
        window.show();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ExportSchemeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BatchExportToExcelUI.class.getName();
    }

    private Map exportRptToOneExcelFile(IObjectCollection reports, String treeId, boolean isByTemplate) throws EASBizException, BOSException {
        StringBuffer fail = new StringBuffer();
        HashMap<String, List<Object>> typeRptMap = new HashMap<String, List<Object>>();
        this.handleRptType(reports, typeRptMap, isByTemplate);
        int[] counts = this.exportRpts(typeRptMap, treeId, fail, isByTemplate);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (fail.length() > 0) {
            map.put("FailMsg", fail.toString());
        }
        map.put("SuccessFileCount", new Integer(counts[1]));
        map.put("SuccessCount", new Integer(counts[0]));
        return map;
    }

    private int[] exportRpts(Map<String, List<Object>> orgTypeRptMap, String treeId, StringBuffer fail, boolean isByTemplate) throws EASBizException, BOSException {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ReportBaseInfo info = null;
        FullOrgUnitInfo orgUnitInfo = null;
        List<Object> rpts = null;
        int count = 0;
        int rptCount = 0;
        String key = null;
        for (String keyString : orgTypeRptMap.keySet()) {
            rpts = orgTypeRptMap.get(keyString);
            Book book = null;
            String fileName = null;
            rptCount = 0;
            for (int j = 0; j < rpts.size(); ++j) {
                block19: {
                    info = (ReportBaseInfo)rpts.get(j);
                    orgUnitInfo = this.isQueryBudget == 1 ? ((HisCslReportInfo)info).getOrgUnit() : ((CslReportInfo)info).getOrgUnit();
                    key = userInfo.getId().toString() + orgUnitInfo.getId().toString() + info.getSourceType().getValue() + (treeId == null ? "" : treeId);
                    boolean canView = (Boolean)this.viewPermissionMap.get(key);
                    if (!canView) {
                        this.addFailMsg(fail, info, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"322_BatchExportSchemeListUI"));
                        continue;
                    }
                    this.batchInitBook(rpts, j, false);
                    if (++rptCount == 1) {
                        block18: {
                            fileName = this.makeFileName(info, orgUnitInfo, fail);
                            if (fileName == null) break;
                            File file = new File(fileName);
                            if (this.filleNames.contains(fileName) || file.exists()) {
                                this.addFailMsg(fail, info, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"323_BatchExportSchemeListUI") + fileName + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"324_BatchExportSchemeListUI"));
                                break;
                            }
                            try {
                                book = info.getBook();
                                if (book != null) {
                                    book.setCalculate(false);
                                }
                                this.setDebugSheetName(book, info);
                                this.handleMaxRowCol(book, info, orgUnitInfo, fail);
                                if (!isByTemplate || book == null) break block18;
                                for (int i = 0; i < book.getSheetCount(); ++i) {
                                    book.getSheet(i).setName(book.getSheet(i).getSheetName() + "(" + orgUnitInfo.getName() + ")");
                                }
                            }
                            catch (Exception e1) {
                                logger.error((Object)"exportRptsByOrgUnit error", (Throwable)e1);
                                this.addFailMsg(fail, info, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"325_BatchExportSchemeListUI"));
                                continue;
                            }
                        }
                        if (book != null) continue;
                        book = Book.Manager.getNewBook(null, (int)0);
                        book.setCalculate(false);
                        continue;
                    }
                    if (book != null) {
                        try {
                            Book curBook = info.getBook();
                            this.setDebugSheetName(curBook, info);
                            curBook.setCalculate(false);
                            this.handleMaxRowCol(curBook, info, orgUnitInfo, fail);
                            if (curBook == null) break block19;
                            for (int i = 0; i < curBook.getSheetCount(); ++i) {
                                if (isByTemplate) {
                                    curBook.getSheet(i).setName(curBook.getSheet(i).getSheetName() + "(" + orgUnitInfo.getName() + ")");
                                }
                                book.addSheet(curBook.getSheet(i));
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"exportRptsByOrgUnit error", (Throwable)e);
                            this.addFailMsg(fail, info, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"325_BatchExportSchemeListUI"));
                            continue;
                        }
                    }
                }
                info.setData(null);
            }
            if (book == null || fileName == null) continue;
            try {
                if (!ExportFileTypeEnum.XLSX.equals((Object)this.fileType)) {
                    ExportManager em = new ExportManager();
                    this.setExportManagerParam(em);
                    KDSBook kdsbook = BookToKDSBook.traslate(book);
                    em.exportToExcel(kdsbook, fileName);
                } else {
                    CslRptUIUtil.exportToExcel2007(book, fileName, this.exportValueType);
                }
            }
            catch (Exception e) {
                logger.error((Object)"exportToExcel2007 error", (Throwable)e);
                this.addFailMsg(fail, info, orgUnitInfo, e.getMessage());
                continue;
            }
            this.filleNames.add(fileName);
            ++count;
        }
        return new int[]{rptCount, count};
    }

    private void handleRptType(IObjectCollection reports, Map<String, List<Object>> typeRptMap, boolean isByTemplate) {
        ReportBaseInfo info2 = null;
        String typeKey = null;
        List<Object> rpts = null;
        for (ReportBaseInfo info2 : reports) {
            typeKey = isByTemplate ? (this.isQueryBudget == 1 ? ((HisCslReportInfo)info2).getTemplate().getGroup() : ((CslReportInfo)info2).getTemplate().getGroup()) : (this.isQueryBudget == 1 ? ((HisCslReportInfo)info2).getOrgUnit().getId().toString() : ((CslReportInfo)info2).getOrgUnit().getId().toString());
            rpts = typeRptMap.get(typeKey);
            if (rpts == null) {
                rpts = new ArrayList<Object>();
            }
            rpts.add(info2);
            typeRptMap.put(typeKey, rpts);
        }
    }

    private void handleMaxRowCol(Book book, ReportBaseInfo report, FullOrgUnitInfo orgUnitInfo, StringBuffer fail) throws EASBizException, BOSException {
        Sheet sheet = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            if (sheet.getMaxColIndex() > 255 || sheet.getMaxRowIndex() > 65535) {
                this.addFailMsg(fail, report, orgUnitInfo, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource", (String)"excel255_65535_OK"));
                if (sheet.getMaxColIndex() > 255) {
                    sheet.getColRange(256, sheet.getMaxColIndex()).delete();
                }
                if (sheet.getMaxRowIndex() > 65535) {
                    sheet.getRowRange(65536, sheet.getMaxRowIndex()).delete();
                }
            }
            if (sheet.getMaxColIndex() != -1 || sheet.getMaxRowIndex() != -1) continue;
            if (book.getSheetCount() == 1) {
                book = null;
                return;
            }
            book.removeSheet(sheet);
            --i;
        }
    }

    private void setDebugSheetName(Book curBook, ReportBaseInfo info) {
        if (DebugLogger.isDebug) {
            Sheet sheet = null;
            for (int i = 0; i < curBook.getSheetCount(); ++i) {
                sheet = curBook.getSheet(i);
                sheet.setName(sheet.getSheetName() + "(" + info.getTemplate().getNumber().replaceAll("-", "") + ")");
            }
        }
    }

    @Override
    public void actionShare_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExportShemeShareListUI.class.getName(), (Map)this.sharePrepare(), null, OprtState.VIEW);
        curUIWindow.show();
    }

    private UIContext sharePrepare() {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        ArrayList list = this.VerifyPermissions(false);
        uiContext.put((Object)"keyList", (Object)list);
        return uiContext;
    }

    @Override
    public void actionUnShare_actionPerformed(ActionEvent e) throws Exception {
        this.sharePrepare();
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExportShemeUnShareListUI.class.getName(), (Map)this.sharePrepare(), null, OprtState.VIEW);
        curUIWindow.show();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.isRemove = true;
        super.actionRemove_actionPerformed(e);
        this.isRemove = false;
    }

    protected ArrayList getSelectedIdValues() {
        if (this.isRemove) {
            ArrayList list = this.VerifyPermissions(false);
            if (list != null) {
                return list;
            }
            return new ArrayList();
        }
        return super.getSelectedIdValues();
    }

    private ArrayList VerifyPermissions(boolean isEdit) {
        String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length < 1) {
            return null;
        }
        boolean isNoPermissions = false;
        ArrayList list = super.getSelectedIdValues();
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) continue;
            ICell creatorCell = row.getCell("creator");
            ICell idCell = row.getCell("id");
            if (creatorCell == null || idCell == null) continue;
            String creator = (String)creatorCell.getValue();
            String id = (String)idCell.getValue();
            if (creator.isEmpty() || creator.equals(user) || list == null) continue;
            list.remove(id);
            isNoPermissions = true;
            if (!isEdit || i != 0) continue;
            MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("NoCan"));
            SysUtil.abort();
        }
        if (list == null || list.size() == 0) {
            MsgBox.showError((Component)((Object)this), (String)CslRptUtil.getString("NoCan"));
            SysUtil.abort();
        } else if (isNoPermissions && !isEdit) {
            int result = MsgBox.showConfirm2((String)CslRptUtil.getString("ExistNoPer"));
            if (result == 0) {
                return list;
            }
            SysUtil.abort();
        }
        return list;
    }
}

